/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.mappers.renting.full;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import cz.airtoy.airshop.dao.mappers.common.BaseMapper;
import cz.airtoy.airshop.dao.mappers.renting.ContractItemsMapper;
import cz.airtoy.airshop.domains.data.TargetCommodityDomain;
import cz.airtoy.airshop.domains.renting.RentalPortfolioDomain;
import cz.airtoy.airshop.domains.renting.full.ContractItemsFullDomain;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContractItemsFullMapper
extends BaseMapper
implements RowMapper<ContractItemsFullDomain> {
    private static final Logger log = LoggerFactory.getLogger(ContractItemsFullMapper.class);

    public ContractItemsFullDomain map(ResultSet resultSet, StatementContext ctx) throws SQLException {
        ContractItemsFullDomain d = new ContractItemsFullDomain();
        ContractItemsMapper.process(resultSet, d);
        ContractItemsFullMapper.addTargetCommodities(resultSet, d);
        ContractItemsFullMapper.addRentalPortfolio(resultSet, d);
        return d;
    }

    public static void addTargetCommodities(ResultSet resultSet, ContractItemsFullDomain d) throws SQLException {
        try {
            GsonBuilder gsonBuilder;
            Gson gson;
            List list;
            String targetCommodities = ContractItemsFullMapper.getString(resultSet, "targetCommodities");
            if (targetCommodities != null && !targetCommodities.isEmpty() && (list = (List)(gson = (gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss")).create()).fromJson(targetCommodities, new TypeToken<List<TargetCommodityDomain>>(){}.getType())) != null) {
                d.setTargetCommodities(list);
            }
        }
        catch (SQLException e) {
            log.error(String.format("SQL Exception: %s", e.getMessage()), (Throwable)e);
        }
        catch (JsonSyntaxException e) {
            log.error(String.format("JSON Exception: %s", e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            log.error(String.format("Exception: %s", e.getMessage()), (Throwable)e);
        }
    }

    public static void addRentalPortfolio(ResultSet resultSet, ContractItemsFullDomain d) throws SQLException {
        try {
            GsonBuilder gsonBuilder;
            Gson gson;
            List list;
            String rentalPortfolio = ContractItemsFullMapper.getString(resultSet, "rentalPortfolio");
            if (rentalPortfolio != null && !rentalPortfolio.isEmpty() && (list = (List)(gson = (gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss")).create()).fromJson(rentalPortfolio, new TypeToken<List<RentalPortfolioDomain>>(){}.getType())) != null) {
                d.setRentalPortfolio(list);
            }
        }
        catch (SQLException e) {
            log.error(String.format("SQL Exception: %s", e.getMessage()), (Throwable)e);
        }
        catch (JsonSyntaxException e) {
            log.error(String.format("JSON Exception: %s", e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            log.error(String.format("Exception: %s", e.getMessage()), (Throwable)e);
        }
    }
}

