/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.TransferWaysMapper;
import cz.airtoy.airshop.domains.TransferWaysDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface TransferWaysDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.name,\n\t\tp.description,\n\t\tp.from_store_id,\n\t\tp.from_doc_queue_id,\n\t\tp.from_firm_id,\n\t\tp.from_firm_office_id,\n\t\tp.from_division_id,\n\t\tp.from_bus_order_id,\n\t\tp.to_store_id,\n\t\tp.to_doc_queue_id,\n\t\tp.date_created\n FROM \n\t\tabra.transfer_ways p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.from_store_id::text ~* :mask \n\tOR \n\t\tp.from_doc_queue_id::text ~* :mask \n\tOR \n\t\tp.from_firm_id::text ~* :mask \n\tOR \n\t\tp.from_firm_office_id::text ~* :mask \n\tOR \n\t\tp.from_division_id::text ~* :mask \n\tOR \n\t\tp.from_bus_order_id::text ~* :mask \n\tOR \n\t\tp.to_store_id::text ~* :mask \n\tOR \n\t\tp.to_doc_queue_id::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public List<TransferWaysDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tabra.transfer_ways p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.from_store_id::text ~* :mask \n\tOR \n\t\tp.from_doc_queue_id::text ~* :mask \n\tOR \n\t\tp.from_firm_id::text ~* :mask \n\tOR \n\t\tp.from_firm_office_id::text ~* :mask \n\tOR \n\t\tp.from_division_id::text ~* :mask \n\tOR \n\t\tp.from_bus_order_id::text ~* :mask \n\tOR \n\t\tp.to_store_id::text ~* :mask \n\tOR \n\t\tp.to_doc_queue_id::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.from_store_id = :fromStoreId AND p.to_store_id = :toStoreId")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public TransferWaysDomain findByFromStoreIdToStoreId(@Bind(value="fromStoreId") Long var1, @Bind(value="toStoreId") Long var2);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.id = :id")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public TransferWaysDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.id = :id")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public List<TransferWaysDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transfer_ways p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public List<TransferWaysDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public TransferWaysDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public List<TransferWaysDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transfer_ways p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public List<TransferWaysDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.name = :name")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public TransferWaysDomain findByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.name = :name")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public List<TransferWaysDomain> findListByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transfer_ways p  WHERE p.name = :name")
    public long findListByNameCount(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.name = :name ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public List<TransferWaysDomain> findListByName(@Bind(value="name") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.description = :description")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public TransferWaysDomain findByDescription(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.description = :description")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public List<TransferWaysDomain> findListByDescription(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transfer_ways p  WHERE p.description = :description")
    public long findListByDescriptionCount(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.description = :description ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public List<TransferWaysDomain> findListByDescription(@Bind(value="description") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.from_store_id = :fromStoreId")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public TransferWaysDomain findByFromStoreId(@Bind(value="fromStoreId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.from_store_id = :fromStoreId")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public List<TransferWaysDomain> findListByFromStoreId(@Bind(value="fromStoreId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transfer_ways p  WHERE p.from_store_id = :fromStoreId")
    public long findListByFromStoreIdCount(@Bind(value="fromStoreId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.from_store_id = :fromStoreId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public List<TransferWaysDomain> findListByFromStoreId(@Bind(value="fromStoreId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.from_doc_queue_id = :fromDocQueueId")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public TransferWaysDomain findByFromDocQueueId(@Bind(value="fromDocQueueId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.from_doc_queue_id = :fromDocQueueId")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public List<TransferWaysDomain> findListByFromDocQueueId(@Bind(value="fromDocQueueId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transfer_ways p  WHERE p.from_doc_queue_id = :fromDocQueueId")
    public long findListByFromDocQueueIdCount(@Bind(value="fromDocQueueId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.from_doc_queue_id = :fromDocQueueId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public List<TransferWaysDomain> findListByFromDocQueueId(@Bind(value="fromDocQueueId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.from_firm_id = :fromFirmId")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public TransferWaysDomain findByFromFirmId(@Bind(value="fromFirmId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.from_firm_id = :fromFirmId")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public List<TransferWaysDomain> findListByFromFirmId(@Bind(value="fromFirmId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transfer_ways p  WHERE p.from_firm_id = :fromFirmId")
    public long findListByFromFirmIdCount(@Bind(value="fromFirmId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.from_firm_id = :fromFirmId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public List<TransferWaysDomain> findListByFromFirmId(@Bind(value="fromFirmId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.from_firm_office_id = :fromFirmOfficeId")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public TransferWaysDomain findByFromFirmOfficeId(@Bind(value="fromFirmOfficeId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.from_firm_office_id = :fromFirmOfficeId")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public List<TransferWaysDomain> findListByFromFirmOfficeId(@Bind(value="fromFirmOfficeId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transfer_ways p  WHERE p.from_firm_office_id = :fromFirmOfficeId")
    public long findListByFromFirmOfficeIdCount(@Bind(value="fromFirmOfficeId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.from_firm_office_id = :fromFirmOfficeId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public List<TransferWaysDomain> findListByFromFirmOfficeId(@Bind(value="fromFirmOfficeId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.from_division_id = :fromDivisionId")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public TransferWaysDomain findByFromDivisionId(@Bind(value="fromDivisionId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.from_division_id = :fromDivisionId")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public List<TransferWaysDomain> findListByFromDivisionId(@Bind(value="fromDivisionId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transfer_ways p  WHERE p.from_division_id = :fromDivisionId")
    public long findListByFromDivisionIdCount(@Bind(value="fromDivisionId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.from_division_id = :fromDivisionId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public List<TransferWaysDomain> findListByFromDivisionId(@Bind(value="fromDivisionId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.from_bus_order_id = :fromBusOrderId")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public TransferWaysDomain findByFromBusOrderId(@Bind(value="fromBusOrderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.from_bus_order_id = :fromBusOrderId")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public List<TransferWaysDomain> findListByFromBusOrderId(@Bind(value="fromBusOrderId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transfer_ways p  WHERE p.from_bus_order_id = :fromBusOrderId")
    public long findListByFromBusOrderIdCount(@Bind(value="fromBusOrderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.from_bus_order_id = :fromBusOrderId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public List<TransferWaysDomain> findListByFromBusOrderId(@Bind(value="fromBusOrderId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.to_store_id = :toStoreId")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public TransferWaysDomain findByToStoreId(@Bind(value="toStoreId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.to_store_id = :toStoreId")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public List<TransferWaysDomain> findListByToStoreId(@Bind(value="toStoreId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transfer_ways p  WHERE p.to_store_id = :toStoreId")
    public long findListByToStoreIdCount(@Bind(value="toStoreId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.to_store_id = :toStoreId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public List<TransferWaysDomain> findListByToStoreId(@Bind(value="toStoreId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.to_doc_queue_id = :toDocQueueId")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public TransferWaysDomain findByToDocQueueId(@Bind(value="toDocQueueId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.to_doc_queue_id = :toDocQueueId")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public List<TransferWaysDomain> findListByToDocQueueId(@Bind(value="toDocQueueId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transfer_ways p  WHERE p.to_doc_queue_id = :toDocQueueId")
    public long findListByToDocQueueIdCount(@Bind(value="toDocQueueId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.to_doc_queue_id = :toDocQueueId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public List<TransferWaysDomain> findListByToDocQueueId(@Bind(value="toDocQueueId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public TransferWaysDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public List<TransferWaysDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transfer_ways p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.from_store_id, p.from_doc_queue_id, p.from_firm_id, p.from_firm_office_id, p.from_division_id, p.from_bus_order_id, p.to_store_id, p.to_doc_queue_id, p.date_created FROM abra.transfer_ways p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransferWaysMapper.class)
    public List<TransferWaysDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO abra.transfer_ways (id, uid, name, description, from_store_id, from_doc_queue_id, from_firm_id, from_firm_office_id, from_division_id, from_bus_order_id, to_store_id, to_doc_queue_id, date_created) VALUES (:id, :uid, :name, :description, :fromStoreId, :fromDocQueueId, :fromFirmId, :fromFirmOfficeId, :fromDivisionId, :fromBusOrderId, :toStoreId, :toDocQueueId, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="name") String var3, @Bind(value="description") String var4, @Bind(value="fromStoreId") Long var5, @Bind(value="fromDocQueueId") Long var6, @Bind(value="fromFirmId") Long var7, @Bind(value="fromFirmOfficeId") Long var8, @Bind(value="fromDivisionId") Long var9, @Bind(value="fromBusOrderId") Long var10, @Bind(value="toStoreId") Long var11, @Bind(value="toDocQueueId") Long var12, @Bind(value="dateCreated") Date var13);

    @SqlUpdate(value="INSERT INTO abra.transfer_ways (name, description, from_store_id, from_doc_queue_id, from_firm_id, from_firm_office_id, from_division_id, from_bus_order_id, to_store_id, to_doc_queue_id, date_created) VALUES (:e.name, :e.description, :e.fromStoreId, :e.fromDocQueueId, :e.fromFirmId, :e.fromFirmOfficeId, :e.fromDivisionId, :e.fromBusOrderId, :e.toStoreId, :e.toDocQueueId, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") TransferWaysDomain var1);

    @SqlUpdate(value="UPDATE abra.transfer_ways SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, from_store_id = :e.fromStoreId, from_doc_queue_id = :e.fromDocQueueId, from_firm_id = :e.fromFirmId, from_firm_office_id = :e.fromFirmOfficeId, from_division_id = :e.fromDivisionId, from_bus_order_id = :e.fromBusOrderId, to_store_id = :e.toStoreId, to_doc_queue_id = :e.toDocQueueId, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") TransferWaysDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE abra.transfer_ways SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, from_store_id = :e.fromStoreId, from_doc_queue_id = :e.fromDocQueueId, from_firm_id = :e.fromFirmId, from_firm_office_id = :e.fromFirmOfficeId, from_division_id = :e.fromDivisionId, from_bus_order_id = :e.fromBusOrderId, to_store_id = :e.toStoreId, to_doc_queue_id = :e.toDocQueueId, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") TransferWaysDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE abra.transfer_ways SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, from_store_id = :e.fromStoreId, from_doc_queue_id = :e.fromDocQueueId, from_firm_id = :e.fromFirmId, from_firm_office_id = :e.fromFirmOfficeId, from_division_id = :e.fromDivisionId, from_bus_order_id = :e.fromBusOrderId, to_store_id = :e.toStoreId, to_doc_queue_id = :e.toDocQueueId, date_created = :e.dateCreated WHERE name = :byName")
    public int updateByName(@BindBean(value="e") TransferWaysDomain var1, @Bind(value="byName") String var2);

    @SqlUpdate(value="UPDATE abra.transfer_ways SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, from_store_id = :e.fromStoreId, from_doc_queue_id = :e.fromDocQueueId, from_firm_id = :e.fromFirmId, from_firm_office_id = :e.fromFirmOfficeId, from_division_id = :e.fromDivisionId, from_bus_order_id = :e.fromBusOrderId, to_store_id = :e.toStoreId, to_doc_queue_id = :e.toDocQueueId, date_created = :e.dateCreated WHERE description = :byDescription")
    public int updateByDescription(@BindBean(value="e") TransferWaysDomain var1, @Bind(value="byDescription") String var2);

    @SqlUpdate(value="UPDATE abra.transfer_ways SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, from_store_id = :e.fromStoreId, from_doc_queue_id = :e.fromDocQueueId, from_firm_id = :e.fromFirmId, from_firm_office_id = :e.fromFirmOfficeId, from_division_id = :e.fromDivisionId, from_bus_order_id = :e.fromBusOrderId, to_store_id = :e.toStoreId, to_doc_queue_id = :e.toDocQueueId, date_created = :e.dateCreated WHERE from_store_id = :byFromStoreId")
    public int updateByFromStoreId(@BindBean(value="e") TransferWaysDomain var1, @Bind(value="byFromStoreId") Long var2);

    @SqlUpdate(value="UPDATE abra.transfer_ways SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, from_store_id = :e.fromStoreId, from_doc_queue_id = :e.fromDocQueueId, from_firm_id = :e.fromFirmId, from_firm_office_id = :e.fromFirmOfficeId, from_division_id = :e.fromDivisionId, from_bus_order_id = :e.fromBusOrderId, to_store_id = :e.toStoreId, to_doc_queue_id = :e.toDocQueueId, date_created = :e.dateCreated WHERE from_doc_queue_id = :byFromDocQueueId")
    public int updateByFromDocQueueId(@BindBean(value="e") TransferWaysDomain var1, @Bind(value="byFromDocQueueId") Long var2);

    @SqlUpdate(value="UPDATE abra.transfer_ways SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, from_store_id = :e.fromStoreId, from_doc_queue_id = :e.fromDocQueueId, from_firm_id = :e.fromFirmId, from_firm_office_id = :e.fromFirmOfficeId, from_division_id = :e.fromDivisionId, from_bus_order_id = :e.fromBusOrderId, to_store_id = :e.toStoreId, to_doc_queue_id = :e.toDocQueueId, date_created = :e.dateCreated WHERE from_firm_id = :byFromFirmId")
    public int updateByFromFirmId(@BindBean(value="e") TransferWaysDomain var1, @Bind(value="byFromFirmId") Long var2);

    @SqlUpdate(value="UPDATE abra.transfer_ways SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, from_store_id = :e.fromStoreId, from_doc_queue_id = :e.fromDocQueueId, from_firm_id = :e.fromFirmId, from_firm_office_id = :e.fromFirmOfficeId, from_division_id = :e.fromDivisionId, from_bus_order_id = :e.fromBusOrderId, to_store_id = :e.toStoreId, to_doc_queue_id = :e.toDocQueueId, date_created = :e.dateCreated WHERE from_firm_office_id = :byFromFirmOfficeId")
    public int updateByFromFirmOfficeId(@BindBean(value="e") TransferWaysDomain var1, @Bind(value="byFromFirmOfficeId") Long var2);

    @SqlUpdate(value="UPDATE abra.transfer_ways SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, from_store_id = :e.fromStoreId, from_doc_queue_id = :e.fromDocQueueId, from_firm_id = :e.fromFirmId, from_firm_office_id = :e.fromFirmOfficeId, from_division_id = :e.fromDivisionId, from_bus_order_id = :e.fromBusOrderId, to_store_id = :e.toStoreId, to_doc_queue_id = :e.toDocQueueId, date_created = :e.dateCreated WHERE from_division_id = :byFromDivisionId")
    public int updateByFromDivisionId(@BindBean(value="e") TransferWaysDomain var1, @Bind(value="byFromDivisionId") Long var2);

    @SqlUpdate(value="UPDATE abra.transfer_ways SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, from_store_id = :e.fromStoreId, from_doc_queue_id = :e.fromDocQueueId, from_firm_id = :e.fromFirmId, from_firm_office_id = :e.fromFirmOfficeId, from_division_id = :e.fromDivisionId, from_bus_order_id = :e.fromBusOrderId, to_store_id = :e.toStoreId, to_doc_queue_id = :e.toDocQueueId, date_created = :e.dateCreated WHERE from_bus_order_id = :byFromBusOrderId")
    public int updateByFromBusOrderId(@BindBean(value="e") TransferWaysDomain var1, @Bind(value="byFromBusOrderId") Long var2);

    @SqlUpdate(value="UPDATE abra.transfer_ways SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, from_store_id = :e.fromStoreId, from_doc_queue_id = :e.fromDocQueueId, from_firm_id = :e.fromFirmId, from_firm_office_id = :e.fromFirmOfficeId, from_division_id = :e.fromDivisionId, from_bus_order_id = :e.fromBusOrderId, to_store_id = :e.toStoreId, to_doc_queue_id = :e.toDocQueueId, date_created = :e.dateCreated WHERE to_store_id = :byToStoreId")
    public int updateByToStoreId(@BindBean(value="e") TransferWaysDomain var1, @Bind(value="byToStoreId") Long var2);

    @SqlUpdate(value="UPDATE abra.transfer_ways SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, from_store_id = :e.fromStoreId, from_doc_queue_id = :e.fromDocQueueId, from_firm_id = :e.fromFirmId, from_firm_office_id = :e.fromFirmOfficeId, from_division_id = :e.fromDivisionId, from_bus_order_id = :e.fromBusOrderId, to_store_id = :e.toStoreId, to_doc_queue_id = :e.toDocQueueId, date_created = :e.dateCreated WHERE to_doc_queue_id = :byToDocQueueId")
    public int updateByToDocQueueId(@BindBean(value="e") TransferWaysDomain var1, @Bind(value="byToDocQueueId") Long var2);

    @SqlUpdate(value="UPDATE abra.transfer_ways SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, from_store_id = :e.fromStoreId, from_doc_queue_id = :e.fromDocQueueId, from_firm_id = :e.fromFirmId, from_firm_office_id = :e.fromFirmOfficeId, from_division_id = :e.fromDivisionId, from_bus_order_id = :e.fromBusOrderId, to_store_id = :e.toStoreId, to_doc_queue_id = :e.toDocQueueId, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") TransferWaysDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM abra.transfer_ways WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM abra.transfer_ways WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM abra.transfer_ways WHERE name = :name")
    public int deleteByName(@Bind(value="name") String var1);

    @SqlUpdate(value="DELETE FROM abra.transfer_ways WHERE description = :description")
    public int deleteByDescription(@Bind(value="description") String var1);

    @SqlUpdate(value="DELETE FROM abra.transfer_ways WHERE from_store_id = :fromStoreId")
    public int deleteByFromStoreId(@Bind(value="fromStoreId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.transfer_ways WHERE from_doc_queue_id = :fromDocQueueId")
    public int deleteByFromDocQueueId(@Bind(value="fromDocQueueId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.transfer_ways WHERE from_firm_id = :fromFirmId")
    public int deleteByFromFirmId(@Bind(value="fromFirmId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.transfer_ways WHERE from_firm_office_id = :fromFirmOfficeId")
    public int deleteByFromFirmOfficeId(@Bind(value="fromFirmOfficeId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.transfer_ways WHERE from_division_id = :fromDivisionId")
    public int deleteByFromDivisionId(@Bind(value="fromDivisionId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.transfer_ways WHERE from_bus_order_id = :fromBusOrderId")
    public int deleteByFromBusOrderId(@Bind(value="fromBusOrderId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.transfer_ways WHERE to_store_id = :toStoreId")
    public int deleteByToStoreId(@Bind(value="toStoreId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.transfer_ways WHERE to_doc_queue_id = :toDocQueueId")
    public int deleteByToDocQueueId(@Bind(value="toDocQueueId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.transfer_ways WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

