/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.OrderProcessItemsMapper;
import cz.airtoy.airshop.domains.OrderProcessItemsDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface OrderProcessItemsDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.order_process_id,\n\t\tp.order_id,\n\t\tp.order_items_id,\n\t\tp.shadow_order_item_id,\n\t\tp.storecard_id,\n\t\tp.key,\n\t\tp.ean,\n\t\tp.quantity,\n\t\tp.color,\n\t\tp.status,\n\t\tp.approved,\n\t\tp.expanded,\n\t\tp.date_updated,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tapp.order_process_items p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.order_process_id::text ~* :mask \n\tOR \n\t\tp.order_id::text ~* :mask \n\tOR \n\t\tp.order_items_id::text ~* :mask \n\tOR \n\t\tp.shadow_order_item_id::text ~* :mask \n\tOR \n\t\tp.storecard_id::text ~* :mask \n\tOR \n\t\tp.key::text ~* :mask \n\tOR \n\t\tp.ean::text ~* :mask \n\tOR \n\t\tp.quantity::text ~* :mask \n\tOR \n\t\tp.color::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.approved::text ~* :mask \n\tOR \n\t\tp.expanded::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tapp.order_process_items p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.order_process_id::text ~* :mask \n\tOR \n\t\tp.order_id::text ~* :mask \n\tOR \n\t\tp.order_items_id::text ~* :mask \n\tOR \n\t\tp.shadow_order_item_id::text ~* :mask \n\tOR \n\t\tp.storecard_id::text ~* :mask \n\tOR \n\t\tp.key::text ~* :mask \n\tOR \n\t\tp.ean::text ~* :mask \n\tOR \n\t\tp.quantity::text ~* :mask \n\tOR \n\t\tp.color::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.approved::text ~* :mask \n\tOR \n\t\tp.expanded::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.id = :id")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public OrderProcessItemsDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.id = :id")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.order_process_items p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public OrderProcessItemsDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.order_process_items p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.order_process_id = :orderProcessId")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public OrderProcessItemsDomain findByOrderProcessId(@Bind(value="orderProcessId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.order_process_id = :orderProcessId")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByOrderProcessId(@Bind(value="orderProcessId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.order_process_items p  WHERE p.order_process_id = :orderProcessId")
    public long findListByOrderProcessIdCount(@Bind(value="orderProcessId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.order_process_id = :orderProcessId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByOrderProcessId(@Bind(value="orderProcessId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.order_id = :orderId")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public OrderProcessItemsDomain findByOrderId(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.order_id = :orderId")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByOrderId(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.order_process_items p  WHERE p.order_id = :orderId")
    public long findListByOrderIdCount(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.order_id = :orderId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByOrderId(@Bind(value="orderId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.order_items_id = :orderItemsId")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public OrderProcessItemsDomain findByOrderItemsId(@Bind(value="orderItemsId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.order_items_id = :orderItemsId")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByOrderItemsId(@Bind(value="orderItemsId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.order_process_items p  WHERE p.order_items_id = :orderItemsId")
    public long findListByOrderItemsIdCount(@Bind(value="orderItemsId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.order_items_id = :orderItemsId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByOrderItemsId(@Bind(value="orderItemsId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.shadow_order_item_id = :shadowOrderItemId")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public OrderProcessItemsDomain findByShadowOrderItemId(@Bind(value="shadowOrderItemId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.shadow_order_item_id = :shadowOrderItemId")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByShadowOrderItemId(@Bind(value="shadowOrderItemId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.order_process_items p  WHERE p.shadow_order_item_id = :shadowOrderItemId")
    public long findListByShadowOrderItemIdCount(@Bind(value="shadowOrderItemId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.shadow_order_item_id = :shadowOrderItemId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByShadowOrderItemId(@Bind(value="shadowOrderItemId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.storecard_id = :storecardId")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public OrderProcessItemsDomain findByStorecardId(@Bind(value="storecardId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.storecard_id = :storecardId")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByStorecardId(@Bind(value="storecardId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.order_process_items p  WHERE p.storecard_id = :storecardId")
    public long findListByStorecardIdCount(@Bind(value="storecardId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.storecard_id = :storecardId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByStorecardId(@Bind(value="storecardId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.key = :key")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public OrderProcessItemsDomain findByKey(@Bind(value="key") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.key = :key")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByKey(@Bind(value="key") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.order_process_items p  WHERE p.key = :key")
    public long findListByKeyCount(@Bind(value="key") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.key = :key ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByKey(@Bind(value="key") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.ean = :ean")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public OrderProcessItemsDomain findByEan(@Bind(value="ean") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.ean = :ean")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByEan(@Bind(value="ean") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.order_process_items p  WHERE p.ean = :ean")
    public long findListByEanCount(@Bind(value="ean") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.ean = :ean ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByEan(@Bind(value="ean") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.quantity = :quantity")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public OrderProcessItemsDomain findByQuantity(@Bind(value="quantity") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.quantity = :quantity")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByQuantity(@Bind(value="quantity") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.order_process_items p  WHERE p.quantity = :quantity")
    public long findListByQuantityCount(@Bind(value="quantity") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.quantity = :quantity ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByQuantity(@Bind(value="quantity") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.color = :color")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public OrderProcessItemsDomain findByColor(@Bind(value="color") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.color = :color")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByColor(@Bind(value="color") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.order_process_items p  WHERE p.color = :color")
    public long findListByColorCount(@Bind(value="color") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.color = :color ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByColor(@Bind(value="color") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.status = :status")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public OrderProcessItemsDomain findByStatus(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.status = :status")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByStatus(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.order_process_items p  WHERE p.status = :status")
    public long findListByStatusCount(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.status = :status ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByStatus(@Bind(value="status") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.approved = :approved")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public OrderProcessItemsDomain findByApproved(@Bind(value="approved") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.approved = :approved")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByApproved(@Bind(value="approved") Boolean var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.order_process_items p  WHERE p.approved = :approved")
    public long findListByApprovedCount(@Bind(value="approved") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.approved = :approved ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByApproved(@Bind(value="approved") Boolean var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.expanded = :expanded")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public OrderProcessItemsDomain findByExpanded(@Bind(value="expanded") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.expanded = :expanded")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByExpanded(@Bind(value="expanded") Boolean var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.order_process_items p  WHERE p.expanded = :expanded")
    public long findListByExpandedCount(@Bind(value="expanded") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.expanded = :expanded ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByExpanded(@Bind(value="expanded") Boolean var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public OrderProcessItemsDomain findByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.order_process_items p  WHERE p.date_updated = :dateUpdated")
    public long findListByDateUpdatedCount(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.date_updated = :dateUpdated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.note = :note")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public OrderProcessItemsDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.note = :note")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.order_process_items p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public OrderProcessItemsDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.order_process_items p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_process_id, p.order_id, p.order_items_id, p.shadow_order_item_id, p.storecard_id, p.key, p.ean, p.quantity, p.color, p.status, p.approved, p.expanded, p.date_updated, p.note, p.date_created FROM app.order_process_items p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderProcessItemsMapper.class)
    public List<OrderProcessItemsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO app.order_process_items (id, uid, order_process_id, order_id, order_items_id, shadow_order_item_id, storecard_id, key, ean, quantity, color, status, approved, expanded, date_updated, note, date_created) VALUES (:id, :uid, :orderProcessId, :orderId, :orderItemsId, :shadowOrderItemId, :storecardId, :key, :ean, :quantity, :color, :status, :approved, :expanded, :dateUpdated, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="orderProcessId") Long var3, @Bind(value="orderId") Long var4, @Bind(value="orderItemsId") Long var5, @Bind(value="shadowOrderItemId") Long var6, @Bind(value="storecardId") String var7, @Bind(value="key") String var8, @Bind(value="ean") String var9, @Bind(value="quantity") Double var10, @Bind(value="color") String var11, @Bind(value="status") String var12, @Bind(value="approved") Boolean var13, @Bind(value="expanded") Boolean var14, @Bind(value="dateUpdated") Date var15, @Bind(value="note") String var16, @Bind(value="dateCreated") Date var17);

    @SqlUpdate(value="INSERT INTO app.order_process_items (order_process_id, order_id, order_items_id, shadow_order_item_id, storecard_id, key, ean, quantity, color, status, approved, expanded, date_updated, note, date_created) VALUES (:e.orderProcessId, :e.orderId, :e.orderItemsId, :e.shadowOrderItemId, :e.storecardId, :e.key, :e.ean, :e.quantity, :e.color, :e.status, :e.approved, :e.expanded, :e.dateUpdated, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") OrderProcessItemsDomain var1);

    @SqlUpdate(value="UPDATE app.order_process_items SET id = :e.id, uid = :e.uid, order_process_id = :e.orderProcessId, order_id = :e.orderId, order_items_id = :e.orderItemsId, shadow_order_item_id = :e.shadowOrderItemId, storecard_id = :e.storecardId, key = :e.key, ean = :e.ean, quantity = :e.quantity, color = :e.color, status = :e.status, approved = :e.approved, expanded = :e.expanded, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") OrderProcessItemsDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE app.order_process_items SET id = :e.id, uid = :e.uid, order_process_id = :e.orderProcessId, order_id = :e.orderId, order_items_id = :e.orderItemsId, shadow_order_item_id = :e.shadowOrderItemId, storecard_id = :e.storecardId, key = :e.key, ean = :e.ean, quantity = :e.quantity, color = :e.color, status = :e.status, approved = :e.approved, expanded = :e.expanded, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") OrderProcessItemsDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE app.order_process_items SET id = :e.id, uid = :e.uid, order_process_id = :e.orderProcessId, order_id = :e.orderId, order_items_id = :e.orderItemsId, shadow_order_item_id = :e.shadowOrderItemId, storecard_id = :e.storecardId, key = :e.key, ean = :e.ean, quantity = :e.quantity, color = :e.color, status = :e.status, approved = :e.approved, expanded = :e.expanded, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE order_process_id = :byOrderProcessId")
    public int updateByOrderProcessId(@BindBean(value="e") OrderProcessItemsDomain var1, @Bind(value="byOrderProcessId") Long var2);

    @SqlUpdate(value="UPDATE app.order_process_items SET id = :e.id, uid = :e.uid, order_process_id = :e.orderProcessId, order_id = :e.orderId, order_items_id = :e.orderItemsId, shadow_order_item_id = :e.shadowOrderItemId, storecard_id = :e.storecardId, key = :e.key, ean = :e.ean, quantity = :e.quantity, color = :e.color, status = :e.status, approved = :e.approved, expanded = :e.expanded, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE order_id = :byOrderId")
    public int updateByOrderId(@BindBean(value="e") OrderProcessItemsDomain var1, @Bind(value="byOrderId") Long var2);

    @SqlUpdate(value="UPDATE app.order_process_items SET id = :e.id, uid = :e.uid, order_process_id = :e.orderProcessId, order_id = :e.orderId, order_items_id = :e.orderItemsId, shadow_order_item_id = :e.shadowOrderItemId, storecard_id = :e.storecardId, key = :e.key, ean = :e.ean, quantity = :e.quantity, color = :e.color, status = :e.status, approved = :e.approved, expanded = :e.expanded, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE order_items_id = :byOrderItemsId")
    public int updateByOrderItemsId(@BindBean(value="e") OrderProcessItemsDomain var1, @Bind(value="byOrderItemsId") Long var2);

    @SqlUpdate(value="UPDATE app.order_process_items SET id = :e.id, uid = :e.uid, order_process_id = :e.orderProcessId, order_id = :e.orderId, order_items_id = :e.orderItemsId, shadow_order_item_id = :e.shadowOrderItemId, storecard_id = :e.storecardId, key = :e.key, ean = :e.ean, quantity = :e.quantity, color = :e.color, status = :e.status, approved = :e.approved, expanded = :e.expanded, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE shadow_order_item_id = :byShadowOrderItemId")
    public int updateByShadowOrderItemId(@BindBean(value="e") OrderProcessItemsDomain var1, @Bind(value="byShadowOrderItemId") Long var2);

    @SqlUpdate(value="UPDATE app.order_process_items SET id = :e.id, uid = :e.uid, order_process_id = :e.orderProcessId, order_id = :e.orderId, order_items_id = :e.orderItemsId, shadow_order_item_id = :e.shadowOrderItemId, storecard_id = :e.storecardId, key = :e.key, ean = :e.ean, quantity = :e.quantity, color = :e.color, status = :e.status, approved = :e.approved, expanded = :e.expanded, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE storecard_id = :byStorecardId")
    public int updateByStorecardId(@BindBean(value="e") OrderProcessItemsDomain var1, @Bind(value="byStorecardId") String var2);

    @SqlUpdate(value="UPDATE app.order_process_items SET id = :e.id, uid = :e.uid, order_process_id = :e.orderProcessId, order_id = :e.orderId, order_items_id = :e.orderItemsId, shadow_order_item_id = :e.shadowOrderItemId, storecard_id = :e.storecardId, key = :e.key, ean = :e.ean, quantity = :e.quantity, color = :e.color, status = :e.status, approved = :e.approved, expanded = :e.expanded, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE key = :byKey")
    public int updateByKey(@BindBean(value="e") OrderProcessItemsDomain var1, @Bind(value="byKey") String var2);

    @SqlUpdate(value="UPDATE app.order_process_items SET id = :e.id, uid = :e.uid, order_process_id = :e.orderProcessId, order_id = :e.orderId, order_items_id = :e.orderItemsId, shadow_order_item_id = :e.shadowOrderItemId, storecard_id = :e.storecardId, key = :e.key, ean = :e.ean, quantity = :e.quantity, color = :e.color, status = :e.status, approved = :e.approved, expanded = :e.expanded, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE ean = :byEan")
    public int updateByEan(@BindBean(value="e") OrderProcessItemsDomain var1, @Bind(value="byEan") String var2);

    @SqlUpdate(value="UPDATE app.order_process_items SET id = :e.id, uid = :e.uid, order_process_id = :e.orderProcessId, order_id = :e.orderId, order_items_id = :e.orderItemsId, shadow_order_item_id = :e.shadowOrderItemId, storecard_id = :e.storecardId, key = :e.key, ean = :e.ean, quantity = :e.quantity, color = :e.color, status = :e.status, approved = :e.approved, expanded = :e.expanded, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE quantity = :byQuantity")
    public int updateByQuantity(@BindBean(value="e") OrderProcessItemsDomain var1, @Bind(value="byQuantity") Double var2);

    @SqlUpdate(value="UPDATE app.order_process_items SET id = :e.id, uid = :e.uid, order_process_id = :e.orderProcessId, order_id = :e.orderId, order_items_id = :e.orderItemsId, shadow_order_item_id = :e.shadowOrderItemId, storecard_id = :e.storecardId, key = :e.key, ean = :e.ean, quantity = :e.quantity, color = :e.color, status = :e.status, approved = :e.approved, expanded = :e.expanded, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE color = :byColor")
    public int updateByColor(@BindBean(value="e") OrderProcessItemsDomain var1, @Bind(value="byColor") String var2);

    @SqlUpdate(value="UPDATE app.order_process_items SET id = :e.id, uid = :e.uid, order_process_id = :e.orderProcessId, order_id = :e.orderId, order_items_id = :e.orderItemsId, shadow_order_item_id = :e.shadowOrderItemId, storecard_id = :e.storecardId, key = :e.key, ean = :e.ean, quantity = :e.quantity, color = :e.color, status = :e.status, approved = :e.approved, expanded = :e.expanded, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE status = :byStatus")
    public int updateByStatus(@BindBean(value="e") OrderProcessItemsDomain var1, @Bind(value="byStatus") String var2);

    @SqlUpdate(value="UPDATE app.order_process_items SET id = :e.id, uid = :e.uid, order_process_id = :e.orderProcessId, order_id = :e.orderId, order_items_id = :e.orderItemsId, shadow_order_item_id = :e.shadowOrderItemId, storecard_id = :e.storecardId, key = :e.key, ean = :e.ean, quantity = :e.quantity, color = :e.color, status = :e.status, approved = :e.approved, expanded = :e.expanded, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE approved = :byApproved")
    public int updateByApproved(@BindBean(value="e") OrderProcessItemsDomain var1, @Bind(value="byApproved") Boolean var2);

    @SqlUpdate(value="UPDATE app.order_process_items SET id = :e.id, uid = :e.uid, order_process_id = :e.orderProcessId, order_id = :e.orderId, order_items_id = :e.orderItemsId, shadow_order_item_id = :e.shadowOrderItemId, storecard_id = :e.storecardId, key = :e.key, ean = :e.ean, quantity = :e.quantity, color = :e.color, status = :e.status, approved = :e.approved, expanded = :e.expanded, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE expanded = :byExpanded")
    public int updateByExpanded(@BindBean(value="e") OrderProcessItemsDomain var1, @Bind(value="byExpanded") Boolean var2);

    @SqlUpdate(value="UPDATE app.order_process_items SET id = :e.id, uid = :e.uid, order_process_id = :e.orderProcessId, order_id = :e.orderId, order_items_id = :e.orderItemsId, shadow_order_item_id = :e.shadowOrderItemId, storecard_id = :e.storecardId, key = :e.key, ean = :e.ean, quantity = :e.quantity, color = :e.color, status = :e.status, approved = :e.approved, expanded = :e.expanded, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_updated = :byDateUpdated")
    public int updateByDateUpdated(@BindBean(value="e") OrderProcessItemsDomain var1, @Bind(value="byDateUpdated") Date var2);

    @SqlUpdate(value="UPDATE app.order_process_items SET id = :e.id, uid = :e.uid, order_process_id = :e.orderProcessId, order_id = :e.orderId, order_items_id = :e.orderItemsId, shadow_order_item_id = :e.shadowOrderItemId, storecard_id = :e.storecardId, key = :e.key, ean = :e.ean, quantity = :e.quantity, color = :e.color, status = :e.status, approved = :e.approved, expanded = :e.expanded, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") OrderProcessItemsDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE app.order_process_items SET id = :e.id, uid = :e.uid, order_process_id = :e.orderProcessId, order_id = :e.orderId, order_items_id = :e.orderItemsId, shadow_order_item_id = :e.shadowOrderItemId, storecard_id = :e.storecardId, key = :e.key, ean = :e.ean, quantity = :e.quantity, color = :e.color, status = :e.status, approved = :e.approved, expanded = :e.expanded, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") OrderProcessItemsDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM app.order_process_items WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM app.order_process_items WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM app.order_process_items WHERE order_process_id = :orderProcessId")
    public int deleteByOrderProcessId(@Bind(value="orderProcessId") Long var1);

    @SqlUpdate(value="DELETE FROM app.order_process_items WHERE order_id = :orderId")
    public int deleteByOrderId(@Bind(value="orderId") Long var1);

    @SqlUpdate(value="DELETE FROM app.order_process_items WHERE order_items_id = :orderItemsId")
    public int deleteByOrderItemsId(@Bind(value="orderItemsId") Long var1);

    @SqlUpdate(value="DELETE FROM app.order_process_items WHERE shadow_order_item_id = :shadowOrderItemId")
    public int deleteByShadowOrderItemId(@Bind(value="shadowOrderItemId") Long var1);

    @SqlUpdate(value="DELETE FROM app.order_process_items WHERE storecard_id = :storecardId")
    public int deleteByStorecardId(@Bind(value="storecardId") String var1);

    @SqlUpdate(value="DELETE FROM app.order_process_items WHERE key = :key")
    public int deleteByKey(@Bind(value="key") String var1);

    @SqlUpdate(value="DELETE FROM app.order_process_items WHERE ean = :ean")
    public int deleteByEan(@Bind(value="ean") String var1);

    @SqlUpdate(value="DELETE FROM app.order_process_items WHERE quantity = :quantity")
    public int deleteByQuantity(@Bind(value="quantity") Double var1);

    @SqlUpdate(value="DELETE FROM app.order_process_items WHERE color = :color")
    public int deleteByColor(@Bind(value="color") String var1);

    @SqlUpdate(value="DELETE FROM app.order_process_items WHERE status = :status")
    public int deleteByStatus(@Bind(value="status") String var1);

    @SqlUpdate(value="DELETE FROM app.order_process_items WHERE approved = :approved")
    public int deleteByApproved(@Bind(value="approved") Boolean var1);

    @SqlUpdate(value="DELETE FROM app.order_process_items WHERE expanded = :expanded")
    public int deleteByExpanded(@Bind(value="expanded") Boolean var1);

    @SqlUpdate(value="DELETE FROM app.order_process_items WHERE date_updated = :dateUpdated")
    public int deleteByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlUpdate(value="DELETE FROM app.order_process_items WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM app.order_process_items WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

