/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.configuration;

import com.google.gson.JsonSyntaxException;
import cz.airtoy.airshop.configuration.Setup;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetupItem {
    private static final Logger log = LoggerFactory.getLogger(SetupItem.class);
    protected String key;
    protected String value;
    protected String type;
    protected Date loaded = new Date();

    public SetupItem(String key, String value, String type) {
        log.debug("Loaded key [" + key + "] value [" + value + "] type [" + type + "]");
        this.key = key;
        this.value = value;
        this.type = type;
    }

    public boolean isKey(String key) {
        return this.key.equals(key != null ? key : "");
    }

    public boolean isKeyStartsWith(String key) {
        return this.key.startsWith(key != null ? key : "");
    }

    public boolean isString() {
        return this.type != null && this.type.equals("STRING");
    }

    public boolean isInteger() {
        return this.type != null && this.type.equals("INT");
    }

    public boolean isLong() {
        return this.type != null && this.type.equals("LONG");
    }

    public boolean isDouble() {
        return this.type != null && this.type.equals("DOUBLE");
    }

    public boolean isBoolean() {
        return this.type != null && this.type.equals("BOOLEAN");
    }

    public boolean isJson() {
        return this.type != null && this.type.equals("JSON");
    }

    public String getAsString() {
        return this.value;
    }

    public Integer getAsInt() {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Long getAsLong() {
        try {
            return Long.parseLong(this.value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Double getAsDouble() {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Boolean getAsBoolean() {
        try {
            return Boolean.parseBoolean(this.value);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object getAsJsonObject(Class obj) {
        try {
            return Setup.getGson().fromJson(this.value, obj);
        }
        catch (JsonSyntaxException e) {
            log.error(String.format("Exception getAsJsonObject[%s] [%s]: %s", this.key, this.value, e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public Object getObject() {
        if (this.type != null) {
            switch (this.type) {
                case "INT": {
                    return this.getAsInt();
                }
                case "LONG": {
                    return this.getAsLong();
                }
                case "DOUBLE": {
                    return this.getAsDouble();
                }
                case "JSON": {
                    return this.getAsString();
                }
                case "BOOLEAN": {
                    return this.getAsBoolean();
                }
            }
            return this.getAsString();
        }
        return this.getAsString();
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    public Date getLoaded() {
        return this.loaded;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setLoaded(Date loaded) {
        this.loaded = loaded;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetupItem)) {
            return false;
        }
        SetupItem other = (SetupItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Date this$loaded = this.getLoaded();
        Date other$loaded = other.getLoaded();
        return !(this$loaded == null ? other$loaded != null : !((Object)this$loaded).equals(other$loaded));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetupItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Date $loaded = this.getLoaded();
        result = result * 59 + ($loaded == null ? 43 : ((Object)$loaded).hashCode());
        return result;
    }

    public String toString() {
        return "SetupItem(key=" + this.getKey() + ", value=" + this.getValue() + ", type=" + this.getType() + ", loaded=" + this.getLoaded() + ")";
    }
}

