/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import cz.airtoy.airshop.configuration.ApplicationConfig;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewJerseyClient {
    private static final Logger log = LoggerFactory.getLogger(NewJerseyClient.class);
    private WebTarget webTarget;
    private Client client;
    private static final String BASE_URI = "http://localhost:8080";
    private String username = null;
    private String password = null;

    public NewJerseyClient() {
        this.createWebClient(ApplicationConfig.CONNECT_TIMEOUT, ApplicationConfig.READ_TIMEOUT);
        if (this.client != null) {
            this.webTarget = this.client.target(BASE_URI).path("Items");
        } else {
            log.error("Cannot set target url[http://localhost:8080] - client is null");
        }
    }

    public NewJerseyClient(String url) {
        this.createWebClient(ApplicationConfig.CONNECT_TIMEOUT, ApplicationConfig.READ_TIMEOUT);
        if (this.client != null) {
            this.webTarget = this.client.target(url);
        } else {
            log.error("Cannot set target url[" + url + "] - client is null");
        }
    }

    public NewJerseyClient(String url, String username, String password) {
        this.createWebClient(ApplicationConfig.CONNECT_TIMEOUT, ApplicationConfig.READ_TIMEOUT);
        this.registerClientBasicAuth(username, password);
        this.username = username;
        this.password = password;
        if (this.client != null) {
            this.webTarget = this.client.target(url);
        } else {
            log.error("Cannot set target url[" + url + "] - client is null");
        }
    }

    public NewJerseyClient(String url, String username, String password, Integer timeout) {
        this.createWebClient(timeout, timeout);
        this.registerClientBasicAuth(username, password);
        this.username = username;
        this.password = password;
        if (this.client != null) {
            this.webTarget = this.client.target(url);
        } else {
            log.error("Cannot set target url[" + url + "] - client is null");
        }
    }

    public String getJson() {
        WebTarget resource = this.webTarget;
        String result = null;
        try {
            result = (String)resource.request(new String[]{"application/json"}).get(String.class);
        }
        catch (Exception e) {
            log.error("E: " + e.getMessage());
        }
        return result;
    }

    public String getText() {
        WebTarget resource = this.webTarget;
        String result = null;
        try {
            result = (String)resource.request(new String[]{"text/plain"}).get(String.class);
        }
        catch (Exception e) {
            log.error("E: " + e.getMessage());
        }
        return result;
    }

    public String delete() {
        WebTarget resource = this.webTarget;
        String result = null;
        try {
            result = (String)resource.request(new String[]{"application/json"}).delete(String.class);
        }
        catch (Exception e) {
            log.error("E: " + e.getMessage());
        }
        return result;
    }

    public String postJson(String post) {
        WebTarget resource = this.webTarget;
        String result = null;
        try {
            result = (String)resource.request(new String[]{"application/json"}).post(Entity.entity((Object)post, (String)"text/plain"), String.class);
        }
        catch (Exception e) {
            log.error("E: " + e.getMessage());
        }
        return result;
    }

    public String postJsonStrAcceptAll(String post) {
        WebTarget resource = this.webTarget;
        String result = null;
        try {
            result = (String)resource.request().post(Entity.entity((Object)post, (String)"text/plain"), String.class);
        }
        catch (Exception e) {
            log.error("E: " + e.getMessage());
        }
        return result;
    }

    public String postJsonAcceptJson(String post) {
        WebTarget resource = this.webTarget;
        String result = null;
        try {
            result = (String)resource.request(new String[]{"application/json"}).post(Entity.entity((Object)post, (String)"application/json"), String.class);
        }
        catch (Exception e) {
            log.error("E: " + e.getMessage());
        }
        return result;
    }

    public String postJsonAcceptAll(String post) {
        WebTarget resource = this.webTarget;
        String result = null;
        try {
            result = (String)resource.request().post(Entity.entity((Object)post, (String)"application/json"), String.class);
        }
        catch (Exception e) {
            log.error("E: " + e.getMessage());
        }
        return result;
    }

    public String putJsonAcceptJson(String put) {
        WebTarget resource = this.webTarget;
        String result = null;
        try {
            result = (String)resource.request(new String[]{"application/json"}).put(Entity.entity((Object)put, (String)"application/json"), String.class);
        }
        catch (Exception e) {
            log.error("E: " + e.getMessage());
        }
        return result;
    }

    public String postXmlAcceptPlain(String post) {
        WebTarget resource = this.webTarget;
        String result = null;
        try {
            result = (String)resource.request(new String[]{"text/plain"}).post(Entity.entity((Object)post, (String)"application/xml"), String.class);
        }
        catch (Exception e) {
            log.error("E: " + e.getMessage());
        }
        return result;
    }

    public String postObjJsonAcceptJson(Object postObj) {
        String post = null;
        try {
            Gson gson = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(Date.class, (src, typeOfSrc, context) -> src == null ? null : new JsonPrimitive((Number)src.getTime())).registerTypeAdapter(Date.class, (json, typeOfT, context) -> json == null ? null : new Date(json.getAsLong())).serializeNulls().create();
            post = gson.toJson(postObj);
        }
        catch (Exception e) {
            log.error("E: " + e.getMessage());
        }
        if (post != null) {
            WebTarget resource = this.webTarget;
            String result = null;
            try {
                result = (String)resource.request(new String[]{"application/json"}).post(Entity.entity((Object)post, (String)"application/json"), String.class);
            }
            catch (Exception e) {
                log.error("E: " + e.getMessage(), (Throwable)e);
            }
            return result;
        }
        log.error("Cannot get post");
        return null;
    }

    public void close() {
        this.client.close();
    }

    private void createWebClient(Integer connectTimeout, Integer readTimeout) {
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, new SecureRandom());
            ClientConfig configuration = new ClientConfig();
            configuration.property("jersey.config.client.connectTimeout", (Object)connectTimeout);
            configuration.property("jersey.config.client.readTimeout", (Object)readTimeout);
            this.client = ClientBuilder.newBuilder().sslContext(sslcontext).withConfig((Configuration)configuration).build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            log.error("Exception creating client: " + e.getMessage(), (Throwable)e);
        }
    }

    private void registerClientBasicAuth(String username, String password) {
        if (this.client != null) {
            HttpAuthenticationFeature feature = HttpAuthenticationFeature.basic((String)username, (String)password);
            this.client.register((Object)feature);
        } else {
            log.error("Cannot register basic auth - client is null");
        }
    }
}

