/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BarcodeUtils {
    private static final Logger log = LoggerFactory.getLogger(BarcodeUtils.class);
    private static final String NON_ALPHANUMERIC_REGEX = "[^A-Za-z0-9]";
    private static final String NON_ALPHANUMERIC_ASTERISK_OK_REGEX = "[^A-Za-z0-9\\*]";

    public static String removeAllNonAlphaNumeric(String s) {
        return s != null ? s.replaceAll(NON_ALPHANUMERIC_REGEX, "") : null;
    }

    public static String removeAllNonAlphaNumericAstrisOk(String s) {
        return s != null ? s.replaceAll(NON_ALPHANUMERIC_ASTERISK_OK_REGEX, "") : null;
    }

    public static String parseZasilkovna(String carrierId) {
        if (carrierId != null && carrierId.length() == 11 && carrierId.startsWith("Z")) {
            log.warn(String.format("CarrierId zasilkovna adjustment starts with Z 11 long strip Z [%s / %s]", carrierId, carrierId.substring(1)));
            carrierId = carrierId.substring(1);
        }
        return carrierId;
    }

    public static String parseDpdLong25(String carrierId) {
        if (carrierId != null && carrierId.length() > 25) {
            String newCarrierId = carrierId.substring(7, 21);
            log.warn(String.format("CarrierId DPD adjustment 25 chars long [%s / %s]", carrierId, newCarrierId));
            return newCarrierId;
        }
        return carrierId;
    }

    public static String parseWedoAsterisk(String carrierId) {
        String[] split;
        if (carrierId != null && carrierId.contains("*") && (split = carrierId.split("\\*")).length > 0) {
            String s = split[0];
            log.warn(String.format("CarrierId Wedo with asterisk [%s / %s]", carrierId, s));
            return s;
        }
        return carrierId;
    }

    public static String parseIntime46FSTo46F(String carrierId) {
        if (carrierId != null && carrierId.startsWith("46FS")) {
            String newCarrierId = carrierId.replace("46FS", "46F");
            if (newCarrierId.length() > 11) {
                newCarrierId = newCarrierId.substring(0, 11);
            }
            log.warn(String.format("CarrierId intime adjustment starts with 46FS > 46F [%s / %s]", carrierId, newCarrierId));
            carrierId = newCarrierId;
        }
        return carrierId;
    }

    public static String parseIntime46FOTo46F(String carrierId) {
        if (carrierId != null && carrierId.startsWith("46FO")) {
            String newCarrierId = carrierId.replace("46FO", "46F");
            if (newCarrierId.length() > 11) {
                newCarrierId = newCarrierId.substring(0, 11);
            }
            log.warn(String.format("CarrierId intime adjustment starts with 46FO > 46F [%s / %s]", carrierId, newCarrierId));
            carrierId = newCarrierId;
        }
        return carrierId;
    }
}

