/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.domains.codecs.renting;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import cz.airtoy.airshop.domains.renting.CustomerDomain;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomerDomainCodec
implements MessageCodec<CustomerDomain, CustomerDomain> {
    private static final Logger log = LoggerFactory.getLogger(CustomerDomainCodec.class);

    public void encodeToWire(Buffer buffer, CustomerDomain customerDomain) {
        GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
        Gson gson = gsonBuilder.create();
        String jsonToStr = gson.toJson((Object)customerDomain);
        int length = jsonToStr.getBytes().length;
        buffer.appendInt(length);
        buffer.appendString(jsonToStr);
    }

    public CustomerDomain decodeFromWire(int position, Buffer buffer) {
        int _pos = position;
        int length = buffer.getInt(_pos);
        String jsonStr = buffer.getString(_pos += 4, _pos += length);
        GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
        Gson gson = gsonBuilder.create();
        return (CustomerDomain)gson.fromJson(jsonStr, CustomerDomain.class);
    }

    public CustomerDomain transform(CustomerDomain customerDomain) {
        return customerDomain;
    }

    public String name() {
        return this.getClass().getSimpleName();
    }

    public byte systemCodecID() {
        return -1;
    }
}

