/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.domains.codecs.email;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import cz.airtoy.airshop.domains.email.SystemsDomain;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemsDomainCodec
implements MessageCodec<SystemsDomain, SystemsDomain> {
    private static final Logger log = LoggerFactory.getLogger(SystemsDomainCodec.class);

    public void encodeToWire(Buffer buffer, SystemsDomain systemsDomain) {
        GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
        Gson gson = gsonBuilder.create();
        String jsonToStr = gson.toJson((Object)systemsDomain);
        int length = jsonToStr.getBytes().length;
        buffer.appendInt(length);
        buffer.appendString(jsonToStr);
    }

    public SystemsDomain decodeFromWire(int position, Buffer buffer) {
        int _pos = position;
        int length = buffer.getInt(_pos);
        String jsonStr = buffer.getString(_pos += 4, _pos += length);
        GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
        Gson gson = gsonBuilder.create();
        return (SystemsDomain)gson.fromJson(jsonStr, SystemsDomain.class);
    }

    public SystemsDomain transform(SystemsDomain systemsDomain) {
        return systemsDomain;
    }

    public String name() {
        return this.getClass().getSimpleName();
    }

    public byte systemCodecID() {
        return -1;
    }
}

