/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.renting;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.renting.DepositMapper;
import cz.airtoy.airshop.dao.mappers.renting.full.DepositFullMapper;
import cz.airtoy.airshop.domains.renting.DepositDomain;
import cz.airtoy.airshop.domains.renting.full.DepositFullDomain;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface DepositDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.customer_id,\n\t\tp.partner_id,\n\t\tp.payment_type,\n\t\tp.amount,\n\t\tp.date_received,\n\t\tp.return_amount,\n\t\tp.date_return,\n\t\tp.payment_type_return,\n\t\tp.date_updated,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\trenting.deposit p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.customer_id::text ~* :mask \n\tOR \n\t\tp.partner_id::text ~* :mask \n\tOR \n\t\tp.payment_type::text ~* :mask \n\tOR \n\t\tp.amount::text ~* :mask \n\tOR \n\t\tp.date_received::text ~* :mask \n\tOR \n\t\tp.return_amount::text ~* :mask \n\tOR \n\t\tp.date_return::text ~* :mask \n\tOR \n\t\tp.payment_type_return::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=DepositMapper.class)
    public List<DepositDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t  p.id,\n\t\tp.uid,\n\t\tp.customer_id,\n\t\tp.partner_id,\n\t\tp.payment_type,\n\t\tp.amount,\n\t\tp.date_received,\n\t\tp.return_amount,\n\t\tp.date_return,\n\t\tp.payment_type_return,\n\t\tp.date_updated,\n\t\tp.note,\n\t\tp.date_created,\n \tcu.id AS \"cust_id\",\n\t\tcu.uid AS \"cust_uid\",\n\t\tcu.phone AS \"cust_phone\",\n\t\tcu.email AS \"cust_email\",\n\t\tcu.username AS \"cust_username\",\n\t\tcu.password AS \"cust_password\",\n\t\tcu.nickname AS \"cust_nickname\",\n\t\tcu.credit AS \"cust_credit\",\n\t\tcu.vip_valid_to AS \"cust_vip_valid_to\",\n\t\tcu.firstname AS \"cust_firstname\",\n\t\tcu.middlename AS \"cust_middlename\",\n\t\tcu.lastname AS \"cust_lastname\",\n\t\tcu.identity_card_number AS \"cust_identity_card_number\",\n\t\tcu.date_birthday AS \"cust_date_birthday\",\n\t\tcu.last_seen AS \"cust_last_seen\",\n\t\tcu.street AS \"cust_street\",\n\t\tcu.street_nr AS \"cust_street_nr\",\n\t\tcu.zip AS \"cust_zip\",\n\t\tcu.city AS \"cust_city\",\n\t\tcu.city_uid AS \"cust_city_uid\",\n\t\tcu.country AS \"cust_country\",\n\t\tcu.company AS \"cust_company\",\n\t\tcu.company_id AS \"cust_company_id\",\n\t\tcu.company_vat AS \"cust_company_vat\",\n\t\tcu.invoice_street AS \"cust_invoice_street\",\n\t\tcu.invoice_street_nr AS \"cust_invoice_street_nr\",\n\t\tcu.invoice_zip AS \"cust_invoice_zip\",\n\t\tcu.invoice_city AS \"cust_invoice_city\",\n\t\tcu.invoice_city_uid AS \"cust_invoice_city_uid\",\n\t\tcu.invoice_country AS \"cust_invoice_country\",\n\t\tcu.store_id AS \"cust_store_id\",\n\t\tcu.active AS \"cust_active\",\n\t\tcu.confirmed AS \"cust_confirmed\",\n\t\tcu.date_changed AS \"cust_date_changed\",\n\t\tcu.user_changed AS \"cust_user_changed\",\n\t\tcu.note AS \"cust_note\",\n\t\tcu.date_created AS \"cust_date_created\",\n\t  co.id AS \"contr_id\",\n\t\tco.uid AS \"contr_uid\",\n\t\tco.type AS \"contr_type\",\n\t\tco.customer_id AS \"contr_customer_id\",\n\t\tco.reservation_id AS \"contr_reservation_id\",\n\t\tco.partner_id AS \"contr_partner_id\",\n\t\tco.deposit_id AS \"contr_deposit_id\",\n\t\tco.status AS \"contr_status\",\n\t\tco.variable_symbol AS \"contr_variable_symbol\",\n\t\tco.deposit_amount AS \"contr_deposit_amount\",\n\t\tco.amount AS \"contr_amount\",\n\t\tco.payment_type AS \"contr_payment_type\",\n\t\tco.date_from AS \"contr_date_from\",\n\t\tco.date_to AS \"contr_date_to\",\n\t\tco.date_rent AS \"contr_date_rent\",\n\t\tco.date_return AS \"contr_date_return\",\n\t\tco.date_reminder AS \"contr_date_reminder\",\n\t\tco.return_note AS \"contr_return_note\",\n\t\tco.date_updated AS \"contr_date_updated\",\n\t\tco.note AS \"contr_note\",\n\t\tco.date_created AS \"contr_date_created\"\n FROM \n\t\trenting.deposit p\n\t\tLEFT OUTER JOIN renting.customer cu ON (p.customer_id = cu.id)\n\t\tLEFT OUTER JOIN renting.contract co ON (co.deposit_id = p.id)\n\tWHERE \n\t\t(CASE WHEN :paymentType = 'ALL' THEN TRUE ELSE (p.payment_type = :paymentType) END) \n\tAND \n\t\t(CASE WHEN :status = 'ALL' THEN TRUE ELSE :status = co.status END) \n\tAND ( \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.customer_id::text ~* :mask \n\tOR \n\t\tp.partner_id::text ~* :mask \n\tOR \n\t\tp.payment_type::text ~* :mask \n\tOR \n\t\tp.amount::text ~* :mask \n\tOR \n\t\tp.date_received::text ~* :mask \n\tOR \n\t\tp.return_amount::text ~* :mask \n\tOR \n\t\tp.date_return::text ~* :mask \n\tOR \n\t\tp.payment_type_return::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\t) \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=DepositFullMapper.class)
    public List<DepositFullDomain> findByMaskFull(@Bind(value="paymentType") String var1, @Bind(value="status") String var2, @Bind(value="mask") String var3, @Bind(value="offset") int var4, @Bind(value="limit") int var5, @Define(value="order") String var6, @Define(value="sort") String var7);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\trenting.deposit p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.customer_id::text ~* :mask \n\tOR \n\t\tp.partner_id::text ~* :mask \n\tOR \n\t\tp.payment_type::text ~* :mask \n\tOR \n\t\tp.amount::text ~* :mask \n\tOR \n\t\tp.date_received::text ~* :mask \n\tOR \n\t\tp.return_amount::text ~* :mask \n\tOR \n\t\tp.date_return::text ~* :mask \n\tOR \n\t\tp.payment_type_return::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\trenting.deposit p\n\t\tLEFT OUTER JOIN renting.customer cu ON (p.customer_id = cu.id)\n\t\tLEFT OUTER JOIN renting.contract co ON (co.deposit_id = p.id)\n\tWHERE \n\t\t(CASE WHEN :paymentType = 'ALL' THEN TRUE ELSE (p.payment_type = :paymentType) END) \n\tAND \n\t\t(CASE WHEN :status = 'ALL' THEN TRUE ELSE :status = co.status END) \n\tAND ( \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.customer_id::text ~* :mask \n\tOR \n\t\tp.partner_id::text ~* :mask \n\tOR \n\t\tp.payment_type::text ~* :mask \n\tOR \n\t\tp.amount::text ~* :mask \n\tOR \n\t\tp.date_received::text ~* :mask \n\tOR \n\t\tp.return_amount::text ~* :mask \n\tOR \n\t\tp.date_return::text ~* :mask \n\tOR \n\t\tp.payment_type_return::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\t) \n\n")
    public long findByMaskFullCount(@Bind(value="paymentType") String var1, @Bind(value="status") String var2, @Bind(value="mask") String var3);

    @SqlQuery(value="SELECT \n\t\tSUM(p.amount) \n FROM \n\t\trenting.deposit p\n\t\tLEFT OUTER JOIN renting.contract co ON (co.deposit_id = p.id)\n\tWHERE \n\t\t(CASE WHEN :paymentType = 'ALL' THEN TRUE ELSE (p.payment_type = :paymentType) END) \n\tAND \n\t\t(CASE WHEN :status = 'ALL' THEN TRUE ELSE :status = co.status END) \n\tAND \n   p.date_created > ( TIMESTAMP WITH TIME ZONE 'epoch' + :createdGte * INTERVAL '1 millisecond' ) AND p.date_created < ( TIMESTAMP WITH TIME ZONE 'epoch' + :createdLte * INTERVAL '1 millisecond' ) \t\n")
    public BigDecimal getDepositSum(@Bind(value="paymentType") String var1, @Bind(value="status") String var2, @Bind(value="createdGte") BigDecimal var3, @Bind(value="createdLte") BigDecimal var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  ")
    @RegisterRowMapper(value=DepositMapper.class)
    public List<DepositDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.id = :id")
    @RegisterRowMapper(value=DepositMapper.class)
    public DepositDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.id = :id")
    @RegisterRowMapper(value=DepositMapper.class)
    public List<DepositDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.deposit p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DepositMapper.class)
    public List<DepositDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=DepositMapper.class)
    public DepositDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=DepositMapper.class)
    public List<DepositDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.deposit p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DepositMapper.class)
    public List<DepositDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.customer_id = :customerId")
    @RegisterRowMapper(value=DepositMapper.class)
    public DepositDomain findByCustomerId(@Bind(value="customerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.customer_id = :customerId")
    @RegisterRowMapper(value=DepositMapper.class)
    public List<DepositDomain> findListByCustomerId(@Bind(value="customerId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.deposit p  WHERE p.customer_id = :customerId")
    public long findListByCustomerIdCount(@Bind(value="customerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.customer_id = :customerId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DepositMapper.class)
    public List<DepositDomain> findListByCustomerId(@Bind(value="customerId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.partner_id = :partnerId")
    @RegisterRowMapper(value=DepositMapper.class)
    public DepositDomain findByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.partner_id = :partnerId")
    @RegisterRowMapper(value=DepositMapper.class)
    public List<DepositDomain> findListByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.deposit p  WHERE p.partner_id = :partnerId")
    public long findListByPartnerIdCount(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.partner_id = :partnerId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DepositMapper.class)
    public List<DepositDomain> findListByPartnerId(@Bind(value="partnerId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.payment_type = :paymentType")
    @RegisterRowMapper(value=DepositMapper.class)
    public DepositDomain findByPaymentType(@Bind(value="paymentType") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.payment_type = :paymentType")
    @RegisterRowMapper(value=DepositMapper.class)
    public List<DepositDomain> findListByPaymentType(@Bind(value="paymentType") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.deposit p  WHERE p.payment_type = :paymentType")
    public long findListByPaymentTypeCount(@Bind(value="paymentType") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.payment_type = :paymentType ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DepositMapper.class)
    public List<DepositDomain> findListByPaymentType(@Bind(value="paymentType") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.amount = :amount")
    @RegisterRowMapper(value=DepositMapper.class)
    public DepositDomain findByAmount(@Bind(value="amount") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.amount = :amount")
    @RegisterRowMapper(value=DepositMapper.class)
    public List<DepositDomain> findListByAmount(@Bind(value="amount") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.deposit p  WHERE p.amount = :amount")
    public long findListByAmountCount(@Bind(value="amount") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.amount = :amount ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DepositMapper.class)
    public List<DepositDomain> findListByAmount(@Bind(value="amount") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.date_received = :dateReceived")
    @RegisterRowMapper(value=DepositMapper.class)
    public DepositDomain findByDateReceived(@Bind(value="dateReceived") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.date_received = :dateReceived")
    @RegisterRowMapper(value=DepositMapper.class)
    public List<DepositDomain> findListByDateReceived(@Bind(value="dateReceived") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.deposit p  WHERE p.date_received = :dateReceived")
    public long findListByDateReceivedCount(@Bind(value="dateReceived") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.date_received = :dateReceived ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DepositMapper.class)
    public List<DepositDomain> findListByDateReceived(@Bind(value="dateReceived") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.return_amount = :returnAmount")
    @RegisterRowMapper(value=DepositMapper.class)
    public DepositDomain findByReturnAmount(@Bind(value="returnAmount") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.return_amount = :returnAmount")
    @RegisterRowMapper(value=DepositMapper.class)
    public List<DepositDomain> findListByReturnAmount(@Bind(value="returnAmount") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.deposit p  WHERE p.return_amount = :returnAmount")
    public long findListByReturnAmountCount(@Bind(value="returnAmount") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.return_amount = :returnAmount ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DepositMapper.class)
    public List<DepositDomain> findListByReturnAmount(@Bind(value="returnAmount") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.date_return = :dateReturn")
    @RegisterRowMapper(value=DepositMapper.class)
    public DepositDomain findByDateReturn(@Bind(value="dateReturn") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.date_return = :dateReturn")
    @RegisterRowMapper(value=DepositMapper.class)
    public List<DepositDomain> findListByDateReturn(@Bind(value="dateReturn") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.deposit p  WHERE p.date_return = :dateReturn")
    public long findListByDateReturnCount(@Bind(value="dateReturn") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.date_return = :dateReturn ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DepositMapper.class)
    public List<DepositDomain> findListByDateReturn(@Bind(value="dateReturn") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.payment_type_return = :paymentTypeReturn")
    @RegisterRowMapper(value=DepositMapper.class)
    public DepositDomain findByPaymentTypeReturn(@Bind(value="paymentTypeReturn") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.payment_type_return = :paymentTypeReturn")
    @RegisterRowMapper(value=DepositMapper.class)
    public List<DepositDomain> findListByPaymentTypeReturn(@Bind(value="paymentTypeReturn") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.deposit p  WHERE p.payment_type_return = :paymentTypeReturn")
    public long findListByPaymentTypeReturnCount(@Bind(value="paymentTypeReturn") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.payment_type_return = :paymentTypeReturn ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DepositMapper.class)
    public List<DepositDomain> findListByPaymentTypeReturn(@Bind(value="paymentTypeReturn") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=DepositMapper.class)
    public DepositDomain findByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=DepositMapper.class)
    public List<DepositDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.deposit p  WHERE p.date_updated = :dateUpdated")
    public long findListByDateUpdatedCount(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.date_updated = :dateUpdated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DepositMapper.class)
    public List<DepositDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.note = :note")
    @RegisterRowMapper(value=DepositMapper.class)
    public DepositDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.note = :note")
    @RegisterRowMapper(value=DepositMapper.class)
    public List<DepositDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.deposit p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DepositMapper.class)
    public List<DepositDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=DepositMapper.class)
    public DepositDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=DepositMapper.class)
    public List<DepositDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.deposit p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.payment_type, p.amount, p.date_received, p.return_amount, p.date_return, p.payment_type_return, p.date_updated, p.note, p.date_created FROM renting.deposit p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DepositMapper.class)
    public List<DepositDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO renting.deposit (id, uid, customer_id, partner_id, payment_type, amount, date_received, return_amount, date_return, payment_type_return, date_updated, note, date_created) VALUES (:id, :uid, :customerId, :partnerId, :paymentType, :amount, :dateReceived, :returnAmount, :dateReturn, :paymentTypeReturn, :dateUpdated, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="customerId") Long var3, @Bind(value="partnerId") Long var4, @Bind(value="paymentType") String var5, @Bind(value="amount") Double var6, @Bind(value="dateReceived") Date var7, @Bind(value="returnAmount") Double var8, @Bind(value="dateReturn") Date var9, @Bind(value="paymentTypeReturn") String var10, @Bind(value="dateUpdated") Date var11, @Bind(value="note") String var12, @Bind(value="dateCreated") Date var13);

    @SqlUpdate(value="INSERT INTO renting.deposit (customer_id, partner_id, payment_type, amount, date_received, return_amount, date_return, payment_type_return, date_updated, note, date_created) VALUES (:e.customerId, :e.partnerId, :e.paymentType, :e.amount, :e.dateReceived, :e.returnAmount, :e.dateReturn, :e.paymentTypeReturn, :e.dateUpdated, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") DepositDomain var1);

    @SqlUpdate(value="UPDATE renting.deposit SET id = :e.id, uid = :e.uid, customer_id = :e.customerId, partner_id = :e.partnerId, payment_type = :e.paymentType, amount = :e.amount, date_received = :e.dateReceived, return_amount = :e.returnAmount, date_return = :e.dateReturn, payment_type_return = :e.paymentTypeReturn, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") DepositDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE renting.deposit SET id = :e.id, uid = :e.uid, customer_id = :e.customerId, partner_id = :e.partnerId, payment_type = :e.paymentType, amount = :e.amount, date_received = :e.dateReceived, return_amount = :e.returnAmount, date_return = :e.dateReturn, payment_type_return = :e.paymentTypeReturn, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") DepositDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE renting.deposit SET id = :e.id, uid = :e.uid, customer_id = :e.customerId, partner_id = :e.partnerId, payment_type = :e.paymentType, amount = :e.amount, date_received = :e.dateReceived, return_amount = :e.returnAmount, date_return = :e.dateReturn, payment_type_return = :e.paymentTypeReturn, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE customer_id = :byCustomerId")
    public int updateByCustomerId(@BindBean(value="e") DepositDomain var1, @Bind(value="byCustomerId") Long var2);

    @SqlUpdate(value="UPDATE renting.deposit SET id = :e.id, uid = :e.uid, customer_id = :e.customerId, partner_id = :e.partnerId, payment_type = :e.paymentType, amount = :e.amount, date_received = :e.dateReceived, return_amount = :e.returnAmount, date_return = :e.dateReturn, payment_type_return = :e.paymentTypeReturn, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE partner_id = :byPartnerId")
    public int updateByPartnerId(@BindBean(value="e") DepositDomain var1, @Bind(value="byPartnerId") Long var2);

    @SqlUpdate(value="UPDATE renting.deposit SET id = :e.id, uid = :e.uid, customer_id = :e.customerId, partner_id = :e.partnerId, payment_type = :e.paymentType, amount = :e.amount, date_received = :e.dateReceived, return_amount = :e.returnAmount, date_return = :e.dateReturn, payment_type_return = :e.paymentTypeReturn, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE payment_type = :byPaymentType")
    public int updateByPaymentType(@BindBean(value="e") DepositDomain var1, @Bind(value="byPaymentType") String var2);

    @SqlUpdate(value="UPDATE renting.deposit SET id = :e.id, uid = :e.uid, customer_id = :e.customerId, partner_id = :e.partnerId, payment_type = :e.paymentType, amount = :e.amount, date_received = :e.dateReceived, return_amount = :e.returnAmount, date_return = :e.dateReturn, payment_type_return = :e.paymentTypeReturn, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE amount = :byAmount")
    public int updateByAmount(@BindBean(value="e") DepositDomain var1, @Bind(value="byAmount") Double var2);

    @SqlUpdate(value="UPDATE renting.deposit SET id = :e.id, uid = :e.uid, customer_id = :e.customerId, partner_id = :e.partnerId, payment_type = :e.paymentType, amount = :e.amount, date_received = :e.dateReceived, return_amount = :e.returnAmount, date_return = :e.dateReturn, payment_type_return = :e.paymentTypeReturn, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_received = :byDateReceived")
    public int updateByDateReceived(@BindBean(value="e") DepositDomain var1, @Bind(value="byDateReceived") Date var2);

    @SqlUpdate(value="UPDATE renting.deposit SET id = :e.id, uid = :e.uid, customer_id = :e.customerId, partner_id = :e.partnerId, payment_type = :e.paymentType, amount = :e.amount, date_received = :e.dateReceived, return_amount = :e.returnAmount, date_return = :e.dateReturn, payment_type_return = :e.paymentTypeReturn, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE return_amount = :byReturnAmount")
    public int updateByReturnAmount(@BindBean(value="e") DepositDomain var1, @Bind(value="byReturnAmount") Double var2);

    @SqlUpdate(value="UPDATE renting.deposit SET id = :e.id, uid = :e.uid, customer_id = :e.customerId, partner_id = :e.partnerId, payment_type = :e.paymentType, amount = :e.amount, date_received = :e.dateReceived, return_amount = :e.returnAmount, date_return = :e.dateReturn, payment_type_return = :e.paymentTypeReturn, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_return = :byDateReturn")
    public int updateByDateReturn(@BindBean(value="e") DepositDomain var1, @Bind(value="byDateReturn") Date var2);

    @SqlUpdate(value="UPDATE renting.deposit SET id = :e.id, uid = :e.uid, customer_id = :e.customerId, partner_id = :e.partnerId, payment_type = :e.paymentType, amount = :e.amount, date_received = :e.dateReceived, return_amount = :e.returnAmount, date_return = :e.dateReturn, payment_type_return = :e.paymentTypeReturn, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE payment_type_return = :byPaymentTypeReturn")
    public int updateByPaymentTypeReturn(@BindBean(value="e") DepositDomain var1, @Bind(value="byPaymentTypeReturn") String var2);

    @SqlUpdate(value="UPDATE renting.deposit SET id = :e.id, uid = :e.uid, customer_id = :e.customerId, partner_id = :e.partnerId, payment_type = :e.paymentType, amount = :e.amount, date_received = :e.dateReceived, return_amount = :e.returnAmount, date_return = :e.dateReturn, payment_type_return = :e.paymentTypeReturn, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_updated = :byDateUpdated")
    public int updateByDateUpdated(@BindBean(value="e") DepositDomain var1, @Bind(value="byDateUpdated") Date var2);

    @SqlUpdate(value="UPDATE renting.deposit SET id = :e.id, uid = :e.uid, customer_id = :e.customerId, partner_id = :e.partnerId, payment_type = :e.paymentType, amount = :e.amount, date_received = :e.dateReceived, return_amount = :e.returnAmount, date_return = :e.dateReturn, payment_type_return = :e.paymentTypeReturn, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") DepositDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE renting.deposit SET id = :e.id, uid = :e.uid, customer_id = :e.customerId, partner_id = :e.partnerId, payment_type = :e.paymentType, amount = :e.amount, date_received = :e.dateReceived, return_amount = :e.returnAmount, date_return = :e.dateReturn, payment_type_return = :e.paymentTypeReturn, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") DepositDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM renting.deposit WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM renting.deposit WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM renting.deposit WHERE customer_id = :customerId")
    public int deleteByCustomerId(@Bind(value="customerId") Long var1);

    @SqlUpdate(value="DELETE FROM renting.deposit WHERE partner_id = :partnerId")
    public int deleteByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlUpdate(value="DELETE FROM renting.deposit WHERE payment_type = :paymentType")
    public int deleteByPaymentType(@Bind(value="paymentType") String var1);

    @SqlUpdate(value="DELETE FROM renting.deposit WHERE amount = :amount")
    public int deleteByAmount(@Bind(value="amount") Double var1);

    @SqlUpdate(value="DELETE FROM renting.deposit WHERE date_received = :dateReceived")
    public int deleteByDateReceived(@Bind(value="dateReceived") Date var1);

    @SqlUpdate(value="DELETE FROM renting.deposit WHERE return_amount = :returnAmount")
    public int deleteByReturnAmount(@Bind(value="returnAmount") Double var1);

    @SqlUpdate(value="DELETE FROM renting.deposit WHERE date_return = :dateReturn")
    public int deleteByDateReturn(@Bind(value="dateReturn") Date var1);

    @SqlUpdate(value="DELETE FROM renting.deposit WHERE payment_type_return = :paymentTypeReturn")
    public int deleteByPaymentTypeReturn(@Bind(value="paymentTypeReturn") String var1);

    @SqlUpdate(value="DELETE FROM renting.deposit WHERE date_updated = :dateUpdated")
    public int deleteByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlUpdate(value="DELETE FROM renting.deposit WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM renting.deposit WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

