/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.data;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.data.TargetCommodityPropertyMapper;
import cz.airtoy.airshop.domains.data.TargetCommodityPropertyDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface TargetCommodityPropertyDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.target_commodity_id,\n\t\tp.language_name,\n\t\tp.name,\n\t\tp.value,\n\t\tp.date_updated,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tdata.target_commodity_property p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.target_commodity_id::text ~* :mask \n\tOR \n\t\tp.language_name::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.value::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=TargetCommodityPropertyMapper.class)
    public List<TargetCommodityPropertyDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tdata.target_commodity_property p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.target_commodity_id::text ~* :mask \n\tOR \n\t\tp.language_name::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.value::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_commodity_property p  ")
    @RegisterRowMapper(value=TargetCommodityPropertyMapper.class)
    public List<TargetCommodityPropertyDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_commodity_property p  WHERE p.id = :id")
    @RegisterRowMapper(value=TargetCommodityPropertyMapper.class)
    public TargetCommodityPropertyDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_commodity_property p  WHERE p.id = :id")
    @RegisterRowMapper(value=TargetCommodityPropertyMapper.class)
    public List<TargetCommodityPropertyDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity_property p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_commodity_property p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityPropertyMapper.class)
    public List<TargetCommodityPropertyDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_commodity_property p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=TargetCommodityPropertyMapper.class)
    public TargetCommodityPropertyDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_commodity_property p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=TargetCommodityPropertyMapper.class)
    public List<TargetCommodityPropertyDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity_property p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_commodity_property p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityPropertyMapper.class)
    public List<TargetCommodityPropertyDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_commodity_property p  WHERE p.target_commodity_id = :targetCommodityId")
    @RegisterRowMapper(value=TargetCommodityPropertyMapper.class)
    public TargetCommodityPropertyDomain findByTargetCommodityId(@Bind(value="targetCommodityId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_commodity_property p  WHERE p.target_commodity_id = :targetCommodityId")
    @RegisterRowMapper(value=TargetCommodityPropertyMapper.class)
    public List<TargetCommodityPropertyDomain> findListByTargetCommodityId(@Bind(value="targetCommodityId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity_property p  WHERE p.target_commodity_id = :targetCommodityId")
    public long findListByTargetCommodityIdCount(@Bind(value="targetCommodityId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_commodity_property p  WHERE p.target_commodity_id = :targetCommodityId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityPropertyMapper.class)
    public List<TargetCommodityPropertyDomain> findListByTargetCommodityId(@Bind(value="targetCommodityId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_commodity_property p  WHERE p.language_name = :languageName")
    @RegisterRowMapper(value=TargetCommodityPropertyMapper.class)
    public TargetCommodityPropertyDomain findByLanguageName(@Bind(value="languageName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_commodity_property p  WHERE p.language_name = :languageName")
    @RegisterRowMapper(value=TargetCommodityPropertyMapper.class)
    public List<TargetCommodityPropertyDomain> findListByLanguageName(@Bind(value="languageName") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity_property p  WHERE p.language_name = :languageName")
    public long findListByLanguageNameCount(@Bind(value="languageName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_commodity_property p  WHERE p.language_name = :languageName ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityPropertyMapper.class)
    public List<TargetCommodityPropertyDomain> findListByLanguageName(@Bind(value="languageName") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_commodity_property p  WHERE p.name = :name")
    @RegisterRowMapper(value=TargetCommodityPropertyMapper.class)
    public TargetCommodityPropertyDomain findByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_commodity_property p  WHERE p.name = :name")
    @RegisterRowMapper(value=TargetCommodityPropertyMapper.class)
    public List<TargetCommodityPropertyDomain> findListByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity_property p  WHERE p.name = :name")
    public long findListByNameCount(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_commodity_property p  WHERE p.name = :name ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityPropertyMapper.class)
    public List<TargetCommodityPropertyDomain> findListByName(@Bind(value="name") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_commodity_property p  WHERE p.value = :value")
    @RegisterRowMapper(value=TargetCommodityPropertyMapper.class)
    public TargetCommodityPropertyDomain findByValue(@Bind(value="value") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_commodity_property p  WHERE p.value = :value")
    @RegisterRowMapper(value=TargetCommodityPropertyMapper.class)
    public List<TargetCommodityPropertyDomain> findListByValue(@Bind(value="value") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity_property p  WHERE p.value = :value")
    public long findListByValueCount(@Bind(value="value") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_commodity_property p  WHERE p.value = :value ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityPropertyMapper.class)
    public List<TargetCommodityPropertyDomain> findListByValue(@Bind(value="value") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_commodity_property p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=TargetCommodityPropertyMapper.class)
    public TargetCommodityPropertyDomain findByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_commodity_property p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=TargetCommodityPropertyMapper.class)
    public List<TargetCommodityPropertyDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity_property p  WHERE p.date_updated = :dateUpdated")
    public long findListByDateUpdatedCount(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_commodity_property p  WHERE p.date_updated = :dateUpdated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityPropertyMapper.class)
    public List<TargetCommodityPropertyDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_commodity_property p  WHERE p.note = :note")
    @RegisterRowMapper(value=TargetCommodityPropertyMapper.class)
    public TargetCommodityPropertyDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_commodity_property p  WHERE p.note = :note")
    @RegisterRowMapper(value=TargetCommodityPropertyMapper.class)
    public List<TargetCommodityPropertyDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity_property p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_commodity_property p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityPropertyMapper.class)
    public List<TargetCommodityPropertyDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_commodity_property p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=TargetCommodityPropertyMapper.class)
    public TargetCommodityPropertyDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_commodity_property p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=TargetCommodityPropertyMapper.class)
    public List<TargetCommodityPropertyDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity_property p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.language_name, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_commodity_property p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityPropertyMapper.class)
    public List<TargetCommodityPropertyDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO data.target_commodity_property (id, uid, target_commodity_id, language_name, name, value, date_updated, note, date_created) VALUES (:id, :uid, :targetCommodityId, :languageName, :name, :value, :dateUpdated, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="targetCommodityId") Long var3, @Bind(value="languageName") String var4, @Bind(value="name") String var5, @Bind(value="value") String var6, @Bind(value="dateUpdated") Date var7, @Bind(value="note") String var8, @Bind(value="dateCreated") Date var9);

    @SqlUpdate(value="INSERT INTO data.target_commodity_property (target_commodity_id, language_name, name, value, date_updated, note, date_created) VALUES (:e.targetCommodityId, :e.languageName, :e.name, :e.value, :e.dateUpdated, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") TargetCommodityPropertyDomain var1);

    @SqlUpdate(value="UPDATE data.target_commodity_property SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, language_name = :e.languageName, name = :e.name, value = :e.value, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") TargetCommodityPropertyDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE data.target_commodity_property SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, language_name = :e.languageName, name = :e.name, value = :e.value, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") TargetCommodityPropertyDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity_property SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, language_name = :e.languageName, name = :e.name, value = :e.value, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE target_commodity_id = :byTargetCommodityId")
    public int updateByTargetCommodityId(@BindBean(value="e") TargetCommodityPropertyDomain var1, @Bind(value="byTargetCommodityId") Long var2);

    @SqlUpdate(value="UPDATE data.target_commodity_property SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, language_name = :e.languageName, name = :e.name, value = :e.value, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE language_name = :byLanguageName")
    public int updateByLanguageName(@BindBean(value="e") TargetCommodityPropertyDomain var1, @Bind(value="byLanguageName") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity_property SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, language_name = :e.languageName, name = :e.name, value = :e.value, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE name = :byName")
    public int updateByName(@BindBean(value="e") TargetCommodityPropertyDomain var1, @Bind(value="byName") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity_property SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, language_name = :e.languageName, name = :e.name, value = :e.value, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE value = :byValue")
    public int updateByValue(@BindBean(value="e") TargetCommodityPropertyDomain var1, @Bind(value="byValue") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity_property SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, language_name = :e.languageName, name = :e.name, value = :e.value, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_updated = :byDateUpdated")
    public int updateByDateUpdated(@BindBean(value="e") TargetCommodityPropertyDomain var1, @Bind(value="byDateUpdated") Date var2);

    @SqlUpdate(value="UPDATE data.target_commodity_property SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, language_name = :e.languageName, name = :e.name, value = :e.value, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") TargetCommodityPropertyDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity_property SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, language_name = :e.languageName, name = :e.name, value = :e.value, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") TargetCommodityPropertyDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM data.target_commodity_property WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity_property WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity_property WHERE target_commodity_id = :targetCommodityId")
    public int deleteByTargetCommodityId(@Bind(value="targetCommodityId") Long var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity_property WHERE language_name = :languageName")
    public int deleteByLanguageName(@Bind(value="languageName") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity_property WHERE name = :name")
    public int deleteByName(@Bind(value="name") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity_property WHERE value = :value")
    public int deleteByValue(@Bind(value="value") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity_property WHERE date_updated = :dateUpdated")
    public int deleteByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity_property WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity_property WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

