/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.system;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.system.SystemOrdersMapper;
import cz.airtoy.airshop.domains.system.SystemOrdersDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface SystemOrdersDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.token,\n\t\tp.email,\n\t\tp.firstname,\n\t\tp.lastname,\n\t\tp.phone,\n\t\tp.beershop_order_id,\n\t\tp.date_order,\n\t\tp.date_changed,\n\t\tp.user_changed,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tsystem.orders p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.token::text ~* :mask \n\tOR \n\t\tp.email::text ~* :mask \n\tOR \n\t\tp.firstname::text ~* :mask \n\tOR \n\t\tp.lastname::text ~* :mask \n\tOR \n\t\tp.phone::text ~* :mask \n\tOR \n\t\tp.beershop_order_id::text ~* :mask \n\tOR \n\t\tp.date_order::text ~* :mask \n\tOR \n\t\tp.date_changed::text ~* :mask \n\tOR \n\t\tp.user_changed::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public List<SystemOrdersDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tsystem.orders p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.token::text ~* :mask \n\tOR \n\t\tp.email::text ~* :mask \n\tOR \n\t\tp.firstname::text ~* :mask \n\tOR \n\t\tp.lastname::text ~* :mask \n\tOR \n\t\tp.phone::text ~* :mask \n\tOR \n\t\tp.beershop_order_id::text ~* :mask \n\tOR \n\t\tp.date_order::text ~* :mask \n\tOR \n\t\tp.date_changed::text ~* :mask \n\tOR \n\t\tp.user_changed::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  ")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public List<SystemOrdersDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.id = :id")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public SystemOrdersDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.id = :id")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public List<SystemOrdersDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.orders p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public List<SystemOrdersDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.token = :token")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public SystemOrdersDomain findByToken(@Bind(value="token") String var1);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.token = :token")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public List<SystemOrdersDomain> findListByToken(@Bind(value="token") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.orders p  WHERE p.token = :token")
    public long findListByTokenCount(@Bind(value="token") String var1);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.token = :token ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public List<SystemOrdersDomain> findListByToken(@Bind(value="token") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.email = :email")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public SystemOrdersDomain findByEmail(@Bind(value="email") String var1);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.email = :email")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public List<SystemOrdersDomain> findListByEmail(@Bind(value="email") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.orders p  WHERE p.email = :email")
    public long findListByEmailCount(@Bind(value="email") String var1);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.email = :email ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public List<SystemOrdersDomain> findListByEmail(@Bind(value="email") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.firstname = :firstname")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public SystemOrdersDomain findByFirstname(@Bind(value="firstname") String var1);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.firstname = :firstname")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public List<SystemOrdersDomain> findListByFirstname(@Bind(value="firstname") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.orders p  WHERE p.firstname = :firstname")
    public long findListByFirstnameCount(@Bind(value="firstname") String var1);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.firstname = :firstname ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public List<SystemOrdersDomain> findListByFirstname(@Bind(value="firstname") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.lastname = :lastname")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public SystemOrdersDomain findByLastname(@Bind(value="lastname") String var1);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.lastname = :lastname")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public List<SystemOrdersDomain> findListByLastname(@Bind(value="lastname") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.orders p  WHERE p.lastname = :lastname")
    public long findListByLastnameCount(@Bind(value="lastname") String var1);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.lastname = :lastname ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public List<SystemOrdersDomain> findListByLastname(@Bind(value="lastname") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.phone = :phone")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public SystemOrdersDomain findByPhone(@Bind(value="phone") String var1);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.phone = :phone")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public List<SystemOrdersDomain> findListByPhone(@Bind(value="phone") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.orders p  WHERE p.phone = :phone")
    public long findListByPhoneCount(@Bind(value="phone") String var1);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.phone = :phone ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public List<SystemOrdersDomain> findListByPhone(@Bind(value="phone") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.beershop_order_id = :beershopOrderId")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public SystemOrdersDomain findByBeershopOrderId(@Bind(value="beershopOrderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.beershop_order_id = :beershopOrderId")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public List<SystemOrdersDomain> findListByBeershopOrderId(@Bind(value="beershopOrderId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.orders p  WHERE p.beershop_order_id = :beershopOrderId")
    public long findListByBeershopOrderIdCount(@Bind(value="beershopOrderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.beershop_order_id = :beershopOrderId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public List<SystemOrdersDomain> findListByBeershopOrderId(@Bind(value="beershopOrderId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.date_order = :dateOrder")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public SystemOrdersDomain findByDateOrder(@Bind(value="dateOrder") Date var1);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.date_order = :dateOrder")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public List<SystemOrdersDomain> findListByDateOrder(@Bind(value="dateOrder") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.orders p  WHERE p.date_order = :dateOrder")
    public long findListByDateOrderCount(@Bind(value="dateOrder") Date var1);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.date_order = :dateOrder ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public List<SystemOrdersDomain> findListByDateOrder(@Bind(value="dateOrder") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.date_changed = :dateChanged")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public SystemOrdersDomain findByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.date_changed = :dateChanged")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public List<SystemOrdersDomain> findListByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.orders p  WHERE p.date_changed = :dateChanged")
    public long findListByDateChangedCount(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.date_changed = :dateChanged ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public List<SystemOrdersDomain> findListByDateChanged(@Bind(value="dateChanged") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.user_changed = :userChanged")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public SystemOrdersDomain findByUserChanged(@Bind(value="userChanged") String var1);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.user_changed = :userChanged")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public List<SystemOrdersDomain> findListByUserChanged(@Bind(value="userChanged") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.orders p  WHERE p.user_changed = :userChanged")
    public long findListByUserChangedCount(@Bind(value="userChanged") String var1);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.user_changed = :userChanged ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public List<SystemOrdersDomain> findListByUserChanged(@Bind(value="userChanged") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.note = :note")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public SystemOrdersDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.note = :note")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public List<SystemOrdersDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.orders p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public List<SystemOrdersDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public SystemOrdersDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public List<SystemOrdersDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.orders p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.token, p.email, p.firstname, p.lastname, p.phone, p.beershop_order_id, p.date_order, p.date_changed, p.user_changed, p.note, p.date_created FROM system.orders p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SystemOrdersMapper.class)
    public List<SystemOrdersDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO system.orders (id, token, email, firstname, lastname, phone, beershop_order_id, date_order, date_changed, user_changed, note, date_created) VALUES (:id, :token, :email, :firstname, :lastname, :phone, :beershopOrderId, :dateOrder, :dateChanged, :userChanged, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="token") String var2, @Bind(value="email") String var3, @Bind(value="firstname") String var4, @Bind(value="lastname") String var5, @Bind(value="phone") String var6, @Bind(value="beershopOrderId") Long var7, @Bind(value="dateOrder") Date var8, @Bind(value="dateChanged") Date var9, @Bind(value="userChanged") String var10, @Bind(value="note") String var11, @Bind(value="dateCreated") Date var12);

    @SqlUpdate(value="INSERT INTO system.orders (token, email, firstname, lastname, phone, beershop_order_id, date_order, date_changed, user_changed, note, date_created) VALUES (:e.token, :e.email, :e.firstname, :e.lastname, :e.phone, :e.beershopOrderId, :e.dateOrder, :e.dateChanged, :e.userChanged, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") SystemOrdersDomain var1);

    @SqlUpdate(value="UPDATE system.orders SET id = :e.id, token = :e.token, email = :e.email, firstname = :e.firstname, lastname = :e.lastname, phone = :e.phone, beershop_order_id = :e.beershopOrderId, date_order = :e.dateOrder, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") SystemOrdersDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE system.orders SET id = :e.id, token = :e.token, email = :e.email, firstname = :e.firstname, lastname = :e.lastname, phone = :e.phone, beershop_order_id = :e.beershopOrderId, date_order = :e.dateOrder, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE token = :byToken")
    public int updateByToken(@BindBean(value="e") SystemOrdersDomain var1, @Bind(value="byToken") String var2);

    @SqlUpdate(value="UPDATE system.orders SET id = :e.id, token = :e.token, email = :e.email, firstname = :e.firstname, lastname = :e.lastname, phone = :e.phone, beershop_order_id = :e.beershopOrderId, date_order = :e.dateOrder, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE email = :byEmail")
    public int updateByEmail(@BindBean(value="e") SystemOrdersDomain var1, @Bind(value="byEmail") String var2);

    @SqlUpdate(value="UPDATE system.orders SET id = :e.id, token = :e.token, email = :e.email, firstname = :e.firstname, lastname = :e.lastname, phone = :e.phone, beershop_order_id = :e.beershopOrderId, date_order = :e.dateOrder, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE firstname = :byFirstname")
    public int updateByFirstname(@BindBean(value="e") SystemOrdersDomain var1, @Bind(value="byFirstname") String var2);

    @SqlUpdate(value="UPDATE system.orders SET id = :e.id, token = :e.token, email = :e.email, firstname = :e.firstname, lastname = :e.lastname, phone = :e.phone, beershop_order_id = :e.beershopOrderId, date_order = :e.dateOrder, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE lastname = :byLastname")
    public int updateByLastname(@BindBean(value="e") SystemOrdersDomain var1, @Bind(value="byLastname") String var2);

    @SqlUpdate(value="UPDATE system.orders SET id = :e.id, token = :e.token, email = :e.email, firstname = :e.firstname, lastname = :e.lastname, phone = :e.phone, beershop_order_id = :e.beershopOrderId, date_order = :e.dateOrder, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE phone = :byPhone")
    public int updateByPhone(@BindBean(value="e") SystemOrdersDomain var1, @Bind(value="byPhone") String var2);

    @SqlUpdate(value="UPDATE system.orders SET id = :e.id, token = :e.token, email = :e.email, firstname = :e.firstname, lastname = :e.lastname, phone = :e.phone, beershop_order_id = :e.beershopOrderId, date_order = :e.dateOrder, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE beershop_order_id = :byBeershopOrderId")
    public int updateByBeershopOrderId(@BindBean(value="e") SystemOrdersDomain var1, @Bind(value="byBeershopOrderId") Long var2);

    @SqlUpdate(value="UPDATE system.orders SET id = :e.id, token = :e.token, email = :e.email, firstname = :e.firstname, lastname = :e.lastname, phone = :e.phone, beershop_order_id = :e.beershopOrderId, date_order = :e.dateOrder, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE date_order = :byDateOrder")
    public int updateByDateOrder(@BindBean(value="e") SystemOrdersDomain var1, @Bind(value="byDateOrder") Date var2);

    @SqlUpdate(value="UPDATE system.orders SET id = :e.id, token = :e.token, email = :e.email, firstname = :e.firstname, lastname = :e.lastname, phone = :e.phone, beershop_order_id = :e.beershopOrderId, date_order = :e.dateOrder, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE date_changed = :byDateChanged")
    public int updateByDateChanged(@BindBean(value="e") SystemOrdersDomain var1, @Bind(value="byDateChanged") Date var2);

    @SqlUpdate(value="UPDATE system.orders SET id = :e.id, token = :e.token, email = :e.email, firstname = :e.firstname, lastname = :e.lastname, phone = :e.phone, beershop_order_id = :e.beershopOrderId, date_order = :e.dateOrder, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE user_changed = :byUserChanged")
    public int updateByUserChanged(@BindBean(value="e") SystemOrdersDomain var1, @Bind(value="byUserChanged") String var2);

    @SqlUpdate(value="UPDATE system.orders SET id = :e.id, token = :e.token, email = :e.email, firstname = :e.firstname, lastname = :e.lastname, phone = :e.phone, beershop_order_id = :e.beershopOrderId, date_order = :e.dateOrder, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") SystemOrdersDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE system.orders SET id = :e.id, token = :e.token, email = :e.email, firstname = :e.firstname, lastname = :e.lastname, phone = :e.phone, beershop_order_id = :e.beershopOrderId, date_order = :e.dateOrder, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") SystemOrdersDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM system.orders WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM system.orders WHERE token = :token")
    public int deleteByToken(@Bind(value="token") String var1);

    @SqlUpdate(value="DELETE FROM system.orders WHERE email = :email")
    public int deleteByEmail(@Bind(value="email") String var1);

    @SqlUpdate(value="DELETE FROM system.orders WHERE firstname = :firstname")
    public int deleteByFirstname(@Bind(value="firstname") String var1);

    @SqlUpdate(value="DELETE FROM system.orders WHERE lastname = :lastname")
    public int deleteByLastname(@Bind(value="lastname") String var1);

    @SqlUpdate(value="DELETE FROM system.orders WHERE phone = :phone")
    public int deleteByPhone(@Bind(value="phone") String var1);

    @SqlUpdate(value="DELETE FROM system.orders WHERE beershop_order_id = :beershopOrderId")
    public int deleteByBeershopOrderId(@Bind(value="beershopOrderId") Long var1);

    @SqlUpdate(value="DELETE FROM system.orders WHERE date_order = :dateOrder")
    public int deleteByDateOrder(@Bind(value="dateOrder") Date var1);

    @SqlUpdate(value="DELETE FROM system.orders WHERE date_changed = :dateChanged")
    public int deleteByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlUpdate(value="DELETE FROM system.orders WHERE user_changed = :userChanged")
    public int deleteByUserChanged(@Bind(value="userChanged") String var1);

    @SqlUpdate(value="DELETE FROM system.orders WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM system.orders WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

