/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.renting;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.renting.ReservationItemsMapper;
import cz.airtoy.airshop.dao.mappers.renting.full.ReservationItemsFullMapper;
import cz.airtoy.airshop.domains.renting.ReservationItemsDomain;
import cz.airtoy.airshop.domains.renting.full.ReservationItemsFullDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface ReservationItemsDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.reservation_id,\n\t\tp.target_commodity_id,\n\t\tp.abra_id,\n\t\tp.plu,\n\t\tp.code,\n\t\tp.cnt,\n\t\tp.ord,\n\t\tp.date_updated,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\trenting.reservation_items p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.reservation_id::text ~* :mask \n\tOR \n\t\tp.target_commodity_id::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.plu::text ~* :mask \n\tOR \n\t\tp.code::text ~* :mask \n\tOR \n\t\tp.cnt::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public List<ReservationItemsDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\trenting.reservation_items p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.reservation_id::text ~* :mask \n\tOR \n\t\tp.target_commodity_id::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.plu::text ~* :mask \n\tOR \n\t\tp.code::text ~* :mask \n\tOR \n\t\tp.cnt::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  ")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public List<ReservationItemsDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.id = :id")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public ReservationItemsDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.id = :id")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public List<ReservationItemsDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.reservation_items p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public List<ReservationItemsDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public ReservationItemsDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public List<ReservationItemsDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.reservation_items p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public List<ReservationItemsDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.reservation_id = :reservationId")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public ReservationItemsDomain findByReservationId(@Bind(value="reservationId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.reservation_id = :reservationId")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public List<ReservationItemsDomain> findListByReservationId(@Bind(value="reservationId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.reservation_items p  WHERE p.reservation_id = :reservationId")
    public long findListByReservationIdCount(@Bind(value="reservationId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.reservation_id = :reservationId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public List<ReservationItemsDomain> findListByReservationId(@Bind(value="reservationId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created, \t  rp.id AS \"renpor_id\",\n\t\trp.uid AS \"renpor_uid\",\n\t\trp.target_commodity_id AS \"renpor_target_commodity_id\",\n\t\trp.abra_id AS \"renpor_abra_id\",\n\t\trp.plu AS \"renpor_plu\",\n\t\trp.code AS \"renpor_code\",\n\t\trp.cnt AS \"renpor_cnt\",\n\t\trp.deposit_amount AS \"renpor_deposit_amount\",\n\t\trp.ord AS \"renpor_ord\",\n\t\trp.date_updated AS \"renpor_date_updated\",\n\t\trp.note AS \"renpor_note\",\n\t\trp.date_created AS \"renpor_date_created\",\n\t   to_json(\n\t\t   array(\n\t\t\t\t   SELECT\n\t\t\t\t\t\t  to_json(tcfoo.*)\n\t\t\t\t   FROM\n\t\t\t\t\t\t(\n            SELECT \n            \t  tc.id AS \"id\",\n            \t\ttc.uid AS \"uid\",\n            \t\ttc.source AS \"source\",\n            \t\ttc.abra_id AS \"abraId\",\n            \t\ttc.plu AS \"plu\",\n            \t\ttc.code AS \"code\",\n            \t\ttc.shipping_weight AS \"shippingWeight\",\n            \t\ttc.external_record_id AS \"externalRecordId\",\n            \t\ttc.disabled AS \"disabled\",\n            \t\ttc.ord AS \"ord\",\n            \t\ttc.manufacturer_id AS \"manufacturerId\",\n            \t\ttc.external_stock_availability_id AS \"externalStockAvailabilityId\",\n            \t\ttc.external_charge_id AS \"externalChargeId\",\n            \t\ttc.vat AS \"vat\",\n            \t\ttc.language_name AS \"languageName\",\n            \t\ttc.name AS \"name\",\n            \t\ttc.alternative_name AS \"alternativeName\",\n            \t\ttc.annotation AS \"annotation\",\n            \t\ttc.description AS \"description\",\n            \t\ttc.meta_title AS \"metaTitle\",\n            \t\ttc.meta_description AS \"metaDescription\",\n            \t\ttc.meta_key_words AS \"metaKeyWords\",\n            \t\ttc.path AS \"path\",\n            \t\ttc.enabled AS \"enabled\",\n            \t\ttc.commodity_keg_size_id AS \"commodityKegSizeId\",\n            \t\ttc.price_amount_purchase_retail AS \"priceAmountPurchaseRetail\",\n            \t\ttc.price_amount_purchase_wholesale AS \"priceAmountPurchaseWholesale\",\n            \t\ttc.price_amount_sale_retail AS \"priceAmountSaleRetail\",\n            \t\ttc.price_amount_sale_wholesale AS \"priceAmountSaleWholesale\",\n            \t\ttc.volume AS \"volume\",\n            \t\ttc.on_order AS \"onOrder\",\n            \t\ttc.date_order AS \"dateOrder\",\n            \t\ttc.date_delivery AS \"dateDelivery\",\n            \t\ttc.date_updated AS \"dateUpdated\",\n            \t\ttc.note AS \"note\",\n            \t\ttc.date_created AS \"dateCreated\"\n             FROM \n            \t\tdata.target_commodity tc\n\t\t\t\t\t\t\tWHERE \n\t\t\t\t\t\t\t\t\ttc.id = p.target_commodity_id\n           ) tcfoo\n          )\n\t\t\t   )::TEXT AS targetCommodities \n FROM renting.reservation_items p  \t\tLEFT OUTER JOIN renting.rental_portfolio rp ON (rp.target_commodity_id = p.target_commodity_id)\n WHERE p.reservation_id = :reservationId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ReservationItemsFullMapper.class)
    public List<ReservationItemsFullDomain> findListByReservationIdFull(@Bind(value="reservationId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.target_commodity_id = :targetCommodityId")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public ReservationItemsDomain findByTargetCommodityId(@Bind(value="targetCommodityId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.target_commodity_id = :targetCommodityId")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public List<ReservationItemsDomain> findListByTargetCommodityId(@Bind(value="targetCommodityId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.reservation_items p  WHERE p.target_commodity_id = :targetCommodityId")
    public long findListByTargetCommodityIdCount(@Bind(value="targetCommodityId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.target_commodity_id = :targetCommodityId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public List<ReservationItemsDomain> findListByTargetCommodityId(@Bind(value="targetCommodityId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.abra_id = :abraId")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public ReservationItemsDomain findByAbraId(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.abra_id = :abraId")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public List<ReservationItemsDomain> findListByAbraId(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.reservation_items p  WHERE p.abra_id = :abraId")
    public long findListByAbraIdCount(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.abra_id = :abraId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public List<ReservationItemsDomain> findListByAbraId(@Bind(value="abraId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.plu = :plu")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public ReservationItemsDomain findByPlu(@Bind(value="plu") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.plu = :plu")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public List<ReservationItemsDomain> findListByPlu(@Bind(value="plu") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.reservation_items p  WHERE p.plu = :plu")
    public long findListByPluCount(@Bind(value="plu") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.plu = :plu ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public List<ReservationItemsDomain> findListByPlu(@Bind(value="plu") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.code = :code")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public ReservationItemsDomain findByCode(@Bind(value="code") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.code = :code")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public List<ReservationItemsDomain> findListByCode(@Bind(value="code") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.reservation_items p  WHERE p.code = :code")
    public long findListByCodeCount(@Bind(value="code") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.code = :code ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public List<ReservationItemsDomain> findListByCode(@Bind(value="code") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.cnt = :cnt")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public ReservationItemsDomain findByCnt(@Bind(value="cnt") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.cnt = :cnt")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public List<ReservationItemsDomain> findListByCnt(@Bind(value="cnt") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.reservation_items p  WHERE p.cnt = :cnt")
    public long findListByCntCount(@Bind(value="cnt") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.cnt = :cnt ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public List<ReservationItemsDomain> findListByCnt(@Bind(value="cnt") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.ord = :ord")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public ReservationItemsDomain findByOrd(@Bind(value="ord") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.ord = :ord")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public List<ReservationItemsDomain> findListByOrd(@Bind(value="ord") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.reservation_items p  WHERE p.ord = :ord")
    public long findListByOrdCount(@Bind(value="ord") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.ord = :ord ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public List<ReservationItemsDomain> findListByOrd(@Bind(value="ord") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public ReservationItemsDomain findByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public List<ReservationItemsDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.reservation_items p  WHERE p.date_updated = :dateUpdated")
    public long findListByDateUpdatedCount(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.date_updated = :dateUpdated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public List<ReservationItemsDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.note = :note")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public ReservationItemsDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.note = :note")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public List<ReservationItemsDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.reservation_items p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public List<ReservationItemsDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public ReservationItemsDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public List<ReservationItemsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.reservation_items p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.reservation_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.ord, p.date_updated, p.note, p.date_created FROM renting.reservation_items p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ReservationItemsMapper.class)
    public List<ReservationItemsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO renting.reservation_items (id, uid, reservation_id, target_commodity_id, abra_id, plu, code, cnt, ord, date_updated, note, date_created) VALUES (:id, :uid, :reservationId, :targetCommodityId, :abraId, :plu, :code, :cnt, :ord, :dateUpdated, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="reservationId") Long var3, @Bind(value="targetCommodityId") Long var4, @Bind(value="abraId") String var5, @Bind(value="plu") String var6, @Bind(value="code") String var7, @Bind(value="cnt") Integer var8, @Bind(value="ord") Integer var9, @Bind(value="dateUpdated") Date var10, @Bind(value="note") String var11, @Bind(value="dateCreated") Date var12);

    @SqlUpdate(value="INSERT INTO renting.reservation_items (reservation_id, target_commodity_id, abra_id, plu, code, cnt, ord, date_updated, note, date_created) VALUES (:e.reservationId, :e.targetCommodityId, :e.abraId, :e.plu, :e.code, :e.cnt, :e.ord, :e.dateUpdated, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") ReservationItemsDomain var1);

    @SqlUpdate(value="UPDATE renting.reservation_items SET id = :e.id, uid = :e.uid, reservation_id = :e.reservationId, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") ReservationItemsDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE renting.reservation_items SET id = :e.id, uid = :e.uid, reservation_id = :e.reservationId, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") ReservationItemsDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE renting.reservation_items SET id = :e.id, uid = :e.uid, reservation_id = :e.reservationId, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE reservation_id = :byReservationId")
    public int updateByReservationId(@BindBean(value="e") ReservationItemsDomain var1, @Bind(value="byReservationId") Long var2);

    @SqlUpdate(value="UPDATE renting.reservation_items SET id = :e.id, uid = :e.uid, reservation_id = :e.reservationId, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE target_commodity_id = :byTargetCommodityId")
    public int updateByTargetCommodityId(@BindBean(value="e") ReservationItemsDomain var1, @Bind(value="byTargetCommodityId") Long var2);

    @SqlUpdate(value="UPDATE renting.reservation_items SET id = :e.id, uid = :e.uid, reservation_id = :e.reservationId, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE abra_id = :byAbraId")
    public int updateByAbraId(@BindBean(value="e") ReservationItemsDomain var1, @Bind(value="byAbraId") String var2);

    @SqlUpdate(value="UPDATE renting.reservation_items SET id = :e.id, uid = :e.uid, reservation_id = :e.reservationId, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE plu = :byPlu")
    public int updateByPlu(@BindBean(value="e") ReservationItemsDomain var1, @Bind(value="byPlu") String var2);

    @SqlUpdate(value="UPDATE renting.reservation_items SET id = :e.id, uid = :e.uid, reservation_id = :e.reservationId, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE code = :byCode")
    public int updateByCode(@BindBean(value="e") ReservationItemsDomain var1, @Bind(value="byCode") String var2);

    @SqlUpdate(value="UPDATE renting.reservation_items SET id = :e.id, uid = :e.uid, reservation_id = :e.reservationId, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE cnt = :byCnt")
    public int updateByCnt(@BindBean(value="e") ReservationItemsDomain var1, @Bind(value="byCnt") Integer var2);

    @SqlUpdate(value="UPDATE renting.reservation_items SET id = :e.id, uid = :e.uid, reservation_id = :e.reservationId, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE ord = :byOrd")
    public int updateByOrd(@BindBean(value="e") ReservationItemsDomain var1, @Bind(value="byOrd") Integer var2);

    @SqlUpdate(value="UPDATE renting.reservation_items SET id = :e.id, uid = :e.uid, reservation_id = :e.reservationId, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_updated = :byDateUpdated")
    public int updateByDateUpdated(@BindBean(value="e") ReservationItemsDomain var1, @Bind(value="byDateUpdated") Date var2);

    @SqlUpdate(value="UPDATE renting.reservation_items SET id = :e.id, uid = :e.uid, reservation_id = :e.reservationId, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") ReservationItemsDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE renting.reservation_items SET id = :e.id, uid = :e.uid, reservation_id = :e.reservationId, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") ReservationItemsDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM renting.reservation_items WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM renting.reservation_items WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM renting.reservation_items WHERE reservation_id = :reservationId")
    public int deleteByReservationId(@Bind(value="reservationId") Long var1);

    @SqlUpdate(value="DELETE FROM renting.reservation_items WHERE target_commodity_id = :targetCommodityId")
    public int deleteByTargetCommodityId(@Bind(value="targetCommodityId") Long var1);

    @SqlUpdate(value="DELETE FROM renting.reservation_items WHERE abra_id = :abraId")
    public int deleteByAbraId(@Bind(value="abraId") String var1);

    @SqlUpdate(value="DELETE FROM renting.reservation_items WHERE plu = :plu")
    public int deleteByPlu(@Bind(value="plu") String var1);

    @SqlUpdate(value="DELETE FROM renting.reservation_items WHERE code = :code")
    public int deleteByCode(@Bind(value="code") String var1);

    @SqlUpdate(value="DELETE FROM renting.reservation_items WHERE cnt = :cnt")
    public int deleteByCnt(@Bind(value="cnt") Integer var1);

    @SqlUpdate(value="DELETE FROM renting.reservation_items WHERE ord = :ord")
    public int deleteByOrd(@Bind(value="ord") Integer var1);

    @SqlUpdate(value="DELETE FROM renting.reservation_items WHERE date_updated = :dateUpdated")
    public int deleteByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlUpdate(value="DELETE FROM renting.reservation_items WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM renting.reservation_items WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

