/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.data;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.data.TargetPropertyMapper;
import cz.airtoy.airshop.domains.data.TargetPropertyDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface TargetPropertyDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.target_id,\n\t\tp.ord,\n\t\tp.language_name,\n\t\tp.ident,\n\t\tp.name,\n\t\tp.value,\n\t\tp.date_updated,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tdata.target_property p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.target_id::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.language_name::text ~* :mask \n\tOR \n\t\tp.ident::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.value::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public List<TargetPropertyDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tdata.target_property p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.target_id::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.language_name::text ~* :mask \n\tOR \n\t\tp.ident::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.value::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  ")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public List<TargetPropertyDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.id = :id")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public TargetPropertyDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.id = :id")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public List<TargetPropertyDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_property p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public List<TargetPropertyDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public TargetPropertyDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public List<TargetPropertyDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_property p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public List<TargetPropertyDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.target_id = :targetId")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public TargetPropertyDomain findByTargetId(@Bind(value="targetId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.target_id = :targetId")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public List<TargetPropertyDomain> findListByTargetId(@Bind(value="targetId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_property p  WHERE p.target_id = :targetId")
    public long findListByTargetIdCount(@Bind(value="targetId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.target_id = :targetId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public List<TargetPropertyDomain> findListByTargetId(@Bind(value="targetId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.ord = :ord")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public TargetPropertyDomain findByOrd(@Bind(value="ord") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.ord = :ord")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public List<TargetPropertyDomain> findListByOrd(@Bind(value="ord") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_property p  WHERE p.ord = :ord")
    public long findListByOrdCount(@Bind(value="ord") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.ord = :ord ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public List<TargetPropertyDomain> findListByOrd(@Bind(value="ord") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.language_name = :languageName")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public TargetPropertyDomain findByLanguageName(@Bind(value="languageName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.language_name = :languageName")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public List<TargetPropertyDomain> findListByLanguageName(@Bind(value="languageName") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_property p  WHERE p.language_name = :languageName")
    public long findListByLanguageNameCount(@Bind(value="languageName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.language_name = :languageName ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public List<TargetPropertyDomain> findListByLanguageName(@Bind(value="languageName") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.ident = :ident")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public TargetPropertyDomain findByIdent(@Bind(value="ident") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.ident = :ident")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public List<TargetPropertyDomain> findListByIdent(@Bind(value="ident") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_property p  WHERE p.ident = :ident")
    public long findListByIdentCount(@Bind(value="ident") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.ident = :ident ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public List<TargetPropertyDomain> findListByIdent(@Bind(value="ident") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.name = :name")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public TargetPropertyDomain findByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.name = :name")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public List<TargetPropertyDomain> findListByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_property p  WHERE p.name = :name")
    public long findListByNameCount(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.name = :name ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public List<TargetPropertyDomain> findListByName(@Bind(value="name") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.value = :value")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public TargetPropertyDomain findByValue(@Bind(value="value") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.value = :value")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public List<TargetPropertyDomain> findListByValue(@Bind(value="value") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_property p  WHERE p.value = :value")
    public long findListByValueCount(@Bind(value="value") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.value = :value ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public List<TargetPropertyDomain> findListByValue(@Bind(value="value") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public TargetPropertyDomain findByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public List<TargetPropertyDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_property p  WHERE p.date_updated = :dateUpdated")
    public long findListByDateUpdatedCount(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.date_updated = :dateUpdated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public List<TargetPropertyDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.note = :note")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public TargetPropertyDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.note = :note")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public List<TargetPropertyDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_property p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public List<TargetPropertyDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public TargetPropertyDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public List<TargetPropertyDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_property p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_id, p.ord, p.language_name, p.ident, p.name, p.value, p.date_updated, p.note, p.date_created FROM data.target_property p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetPropertyMapper.class)
    public List<TargetPropertyDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO data.target_property (id, uid, target_id, ord, language_name, ident, name, value, date_updated, note, date_created) VALUES (:id, :uid, :targetId, :ord, :languageName, :ident, :name, :value, :dateUpdated, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="targetId") Long var3, @Bind(value="ord") Integer var4, @Bind(value="languageName") String var5, @Bind(value="ident") String var6, @Bind(value="name") String var7, @Bind(value="value") String var8, @Bind(value="dateUpdated") Date var9, @Bind(value="note") String var10, @Bind(value="dateCreated") Date var11);

    @SqlUpdate(value="INSERT INTO data.target_property (target_id, ord, language_name, ident, name, value, date_updated, note, date_created) VALUES (:e.targetId, :e.ord, :e.languageName, :e.ident, :e.name, :e.value, :e.dateUpdated, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") TargetPropertyDomain var1);

    @SqlUpdate(value="UPDATE data.target_property SET id = :e.id, uid = :e.uid, target_id = :e.targetId, ord = :e.ord, language_name = :e.languageName, ident = :e.ident, name = :e.name, value = :e.value, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") TargetPropertyDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE data.target_property SET id = :e.id, uid = :e.uid, target_id = :e.targetId, ord = :e.ord, language_name = :e.languageName, ident = :e.ident, name = :e.name, value = :e.value, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") TargetPropertyDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE data.target_property SET id = :e.id, uid = :e.uid, target_id = :e.targetId, ord = :e.ord, language_name = :e.languageName, ident = :e.ident, name = :e.name, value = :e.value, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE target_id = :byTargetId")
    public int updateByTargetId(@BindBean(value="e") TargetPropertyDomain var1, @Bind(value="byTargetId") Long var2);

    @SqlUpdate(value="UPDATE data.target_property SET id = :e.id, uid = :e.uid, target_id = :e.targetId, ord = :e.ord, language_name = :e.languageName, ident = :e.ident, name = :e.name, value = :e.value, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE ord = :byOrd")
    public int updateByOrd(@BindBean(value="e") TargetPropertyDomain var1, @Bind(value="byOrd") Integer var2);

    @SqlUpdate(value="UPDATE data.target_property SET id = :e.id, uid = :e.uid, target_id = :e.targetId, ord = :e.ord, language_name = :e.languageName, ident = :e.ident, name = :e.name, value = :e.value, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE language_name = :byLanguageName")
    public int updateByLanguageName(@BindBean(value="e") TargetPropertyDomain var1, @Bind(value="byLanguageName") String var2);

    @SqlUpdate(value="UPDATE data.target_property SET id = :e.id, uid = :e.uid, target_id = :e.targetId, ord = :e.ord, language_name = :e.languageName, ident = :e.ident, name = :e.name, value = :e.value, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE ident = :byIdent")
    public int updateByIdent(@BindBean(value="e") TargetPropertyDomain var1, @Bind(value="byIdent") String var2);

    @SqlUpdate(value="UPDATE data.target_property SET id = :e.id, uid = :e.uid, target_id = :e.targetId, ord = :e.ord, language_name = :e.languageName, ident = :e.ident, name = :e.name, value = :e.value, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE name = :byName")
    public int updateByName(@BindBean(value="e") TargetPropertyDomain var1, @Bind(value="byName") String var2);

    @SqlUpdate(value="UPDATE data.target_property SET id = :e.id, uid = :e.uid, target_id = :e.targetId, ord = :e.ord, language_name = :e.languageName, ident = :e.ident, name = :e.name, value = :e.value, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE value = :byValue")
    public int updateByValue(@BindBean(value="e") TargetPropertyDomain var1, @Bind(value="byValue") String var2);

    @SqlUpdate(value="UPDATE data.target_property SET id = :e.id, uid = :e.uid, target_id = :e.targetId, ord = :e.ord, language_name = :e.languageName, ident = :e.ident, name = :e.name, value = :e.value, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_updated = :byDateUpdated")
    public int updateByDateUpdated(@BindBean(value="e") TargetPropertyDomain var1, @Bind(value="byDateUpdated") Date var2);

    @SqlUpdate(value="UPDATE data.target_property SET id = :e.id, uid = :e.uid, target_id = :e.targetId, ord = :e.ord, language_name = :e.languageName, ident = :e.ident, name = :e.name, value = :e.value, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") TargetPropertyDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE data.target_property SET id = :e.id, uid = :e.uid, target_id = :e.targetId, ord = :e.ord, language_name = :e.languageName, ident = :e.ident, name = :e.name, value = :e.value, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") TargetPropertyDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM data.target_property WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM data.target_property WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM data.target_property WHERE target_id = :targetId")
    public int deleteByTargetId(@Bind(value="targetId") Long var1);

    @SqlUpdate(value="DELETE FROM data.target_property WHERE ord = :ord")
    public int deleteByOrd(@Bind(value="ord") Integer var1);

    @SqlUpdate(value="DELETE FROM data.target_property WHERE language_name = :languageName")
    public int deleteByLanguageName(@Bind(value="languageName") String var1);

    @SqlUpdate(value="DELETE FROM data.target_property WHERE ident = :ident")
    public int deleteByIdent(@Bind(value="ident") String var1);

    @SqlUpdate(value="DELETE FROM data.target_property WHERE name = :name")
    public int deleteByName(@Bind(value="name") String var1);

    @SqlUpdate(value="DELETE FROM data.target_property WHERE value = :value")
    public int deleteByValue(@Bind(value="value") String var1);

    @SqlUpdate(value="DELETE FROM data.target_property WHERE date_updated = :dateUpdated")
    public int deleteByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlUpdate(value="DELETE FROM data.target_property WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM data.target_property WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

