/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.data;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.data.TargetMapper;
import cz.airtoy.airshop.domains.data.TargetDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface TargetDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.language_name,\n\t\tp.name,\n\t\tp.enabled,\n\t\tp.date_updated,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tdata.target p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.language_name::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.enabled::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=TargetMapper.class)
    public List<TargetDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tdata.target p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.language_name::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.enabled::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language_name, p.name, p.enabled, p.date_updated, p.note, p.date_created FROM data.target p  ")
    @RegisterRowMapper(value=TargetMapper.class)
    public List<TargetDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.language_name, p.name, p.enabled, p.date_updated, p.note, p.date_created FROM data.target p  WHERE p.id = :id")
    @RegisterRowMapper(value=TargetMapper.class)
    public TargetDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language_name, p.name, p.enabled, p.date_updated, p.note, p.date_created FROM data.target p  WHERE p.id = :id")
    @RegisterRowMapper(value=TargetMapper.class)
    public List<TargetDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language_name, p.name, p.enabled, p.date_updated, p.note, p.date_created FROM data.target p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetMapper.class)
    public List<TargetDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.language_name, p.name, p.enabled, p.date_updated, p.note, p.date_created FROM data.target p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=TargetMapper.class)
    public TargetDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language_name, p.name, p.enabled, p.date_updated, p.note, p.date_created FROM data.target p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=TargetMapper.class)
    public List<TargetDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language_name, p.name, p.enabled, p.date_updated, p.note, p.date_created FROM data.target p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetMapper.class)
    public List<TargetDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.language_name, p.name, p.enabled, p.date_updated, p.note, p.date_created FROM data.target p  WHERE p.language_name = :languageName")
    @RegisterRowMapper(value=TargetMapper.class)
    public TargetDomain findByLanguageName(@Bind(value="languageName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language_name, p.name, p.enabled, p.date_updated, p.note, p.date_created FROM data.target p  WHERE p.language_name = :languageName")
    @RegisterRowMapper(value=TargetMapper.class)
    public List<TargetDomain> findListByLanguageName(@Bind(value="languageName") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target p  WHERE p.language_name = :languageName")
    public long findListByLanguageNameCount(@Bind(value="languageName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language_name, p.name, p.enabled, p.date_updated, p.note, p.date_created FROM data.target p  WHERE p.language_name = :languageName ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetMapper.class)
    public List<TargetDomain> findListByLanguageName(@Bind(value="languageName") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.language_name, p.name, p.enabled, p.date_updated, p.note, p.date_created FROM data.target p  WHERE p.name = :name")
    @RegisterRowMapper(value=TargetMapper.class)
    public TargetDomain findByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language_name, p.name, p.enabled, p.date_updated, p.note, p.date_created FROM data.target p  WHERE p.name = :name")
    @RegisterRowMapper(value=TargetMapper.class)
    public List<TargetDomain> findListByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target p  WHERE p.name = :name")
    public long findListByNameCount(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language_name, p.name, p.enabled, p.date_updated, p.note, p.date_created FROM data.target p  WHERE p.name = :name ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetMapper.class)
    public List<TargetDomain> findListByName(@Bind(value="name") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.language_name, p.name, p.enabled, p.date_updated, p.note, p.date_created FROM data.target p  WHERE p.enabled = :enabled")
    @RegisterRowMapper(value=TargetMapper.class)
    public TargetDomain findByEnabled(@Bind(value="enabled") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language_name, p.name, p.enabled, p.date_updated, p.note, p.date_created FROM data.target p  WHERE p.enabled = :enabled")
    @RegisterRowMapper(value=TargetMapper.class)
    public List<TargetDomain> findListByEnabled(@Bind(value="enabled") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target p  WHERE p.enabled = :enabled")
    public long findListByEnabledCount(@Bind(value="enabled") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language_name, p.name, p.enabled, p.date_updated, p.note, p.date_created FROM data.target p  WHERE p.enabled = :enabled ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetMapper.class)
    public List<TargetDomain> findListByEnabled(@Bind(value="enabled") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.language_name, p.name, p.enabled, p.date_updated, p.note, p.date_created FROM data.target p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=TargetMapper.class)
    public TargetDomain findByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language_name, p.name, p.enabled, p.date_updated, p.note, p.date_created FROM data.target p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=TargetMapper.class)
    public List<TargetDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target p  WHERE p.date_updated = :dateUpdated")
    public long findListByDateUpdatedCount(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language_name, p.name, p.enabled, p.date_updated, p.note, p.date_created FROM data.target p  WHERE p.date_updated = :dateUpdated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetMapper.class)
    public List<TargetDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.language_name, p.name, p.enabled, p.date_updated, p.note, p.date_created FROM data.target p  WHERE p.note = :note")
    @RegisterRowMapper(value=TargetMapper.class)
    public TargetDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language_name, p.name, p.enabled, p.date_updated, p.note, p.date_created FROM data.target p  WHERE p.note = :note")
    @RegisterRowMapper(value=TargetMapper.class)
    public List<TargetDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language_name, p.name, p.enabled, p.date_updated, p.note, p.date_created FROM data.target p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetMapper.class)
    public List<TargetDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.language_name, p.name, p.enabled, p.date_updated, p.note, p.date_created FROM data.target p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=TargetMapper.class)
    public TargetDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language_name, p.name, p.enabled, p.date_updated, p.note, p.date_created FROM data.target p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=TargetMapper.class)
    public List<TargetDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language_name, p.name, p.enabled, p.date_updated, p.note, p.date_created FROM data.target p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetMapper.class)
    public List<TargetDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO data.target (id, uid, language_name, name, enabled, date_updated, note, date_created) VALUES (:id, :uid, :languageName, :name, :enabled, :dateUpdated, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="languageName") String var3, @Bind(value="name") String var4, @Bind(value="enabled") Integer var5, @Bind(value="dateUpdated") Date var6, @Bind(value="note") String var7, @Bind(value="dateCreated") Date var8);

    @SqlUpdate(value="INSERT INTO data.target (language_name, name, enabled, date_updated, note, date_created) VALUES (:e.languageName, :e.name, :e.enabled, :e.dateUpdated, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") TargetDomain var1);

    @SqlUpdate(value="UPDATE data.target SET id = :e.id, uid = :e.uid, language_name = :e.languageName, name = :e.name, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") TargetDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE data.target SET id = :e.id, uid = :e.uid, language_name = :e.languageName, name = :e.name, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") TargetDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE data.target SET id = :e.id, uid = :e.uid, language_name = :e.languageName, name = :e.name, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE language_name = :byLanguageName")
    public int updateByLanguageName(@BindBean(value="e") TargetDomain var1, @Bind(value="byLanguageName") String var2);

    @SqlUpdate(value="UPDATE data.target SET id = :e.id, uid = :e.uid, language_name = :e.languageName, name = :e.name, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE name = :byName")
    public int updateByName(@BindBean(value="e") TargetDomain var1, @Bind(value="byName") String var2);

    @SqlUpdate(value="UPDATE data.target SET id = :e.id, uid = :e.uid, language_name = :e.languageName, name = :e.name, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE enabled = :byEnabled")
    public int updateByEnabled(@BindBean(value="e") TargetDomain var1, @Bind(value="byEnabled") Integer var2);

    @SqlUpdate(value="UPDATE data.target SET id = :e.id, uid = :e.uid, language_name = :e.languageName, name = :e.name, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_updated = :byDateUpdated")
    public int updateByDateUpdated(@BindBean(value="e") TargetDomain var1, @Bind(value="byDateUpdated") Date var2);

    @SqlUpdate(value="UPDATE data.target SET id = :e.id, uid = :e.uid, language_name = :e.languageName, name = :e.name, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") TargetDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE data.target SET id = :e.id, uid = :e.uid, language_name = :e.languageName, name = :e.name, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") TargetDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM data.target WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM data.target WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM data.target WHERE language_name = :languageName")
    public int deleteByLanguageName(@Bind(value="languageName") String var1);

    @SqlUpdate(value="DELETE FROM data.target WHERE name = :name")
    public int deleteByName(@Bind(value="name") String var1);

    @SqlUpdate(value="DELETE FROM data.target WHERE enabled = :enabled")
    public int deleteByEnabled(@Bind(value="enabled") Integer var1);

    @SqlUpdate(value="DELETE FROM data.target WHERE date_updated = :dateUpdated")
    public int deleteByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlUpdate(value="DELETE FROM data.target WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM data.target WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

