/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.domains.codecs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import cz.airtoy.airshop.domains.OrderItemsDomain;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderItemsDomainCodec
implements MessageCodec<OrderItemsDomain, OrderItemsDomain> {
    private static final Logger log = LoggerFactory.getLogger(OrderItemsDomainCodec.class);

    public void encodeToWire(Buffer buffer, OrderItemsDomain orderItemsDomain) {
        GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
        Gson gson = gsonBuilder.create();
        String jsonToStr = gson.toJson((Object)orderItemsDomain);
        int length = jsonToStr.getBytes().length;
        buffer.appendInt(length);
        buffer.appendString(jsonToStr);
    }

    public OrderItemsDomain decodeFromWire(int position, Buffer buffer) {
        int _pos = position;
        int length = buffer.getInt(_pos);
        String jsonStr = buffer.getString(_pos += 4, _pos += length);
        GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
        Gson gson = gsonBuilder.create();
        return (OrderItemsDomain)gson.fromJson(jsonStr, OrderItemsDomain.class);
    }

    public OrderItemsDomain transform(OrderItemsDomain orderItemsDomain) {
        return orderItemsDomain;
    }

    public String name() {
        return this.getClass().getSimpleName();
    }

    public byte systemCodecID() {
        return -1;
    }
}

