/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.email;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.email.EventLogMapper;
import cz.airtoy.airshop.domains.email.EventLogDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface EventLogDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.system_id,\n\t\tp.template_id,\n\t\tp.recipient_id,\n\t\tp.event_type,\n\t\tp.rule_name,\n\t\tp.data,\n\t\tp.date_created\n FROM \n\t\temail.event_log p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.system_id::text ~* :mask \n\tOR \n\t\tp.template_id::text ~* :mask \n\tOR \n\t\tp.recipient_id::text ~* :mask \n\tOR \n\t\tp.event_type::text ~* :mask \n\tOR \n\t\tp.rule_name::text ~* :mask \n\tOR \n\t\tp.data::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=EventLogMapper.class)
    public List<EventLogDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\temail.event_log p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.system_id::text ~* :mask \n\tOR \n\t\tp.template_id::text ~* :mask \n\tOR \n\t\tp.recipient_id::text ~* :mask \n\tOR \n\t\tp.event_type::text ~* :mask \n\tOR \n\t\tp.rule_name::text ~* :mask \n\tOR \n\t\tp.data::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system_id, p.template_id, p.recipient_id, p.event_type, p.rule_name, p.data, p.date_created FROM email.event_log p  ")
    @RegisterRowMapper(value=EventLogMapper.class)
    public List<EventLogDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.system_id, p.template_id, p.recipient_id, p.event_type, p.rule_name, p.data, p.date_created FROM email.event_log p  WHERE p.id = :id")
    @RegisterRowMapper(value=EventLogMapper.class)
    public EventLogDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system_id, p.template_id, p.recipient_id, p.event_type, p.rule_name, p.data, p.date_created FROM email.event_log p  WHERE p.id = :id")
    @RegisterRowMapper(value=EventLogMapper.class)
    public List<EventLogDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.event_log p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system_id, p.template_id, p.recipient_id, p.event_type, p.rule_name, p.data, p.date_created FROM email.event_log p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EventLogMapper.class)
    public List<EventLogDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.system_id, p.template_id, p.recipient_id, p.event_type, p.rule_name, p.data, p.date_created FROM email.event_log p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=EventLogMapper.class)
    public EventLogDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system_id, p.template_id, p.recipient_id, p.event_type, p.rule_name, p.data, p.date_created FROM email.event_log p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=EventLogMapper.class)
    public List<EventLogDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.event_log p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system_id, p.template_id, p.recipient_id, p.event_type, p.rule_name, p.data, p.date_created FROM email.event_log p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EventLogMapper.class)
    public List<EventLogDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.system_id, p.template_id, p.recipient_id, p.event_type, p.rule_name, p.data, p.date_created FROM email.event_log p  WHERE p.system_id = :systemId")
    @RegisterRowMapper(value=EventLogMapper.class)
    public EventLogDomain findBySystemId(@Bind(value="systemId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system_id, p.template_id, p.recipient_id, p.event_type, p.rule_name, p.data, p.date_created FROM email.event_log p  WHERE p.system_id = :systemId")
    @RegisterRowMapper(value=EventLogMapper.class)
    public List<EventLogDomain> findListBySystemId(@Bind(value="systemId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.event_log p  WHERE p.system_id = :systemId")
    public long findListBySystemIdCount(@Bind(value="systemId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system_id, p.template_id, p.recipient_id, p.event_type, p.rule_name, p.data, p.date_created FROM email.event_log p  WHERE p.system_id = :systemId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EventLogMapper.class)
    public List<EventLogDomain> findListBySystemId(@Bind(value="systemId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.system_id, p.template_id, p.recipient_id, p.event_type, p.rule_name, p.data, p.date_created FROM email.event_log p  WHERE p.template_id = :templateId")
    @RegisterRowMapper(value=EventLogMapper.class)
    public EventLogDomain findByTemplateId(@Bind(value="templateId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system_id, p.template_id, p.recipient_id, p.event_type, p.rule_name, p.data, p.date_created FROM email.event_log p  WHERE p.template_id = :templateId")
    @RegisterRowMapper(value=EventLogMapper.class)
    public List<EventLogDomain> findListByTemplateId(@Bind(value="templateId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.event_log p  WHERE p.template_id = :templateId")
    public long findListByTemplateIdCount(@Bind(value="templateId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system_id, p.template_id, p.recipient_id, p.event_type, p.rule_name, p.data, p.date_created FROM email.event_log p  WHERE p.template_id = :templateId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EventLogMapper.class)
    public List<EventLogDomain> findListByTemplateId(@Bind(value="templateId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.system_id, p.template_id, p.recipient_id, p.event_type, p.rule_name, p.data, p.date_created FROM email.event_log p  WHERE p.recipient_id = :recipientId")
    @RegisterRowMapper(value=EventLogMapper.class)
    public EventLogDomain findByRecipientId(@Bind(value="recipientId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system_id, p.template_id, p.recipient_id, p.event_type, p.rule_name, p.data, p.date_created FROM email.event_log p  WHERE p.recipient_id = :recipientId")
    @RegisterRowMapper(value=EventLogMapper.class)
    public List<EventLogDomain> findListByRecipientId(@Bind(value="recipientId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.event_log p  WHERE p.recipient_id = :recipientId")
    public long findListByRecipientIdCount(@Bind(value="recipientId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system_id, p.template_id, p.recipient_id, p.event_type, p.rule_name, p.data, p.date_created FROM email.event_log p  WHERE p.recipient_id = :recipientId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EventLogMapper.class)
    public List<EventLogDomain> findListByRecipientId(@Bind(value="recipientId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.system_id, p.template_id, p.recipient_id, p.event_type, p.rule_name, p.data, p.date_created FROM email.event_log p  WHERE p.event_type = :eventType")
    @RegisterRowMapper(value=EventLogMapper.class)
    public EventLogDomain findByEventType(@Bind(value="eventType") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system_id, p.template_id, p.recipient_id, p.event_type, p.rule_name, p.data, p.date_created FROM email.event_log p  WHERE p.event_type = :eventType")
    @RegisterRowMapper(value=EventLogMapper.class)
    public List<EventLogDomain> findListByEventType(@Bind(value="eventType") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.event_log p  WHERE p.event_type = :eventType")
    public long findListByEventTypeCount(@Bind(value="eventType") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system_id, p.template_id, p.recipient_id, p.event_type, p.rule_name, p.data, p.date_created FROM email.event_log p  WHERE p.event_type = :eventType ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EventLogMapper.class)
    public List<EventLogDomain> findListByEventType(@Bind(value="eventType") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.system_id, p.template_id, p.recipient_id, p.event_type, p.rule_name, p.data, p.date_created FROM email.event_log p  WHERE p.rule_name = :ruleName")
    @RegisterRowMapper(value=EventLogMapper.class)
    public EventLogDomain findByRuleName(@Bind(value="ruleName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system_id, p.template_id, p.recipient_id, p.event_type, p.rule_name, p.data, p.date_created FROM email.event_log p  WHERE p.rule_name = :ruleName")
    @RegisterRowMapper(value=EventLogMapper.class)
    public List<EventLogDomain> findListByRuleName(@Bind(value="ruleName") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.event_log p  WHERE p.rule_name = :ruleName")
    public long findListByRuleNameCount(@Bind(value="ruleName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system_id, p.template_id, p.recipient_id, p.event_type, p.rule_name, p.data, p.date_created FROM email.event_log p  WHERE p.rule_name = :ruleName ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EventLogMapper.class)
    public List<EventLogDomain> findListByRuleName(@Bind(value="ruleName") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.system_id, p.template_id, p.recipient_id, p.event_type, p.rule_name, p.data, p.date_created FROM email.event_log p  WHERE p.data = :data")
    @RegisterRowMapper(value=EventLogMapper.class)
    public EventLogDomain findByData(@Bind(value="data") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system_id, p.template_id, p.recipient_id, p.event_type, p.rule_name, p.data, p.date_created FROM email.event_log p  WHERE p.data = :data")
    @RegisterRowMapper(value=EventLogMapper.class)
    public List<EventLogDomain> findListByData(@Bind(value="data") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.event_log p  WHERE p.data = :data")
    public long findListByDataCount(@Bind(value="data") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system_id, p.template_id, p.recipient_id, p.event_type, p.rule_name, p.data, p.date_created FROM email.event_log p  WHERE p.data = :data ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EventLogMapper.class)
    public List<EventLogDomain> findListByData(@Bind(value="data") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.system_id, p.template_id, p.recipient_id, p.event_type, p.rule_name, p.data, p.date_created FROM email.event_log p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=EventLogMapper.class)
    public EventLogDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system_id, p.template_id, p.recipient_id, p.event_type, p.rule_name, p.data, p.date_created FROM email.event_log p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=EventLogMapper.class)
    public List<EventLogDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.event_log p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system_id, p.template_id, p.recipient_id, p.event_type, p.rule_name, p.data, p.date_created FROM email.event_log p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EventLogMapper.class)
    public List<EventLogDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO email.event_log (id, uid, system_id, template_id, recipient_id, event_type, rule_name, data, date_created) VALUES (:id, :uid, :systemId, :templateId, :recipientId, :eventType, :ruleName, :data, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="systemId") Long var3, @Bind(value="templateId") Long var4, @Bind(value="recipientId") Long var5, @Bind(value="eventType") String var6, @Bind(value="ruleName") String var7, @Bind(value="data") String var8, @Bind(value="dateCreated") Date var9);

    @SqlUpdate(value="INSERT INTO email.event_log (system_id, template_id, recipient_id, event_type, rule_name, data, date_created) VALUES (:e.systemId, :e.templateId, :e.recipientId, :e.eventType, :e.ruleName, :e.data, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") EventLogDomain var1);

    @SqlUpdate(value="UPDATE email.event_log SET id = :e.id, uid = :e.uid, system_id = :e.systemId, template_id = :e.templateId, recipient_id = :e.recipientId, event_type = :e.eventType, rule_name = :e.ruleName, data = :e.data, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") EventLogDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE email.event_log SET id = :e.id, uid = :e.uid, system_id = :e.systemId, template_id = :e.templateId, recipient_id = :e.recipientId, event_type = :e.eventType, rule_name = :e.ruleName, data = :e.data, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") EventLogDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE email.event_log SET id = :e.id, uid = :e.uid, system_id = :e.systemId, template_id = :e.templateId, recipient_id = :e.recipientId, event_type = :e.eventType, rule_name = :e.ruleName, data = :e.data, date_created = :e.dateCreated WHERE system_id = :bySystemId")
    public int updateBySystemId(@BindBean(value="e") EventLogDomain var1, @Bind(value="bySystemId") Long var2);

    @SqlUpdate(value="UPDATE email.event_log SET id = :e.id, uid = :e.uid, system_id = :e.systemId, template_id = :e.templateId, recipient_id = :e.recipientId, event_type = :e.eventType, rule_name = :e.ruleName, data = :e.data, date_created = :e.dateCreated WHERE template_id = :byTemplateId")
    public int updateByTemplateId(@BindBean(value="e") EventLogDomain var1, @Bind(value="byTemplateId") Long var2);

    @SqlUpdate(value="UPDATE email.event_log SET id = :e.id, uid = :e.uid, system_id = :e.systemId, template_id = :e.templateId, recipient_id = :e.recipientId, event_type = :e.eventType, rule_name = :e.ruleName, data = :e.data, date_created = :e.dateCreated WHERE recipient_id = :byRecipientId")
    public int updateByRecipientId(@BindBean(value="e") EventLogDomain var1, @Bind(value="byRecipientId") Long var2);

    @SqlUpdate(value="UPDATE email.event_log SET id = :e.id, uid = :e.uid, system_id = :e.systemId, template_id = :e.templateId, recipient_id = :e.recipientId, event_type = :e.eventType, rule_name = :e.ruleName, data = :e.data, date_created = :e.dateCreated WHERE event_type = :byEventType")
    public int updateByEventType(@BindBean(value="e") EventLogDomain var1, @Bind(value="byEventType") String var2);

    @SqlUpdate(value="UPDATE email.event_log SET id = :e.id, uid = :e.uid, system_id = :e.systemId, template_id = :e.templateId, recipient_id = :e.recipientId, event_type = :e.eventType, rule_name = :e.ruleName, data = :e.data, date_created = :e.dateCreated WHERE rule_name = :byRuleName")
    public int updateByRuleName(@BindBean(value="e") EventLogDomain var1, @Bind(value="byRuleName") String var2);

    @SqlUpdate(value="UPDATE email.event_log SET id = :e.id, uid = :e.uid, system_id = :e.systemId, template_id = :e.templateId, recipient_id = :e.recipientId, event_type = :e.eventType, rule_name = :e.ruleName, data = :e.data, date_created = :e.dateCreated WHERE data = :byData")
    public int updateByData(@BindBean(value="e") EventLogDomain var1, @Bind(value="byData") String var2);

    @SqlUpdate(value="UPDATE email.event_log SET id = :e.id, uid = :e.uid, system_id = :e.systemId, template_id = :e.templateId, recipient_id = :e.recipientId, event_type = :e.eventType, rule_name = :e.ruleName, data = :e.data, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") EventLogDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM email.event_log WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM email.event_log WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM email.event_log WHERE system_id = :systemId")
    public int deleteBySystemId(@Bind(value="systemId") Long var1);

    @SqlUpdate(value="DELETE FROM email.event_log WHERE template_id = :templateId")
    public int deleteByTemplateId(@Bind(value="templateId") Long var1);

    @SqlUpdate(value="DELETE FROM email.event_log WHERE recipient_id = :recipientId")
    public int deleteByRecipientId(@Bind(value="recipientId") Long var1);

    @SqlUpdate(value="DELETE FROM email.event_log WHERE event_type = :eventType")
    public int deleteByEventType(@Bind(value="eventType") String var1);

    @SqlUpdate(value="DELETE FROM email.event_log WHERE rule_name = :ruleName")
    public int deleteByRuleName(@Bind(value="ruleName") String var1);

    @SqlUpdate(value="DELETE FROM email.event_log WHERE data = :data")
    public int deleteByData(@Bind(value="data") String var1);

    @SqlUpdate(value="DELETE FROM email.event_log WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

