/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.email;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.email.EmailReadMapper;
import cz.airtoy.airshop.domains.email.EmailReadDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface EmailReadDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.email_id,\n\t\tp.partner_id,\n\t\tp.read,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\temail.email_read p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.email_id::text ~* :mask \n\tOR \n\t\tp.partner_id::text ~* :mask \n\tOR \n\t\tp.read::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=EmailReadMapper.class)
    public List<EmailReadDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\temail.email_read p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.email_id::text ~* :mask \n\tOR \n\t\tp.partner_id::text ~* :mask \n\tOR \n\t\tp.read::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.partner_id, p.read, p.note, p.date_created FROM email.email_read p  ")
    @RegisterRowMapper(value=EmailReadMapper.class)
    public List<EmailReadDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.partner_id, p.read, p.note, p.date_created FROM email.email_read p  WHERE p.id = :id")
    @RegisterRowMapper(value=EmailReadMapper.class)
    public EmailReadDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.partner_id, p.read, p.note, p.date_created FROM email.email_read p  WHERE p.id = :id")
    @RegisterRowMapper(value=EmailReadMapper.class)
    public List<EmailReadDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.email_read p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.partner_id, p.read, p.note, p.date_created FROM email.email_read p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EmailReadMapper.class)
    public List<EmailReadDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.partner_id, p.read, p.note, p.date_created FROM email.email_read p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=EmailReadMapper.class)
    public EmailReadDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.partner_id, p.read, p.note, p.date_created FROM email.email_read p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=EmailReadMapper.class)
    public List<EmailReadDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.email_read p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.partner_id, p.read, p.note, p.date_created FROM email.email_read p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EmailReadMapper.class)
    public List<EmailReadDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.partner_id, p.read, p.note, p.date_created FROM email.email_read p  WHERE p.email_id = :emailId")
    @RegisterRowMapper(value=EmailReadMapper.class)
    public EmailReadDomain findByEmailId(@Bind(value="emailId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.partner_id, p.read, p.note, p.date_created FROM email.email_read p  WHERE p.email_id = :emailId")
    @RegisterRowMapper(value=EmailReadMapper.class)
    public List<EmailReadDomain> findListByEmailId(@Bind(value="emailId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.email_read p  WHERE p.email_id = :emailId")
    public long findListByEmailIdCount(@Bind(value="emailId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.partner_id, p.read, p.note, p.date_created FROM email.email_read p  WHERE p.email_id = :emailId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EmailReadMapper.class)
    public List<EmailReadDomain> findListByEmailId(@Bind(value="emailId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.partner_id, p.read, p.note, p.date_created FROM email.email_read p  WHERE p.partner_id = :partnerId")
    @RegisterRowMapper(value=EmailReadMapper.class)
    public EmailReadDomain findByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.partner_id, p.read, p.note, p.date_created FROM email.email_read p  WHERE p.partner_id = :partnerId")
    @RegisterRowMapper(value=EmailReadMapper.class)
    public List<EmailReadDomain> findListByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.email_read p  WHERE p.partner_id = :partnerId")
    public long findListByPartnerIdCount(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.partner_id, p.read, p.note, p.date_created FROM email.email_read p  WHERE p.partner_id = :partnerId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EmailReadMapper.class)
    public List<EmailReadDomain> findListByPartnerId(@Bind(value="partnerId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.partner_id, p.read, p.note, p.date_created FROM email.email_read p  WHERE p.read = :read")
    @RegisterRowMapper(value=EmailReadMapper.class)
    public EmailReadDomain findByRead(@Bind(value="read") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.partner_id, p.read, p.note, p.date_created FROM email.email_read p  WHERE p.read = :read")
    @RegisterRowMapper(value=EmailReadMapper.class)
    public List<EmailReadDomain> findListByRead(@Bind(value="read") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.email_read p  WHERE p.read = :read")
    public long findListByReadCount(@Bind(value="read") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.partner_id, p.read, p.note, p.date_created FROM email.email_read p  WHERE p.read = :read ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EmailReadMapper.class)
    public List<EmailReadDomain> findListByRead(@Bind(value="read") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.partner_id, p.read, p.note, p.date_created FROM email.email_read p  WHERE p.note = :note")
    @RegisterRowMapper(value=EmailReadMapper.class)
    public EmailReadDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.partner_id, p.read, p.note, p.date_created FROM email.email_read p  WHERE p.note = :note")
    @RegisterRowMapper(value=EmailReadMapper.class)
    public List<EmailReadDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.email_read p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.partner_id, p.read, p.note, p.date_created FROM email.email_read p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EmailReadMapper.class)
    public List<EmailReadDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.partner_id, p.read, p.note, p.date_created FROM email.email_read p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=EmailReadMapper.class)
    public EmailReadDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.partner_id, p.read, p.note, p.date_created FROM email.email_read p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=EmailReadMapper.class)
    public List<EmailReadDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.email_read p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.email_id, p.partner_id, p.read, p.note, p.date_created FROM email.email_read p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=EmailReadMapper.class)
    public List<EmailReadDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO email.email_read (id, uid, email_id, partner_id, read, note, date_created) VALUES (:id, :uid, :emailId, :partnerId, :read, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="emailId") Long var3, @Bind(value="partnerId") Long var4, @Bind(value="read") Date var5, @Bind(value="note") String var6, @Bind(value="dateCreated") Date var7);

    @SqlUpdate(value="INSERT INTO email.email_read (email_id, partner_id, read, note, date_created) VALUES (:e.emailId, :e.partnerId, :e.read, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") EmailReadDomain var1);

    @SqlUpdate(value="UPDATE email.email_read SET id = :e.id, uid = :e.uid, email_id = :e.emailId, partner_id = :e.partnerId, read = :e.read, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") EmailReadDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE email.email_read SET id = :e.id, uid = :e.uid, email_id = :e.emailId, partner_id = :e.partnerId, read = :e.read, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") EmailReadDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE email.email_read SET id = :e.id, uid = :e.uid, email_id = :e.emailId, partner_id = :e.partnerId, read = :e.read, note = :e.note, date_created = :e.dateCreated WHERE email_id = :byEmailId")
    public int updateByEmailId(@BindBean(value="e") EmailReadDomain var1, @Bind(value="byEmailId") Long var2);

    @SqlUpdate(value="UPDATE email.email_read SET id = :e.id, uid = :e.uid, email_id = :e.emailId, partner_id = :e.partnerId, read = :e.read, note = :e.note, date_created = :e.dateCreated WHERE partner_id = :byPartnerId")
    public int updateByPartnerId(@BindBean(value="e") EmailReadDomain var1, @Bind(value="byPartnerId") Long var2);

    @SqlUpdate(value="UPDATE email.email_read SET id = :e.id, uid = :e.uid, email_id = :e.emailId, partner_id = :e.partnerId, read = :e.read, note = :e.note, date_created = :e.dateCreated WHERE read = :byRead")
    public int updateByRead(@BindBean(value="e") EmailReadDomain var1, @Bind(value="byRead") Date var2);

    @SqlUpdate(value="UPDATE email.email_read SET id = :e.id, uid = :e.uid, email_id = :e.emailId, partner_id = :e.partnerId, read = :e.read, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") EmailReadDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE email.email_read SET id = :e.id, uid = :e.uid, email_id = :e.emailId, partner_id = :e.partnerId, read = :e.read, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") EmailReadDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM email.email_read WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM email.email_read WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM email.email_read WHERE email_id = :emailId")
    public int deleteByEmailId(@Bind(value="emailId") Long var1);

    @SqlUpdate(value="DELETE FROM email.email_read WHERE partner_id = :partnerId")
    public int deleteByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlUpdate(value="DELETE FROM email.email_read WHERE read = :read")
    public int deleteByRead(@Bind(value="read") Date var1);

    @SqlUpdate(value="DELETE FROM email.email_read WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM email.email_read WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

