/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.SetupMapper;
import cz.airtoy.airshop.domains.SetupDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface SetupDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.system,\n\t\tp.key,\n\t\tp.value,\n\t\tp.type,\n\t\tp.valid_from,\n\t\tp.valid_to,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tsystem.setup p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.system::text ~* :mask \n\tOR \n\t\tp.key::text ~* :mask \n\tOR \n\t\tp.value::text ~* :mask \n\tOR \n\t\tp.type::text ~* :mask \n\tOR \n\t\tp.valid_from::text ~* :mask \n\tOR \n\t\tp.valid_to::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=SetupMapper.class)
    public List<SetupDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tsystem.setup p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.system::text ~* :mask \n\tOR \n\t\tp.key::text ~* :mask \n\tOR \n\t\tp.value::text ~* :mask \n\tOR \n\t\tp.type::text ~* :mask \n\tOR \n\t\tp.valid_from::text ~* :mask \n\tOR \n\t\tp.valid_to::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.id = :id")
    @RegisterRowMapper(value=SetupMapper.class)
    public SetupDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.id = :id")
    @RegisterRowMapper(value=SetupMapper.class)
    public List<SetupDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.setup p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SetupMapper.class)
    public List<SetupDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=SetupMapper.class)
    public SetupDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=SetupMapper.class)
    public List<SetupDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.setup p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SetupMapper.class)
    public List<SetupDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.system = :system")
    @RegisterRowMapper(value=SetupMapper.class)
    public SetupDomain findBySystem(@Bind(value="system") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.system = :system")
    @RegisterRowMapper(value=SetupMapper.class)
    public List<SetupDomain> findListBySystem(@Bind(value="system") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.system LIKE :system")
    @RegisterRowMapper(value=SetupMapper.class)
    public List<SetupDomain> findListBySystemLike(@Bind(value="system") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.setup p  WHERE p.system = :system")
    public long findListBySystemCount(@Bind(value="system") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.system = :system ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SetupMapper.class)
    public List<SetupDomain> findListBySystem(@Bind(value="system") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.key = :key")
    @RegisterRowMapper(value=SetupMapper.class)
    public SetupDomain findByKey(@Bind(value="key") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.key = :key")
    @RegisterRowMapper(value=SetupMapper.class)
    public List<SetupDomain> findListByKey(@Bind(value="key") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.key LIKE :key")
    @RegisterRowMapper(value=SetupMapper.class)
    public List<SetupDomain> findListByKeyLike(@Bind(value="key") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.setup p  WHERE p.key = :key")
    public long findListByKeyCount(@Bind(value="key") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.key = :key ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SetupMapper.class)
    public List<SetupDomain> findListByKey(@Bind(value="key") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.value = :value")
    @RegisterRowMapper(value=SetupMapper.class)
    public SetupDomain findByValue(@Bind(value="value") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.value = :value")
    @RegisterRowMapper(value=SetupMapper.class)
    public List<SetupDomain> findListByValue(@Bind(value="value") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.setup p  WHERE p.value = :value")
    public long findListByValueCount(@Bind(value="value") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.value = :value ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SetupMapper.class)
    public List<SetupDomain> findListByValue(@Bind(value="value") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.type = :type")
    @RegisterRowMapper(value=SetupMapper.class)
    public SetupDomain findByType(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.type = :type")
    @RegisterRowMapper(value=SetupMapper.class)
    public List<SetupDomain> findListByType(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.setup p  WHERE p.type = :type")
    public long findListByTypeCount(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.type = :type ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SetupMapper.class)
    public List<SetupDomain> findListByType(@Bind(value="type") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.valid_from = :validFrom")
    @RegisterRowMapper(value=SetupMapper.class)
    public SetupDomain findByValidFrom(@Bind(value="validFrom") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.valid_from = :validFrom")
    @RegisterRowMapper(value=SetupMapper.class)
    public List<SetupDomain> findListByValidFrom(@Bind(value="validFrom") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.setup p  WHERE p.valid_from = :validFrom")
    public long findListByValidFromCount(@Bind(value="validFrom") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.valid_from = :validFrom ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SetupMapper.class)
    public List<SetupDomain> findListByValidFrom(@Bind(value="validFrom") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.valid_to = :validTo")
    @RegisterRowMapper(value=SetupMapper.class)
    public SetupDomain findByValidTo(@Bind(value="validTo") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.valid_to = :validTo")
    @RegisterRowMapper(value=SetupMapper.class)
    public List<SetupDomain> findListByValidTo(@Bind(value="validTo") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.setup p  WHERE p.valid_to = :validTo")
    public long findListByValidToCount(@Bind(value="validTo") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.valid_to = :validTo ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SetupMapper.class)
    public List<SetupDomain> findListByValidTo(@Bind(value="validTo") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.note = :note")
    @RegisterRowMapper(value=SetupMapper.class)
    public SetupDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.note = :note")
    @RegisterRowMapper(value=SetupMapper.class)
    public List<SetupDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.setup p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SetupMapper.class)
    public List<SetupDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=SetupMapper.class)
    public SetupDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=SetupMapper.class)
    public List<SetupDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.setup p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.system, p.key, p.value, p.type, p.valid_from, p.valid_to, p.note, p.date_created FROM system.setup p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SetupMapper.class)
    public List<SetupDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO system.setup (id, uid, system, key, value, type, valid_from, valid_to, note, date_created) VALUES (:id, :uid, :system, :key, :value, :type, :validFrom, :validTo, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="system") String var3, @Bind(value="key") String var4, @Bind(value="value") String var5, @Bind(value="type") String var6, @Bind(value="validFrom") Date var7, @Bind(value="validTo") Date var8, @Bind(value="note") String var9, @Bind(value="dateCreated") Date var10);

    @SqlUpdate(value="INSERT INTO system.setup (system, key, value, type, valid_from, valid_to, note, date_created) VALUES (:e.system, :e.key, :e.value, :e.type, :e.validFrom, :e.validTo, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") SetupDomain var1);

    @SqlUpdate(value="UPDATE system.setup SET id = :e.id, uid = :e.uid, system = :e.system, key = :e.key, value = :e.value, type = :e.type, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") SetupDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE system.setup SET id = :e.id, uid = :e.uid, system = :e.system, key = :e.key, value = :e.value, type = :e.type, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") SetupDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE system.setup SET id = :e.id, uid = :e.uid, system = :e.system, key = :e.key, value = :e.value, type = :e.type, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE system = :bySystem")
    public int updateBySystem(@BindBean(value="e") SetupDomain var1, @Bind(value="bySystem") String var2);

    @SqlUpdate(value="UPDATE system.setup SET id = :e.id, uid = :e.uid, system = :e.system, key = :e.key, value = :e.value, type = :e.type, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE key = :byKey")
    public int updateByKey(@BindBean(value="e") SetupDomain var1, @Bind(value="byKey") String var2);

    @SqlUpdate(value="UPDATE system.setup SET id = :e.id, uid = :e.uid, system = :e.system, key = :e.key, value = :e.value, type = :e.type, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE value = :byValue")
    public int updateByValue(@BindBean(value="e") SetupDomain var1, @Bind(value="byValue") String var2);

    @SqlUpdate(value="UPDATE system.setup SET id = :e.id, uid = :e.uid, system = :e.system, key = :e.key, value = :e.value, type = :e.type, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE type = :byType")
    public int updateByType(@BindBean(value="e") SetupDomain var1, @Bind(value="byType") String var2);

    @SqlUpdate(value="UPDATE system.setup SET id = :e.id, uid = :e.uid, system = :e.system, key = :e.key, value = :e.value, type = :e.type, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE valid_from = :byValidFrom")
    public int updateByValidFrom(@BindBean(value="e") SetupDomain var1, @Bind(value="byValidFrom") Date var2);

    @SqlUpdate(value="UPDATE system.setup SET id = :e.id, uid = :e.uid, system = :e.system, key = :e.key, value = :e.value, type = :e.type, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE valid_to = :byValidTo")
    public int updateByValidTo(@BindBean(value="e") SetupDomain var1, @Bind(value="byValidTo") Date var2);

    @SqlUpdate(value="UPDATE system.setup SET id = :e.id, uid = :e.uid, system = :e.system, key = :e.key, value = :e.value, type = :e.type, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") SetupDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE system.setup SET id = :e.id, uid = :e.uid, system = :e.system, key = :e.key, value = :e.value, type = :e.type, valid_from = :e.validFrom, valid_to = :e.validTo, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") SetupDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM system.setup WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM system.setup WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM system.setup WHERE system = :system")
    public int deleteBySystem(@Bind(value="system") String var1);

    @SqlUpdate(value="DELETE FROM system.setup WHERE key = :key")
    public int deleteByKey(@Bind(value="key") String var1);

    @SqlUpdate(value="DELETE FROM system.setup WHERE value = :value")
    public int deleteByValue(@Bind(value="value") String var1);

    @SqlUpdate(value="DELETE FROM system.setup WHERE type = :type")
    public int deleteByType(@Bind(value="type") String var1);

    @SqlUpdate(value="DELETE FROM system.setup WHERE valid_from = :validFrom")
    public int deleteByValidFrom(@Bind(value="validFrom") Date var1);

    @SqlUpdate(value="DELETE FROM system.setup WHERE valid_to = :validTo")
    public int deleteByValidTo(@Bind(value="validTo") Date var1);

    @SqlUpdate(value="DELETE FROM system.setup WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM system.setup WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

