/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.OrderActionsMapper;
import cz.airtoy.airshop.domains.OrderActionsDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface OrderActionsDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.order_id,\n\t\tp.type,\n\t\tp.action,\n\t\tp.status,\n\t\tp.data,\n\t\tp.object_id,\n\t\tp.object_id_str,\n\t\tp.date_created\n FROM \n\t\tabra.order_actions p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.order_id::text ~* :mask \n\tOR \n\t\tp.type::text ~* :mask \n\tOR \n\t\tp.action::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.data::text ~* :mask \n\tOR \n\t\tp.object_id::text ~* :mask \n\tOR \n\t\tp.object_id_str::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=OrderActionsMapper.class)
    public List<OrderActionsDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tabra.order_actions p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.order_id::text ~* :mask \n\tOR \n\t\tp.type::text ~* :mask \n\tOR \n\t\tp.action::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.data::text ~* :mask \n\tOR \n\t\tp.object_id::text ~* :mask \n\tOR \n\t\tp.object_id_str::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.type, p.action, p.status, p.data, p.object_id, p.object_id_str, p.date_created FROM abra.order_actions p  WHERE p.id = :id")
    @RegisterRowMapper(value=OrderActionsMapper.class)
    public OrderActionsDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.type, p.action, p.status, p.data, p.object_id, p.object_id_str, p.date_created FROM abra.order_actions p  WHERE p.id = :id")
    @RegisterRowMapper(value=OrderActionsMapper.class)
    public List<OrderActionsDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_actions p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.type, p.action, p.status, p.data, p.object_id, p.object_id_str, p.date_created FROM abra.order_actions p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderActionsMapper.class)
    public List<OrderActionsDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.type, p.action, p.status, p.data, p.object_id, p.object_id_str, p.date_created FROM abra.order_actions p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=OrderActionsMapper.class)
    public OrderActionsDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.type, p.action, p.status, p.data, p.object_id, p.object_id_str, p.date_created FROM abra.order_actions p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=OrderActionsMapper.class)
    public List<OrderActionsDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_actions p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.type, p.action, p.status, p.data, p.object_id, p.object_id_str, p.date_created FROM abra.order_actions p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderActionsMapper.class)
    public List<OrderActionsDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.type, p.action, p.status, p.data, p.object_id, p.object_id_str, p.date_created FROM abra.order_actions p  WHERE p.order_id = :orderId")
    @RegisterRowMapper(value=OrderActionsMapper.class)
    public OrderActionsDomain findByOrderId(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.type, p.action, p.status, p.data, p.object_id, p.object_id_str, p.date_created FROM abra.order_actions p  WHERE p.order_id = :orderId")
    @RegisterRowMapper(value=OrderActionsMapper.class)
    public List<OrderActionsDomain> findListByOrderId(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_actions p  WHERE p.order_id = :orderId")
    public long findListByOrderIdCount(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.type, p.action, p.status, p.data, p.object_id, p.object_id_str, p.date_created FROM abra.order_actions p  WHERE p.order_id = :orderId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderActionsMapper.class)
    public List<OrderActionsDomain> findListByOrderId(@Bind(value="orderId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.type, p.action, p.status, p.data, p.object_id, p.object_id_str, p.date_created FROM abra.order_actions p  WHERE p.type = :type")
    @RegisterRowMapper(value=OrderActionsMapper.class)
    public OrderActionsDomain findByType(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.type, p.action, p.status, p.data, p.object_id, p.object_id_str, p.date_created FROM abra.order_actions p  WHERE p.type = :type")
    @RegisterRowMapper(value=OrderActionsMapper.class)
    public List<OrderActionsDomain> findListByType(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_actions p  WHERE p.type = :type")
    public long findListByTypeCount(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.type, p.action, p.status, p.data, p.object_id, p.object_id_str, p.date_created FROM abra.order_actions p  WHERE p.type = :type ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderActionsMapper.class)
    public List<OrderActionsDomain> findListByType(@Bind(value="type") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.type, p.action, p.status, p.data, p.object_id, p.object_id_str, p.date_created FROM abra.order_actions p  WHERE p.action = :action")
    @RegisterRowMapper(value=OrderActionsMapper.class)
    public OrderActionsDomain findByAction(@Bind(value="action") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.type, p.action, p.status, p.data, p.object_id, p.object_id_str, p.date_created FROM abra.order_actions p  WHERE p.action = :action")
    @RegisterRowMapper(value=OrderActionsMapper.class)
    public List<OrderActionsDomain> findListByAction(@Bind(value="action") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_actions p  WHERE p.action = :action")
    public long findListByActionCount(@Bind(value="action") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.type, p.action, p.status, p.data, p.object_id, p.object_id_str, p.date_created FROM abra.order_actions p  WHERE p.action = :action ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderActionsMapper.class)
    public List<OrderActionsDomain> findListByAction(@Bind(value="action") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.type, p.action, p.status, p.data, p.object_id, p.object_id_str, p.date_created FROM abra.order_actions p  WHERE p.status = :status")
    @RegisterRowMapper(value=OrderActionsMapper.class)
    public OrderActionsDomain findByStatus(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.type, p.action, p.status, p.data, p.object_id, p.object_id_str, p.date_created FROM abra.order_actions p  WHERE p.status = :status")
    @RegisterRowMapper(value=OrderActionsMapper.class)
    public List<OrderActionsDomain> findListByStatus(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_actions p  WHERE p.status = :status")
    public long findListByStatusCount(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.type, p.action, p.status, p.data, p.object_id, p.object_id_str, p.date_created FROM abra.order_actions p  WHERE p.status = :status ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderActionsMapper.class)
    public List<OrderActionsDomain> findListByStatus(@Bind(value="status") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.type, p.action, p.status, p.data, p.object_id, p.object_id_str, p.date_created FROM abra.order_actions p  WHERE p.data = :data")
    @RegisterRowMapper(value=OrderActionsMapper.class)
    public OrderActionsDomain findByData(@Bind(value="data") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.type, p.action, p.status, p.data, p.object_id, p.object_id_str, p.date_created FROM abra.order_actions p  WHERE p.data = :data")
    @RegisterRowMapper(value=OrderActionsMapper.class)
    public List<OrderActionsDomain> findListByData(@Bind(value="data") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_actions p  WHERE p.data = :data")
    public long findListByDataCount(@Bind(value="data") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.type, p.action, p.status, p.data, p.object_id, p.object_id_str, p.date_created FROM abra.order_actions p  WHERE p.data = :data ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderActionsMapper.class)
    public List<OrderActionsDomain> findListByData(@Bind(value="data") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.type, p.action, p.status, p.data, p.object_id, p.object_id_str, p.date_created FROM abra.order_actions p  WHERE p.object_id = :objectId")
    @RegisterRowMapper(value=OrderActionsMapper.class)
    public OrderActionsDomain findByObjectId(@Bind(value="objectId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.type, p.action, p.status, p.data, p.object_id, p.object_id_str, p.date_created FROM abra.order_actions p  WHERE p.object_id = :objectId")
    @RegisterRowMapper(value=OrderActionsMapper.class)
    public List<OrderActionsDomain> findListByObjectId(@Bind(value="objectId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_actions p  WHERE p.object_id = :objectId")
    public long findListByObjectIdCount(@Bind(value="objectId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.type, p.action, p.status, p.data, p.object_id, p.object_id_str, p.date_created FROM abra.order_actions p  WHERE p.object_id = :objectId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderActionsMapper.class)
    public List<OrderActionsDomain> findListByObjectId(@Bind(value="objectId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.type, p.action, p.status, p.data, p.object_id, p.object_id_str, p.date_created FROM abra.order_actions p  WHERE p.object_id_str = :objectIdStr")
    @RegisterRowMapper(value=OrderActionsMapper.class)
    public OrderActionsDomain findByObjectIdStr(@Bind(value="objectIdStr") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.type, p.action, p.status, p.data, p.object_id, p.object_id_str, p.date_created FROM abra.order_actions p  WHERE p.object_id_str = :objectIdStr")
    @RegisterRowMapper(value=OrderActionsMapper.class)
    public List<OrderActionsDomain> findListByObjectIdStr(@Bind(value="objectIdStr") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_actions p  WHERE p.object_id_str = :objectIdStr")
    public long findListByObjectIdStrCount(@Bind(value="objectIdStr") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.type, p.action, p.status, p.data, p.object_id, p.object_id_str, p.date_created FROM abra.order_actions p  WHERE p.object_id_str = :objectIdStr ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderActionsMapper.class)
    public List<OrderActionsDomain> findListByObjectIdStr(@Bind(value="objectIdStr") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.type, p.action, p.status, p.data, p.object_id, p.object_id_str, p.date_created FROM abra.order_actions p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=OrderActionsMapper.class)
    public OrderActionsDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.type, p.action, p.status, p.data, p.object_id, p.object_id_str, p.date_created FROM abra.order_actions p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=OrderActionsMapper.class)
    public List<OrderActionsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_actions p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.type, p.action, p.status, p.data, p.object_id, p.object_id_str, p.date_created FROM abra.order_actions p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderActionsMapper.class)
    public List<OrderActionsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO abra.order_actions (id, uid, order_id, type, action, status, data, object_id, object_id_str, date_created) VALUES (:id, :uid, :orderId, :type, :action, :status, :data, :objectId, :objectIdStr, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="orderId") Long var3, @Bind(value="type") String var4, @Bind(value="action") String var5, @Bind(value="status") String var6, @Bind(value="data") String var7, @Bind(value="objectId") Long var8, @Bind(value="objectIdStr") String var9, @Bind(value="dateCreated") Date var10);

    @SqlUpdate(value="INSERT INTO abra.order_actions (order_id, type, action, status, data, object_id, object_id_str, date_created) VALUES (:e.orderId, :e.type, :e.action, :e.status, :e.data, :e.objectId, :e.objectIdStr, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") OrderActionsDomain var1);

    @SqlUpdate(value="UPDATE abra.order_actions SET id = :e.id, uid = :e.uid, order_id = :e.orderId, type = :e.type, action = :e.action, status = :e.status, data = :e.data, object_id = :e.objectId, object_id_str = :e.objectIdStr, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") OrderActionsDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE abra.order_actions SET id = :e.id, uid = :e.uid, order_id = :e.orderId, type = :e.type, action = :e.action, status = :e.status, data = :e.data, object_id = :e.objectId, object_id_str = :e.objectIdStr, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") OrderActionsDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE abra.order_actions SET id = :e.id, uid = :e.uid, order_id = :e.orderId, type = :e.type, action = :e.action, status = :e.status, data = :e.data, object_id = :e.objectId, object_id_str = :e.objectIdStr, date_created = :e.dateCreated WHERE order_id = :byOrderId")
    public int updateByOrderId(@BindBean(value="e") OrderActionsDomain var1, @Bind(value="byOrderId") Long var2);

    @SqlUpdate(value="UPDATE abra.order_actions SET id = :e.id, uid = :e.uid, order_id = :e.orderId, type = :e.type, action = :e.action, status = :e.status, data = :e.data, object_id = :e.objectId, object_id_str = :e.objectIdStr, date_created = :e.dateCreated WHERE type = :byType")
    public int updateByType(@BindBean(value="e") OrderActionsDomain var1, @Bind(value="byType") String var2);

    @SqlUpdate(value="UPDATE abra.order_actions SET id = :e.id, uid = :e.uid, order_id = :e.orderId, type = :e.type, action = :e.action, status = :e.status, data = :e.data, object_id = :e.objectId, object_id_str = :e.objectIdStr, date_created = :e.dateCreated WHERE action = :byAction")
    public int updateByAction(@BindBean(value="e") OrderActionsDomain var1, @Bind(value="byAction") String var2);

    @SqlUpdate(value="UPDATE abra.order_actions SET id = :e.id, uid = :e.uid, order_id = :e.orderId, type = :e.type, action = :e.action, status = :e.status, data = :e.data, object_id = :e.objectId, object_id_str = :e.objectIdStr, date_created = :e.dateCreated WHERE status = :byStatus")
    public int updateByStatus(@BindBean(value="e") OrderActionsDomain var1, @Bind(value="byStatus") String var2);

    @SqlUpdate(value="UPDATE abra.order_actions SET id = :e.id, uid = :e.uid, order_id = :e.orderId, type = :e.type, action = :e.action, status = :e.status, data = :e.data, object_id = :e.objectId, object_id_str = :e.objectIdStr, date_created = :e.dateCreated WHERE data = :byData")
    public int updateByData(@BindBean(value="e") OrderActionsDomain var1, @Bind(value="byData") String var2);

    @SqlUpdate(value="UPDATE abra.order_actions SET id = :e.id, uid = :e.uid, order_id = :e.orderId, type = :e.type, action = :e.action, status = :e.status, data = :e.data, object_id = :e.objectId, object_id_str = :e.objectIdStr, date_created = :e.dateCreated WHERE object_id = :byObjectId")
    public int updateByObjectId(@BindBean(value="e") OrderActionsDomain var1, @Bind(value="byObjectId") Long var2);

    @SqlUpdate(value="UPDATE abra.order_actions SET id = :e.id, uid = :e.uid, order_id = :e.orderId, type = :e.type, action = :e.action, status = :e.status, data = :e.data, object_id = :e.objectId, object_id_str = :e.objectIdStr, date_created = :e.dateCreated WHERE object_id_str = :byObjectIdStr")
    public int updateByObjectIdStr(@BindBean(value="e") OrderActionsDomain var1, @Bind(value="byObjectIdStr") String var2);

    @SqlUpdate(value="UPDATE abra.order_actions SET id = :e.id, uid = :e.uid, order_id = :e.orderId, type = :e.type, action = :e.action, status = :e.status, data = :e.data, object_id = :e.objectId, object_id_str = :e.objectIdStr, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") OrderActionsDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM abra.order_actions WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM abra.order_actions WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_actions WHERE order_id = :orderId")
    public int deleteByOrderId(@Bind(value="orderId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.order_actions WHERE type = :type")
    public int deleteByType(@Bind(value="type") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_actions WHERE action = :action")
    public int deleteByAction(@Bind(value="action") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_actions WHERE status = :status")
    public int deleteByStatus(@Bind(value="status") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_actions WHERE data = :data")
    public int deleteByData(@Bind(value="data") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_actions WHERE object_id = :objectId")
    public int deleteByObjectId(@Bind(value="objectId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.order_actions WHERE object_id_str = :objectIdStr")
    public int deleteByObjectIdStr(@Bind(value="objectIdStr") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_actions WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

