/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class OaDateUtils {
    public static Date convertFromOaDate(Double d) throws ParseException {
        if (d != null) {
            double mantissa = d - (double)d.longValue();
            double hour = mantissa * 24.0;
            double min = (hour - (double)((long)hour)) * 60.0;
            double sec = (min - (double)((long)min)) * 60.0;
            SimpleDateFormat myFormat = new SimpleDateFormat("dd MM yyyy");
            Date baseDate = myFormat.parse("30 12 1899");
            Calendar c = Calendar.getInstance();
            c.setTime(baseDate);
            c.add(5, d.intValue());
            c.add(10, (int)hour);
            c.add(12, (int)min);
            c.add(13, (int)sec);
            return c.getTime();
        }
        return null;
    }

    public static String convertToOaDate(Date date) throws ParseException {
        if (date != null) {
            SimpleDateFormat myFormat = new SimpleDateFormat("dd MM yyyy");
            Date baseDate = myFormat.parse("30 12 1899");
            Long days = TimeUnit.DAYS.convert(date.getTime() - baseDate.getTime(), TimeUnit.MILLISECONDS);
            double oaDate = (double)days.longValue() + (double)date.getHours() / 24.0 + (double)date.getMinutes() / 1440.0 + (double)date.getSeconds() / 86400.0;
            return String.valueOf(oaDate);
        }
        return null;
    }

    public static Double convertToOaDateDouble(Date date) throws ParseException {
        if (date != null) {
            SimpleDateFormat myFormat = new SimpleDateFormat("dd MM yyyy");
            Date baseDate = myFormat.parse("30 12 1899");
            Long days = TimeUnit.DAYS.convert(date.getTime() - baseDate.getTime(), TimeUnit.MILLISECONDS);
            return (double)days.longValue() + (double)date.getHours() / 24.0 + (double)date.getMinutes() / 1440.0 + (double)date.getSeconds() / 86400.0;
        }
        return null;
    }
}

