/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.system;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.system.SystemOrderBeersMapper;
import cz.airtoy.airshop.domains.system.SystemOrderBeersDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface SystemOrderBeersDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.order_id,\n\t\tp.beer_id,\n\t\tp.date_changed,\n\t\tp.user_changed,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tsystem.order_beers p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.order_id::text ~* :mask \n\tOR \n\t\tp.beer_id::text ~* :mask \n\tOR \n\t\tp.date_changed::text ~* :mask \n\tOR \n\t\tp.user_changed::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=SystemOrderBeersMapper.class)
    public List<SystemOrderBeersDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tsystem.order_beers p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.order_id::text ~* :mask \n\tOR \n\t\tp.beer_id::text ~* :mask \n\tOR \n\t\tp.date_changed::text ~* :mask \n\tOR \n\t\tp.user_changed::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.beer_id, p.date_changed, p.user_changed, p.note, p.date_created FROM system.order_beers p  ")
    @RegisterRowMapper(value=SystemOrderBeersMapper.class)
    public List<SystemOrderBeersDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.order_id, p.beer_id, p.date_changed, p.user_changed, p.note, p.date_created FROM system.order_beers p  WHERE p.id = :id")
    @RegisterRowMapper(value=SystemOrderBeersMapper.class)
    public SystemOrderBeersDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.beer_id, p.date_changed, p.user_changed, p.note, p.date_created FROM system.order_beers p  WHERE p.id = :id")
    @RegisterRowMapper(value=SystemOrderBeersMapper.class)
    public List<SystemOrderBeersDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.order_beers p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.beer_id, p.date_changed, p.user_changed, p.note, p.date_created FROM system.order_beers p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SystemOrderBeersMapper.class)
    public List<SystemOrderBeersDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.order_id, p.beer_id, p.date_changed, p.user_changed, p.note, p.date_created FROM system.order_beers p  WHERE p.order_id = :orderId")
    @RegisterRowMapper(value=SystemOrderBeersMapper.class)
    public SystemOrderBeersDomain findBySystemOrderId(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.beer_id, p.date_changed, p.user_changed, p.note, p.date_created FROM system.order_beers p  WHERE p.order_id = :orderId")
    @RegisterRowMapper(value=SystemOrderBeersMapper.class)
    public List<SystemOrderBeersDomain> findListBySystemOrderId(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.order_beers p  WHERE p.order_id = :orderId")
    public long findListBySystemOrderIdCount(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.beer_id, p.date_changed, p.user_changed, p.note, p.date_created FROM system.order_beers p  WHERE p.order_id = :orderId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SystemOrderBeersMapper.class)
    public List<SystemOrderBeersDomain> findListBySystemOrderId(@Bind(value="orderId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.order_id, p.beer_id, p.date_changed, p.user_changed, p.note, p.date_created FROM system.order_beers p  WHERE p.beer_id = :beerId")
    @RegisterRowMapper(value=SystemOrderBeersMapper.class)
    public SystemOrderBeersDomain findByBeerId(@Bind(value="beerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.beer_id, p.date_changed, p.user_changed, p.note, p.date_created FROM system.order_beers p  WHERE p.beer_id = :beerId")
    @RegisterRowMapper(value=SystemOrderBeersMapper.class)
    public List<SystemOrderBeersDomain> findListByBeerId(@Bind(value="beerId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.order_beers p  WHERE p.beer_id = :beerId")
    public long findListByBeerIdCount(@Bind(value="beerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.beer_id, p.date_changed, p.user_changed, p.note, p.date_created FROM system.order_beers p  WHERE p.beer_id = :beerId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SystemOrderBeersMapper.class)
    public List<SystemOrderBeersDomain> findListByBeerId(@Bind(value="beerId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.order_id, p.beer_id, p.date_changed, p.user_changed, p.note, p.date_created FROM system.order_beers p  WHERE p.date_changed = :dateChanged")
    @RegisterRowMapper(value=SystemOrderBeersMapper.class)
    public SystemOrderBeersDomain findByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.beer_id, p.date_changed, p.user_changed, p.note, p.date_created FROM system.order_beers p  WHERE p.date_changed = :dateChanged")
    @RegisterRowMapper(value=SystemOrderBeersMapper.class)
    public List<SystemOrderBeersDomain> findListByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.order_beers p  WHERE p.date_changed = :dateChanged")
    public long findListByDateChangedCount(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.beer_id, p.date_changed, p.user_changed, p.note, p.date_created FROM system.order_beers p  WHERE p.date_changed = :dateChanged ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SystemOrderBeersMapper.class)
    public List<SystemOrderBeersDomain> findListByDateChanged(@Bind(value="dateChanged") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.order_id, p.beer_id, p.date_changed, p.user_changed, p.note, p.date_created FROM system.order_beers p  WHERE p.user_changed = :userChanged")
    @RegisterRowMapper(value=SystemOrderBeersMapper.class)
    public SystemOrderBeersDomain findByUserChanged(@Bind(value="userChanged") String var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.beer_id, p.date_changed, p.user_changed, p.note, p.date_created FROM system.order_beers p  WHERE p.user_changed = :userChanged")
    @RegisterRowMapper(value=SystemOrderBeersMapper.class)
    public List<SystemOrderBeersDomain> findListByUserChanged(@Bind(value="userChanged") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.order_beers p  WHERE p.user_changed = :userChanged")
    public long findListByUserChangedCount(@Bind(value="userChanged") String var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.beer_id, p.date_changed, p.user_changed, p.note, p.date_created FROM system.order_beers p  WHERE p.user_changed = :userChanged ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SystemOrderBeersMapper.class)
    public List<SystemOrderBeersDomain> findListByUserChanged(@Bind(value="userChanged") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.order_id, p.beer_id, p.date_changed, p.user_changed, p.note, p.date_created FROM system.order_beers p  WHERE p.note = :note")
    @RegisterRowMapper(value=SystemOrderBeersMapper.class)
    public SystemOrderBeersDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.beer_id, p.date_changed, p.user_changed, p.note, p.date_created FROM system.order_beers p  WHERE p.note = :note")
    @RegisterRowMapper(value=SystemOrderBeersMapper.class)
    public List<SystemOrderBeersDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.order_beers p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.beer_id, p.date_changed, p.user_changed, p.note, p.date_created FROM system.order_beers p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SystemOrderBeersMapper.class)
    public List<SystemOrderBeersDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.order_id, p.beer_id, p.date_changed, p.user_changed, p.note, p.date_created FROM system.order_beers p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=SystemOrderBeersMapper.class)
    public SystemOrderBeersDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.beer_id, p.date_changed, p.user_changed, p.note, p.date_created FROM system.order_beers p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=SystemOrderBeersMapper.class)
    public List<SystemOrderBeersDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.order_beers p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.beer_id, p.date_changed, p.user_changed, p.note, p.date_created FROM system.order_beers p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SystemOrderBeersMapper.class)
    public List<SystemOrderBeersDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO system.order_beers (id, order_id, beer_id, date_changed, user_changed, note, date_created) VALUES (:id, :orderId, :beerId, :dateChanged, :userChanged, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="orderId") Long var2, @Bind(value="beerId") Long var3, @Bind(value="dateChanged") Date var4, @Bind(value="userChanged") String var5, @Bind(value="note") String var6, @Bind(value="dateCreated") Date var7);

    @SqlUpdate(value="INSERT INTO system.order_beers (order_id, beer_id, date_changed, user_changed, note, date_created) VALUES (:e.orderId, :e.beerId, :e.dateChanged, :e.userChanged, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") SystemOrderBeersDomain var1);

    @SqlUpdate(value="UPDATE system.order_beers SET id = :e.id, order_id = :e.orderId, beer_id = :e.beerId, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") SystemOrderBeersDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE system.order_beers SET id = :e.id, order_id = :e.orderId, beer_id = :e.beerId, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE order_id = :bySystemOrderId")
    public int updateBySystemOrderId(@BindBean(value="e") SystemOrderBeersDomain var1, @Bind(value="bySystemOrderId") Long var2);

    @SqlUpdate(value="UPDATE system.order_beers SET id = :e.id, order_id = :e.orderId, beer_id = :e.beerId, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE beer_id = :byBeerId")
    public int updateByBeerId(@BindBean(value="e") SystemOrderBeersDomain var1, @Bind(value="byBeerId") Long var2);

    @SqlUpdate(value="UPDATE system.order_beers SET id = :e.id, order_id = :e.orderId, beer_id = :e.beerId, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE date_changed = :byDateChanged")
    public int updateByDateChanged(@BindBean(value="e") SystemOrderBeersDomain var1, @Bind(value="byDateChanged") Date var2);

    @SqlUpdate(value="UPDATE system.order_beers SET id = :e.id, order_id = :e.orderId, beer_id = :e.beerId, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE user_changed = :byUserChanged")
    public int updateByUserChanged(@BindBean(value="e") SystemOrderBeersDomain var1, @Bind(value="byUserChanged") String var2);

    @SqlUpdate(value="UPDATE system.order_beers SET id = :e.id, order_id = :e.orderId, beer_id = :e.beerId, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") SystemOrderBeersDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE system.order_beers SET id = :e.id, order_id = :e.orderId, beer_id = :e.beerId, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") SystemOrderBeersDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM system.order_beers WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM system.order_beers WHERE order_id = :orderId")
    public int deleteBySystemOrderId(@Bind(value="orderId") Long var1);

    @SqlUpdate(value="DELETE FROM system.order_beers WHERE beer_id = :beerId")
    public int deleteByBeerId(@Bind(value="beerId") Long var1);

    @SqlUpdate(value="DELETE FROM system.order_beers WHERE date_changed = :dateChanged")
    public int deleteByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlUpdate(value="DELETE FROM system.order_beers WHERE user_changed = :userChanged")
    public int deleteByUserChanged(@Bind(value="userChanged") String var1);

    @SqlUpdate(value="DELETE FROM system.order_beers WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM system.order_beers WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

