/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.data;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.data.TargetCommodityVariantMapper;
import cz.airtoy.airshop.domains.data.TargetCommodityVariantDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface TargetCommodityVariantDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.target_commodity_id,\n\t\tp.manufacturer_id,\n\t\tp.vat,\n\t\tp.language_name,\n\t\tp.name,\n\t\tp.alternative_name,\n\t\tp.annotation,\n\t\tp.description,\n\t\tp.meta_title,\n\t\tp.meta_description,\n\t\tp.meta_key_words,\n\t\tp.path,\n\t\tp.date_updated,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tdata.target_commodity_variant p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.target_commodity_id::text ~* :mask \n\tOR \n\t\tp.manufacturer_id::text ~* :mask \n\tOR \n\t\tp.vat::text ~* :mask \n\tOR \n\t\tp.language_name::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.alternative_name::text ~* :mask \n\tOR \n\t\tp.annotation::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.meta_title::text ~* :mask \n\tOR \n\t\tp.meta_description::text ~* :mask \n\tOR \n\t\tp.meta_key_words::text ~* :mask \n\tOR \n\t\tp.path::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tdata.target_commodity_variant p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.target_commodity_id::text ~* :mask \n\tOR \n\t\tp.manufacturer_id::text ~* :mask \n\tOR \n\t\tp.vat::text ~* :mask \n\tOR \n\t\tp.language_name::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.alternative_name::text ~* :mask \n\tOR \n\t\tp.annotation::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.meta_title::text ~* :mask \n\tOR \n\t\tp.meta_description::text ~* :mask \n\tOR \n\t\tp.meta_key_words::text ~* :mask \n\tOR \n\t\tp.path::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  ")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.id = :id")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public TargetCommodityVariantDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.id = :id")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity_variant p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public TargetCommodityVariantDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity_variant p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.target_commodity_id = :targetCommodityId")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public TargetCommodityVariantDomain findByTargetCommodityId(@Bind(value="targetCommodityId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.target_commodity_id = :targetCommodityId")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByTargetCommodityId(@Bind(value="targetCommodityId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity_variant p  WHERE p.target_commodity_id = :targetCommodityId")
    public long findListByTargetCommodityIdCount(@Bind(value="targetCommodityId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.target_commodity_id = :targetCommodityId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByTargetCommodityId(@Bind(value="targetCommodityId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.manufacturer_id = :manufacturerId")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public TargetCommodityVariantDomain findByManufacturerId(@Bind(value="manufacturerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.manufacturer_id = :manufacturerId")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByManufacturerId(@Bind(value="manufacturerId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity_variant p  WHERE p.manufacturer_id = :manufacturerId")
    public long findListByManufacturerIdCount(@Bind(value="manufacturerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.manufacturer_id = :manufacturerId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByManufacturerId(@Bind(value="manufacturerId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.vat = :vat")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public TargetCommodityVariantDomain findByVat(@Bind(value="vat") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.vat = :vat")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByVat(@Bind(value="vat") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity_variant p  WHERE p.vat = :vat")
    public long findListByVatCount(@Bind(value="vat") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.vat = :vat ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByVat(@Bind(value="vat") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.language_name = :languageName")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public TargetCommodityVariantDomain findByLanguageName(@Bind(value="languageName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.language_name = :languageName")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByLanguageName(@Bind(value="languageName") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity_variant p  WHERE p.language_name = :languageName")
    public long findListByLanguageNameCount(@Bind(value="languageName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.language_name = :languageName ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByLanguageName(@Bind(value="languageName") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.name = :name")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public TargetCommodityVariantDomain findByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.name = :name")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity_variant p  WHERE p.name = :name")
    public long findListByNameCount(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.name = :name ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByName(@Bind(value="name") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.alternative_name = :alternativeName")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public TargetCommodityVariantDomain findByAlternativeName(@Bind(value="alternativeName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.alternative_name = :alternativeName")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByAlternativeName(@Bind(value="alternativeName") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity_variant p  WHERE p.alternative_name = :alternativeName")
    public long findListByAlternativeNameCount(@Bind(value="alternativeName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.alternative_name = :alternativeName ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByAlternativeName(@Bind(value="alternativeName") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.annotation = :annotation")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public TargetCommodityVariantDomain findByAnnotation(@Bind(value="annotation") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.annotation = :annotation")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByAnnotation(@Bind(value="annotation") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity_variant p  WHERE p.annotation = :annotation")
    public long findListByAnnotationCount(@Bind(value="annotation") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.annotation = :annotation ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByAnnotation(@Bind(value="annotation") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.description = :description")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public TargetCommodityVariantDomain findByDescription(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.description = :description")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByDescription(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity_variant p  WHERE p.description = :description")
    public long findListByDescriptionCount(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.description = :description ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByDescription(@Bind(value="description") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.meta_title = :metaTitle")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public TargetCommodityVariantDomain findByMetaTitle(@Bind(value="metaTitle") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.meta_title = :metaTitle")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByMetaTitle(@Bind(value="metaTitle") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity_variant p  WHERE p.meta_title = :metaTitle")
    public long findListByMetaTitleCount(@Bind(value="metaTitle") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.meta_title = :metaTitle ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByMetaTitle(@Bind(value="metaTitle") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.meta_description = :metaDescription")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public TargetCommodityVariantDomain findByMetaDescription(@Bind(value="metaDescription") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.meta_description = :metaDescription")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByMetaDescription(@Bind(value="metaDescription") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity_variant p  WHERE p.meta_description = :metaDescription")
    public long findListByMetaDescriptionCount(@Bind(value="metaDescription") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.meta_description = :metaDescription ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByMetaDescription(@Bind(value="metaDescription") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.meta_key_words = :metaKeyWords")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public TargetCommodityVariantDomain findByMetaKeyWords(@Bind(value="metaKeyWords") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.meta_key_words = :metaKeyWords")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByMetaKeyWords(@Bind(value="metaKeyWords") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity_variant p  WHERE p.meta_key_words = :metaKeyWords")
    public long findListByMetaKeyWordsCount(@Bind(value="metaKeyWords") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.meta_key_words = :metaKeyWords ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByMetaKeyWords(@Bind(value="metaKeyWords") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.path = :path")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public TargetCommodityVariantDomain findByPath(@Bind(value="path") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.path = :path")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByPath(@Bind(value="path") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity_variant p  WHERE p.path = :path")
    public long findListByPathCount(@Bind(value="path") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.path = :path ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByPath(@Bind(value="path") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public TargetCommodityVariantDomain findByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity_variant p  WHERE p.date_updated = :dateUpdated")
    public long findListByDateUpdatedCount(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.date_updated = :dateUpdated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.note = :note")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public TargetCommodityVariantDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.note = :note")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity_variant p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public TargetCommodityVariantDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_commodity_variant p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.manufacturer_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.target_commodity_variant p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCommodityVariantMapper.class)
    public List<TargetCommodityVariantDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO data.target_commodity_variant (id, uid, target_commodity_id, manufacturer_id, vat, language_name, name, alternative_name, annotation, description, meta_title, meta_description, meta_key_words, path, date_updated, note, date_created) VALUES (:id, :uid, :targetCommodityId, :manufacturerId, :vat, :languageName, :name, :alternativeName, :annotation, :description, :metaTitle, :metaDescription, :metaKeyWords, :path, :dateUpdated, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="targetCommodityId") Long var3, @Bind(value="manufacturerId") Long var4, @Bind(value="vat") Double var5, @Bind(value="languageName") String var6, @Bind(value="name") String var7, @Bind(value="alternativeName") String var8, @Bind(value="annotation") String var9, @Bind(value="description") String var10, @Bind(value="metaTitle") String var11, @Bind(value="metaDescription") String var12, @Bind(value="metaKeyWords") String var13, @Bind(value="path") String var14, @Bind(value="dateUpdated") Date var15, @Bind(value="note") String var16, @Bind(value="dateCreated") Date var17);

    @SqlUpdate(value="INSERT INTO data.target_commodity_variant (target_commodity_id, manufacturer_id, vat, language_name, name, alternative_name, annotation, description, meta_title, meta_description, meta_key_words, path, date_updated, note, date_created) VALUES (:e.targetCommodityId, :e.manufacturerId, :e.vat, :e.languageName, :e.name, :e.alternativeName, :e.annotation, :e.description, :e.metaTitle, :e.metaDescription, :e.metaKeyWords, :e.path, :e.dateUpdated, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") TargetCommodityVariantDomain var1);

    @SqlUpdate(value="UPDATE data.target_commodity_variant SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, manufacturer_id = :e.manufacturerId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") TargetCommodityVariantDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE data.target_commodity_variant SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, manufacturer_id = :e.manufacturerId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") TargetCommodityVariantDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity_variant SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, manufacturer_id = :e.manufacturerId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE target_commodity_id = :byTargetCommodityId")
    public int updateByTargetCommodityId(@BindBean(value="e") TargetCommodityVariantDomain var1, @Bind(value="byTargetCommodityId") Long var2);

    @SqlUpdate(value="UPDATE data.target_commodity_variant SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, manufacturer_id = :e.manufacturerId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE manufacturer_id = :byManufacturerId")
    public int updateByManufacturerId(@BindBean(value="e") TargetCommodityVariantDomain var1, @Bind(value="byManufacturerId") Long var2);

    @SqlUpdate(value="UPDATE data.target_commodity_variant SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, manufacturer_id = :e.manufacturerId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE vat = :byVat")
    public int updateByVat(@BindBean(value="e") TargetCommodityVariantDomain var1, @Bind(value="byVat") Double var2);

    @SqlUpdate(value="UPDATE data.target_commodity_variant SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, manufacturer_id = :e.manufacturerId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE language_name = :byLanguageName")
    public int updateByLanguageName(@BindBean(value="e") TargetCommodityVariantDomain var1, @Bind(value="byLanguageName") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity_variant SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, manufacturer_id = :e.manufacturerId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE name = :byName")
    public int updateByName(@BindBean(value="e") TargetCommodityVariantDomain var1, @Bind(value="byName") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity_variant SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, manufacturer_id = :e.manufacturerId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE alternative_name = :byAlternativeName")
    public int updateByAlternativeName(@BindBean(value="e") TargetCommodityVariantDomain var1, @Bind(value="byAlternativeName") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity_variant SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, manufacturer_id = :e.manufacturerId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE annotation = :byAnnotation")
    public int updateByAnnotation(@BindBean(value="e") TargetCommodityVariantDomain var1, @Bind(value="byAnnotation") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity_variant SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, manufacturer_id = :e.manufacturerId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE description = :byDescription")
    public int updateByDescription(@BindBean(value="e") TargetCommodityVariantDomain var1, @Bind(value="byDescription") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity_variant SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, manufacturer_id = :e.manufacturerId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE meta_title = :byMetaTitle")
    public int updateByMetaTitle(@BindBean(value="e") TargetCommodityVariantDomain var1, @Bind(value="byMetaTitle") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity_variant SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, manufacturer_id = :e.manufacturerId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE meta_description = :byMetaDescription")
    public int updateByMetaDescription(@BindBean(value="e") TargetCommodityVariantDomain var1, @Bind(value="byMetaDescription") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity_variant SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, manufacturer_id = :e.manufacturerId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE meta_key_words = :byMetaKeyWords")
    public int updateByMetaKeyWords(@BindBean(value="e") TargetCommodityVariantDomain var1, @Bind(value="byMetaKeyWords") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity_variant SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, manufacturer_id = :e.manufacturerId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE path = :byPath")
    public int updateByPath(@BindBean(value="e") TargetCommodityVariantDomain var1, @Bind(value="byPath") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity_variant SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, manufacturer_id = :e.manufacturerId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_updated = :byDateUpdated")
    public int updateByDateUpdated(@BindBean(value="e") TargetCommodityVariantDomain var1, @Bind(value="byDateUpdated") Date var2);

    @SqlUpdate(value="UPDATE data.target_commodity_variant SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, manufacturer_id = :e.manufacturerId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") TargetCommodityVariantDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE data.target_commodity_variant SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, manufacturer_id = :e.manufacturerId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") TargetCommodityVariantDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM data.target_commodity_variant WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity_variant WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity_variant WHERE target_commodity_id = :targetCommodityId")
    public int deleteByTargetCommodityId(@Bind(value="targetCommodityId") Long var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity_variant WHERE manufacturer_id = :manufacturerId")
    public int deleteByManufacturerId(@Bind(value="manufacturerId") Long var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity_variant WHERE vat = :vat")
    public int deleteByVat(@Bind(value="vat") Double var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity_variant WHERE language_name = :languageName")
    public int deleteByLanguageName(@Bind(value="languageName") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity_variant WHERE name = :name")
    public int deleteByName(@Bind(value="name") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity_variant WHERE alternative_name = :alternativeName")
    public int deleteByAlternativeName(@Bind(value="alternativeName") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity_variant WHERE annotation = :annotation")
    public int deleteByAnnotation(@Bind(value="annotation") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity_variant WHERE description = :description")
    public int deleteByDescription(@Bind(value="description") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity_variant WHERE meta_title = :metaTitle")
    public int deleteByMetaTitle(@Bind(value="metaTitle") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity_variant WHERE meta_description = :metaDescription")
    public int deleteByMetaDescription(@Bind(value="metaDescription") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity_variant WHERE meta_key_words = :metaKeyWords")
    public int deleteByMetaKeyWords(@Bind(value="metaKeyWords") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity_variant WHERE path = :path")
    public int deleteByPath(@Bind(value="path") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity_variant WHERE date_updated = :dateUpdated")
    public int deleteByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity_variant WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM data.target_commodity_variant WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

