/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.data;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.data.TargetCategoryVariantMapper;
import cz.airtoy.airshop.domains.data.TargetCategoryVariantDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface TargetCategoryVariantDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.target_category_id,\n\t\tp.language_name,\n\t\tp.name,\n\t\tp.alternative_name,\n\t\tp.description,\n\t\tp.alternative_description,\n\t\tp.rank,\n\t\tp.meta_title,\n\t\tp.meta_description,\n\t\tp.meta_key_words,\n\t\tp.date_updated,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tdata.target_category_variant p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.target_category_id::text ~* :mask \n\tOR \n\t\tp.language_name::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.alternative_name::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.alternative_description::text ~* :mask \n\tOR \n\t\tp.rank::text ~* :mask \n\tOR \n\t\tp.meta_title::text ~* :mask \n\tOR \n\t\tp.meta_description::text ~* :mask \n\tOR \n\t\tp.meta_key_words::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tdata.target_category_variant p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.target_category_id::text ~* :mask \n\tOR \n\t\tp.language_name::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.alternative_name::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.alternative_description::text ~* :mask \n\tOR \n\t\tp.rank::text ~* :mask \n\tOR \n\t\tp.meta_title::text ~* :mask \n\tOR \n\t\tp.meta_description::text ~* :mask \n\tOR \n\t\tp.meta_key_words::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  ")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.id = :id")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public TargetCategoryVariantDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.id = :id")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_category_variant p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public TargetCategoryVariantDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_category_variant p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.target_category_id = :targetCategoryId")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public TargetCategoryVariantDomain findByTargetCategoryId(@Bind(value="targetCategoryId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.target_category_id = :targetCategoryId")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findListByTargetCategoryId(@Bind(value="targetCategoryId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_category_variant p  WHERE p.target_category_id = :targetCategoryId")
    public long findListByTargetCategoryIdCount(@Bind(value="targetCategoryId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.target_category_id = :targetCategoryId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findListByTargetCategoryId(@Bind(value="targetCategoryId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.language_name = :languageName")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public TargetCategoryVariantDomain findByLanguageName(@Bind(value="languageName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.language_name = :languageName")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findListByLanguageName(@Bind(value="languageName") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_category_variant p  WHERE p.language_name = :languageName")
    public long findListByLanguageNameCount(@Bind(value="languageName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.language_name = :languageName ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findListByLanguageName(@Bind(value="languageName") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.name = :name")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public TargetCategoryVariantDomain findByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.name = :name")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findListByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_category_variant p  WHERE p.name = :name")
    public long findListByNameCount(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.name = :name ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findListByName(@Bind(value="name") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.alternative_name = :alternativeName")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public TargetCategoryVariantDomain findByAlternativeName(@Bind(value="alternativeName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.alternative_name = :alternativeName")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findListByAlternativeName(@Bind(value="alternativeName") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_category_variant p  WHERE p.alternative_name = :alternativeName")
    public long findListByAlternativeNameCount(@Bind(value="alternativeName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.alternative_name = :alternativeName ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findListByAlternativeName(@Bind(value="alternativeName") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.description = :description")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public TargetCategoryVariantDomain findByDescription(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.description = :description")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findListByDescription(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_category_variant p  WHERE p.description = :description")
    public long findListByDescriptionCount(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.description = :description ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findListByDescription(@Bind(value="description") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.alternative_description = :alternativeDescription")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public TargetCategoryVariantDomain findByAlternativeDescription(@Bind(value="alternativeDescription") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.alternative_description = :alternativeDescription")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findListByAlternativeDescription(@Bind(value="alternativeDescription") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_category_variant p  WHERE p.alternative_description = :alternativeDescription")
    public long findListByAlternativeDescriptionCount(@Bind(value="alternativeDescription") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.alternative_description = :alternativeDescription ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findListByAlternativeDescription(@Bind(value="alternativeDescription") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.rank = :rank")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public TargetCategoryVariantDomain findByRank(@Bind(value="rank") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.rank = :rank")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findListByRank(@Bind(value="rank") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_category_variant p  WHERE p.rank = :rank")
    public long findListByRankCount(@Bind(value="rank") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.rank = :rank ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findListByRank(@Bind(value="rank") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.meta_title = :metaTitle")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public TargetCategoryVariantDomain findByMetaTitle(@Bind(value="metaTitle") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.meta_title = :metaTitle")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findListByMetaTitle(@Bind(value="metaTitle") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_category_variant p  WHERE p.meta_title = :metaTitle")
    public long findListByMetaTitleCount(@Bind(value="metaTitle") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.meta_title = :metaTitle ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findListByMetaTitle(@Bind(value="metaTitle") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.meta_description = :metaDescription")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public TargetCategoryVariantDomain findByMetaDescription(@Bind(value="metaDescription") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.meta_description = :metaDescription")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findListByMetaDescription(@Bind(value="metaDescription") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_category_variant p  WHERE p.meta_description = :metaDescription")
    public long findListByMetaDescriptionCount(@Bind(value="metaDescription") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.meta_description = :metaDescription ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findListByMetaDescription(@Bind(value="metaDescription") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.meta_key_words = :metaKeyWords")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public TargetCategoryVariantDomain findByMetaKeyWords(@Bind(value="metaKeyWords") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.meta_key_words = :metaKeyWords")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findListByMetaKeyWords(@Bind(value="metaKeyWords") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_category_variant p  WHERE p.meta_key_words = :metaKeyWords")
    public long findListByMetaKeyWordsCount(@Bind(value="metaKeyWords") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.meta_key_words = :metaKeyWords ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findListByMetaKeyWords(@Bind(value="metaKeyWords") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public TargetCategoryVariantDomain findByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_category_variant p  WHERE p.date_updated = :dateUpdated")
    public long findListByDateUpdatedCount(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.date_updated = :dateUpdated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.note = :note")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public TargetCategoryVariantDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.note = :note")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_category_variant p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public TargetCategoryVariantDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.target_category_variant p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.target_category_variant p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TargetCategoryVariantMapper.class)
    public List<TargetCategoryVariantDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO data.target_category_variant (id, uid, target_category_id, language_name, name, alternative_name, description, alternative_description, rank, meta_title, meta_description, meta_key_words, date_updated, note, date_created) VALUES (:id, :uid, :targetCategoryId, :languageName, :name, :alternativeName, :description, :alternativeDescription, :rank, :metaTitle, :metaDescription, :metaKeyWords, :dateUpdated, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="targetCategoryId") Long var3, @Bind(value="languageName") String var4, @Bind(value="name") String var5, @Bind(value="alternativeName") String var6, @Bind(value="description") String var7, @Bind(value="alternativeDescription") String var8, @Bind(value="rank") Integer var9, @Bind(value="metaTitle") String var10, @Bind(value="metaDescription") String var11, @Bind(value="metaKeyWords") String var12, @Bind(value="dateUpdated") Date var13, @Bind(value="note") String var14, @Bind(value="dateCreated") Date var15);

    @SqlUpdate(value="INSERT INTO data.target_category_variant (target_category_id, language_name, name, alternative_name, description, alternative_description, rank, meta_title, meta_description, meta_key_words, date_updated, note, date_created) VALUES (:e.targetCategoryId, :e.languageName, :e.name, :e.alternativeName, :e.description, :e.alternativeDescription, :e.rank, :e.metaTitle, :e.metaDescription, :e.metaKeyWords, :e.dateUpdated, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") TargetCategoryVariantDomain var1);

    @SqlUpdate(value="UPDATE data.target_category_variant SET id = :e.id, uid = :e.uid, target_category_id = :e.targetCategoryId, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, description = :e.description, alternative_description = :e.alternativeDescription, rank = :e.rank, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") TargetCategoryVariantDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE data.target_category_variant SET id = :e.id, uid = :e.uid, target_category_id = :e.targetCategoryId, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, description = :e.description, alternative_description = :e.alternativeDescription, rank = :e.rank, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") TargetCategoryVariantDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE data.target_category_variant SET id = :e.id, uid = :e.uid, target_category_id = :e.targetCategoryId, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, description = :e.description, alternative_description = :e.alternativeDescription, rank = :e.rank, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE target_category_id = :byTargetCategoryId")
    public int updateByTargetCategoryId(@BindBean(value="e") TargetCategoryVariantDomain var1, @Bind(value="byTargetCategoryId") Long var2);

    @SqlUpdate(value="UPDATE data.target_category_variant SET id = :e.id, uid = :e.uid, target_category_id = :e.targetCategoryId, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, description = :e.description, alternative_description = :e.alternativeDescription, rank = :e.rank, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE language_name = :byLanguageName")
    public int updateByLanguageName(@BindBean(value="e") TargetCategoryVariantDomain var1, @Bind(value="byLanguageName") String var2);

    @SqlUpdate(value="UPDATE data.target_category_variant SET id = :e.id, uid = :e.uid, target_category_id = :e.targetCategoryId, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, description = :e.description, alternative_description = :e.alternativeDescription, rank = :e.rank, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE name = :byName")
    public int updateByName(@BindBean(value="e") TargetCategoryVariantDomain var1, @Bind(value="byName") String var2);

    @SqlUpdate(value="UPDATE data.target_category_variant SET id = :e.id, uid = :e.uid, target_category_id = :e.targetCategoryId, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, description = :e.description, alternative_description = :e.alternativeDescription, rank = :e.rank, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE alternative_name = :byAlternativeName")
    public int updateByAlternativeName(@BindBean(value="e") TargetCategoryVariantDomain var1, @Bind(value="byAlternativeName") String var2);

    @SqlUpdate(value="UPDATE data.target_category_variant SET id = :e.id, uid = :e.uid, target_category_id = :e.targetCategoryId, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, description = :e.description, alternative_description = :e.alternativeDescription, rank = :e.rank, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE description = :byDescription")
    public int updateByDescription(@BindBean(value="e") TargetCategoryVariantDomain var1, @Bind(value="byDescription") String var2);

    @SqlUpdate(value="UPDATE data.target_category_variant SET id = :e.id, uid = :e.uid, target_category_id = :e.targetCategoryId, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, description = :e.description, alternative_description = :e.alternativeDescription, rank = :e.rank, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE alternative_description = :byAlternativeDescription")
    public int updateByAlternativeDescription(@BindBean(value="e") TargetCategoryVariantDomain var1, @Bind(value="byAlternativeDescription") String var2);

    @SqlUpdate(value="UPDATE data.target_category_variant SET id = :e.id, uid = :e.uid, target_category_id = :e.targetCategoryId, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, description = :e.description, alternative_description = :e.alternativeDescription, rank = :e.rank, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE rank = :byRank")
    public int updateByRank(@BindBean(value="e") TargetCategoryVariantDomain var1, @Bind(value="byRank") Integer var2);

    @SqlUpdate(value="UPDATE data.target_category_variant SET id = :e.id, uid = :e.uid, target_category_id = :e.targetCategoryId, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, description = :e.description, alternative_description = :e.alternativeDescription, rank = :e.rank, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE meta_title = :byMetaTitle")
    public int updateByMetaTitle(@BindBean(value="e") TargetCategoryVariantDomain var1, @Bind(value="byMetaTitle") String var2);

    @SqlUpdate(value="UPDATE data.target_category_variant SET id = :e.id, uid = :e.uid, target_category_id = :e.targetCategoryId, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, description = :e.description, alternative_description = :e.alternativeDescription, rank = :e.rank, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE meta_description = :byMetaDescription")
    public int updateByMetaDescription(@BindBean(value="e") TargetCategoryVariantDomain var1, @Bind(value="byMetaDescription") String var2);

    @SqlUpdate(value="UPDATE data.target_category_variant SET id = :e.id, uid = :e.uid, target_category_id = :e.targetCategoryId, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, description = :e.description, alternative_description = :e.alternativeDescription, rank = :e.rank, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE meta_key_words = :byMetaKeyWords")
    public int updateByMetaKeyWords(@BindBean(value="e") TargetCategoryVariantDomain var1, @Bind(value="byMetaKeyWords") String var2);

    @SqlUpdate(value="UPDATE data.target_category_variant SET id = :e.id, uid = :e.uid, target_category_id = :e.targetCategoryId, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, description = :e.description, alternative_description = :e.alternativeDescription, rank = :e.rank, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_updated = :byDateUpdated")
    public int updateByDateUpdated(@BindBean(value="e") TargetCategoryVariantDomain var1, @Bind(value="byDateUpdated") Date var2);

    @SqlUpdate(value="UPDATE data.target_category_variant SET id = :e.id, uid = :e.uid, target_category_id = :e.targetCategoryId, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, description = :e.description, alternative_description = :e.alternativeDescription, rank = :e.rank, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") TargetCategoryVariantDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE data.target_category_variant SET id = :e.id, uid = :e.uid, target_category_id = :e.targetCategoryId, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, description = :e.description, alternative_description = :e.alternativeDescription, rank = :e.rank, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") TargetCategoryVariantDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM data.target_category_variant WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM data.target_category_variant WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM data.target_category_variant WHERE target_category_id = :targetCategoryId")
    public int deleteByTargetCategoryId(@Bind(value="targetCategoryId") Long var1);

    @SqlUpdate(value="DELETE FROM data.target_category_variant WHERE language_name = :languageName")
    public int deleteByLanguageName(@Bind(value="languageName") String var1);

    @SqlUpdate(value="DELETE FROM data.target_category_variant WHERE name = :name")
    public int deleteByName(@Bind(value="name") String var1);

    @SqlUpdate(value="DELETE FROM data.target_category_variant WHERE alternative_name = :alternativeName")
    public int deleteByAlternativeName(@Bind(value="alternativeName") String var1);

    @SqlUpdate(value="DELETE FROM data.target_category_variant WHERE description = :description")
    public int deleteByDescription(@Bind(value="description") String var1);

    @SqlUpdate(value="DELETE FROM data.target_category_variant WHERE alternative_description = :alternativeDescription")
    public int deleteByAlternativeDescription(@Bind(value="alternativeDescription") String var1);

    @SqlUpdate(value="DELETE FROM data.target_category_variant WHERE rank = :rank")
    public int deleteByRank(@Bind(value="rank") Integer var1);

    @SqlUpdate(value="DELETE FROM data.target_category_variant WHERE meta_title = :metaTitle")
    public int deleteByMetaTitle(@Bind(value="metaTitle") String var1);

    @SqlUpdate(value="DELETE FROM data.target_category_variant WHERE meta_description = :metaDescription")
    public int deleteByMetaDescription(@Bind(value="metaDescription") String var1);

    @SqlUpdate(value="DELETE FROM data.target_category_variant WHERE meta_key_words = :metaKeyWords")
    public int deleteByMetaKeyWords(@Bind(value="metaKeyWords") String var1);

    @SqlUpdate(value="DELETE FROM data.target_category_variant WHERE date_updated = :dateUpdated")
    public int deleteByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlUpdate(value="DELETE FROM data.target_category_variant WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM data.target_category_variant WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

