/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.IncomeTypesMapper;
import cz.airtoy.airshop.domains.IncomeTypesDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface IncomeTypesDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.abra_id,\n\t\tp.analyticalaccount,\n\t\tp.bookcolumn,\n\t\tp.category,\n\t\tp.classid,\n\t\tp.code,\n\t\tp.description,\n\t\tp.displayname,\n\t\tp.eetkind,\n\t\tp.hidden,\n\t\tp.name,\n\t\tp.objversion,\n\t\tp.parent_id,\n\t\tp.updated,\n\t\tp.date_created\n FROM \n\t\tabra.income_types p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.analyticalaccount::text ~* :mask \n\tOR \n\t\tp.bookcolumn::text ~* :mask \n\tOR \n\t\tp.category::text ~* :mask \n\tOR \n\t\tp.classid::text ~* :mask \n\tOR \n\t\tp.code::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.displayname::text ~* :mask \n\tOR \n\t\tp.eetkind::text ~* :mask \n\tOR \n\t\tp.hidden::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.objversion::text ~* :mask \n\tOR \n\t\tp.parent_id::text ~* :mask \n\tOR \n\t\tp.updated::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tabra.income_types p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.analyticalaccount::text ~* :mask \n\tOR \n\t\tp.bookcolumn::text ~* :mask \n\tOR \n\t\tp.category::text ~* :mask \n\tOR \n\t\tp.classid::text ~* :mask \n\tOR \n\t\tp.code::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.displayname::text ~* :mask \n\tOR \n\t\tp.eetkind::text ~* :mask \n\tOR \n\t\tp.hidden::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.objversion::text ~* :mask \n\tOR \n\t\tp.parent_id::text ~* :mask \n\tOR \n\t\tp.updated::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.id = :id")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public IncomeTypesDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.id = :id")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.income_types p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public IncomeTypesDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.income_types p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.abra_id = :abraId")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public IncomeTypesDomain findByAbraId(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.abra_id = :abraId")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByAbraId(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.income_types p  WHERE p.abra_id = :abraId")
    public long findListByAbraIdCount(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.abra_id = :abraId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByAbraId(@Bind(value="abraId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.analyticalaccount = :analyticalaccount")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public IncomeTypesDomain findByAnalyticalaccount(@Bind(value="analyticalaccount") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.analyticalaccount = :analyticalaccount")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByAnalyticalaccount(@Bind(value="analyticalaccount") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.income_types p  WHERE p.analyticalaccount = :analyticalaccount")
    public long findListByAnalyticalaccountCount(@Bind(value="analyticalaccount") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.analyticalaccount = :analyticalaccount ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByAnalyticalaccount(@Bind(value="analyticalaccount") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.bookcolumn = :bookcolumn")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public IncomeTypesDomain findByBookcolumn(@Bind(value="bookcolumn") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.bookcolumn = :bookcolumn")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByBookcolumn(@Bind(value="bookcolumn") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.income_types p  WHERE p.bookcolumn = :bookcolumn")
    public long findListByBookcolumnCount(@Bind(value="bookcolumn") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.bookcolumn = :bookcolumn ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByBookcolumn(@Bind(value="bookcolumn") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.category = :category")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public IncomeTypesDomain findByCategory(@Bind(value="category") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.category = :category")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByCategory(@Bind(value="category") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.income_types p  WHERE p.category = :category")
    public long findListByCategoryCount(@Bind(value="category") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.category = :category ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByCategory(@Bind(value="category") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.classid = :classid")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public IncomeTypesDomain findByClassid(@Bind(value="classid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.classid = :classid")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByClassid(@Bind(value="classid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.income_types p  WHERE p.classid = :classid")
    public long findListByClassidCount(@Bind(value="classid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.classid = :classid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByClassid(@Bind(value="classid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.code = :code")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public IncomeTypesDomain findByCode(@Bind(value="code") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.code = :code")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByCode(@Bind(value="code") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.income_types p  WHERE p.code = :code")
    public long findListByCodeCount(@Bind(value="code") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.code = :code ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByCode(@Bind(value="code") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.description = :description")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public IncomeTypesDomain findByDescription(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.description = :description")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByDescription(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.income_types p  WHERE p.description = :description")
    public long findListByDescriptionCount(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.description = :description ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByDescription(@Bind(value="description") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.displayname = :displayname")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public IncomeTypesDomain findByDisplayname(@Bind(value="displayname") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.displayname = :displayname")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByDisplayname(@Bind(value="displayname") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.income_types p  WHERE p.displayname = :displayname")
    public long findListByDisplaynameCount(@Bind(value="displayname") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.displayname = :displayname ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByDisplayname(@Bind(value="displayname") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.eetkind = :eetkind")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public IncomeTypesDomain findByEetkind(@Bind(value="eetkind") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.eetkind = :eetkind")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByEetkind(@Bind(value="eetkind") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.income_types p  WHERE p.eetkind = :eetkind")
    public long findListByEetkindCount(@Bind(value="eetkind") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.eetkind = :eetkind ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByEetkind(@Bind(value="eetkind") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.hidden = :hidden")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public IncomeTypesDomain findByHidden(@Bind(value="hidden") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.hidden = :hidden")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByHidden(@Bind(value="hidden") Boolean var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.income_types p  WHERE p.hidden = :hidden")
    public long findListByHiddenCount(@Bind(value="hidden") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.hidden = :hidden ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByHidden(@Bind(value="hidden") Boolean var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.name = :name")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public IncomeTypesDomain findByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.name = :name")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.income_types p  WHERE p.name = :name")
    public long findListByNameCount(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.name = :name ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByName(@Bind(value="name") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.objversion = :objversion")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public IncomeTypesDomain findByObjversion(@Bind(value="objversion") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.objversion = :objversion")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByObjversion(@Bind(value="objversion") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.income_types p  WHERE p.objversion = :objversion")
    public long findListByObjversionCount(@Bind(value="objversion") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.objversion = :objversion ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByObjversion(@Bind(value="objversion") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.parent_id = :parentId")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public IncomeTypesDomain findByParentId(@Bind(value="parentId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.parent_id = :parentId")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByParentId(@Bind(value="parentId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.income_types p  WHERE p.parent_id = :parentId")
    public long findListByParentIdCount(@Bind(value="parentId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.parent_id = :parentId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByParentId(@Bind(value="parentId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.updated = :updated")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public IncomeTypesDomain findByUpdated(@Bind(value="updated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.updated = :updated")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByUpdated(@Bind(value="updated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.income_types p  WHERE p.updated = :updated")
    public long findListByUpdatedCount(@Bind(value="updated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.updated = :updated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByUpdated(@Bind(value="updated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public IncomeTypesDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.income_types p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.bookcolumn, p.category, p.classid, p.code, p.description, p.displayname, p.eetkind, p.hidden, p.name, p.objversion, p.parent_id, p.updated, p.date_created FROM abra.income_types p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=IncomeTypesMapper.class)
    public List<IncomeTypesDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO abra.income_types (id, uid, abra_id, analyticalaccount, bookcolumn, category, classid, code, description, displayname, eetkind, hidden, name, objversion, parent_id, updated, date_created) VALUES (:id, :uid, :abraId, :analyticalaccount, :bookcolumn, :category, :classid, :code, :description, :displayname, :eetkind, :hidden, :name, :objversion, :parentId, :updated, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="abraId") String var3, @Bind(value="analyticalaccount") String var4, @Bind(value="bookcolumn") Integer var5, @Bind(value="category") Integer var6, @Bind(value="classid") String var7, @Bind(value="code") String var8, @Bind(value="description") String var9, @Bind(value="displayname") String var10, @Bind(value="eetkind") Integer var11, @Bind(value="hidden") Boolean var12, @Bind(value="name") String var13, @Bind(value="objversion") Integer var14, @Bind(value="parentId") String var15, @Bind(value="updated") Date var16, @Bind(value="dateCreated") Date var17);

    @SqlUpdate(value="INSERT INTO abra.income_types (abra_id, analyticalaccount, bookcolumn, category, classid, code, description, displayname, eetkind, hidden, name, objversion, parent_id, updated, date_created) VALUES (:e.abraId, :e.analyticalaccount, :e.bookcolumn, :e.category, :e.classid, :e.code, :e.description, :e.displayname, :e.eetkind, :e.hidden, :e.name, :e.objversion, :e.parentId, :e.updated, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") IncomeTypesDomain var1);

    @SqlUpdate(value="UPDATE abra.income_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, bookcolumn = :e.bookcolumn, category = :e.category, classid = :e.classid, code = :e.code, description = :e.description, displayname = :e.displayname, eetkind = :e.eetkind, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") IncomeTypesDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE abra.income_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, bookcolumn = :e.bookcolumn, category = :e.category, classid = :e.classid, code = :e.code, description = :e.description, displayname = :e.displayname, eetkind = :e.eetkind, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") IncomeTypesDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE abra.income_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, bookcolumn = :e.bookcolumn, category = :e.category, classid = :e.classid, code = :e.code, description = :e.description, displayname = :e.displayname, eetkind = :e.eetkind, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE abra_id = :byAbraId")
    public int updateByAbraId(@BindBean(value="e") IncomeTypesDomain var1, @Bind(value="byAbraId") String var2);

    @SqlUpdate(value="UPDATE abra.income_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, bookcolumn = :e.bookcolumn, category = :e.category, classid = :e.classid, code = :e.code, description = :e.description, displayname = :e.displayname, eetkind = :e.eetkind, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE analyticalaccount = :byAnalyticalaccount")
    public int updateByAnalyticalaccount(@BindBean(value="e") IncomeTypesDomain var1, @Bind(value="byAnalyticalaccount") String var2);

    @SqlUpdate(value="UPDATE abra.income_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, bookcolumn = :e.bookcolumn, category = :e.category, classid = :e.classid, code = :e.code, description = :e.description, displayname = :e.displayname, eetkind = :e.eetkind, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE bookcolumn = :byBookcolumn")
    public int updateByBookcolumn(@BindBean(value="e") IncomeTypesDomain var1, @Bind(value="byBookcolumn") Integer var2);

    @SqlUpdate(value="UPDATE abra.income_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, bookcolumn = :e.bookcolumn, category = :e.category, classid = :e.classid, code = :e.code, description = :e.description, displayname = :e.displayname, eetkind = :e.eetkind, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE category = :byCategory")
    public int updateByCategory(@BindBean(value="e") IncomeTypesDomain var1, @Bind(value="byCategory") Integer var2);

    @SqlUpdate(value="UPDATE abra.income_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, bookcolumn = :e.bookcolumn, category = :e.category, classid = :e.classid, code = :e.code, description = :e.description, displayname = :e.displayname, eetkind = :e.eetkind, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE classid = :byClassid")
    public int updateByClassid(@BindBean(value="e") IncomeTypesDomain var1, @Bind(value="byClassid") String var2);

    @SqlUpdate(value="UPDATE abra.income_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, bookcolumn = :e.bookcolumn, category = :e.category, classid = :e.classid, code = :e.code, description = :e.description, displayname = :e.displayname, eetkind = :e.eetkind, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE code = :byCode")
    public int updateByCode(@BindBean(value="e") IncomeTypesDomain var1, @Bind(value="byCode") String var2);

    @SqlUpdate(value="UPDATE abra.income_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, bookcolumn = :e.bookcolumn, category = :e.category, classid = :e.classid, code = :e.code, description = :e.description, displayname = :e.displayname, eetkind = :e.eetkind, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE description = :byDescription")
    public int updateByDescription(@BindBean(value="e") IncomeTypesDomain var1, @Bind(value="byDescription") String var2);

    @SqlUpdate(value="UPDATE abra.income_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, bookcolumn = :e.bookcolumn, category = :e.category, classid = :e.classid, code = :e.code, description = :e.description, displayname = :e.displayname, eetkind = :e.eetkind, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE displayname = :byDisplayname")
    public int updateByDisplayname(@BindBean(value="e") IncomeTypesDomain var1, @Bind(value="byDisplayname") String var2);

    @SqlUpdate(value="UPDATE abra.income_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, bookcolumn = :e.bookcolumn, category = :e.category, classid = :e.classid, code = :e.code, description = :e.description, displayname = :e.displayname, eetkind = :e.eetkind, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE eetkind = :byEetkind")
    public int updateByEetkind(@BindBean(value="e") IncomeTypesDomain var1, @Bind(value="byEetkind") Integer var2);

    @SqlUpdate(value="UPDATE abra.income_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, bookcolumn = :e.bookcolumn, category = :e.category, classid = :e.classid, code = :e.code, description = :e.description, displayname = :e.displayname, eetkind = :e.eetkind, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE hidden = :byHidden")
    public int updateByHidden(@BindBean(value="e") IncomeTypesDomain var1, @Bind(value="byHidden") Boolean var2);

    @SqlUpdate(value="UPDATE abra.income_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, bookcolumn = :e.bookcolumn, category = :e.category, classid = :e.classid, code = :e.code, description = :e.description, displayname = :e.displayname, eetkind = :e.eetkind, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE name = :byName")
    public int updateByName(@BindBean(value="e") IncomeTypesDomain var1, @Bind(value="byName") String var2);

    @SqlUpdate(value="UPDATE abra.income_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, bookcolumn = :e.bookcolumn, category = :e.category, classid = :e.classid, code = :e.code, description = :e.description, displayname = :e.displayname, eetkind = :e.eetkind, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE objversion = :byObjversion")
    public int updateByObjversion(@BindBean(value="e") IncomeTypesDomain var1, @Bind(value="byObjversion") Integer var2);

    @SqlUpdate(value="UPDATE abra.income_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, bookcolumn = :e.bookcolumn, category = :e.category, classid = :e.classid, code = :e.code, description = :e.description, displayname = :e.displayname, eetkind = :e.eetkind, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE parent_id = :byParentId")
    public int updateByParentId(@BindBean(value="e") IncomeTypesDomain var1, @Bind(value="byParentId") String var2);

    @SqlUpdate(value="UPDATE abra.income_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, bookcolumn = :e.bookcolumn, category = :e.category, classid = :e.classid, code = :e.code, description = :e.description, displayname = :e.displayname, eetkind = :e.eetkind, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE updated = :byUpdated")
    public int updateByUpdated(@BindBean(value="e") IncomeTypesDomain var1, @Bind(value="byUpdated") Date var2);

    @SqlUpdate(value="UPDATE abra.income_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, bookcolumn = :e.bookcolumn, category = :e.category, classid = :e.classid, code = :e.code, description = :e.description, displayname = :e.displayname, eetkind = :e.eetkind, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, parent_id = :e.parentId, updated = :e.updated, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") IncomeTypesDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM abra.income_types WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM abra.income_types WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM abra.income_types WHERE abra_id = :abraId")
    public int deleteByAbraId(@Bind(value="abraId") String var1);

    @SqlUpdate(value="DELETE FROM abra.income_types WHERE analyticalaccount = :analyticalaccount")
    public int deleteByAnalyticalaccount(@Bind(value="analyticalaccount") String var1);

    @SqlUpdate(value="DELETE FROM abra.income_types WHERE bookcolumn = :bookcolumn")
    public int deleteByBookcolumn(@Bind(value="bookcolumn") Integer var1);

    @SqlUpdate(value="DELETE FROM abra.income_types WHERE category = :category")
    public int deleteByCategory(@Bind(value="category") Integer var1);

    @SqlUpdate(value="DELETE FROM abra.income_types WHERE classid = :classid")
    public int deleteByClassid(@Bind(value="classid") String var1);

    @SqlUpdate(value="DELETE FROM abra.income_types WHERE code = :code")
    public int deleteByCode(@Bind(value="code") String var1);

    @SqlUpdate(value="DELETE FROM abra.income_types WHERE description = :description")
    public int deleteByDescription(@Bind(value="description") String var1);

    @SqlUpdate(value="DELETE FROM abra.income_types WHERE displayname = :displayname")
    public int deleteByDisplayname(@Bind(value="displayname") String var1);

    @SqlUpdate(value="DELETE FROM abra.income_types WHERE eetkind = :eetkind")
    public int deleteByEetkind(@Bind(value="eetkind") Integer var1);

    @SqlUpdate(value="DELETE FROM abra.income_types WHERE hidden = :hidden")
    public int deleteByHidden(@Bind(value="hidden") Boolean var1);

    @SqlUpdate(value="DELETE FROM abra.income_types WHERE name = :name")
    public int deleteByName(@Bind(value="name") String var1);

    @SqlUpdate(value="DELETE FROM abra.income_types WHERE objversion = :objversion")
    public int deleteByObjversion(@Bind(value="objversion") Integer var1);

    @SqlUpdate(value="DELETE FROM abra.income_types WHERE parent_id = :parentId")
    public int deleteByParentId(@Bind(value="parentId") String var1);

    @SqlUpdate(value="DELETE FROM abra.income_types WHERE updated = :updated")
    public int deleteByUpdated(@Bind(value="updated") Date var1);

    @SqlUpdate(value="DELETE FROM abra.income_types WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

