/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.configuration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import cz.airtoy.airshop.configuration.SetupItem;
import cz.airtoy.airshop.dao.dbi.SetupDbiDao;
import cz.airtoy.airshop.domains.SetupDomain;
import java.lang.reflect.Field;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Setup {
    private static final Logger log = LoggerFactory.getLogger(Setup.class);
    private static volatile Setup instance = null;
    private static SetupDbiDao setupDbiDao = null;
    private static String system = null;
    private static List<SetupItem> itemList = new ArrayList<SetupItem>();

    public Setup(SetupDbiDao setupDbiDao, String system) {
        Setup.setupDbiDao = setupDbiDao;
        Setup.system = system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Setup getInstance(SetupDbiDao setupDbiDao, String system) {
        Setup result = instance;
        if (result != null) return result;
        Class<Setup> clazz = Setup.class;
        synchronized (Setup.class) {
            result = instance;
            if (result != null) return result;
            instance = result = new Setup(setupDbiDao, system);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result;
        }
    }

    public void load() {
        this.loadFromDb();
    }

    public void refresh() {
        this.loadFromDb();
    }

    private void loadFromDb() {
        if (setupDbiDao != null) {
            itemList = new ArrayList<SetupItem>();
            List<SetupDomain> setupDomainList = setupDbiDao.findListBySystem(system);
            if (setupDomainList != null) {
                for (SetupDomain setupDomain : setupDomainList) {
                    itemList.add(new SetupItem(setupDomain.getKey(), setupDomain.getValue(), setupDomain.getType()));
                }
            }
        }
    }

    public SetupItem get(String key) {
        for (SetupItem setupItem : itemList) {
            if (!setupItem.isKey(key)) continue;
            return setupItem;
        }
        return null;
    }

    public Object getValue(String key, Object def) {
        Object res = this.getValue(key);
        if (res != null) {
            return res;
        }
        return def;
    }

    public Object getValue(String key) {
        for (SetupItem setupItem : itemList) {
            if (!setupItem.isKey(key)) continue;
            return setupItem.getObject();
        }
        return null;
    }

    public Integer getAsInteger(String key, Integer def) {
        Integer res = this.getAsInteger(key);
        if (res != null) {
            return res;
        }
        return def;
    }

    public Integer getAsInteger(String key) {
        for (SetupItem setupItem : itemList) {
            if (!setupItem.isKey(key)) continue;
            return setupItem.getAsInt();
        }
        return null;
    }

    public Long getAsLong(String key, Long def) {
        Long res = this.getAsLong(key);
        if (res != null) {
            return res;
        }
        return def;
    }

    public Long getAsLong(String key) {
        for (SetupItem setupItem : itemList) {
            if (!setupItem.isKey(key)) continue;
            return setupItem.getAsLong();
        }
        return null;
    }

    public Double getAsDouble(String key, Double def) {
        Double res = this.getAsDouble(key);
        if (res != null) {
            return res;
        }
        return def;
    }

    public Double getAsDouble(String key) {
        for (SetupItem setupItem : itemList) {
            if (!setupItem.isKey(key)) continue;
            return setupItem.getAsDouble();
        }
        return null;
    }

    public Boolean getAsBoolean(String key, Boolean def) {
        Boolean res = this.getAsBoolean(key);
        if (res != null) {
            return res;
        }
        return def;
    }

    public Boolean getAsBoolean(String key) {
        for (SetupItem setupItem : itemList) {
            if (!setupItem.isKey(key)) continue;
            return setupItem.getAsBoolean();
        }
        return null;
    }

    public String getAsString(String key, String def) {
        String res = this.getAsString(key);
        if (res != null) {
            return res;
        }
        return def;
    }

    public String getAsString(String key) {
        for (SetupItem setupItem : itemList) {
            if (!setupItem.isKey(key)) continue;
            return setupItem.getAsString();
        }
        return null;
    }

    public Object getAsJsonObject(String key, Class obj) {
        for (SetupItem setupItem : itemList) {
            if (!setupItem.isKey(key)) continue;
            try {
                return Setup.getGson().fromJson(setupItem.getAsString(), obj);
            }
            catch (JsonSyntaxException e) {
                log.error(String.format("Exception getAsJsonObject[%s] [%s]: %s", key, setupItem.getAsString(), e.getMessage()), (Throwable)e);
            }
        }
        return null;
    }

    public <T> Optional<T> getAsJsonObjectWherePropertyValue(String key, Class<T> objectType, String whereProperty, String value) {
        for (SetupItem setupItem : itemList) {
            if (!setupItem.isKeyStartsWith(key)) continue;
            try {
                Object t = Setup.getGson().fromJson(setupItem.getAsString(), objectType);
                Field field = objectType.getDeclaredField(whereProperty);
                field.setAccessible(true);
                Object propertyValue = field.get(t);
                if (propertyValue == null || !value.equals(propertyValue.toString())) continue;
                return Optional.ofNullable(t);
            }
            catch (JsonSyntaxException e) {
                log.error(String.format("Exception getAsJsonObjectList[%s] [%s]: %s", key, setupItem.getAsString(), e.getMessage()), (Throwable)e);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                log.error(String.format("Error accessing property [%s] of object: %s", whereProperty, e.getMessage()), (Throwable)e);
            }
        }
        return Optional.empty();
    }

    public <T> Optional<List<T>> getAsJsonObjectList(String key, Class<T> objectType) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (SetupItem setupItem : itemList) {
            if (!setupItem.isKeyStartsWith(key)) continue;
            try {
                result.add(Setup.getGson().fromJson(setupItem.getAsString(), objectType));
            }
            catch (JsonSyntaxException e) {
                log.error(String.format("Exception getAsJsonObjectList[%s] [%s]: %s", key, setupItem.getAsString(), e.getMessage()), (Throwable)e);
            }
        }
        return result.isEmpty() ? Optional.empty() : Optional.ofNullable(result);
    }

    public static Gson getGson() {
        return new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(java.util.Date.class, (src, typeOfSrc, context) -> src == null ? null : new JsonPrimitive((Number)src.getTime())).registerTypeAdapter(java.util.Date.class, (json, typeOfT, context) -> json == null ? null : new java.util.Date(json.getAsLong())).registerTypeAdapter(Date.class, (src, typeOfSrc, context) -> src == null ? null : new JsonPrimitive((Number)src.getTime())).registerTypeAdapter(Date.class, (json, typeOfT, context) -> json == null ? null : new java.util.Date(json.getAsLong())).serializeNulls().excludeFieldsWithoutExposeAnnotation().create();
    }
}

