/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import cz.airtoy.airshop.domains.PrinterProfileDomain;
import cz.airtoy.airshop.domains.printers.PrintRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitUtils {
    private static final Logger log = LoggerFactory.getLogger(RabbitUtils.class);

    public static void sendPrintRequest(PrintRequest printRequest, String printQueue, PrinterProfileDomain printerProfileDomain, String rabbitHost, Integer rabbitPort, String rabbitUsername, String rabbitPassword) {
        try {
            GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSS");
            Gson gson = gsonBuilder.create();
            String message = gson.toJson((Object)printRequest);
            ConnectionFactory factory = new ConnectionFactory();
            factory.setHost(rabbitHost);
            factory.setPort(rabbitPort.intValue());
            factory.setUsername(rabbitUsername);
            factory.setPassword(rabbitPassword);
            factory.setNetworkRecoveryInterval(10000);
            factory.setAutomaticRecoveryEnabled(true);
            Connection connection = factory.newConnection();
            Channel channel = connection.createChannel();
            channel.queueDeclare(printQueue, true, false, false, null);
            channel.basicPublish("", printQueue, null, message.getBytes(printerProfileDomain.getMsgCharsetEncode()));
            channel.close();
            connection.close();
        }
        catch (Exception e) {
            log.error("Cannot send message to RabbitMQ: " + printRequest + " / " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RabbitUtils)) {
            return false;
        }
        RabbitUtils other = (RabbitUtils)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof RabbitUtils;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public String toString() {
        return "RabbitUtils()";
    }
}

