/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.domains.codecs.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import cz.airtoy.airshop.domains.data.ManufacturerDomain;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManufacturerDomainCodec
implements MessageCodec<ManufacturerDomain, ManufacturerDomain> {
    private static final Logger log = LoggerFactory.getLogger(ManufacturerDomainCodec.class);

    public void encodeToWire(Buffer buffer, ManufacturerDomain manufacturerDomain) {
        GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
        Gson gson = gsonBuilder.create();
        String jsonToStr = gson.toJson((Object)manufacturerDomain);
        int length = jsonToStr.getBytes().length;
        buffer.appendInt(length);
        buffer.appendString(jsonToStr);
    }

    public ManufacturerDomain decodeFromWire(int position, Buffer buffer) {
        int _pos = position;
        int length = buffer.getInt(_pos);
        String jsonStr = buffer.getString(_pos += 4, _pos += length);
        GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
        Gson gson = gsonBuilder.create();
        return (ManufacturerDomain)gson.fromJson(jsonStr, ManufacturerDomain.class);
    }

    public ManufacturerDomain transform(ManufacturerDomain manufacturerDomain) {
        return manufacturerDomain;
    }

    public String name() {
        return this.getClass().getSimpleName();
    }

    public byte systemCodecID() {
        return -1;
    }
}

