/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.email;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.email.RecipientSystemMapper;
import cz.airtoy.airshop.domains.email.RecipientSystemDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface RecipientSystemDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.recipient_id,\n\t\tp.system_id,\n\t\tp.date_created\n FROM \n\t\temail.recipient_system p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.recipient_id::text ~* :mask \n\tOR \n\t\tp.system_id::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=RecipientSystemMapper.class)
    public List<RecipientSystemDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\temail.recipient_system p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.recipient_id::text ~* :mask \n\tOR \n\t\tp.system_id::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.recipient_id, p.system_id, p.date_created FROM email.recipient_system p  ")
    @RegisterRowMapper(value=RecipientSystemMapper.class)
    public List<RecipientSystemDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.recipient_id, p.system_id, p.date_created FROM email.recipient_system p  WHERE p.id = :id")
    @RegisterRowMapper(value=RecipientSystemMapper.class)
    public RecipientSystemDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.recipient_id, p.system_id, p.date_created FROM email.recipient_system p  WHERE p.id = :id")
    @RegisterRowMapper(value=RecipientSystemMapper.class)
    public List<RecipientSystemDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.recipient_system p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.recipient_id, p.system_id, p.date_created FROM email.recipient_system p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=RecipientSystemMapper.class)
    public List<RecipientSystemDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.recipient_id, p.system_id, p.date_created FROM email.recipient_system p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=RecipientSystemMapper.class)
    public RecipientSystemDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.recipient_id, p.system_id, p.date_created FROM email.recipient_system p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=RecipientSystemMapper.class)
    public List<RecipientSystemDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.recipient_system p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.recipient_id, p.system_id, p.date_created FROM email.recipient_system p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=RecipientSystemMapper.class)
    public List<RecipientSystemDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.recipient_id, p.system_id, p.date_created FROM email.recipient_system p  WHERE p.recipient_id = :recipientId")
    @RegisterRowMapper(value=RecipientSystemMapper.class)
    public RecipientSystemDomain findByRecipientId(@Bind(value="recipientId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.recipient_id, p.system_id, p.date_created FROM email.recipient_system p  WHERE p.recipient_id = :recipientId")
    @RegisterRowMapper(value=RecipientSystemMapper.class)
    public List<RecipientSystemDomain> findListByRecipientId(@Bind(value="recipientId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.recipient_system p  WHERE p.recipient_id = :recipientId")
    public long findListByRecipientIdCount(@Bind(value="recipientId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.recipient_id, p.system_id, p.date_created FROM email.recipient_system p  WHERE p.recipient_id = :recipientId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=RecipientSystemMapper.class)
    public List<RecipientSystemDomain> findListByRecipientId(@Bind(value="recipientId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.recipient_id, p.system_id, p.date_created FROM email.recipient_system p  WHERE p.system_id = :systemId")
    @RegisterRowMapper(value=RecipientSystemMapper.class)
    public RecipientSystemDomain findBySystemId(@Bind(value="systemId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.recipient_id, p.system_id, p.date_created FROM email.recipient_system p  WHERE p.system_id = :systemId")
    @RegisterRowMapper(value=RecipientSystemMapper.class)
    public List<RecipientSystemDomain> findListBySystemId(@Bind(value="systemId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.recipient_system p  WHERE p.system_id = :systemId")
    public long findListBySystemIdCount(@Bind(value="systemId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.recipient_id, p.system_id, p.date_created FROM email.recipient_system p  WHERE p.system_id = :systemId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=RecipientSystemMapper.class)
    public List<RecipientSystemDomain> findListBySystemId(@Bind(value="systemId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.recipient_id, p.system_id, p.date_created FROM email.recipient_system p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=RecipientSystemMapper.class)
    public RecipientSystemDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.recipient_id, p.system_id, p.date_created FROM email.recipient_system p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=RecipientSystemMapper.class)
    public List<RecipientSystemDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.recipient_system p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.recipient_id, p.system_id, p.date_created FROM email.recipient_system p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=RecipientSystemMapper.class)
    public List<RecipientSystemDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO email.recipient_system (id, uid, recipient_id, system_id, date_created) VALUES (:id, :uid, :recipientId, :systemId, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="recipientId") Long var3, @Bind(value="systemId") Long var4, @Bind(value="dateCreated") Date var5);

    @SqlUpdate(value="INSERT INTO email.recipient_system (recipient_id, system_id, date_created) VALUES (:e.recipientId, :e.systemId, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") RecipientSystemDomain var1);

    @SqlUpdate(value="UPDATE email.recipient_system SET id = :e.id, uid = :e.uid, recipient_id = :e.recipientId, system_id = :e.systemId, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") RecipientSystemDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE email.recipient_system SET id = :e.id, uid = :e.uid, recipient_id = :e.recipientId, system_id = :e.systemId, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") RecipientSystemDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE email.recipient_system SET id = :e.id, uid = :e.uid, recipient_id = :e.recipientId, system_id = :e.systemId, date_created = :e.dateCreated WHERE recipient_id = :byRecipientId")
    public int updateByRecipientId(@BindBean(value="e") RecipientSystemDomain var1, @Bind(value="byRecipientId") Long var2);

    @SqlUpdate(value="UPDATE email.recipient_system SET id = :e.id, uid = :e.uid, recipient_id = :e.recipientId, system_id = :e.systemId, date_created = :e.dateCreated WHERE system_id = :bySystemId")
    public int updateBySystemId(@BindBean(value="e") RecipientSystemDomain var1, @Bind(value="bySystemId") Long var2);

    @SqlUpdate(value="UPDATE email.recipient_system SET id = :e.id, uid = :e.uid, recipient_id = :e.recipientId, system_id = :e.systemId, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") RecipientSystemDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM email.recipient_system WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM email.recipient_system WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM email.recipient_system WHERE recipient_id = :recipientId")
    public int deleteByRecipientId(@Bind(value="recipientId") Long var1);

    @SqlUpdate(value="DELETE FROM email.recipient_system WHERE system_id = :systemId")
    public int deleteBySystemId(@Bind(value="systemId") Long var1);

    @SqlUpdate(value="DELETE FROM email.recipient_system WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

