/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.TransportationPackItemsMapper;
import cz.airtoy.airshop.domains.TransportationPackItemsDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface TransportationPackItemsDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.transportation_pack_id,\n\t\tp.order_id,\n\t\tp.status,\n\t\tp.date_created\n FROM \n\t\tabra.transportation_pack_items p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.transportation_pack_id::text ~* :mask \n\tOR \n\t\tp.order_id::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=TransportationPackItemsMapper.class)
    public List<TransportationPackItemsDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tabra.transportation_pack_items p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.transportation_pack_id::text ~* :mask \n\tOR \n\t\tp.order_id::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transportation_pack_id, p.order_id, p.status, p.date_created FROM abra.transportation_pack_items p  WHERE p.id = :id")
    @RegisterRowMapper(value=TransportationPackItemsMapper.class)
    public TransportationPackItemsDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transportation_pack_id, p.order_id, p.status, p.date_created FROM abra.transportation_pack_items p  WHERE p.id = :id")
    @RegisterRowMapper(value=TransportationPackItemsMapper.class)
    public List<TransportationPackItemsDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transportation_pack_items p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transportation_pack_id, p.order_id, p.status, p.date_created FROM abra.transportation_pack_items p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransportationPackItemsMapper.class)
    public List<TransportationPackItemsDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.transportation_pack_id, p.order_id, p.status, p.date_created FROM abra.transportation_pack_items p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=TransportationPackItemsMapper.class)
    public TransportationPackItemsDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transportation_pack_id, p.order_id, p.status, p.date_created FROM abra.transportation_pack_items p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=TransportationPackItemsMapper.class)
    public List<TransportationPackItemsDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transportation_pack_items p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transportation_pack_id, p.order_id, p.status, p.date_created FROM abra.transportation_pack_items p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransportationPackItemsMapper.class)
    public List<TransportationPackItemsDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.transportation_pack_id, p.order_id, p.status, p.date_created FROM abra.transportation_pack_items p  WHERE p.transportation_pack_id = :transportationPackId")
    @RegisterRowMapper(value=TransportationPackItemsMapper.class)
    public TransportationPackItemsDomain findByTransportationPackId(@Bind(value="transportationPackId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transportation_pack_id, p.order_id, p.status, p.date_created FROM abra.transportation_pack_items p  WHERE p.transportation_pack_id = :transportationPackId")
    @RegisterRowMapper(value=TransportationPackItemsMapper.class)
    public List<TransportationPackItemsDomain> findListByTransportationPackId(@Bind(value="transportationPackId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transportation_pack_items p  WHERE p.transportation_pack_id = :transportationPackId")
    public long findListByTransportationPackIdCount(@Bind(value="transportationPackId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transportation_pack_id, p.order_id, p.status, p.date_created FROM abra.transportation_pack_items p  WHERE p.transportation_pack_id = :transportationPackId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransportationPackItemsMapper.class)
    public List<TransportationPackItemsDomain> findListByTransportationPackId(@Bind(value="transportationPackId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.transportation_pack_id, p.order_id, p.status, p.date_created FROM abra.transportation_pack_items p  WHERE p.order_id = :orderId")
    @RegisterRowMapper(value=TransportationPackItemsMapper.class)
    public TransportationPackItemsDomain findByOrderId(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transportation_pack_id, p.order_id, p.status, p.date_created FROM abra.transportation_pack_items p  WHERE p.order_id = :orderId")
    @RegisterRowMapper(value=TransportationPackItemsMapper.class)
    public List<TransportationPackItemsDomain> findListByOrderId(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transportation_pack_items p  WHERE p.order_id = :orderId")
    public long findListByOrderIdCount(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transportation_pack_id, p.order_id, p.status, p.date_created FROM abra.transportation_pack_items p  WHERE p.order_id = :orderId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransportationPackItemsMapper.class)
    public List<TransportationPackItemsDomain> findListByOrderId(@Bind(value="orderId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.transportation_pack_id, p.order_id, p.status, p.date_created FROM abra.transportation_pack_items p  WHERE p.status = :status")
    @RegisterRowMapper(value=TransportationPackItemsMapper.class)
    public TransportationPackItemsDomain findByStatus(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transportation_pack_id, p.order_id, p.status, p.date_created FROM abra.transportation_pack_items p  WHERE p.status = :status")
    @RegisterRowMapper(value=TransportationPackItemsMapper.class)
    public List<TransportationPackItemsDomain> findListByStatus(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transportation_pack_items p  WHERE p.status = :status")
    public long findListByStatusCount(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transportation_pack_id, p.order_id, p.status, p.date_created FROM abra.transportation_pack_items p  WHERE p.status = :status ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransportationPackItemsMapper.class)
    public List<TransportationPackItemsDomain> findListByStatus(@Bind(value="status") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.transportation_pack_id, p.order_id, p.status, p.date_created FROM abra.transportation_pack_items p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=TransportationPackItemsMapper.class)
    public TransportationPackItemsDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transportation_pack_id, p.order_id, p.status, p.date_created FROM abra.transportation_pack_items p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=TransportationPackItemsMapper.class)
    public List<TransportationPackItemsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transportation_pack_items p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.transportation_pack_id, p.order_id, p.status, p.date_created FROM abra.transportation_pack_items p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransportationPackItemsMapper.class)
    public List<TransportationPackItemsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO abra.transportation_pack_items (id, uid, transportation_pack_id, order_id, status, date_created) VALUES (:id, :uid, :transportationPackId, :orderId, :status, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="transportationPackId") Long var3, @Bind(value="orderId") Long var4, @Bind(value="status") String var5, @Bind(value="dateCreated") Date var6);

    @SqlUpdate(value="INSERT INTO abra.transportation_pack_items (transportation_pack_id, order_id, status, date_created) VALUES (:e.transportationPackId, :e.orderId, :e.status, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") TransportationPackItemsDomain var1);

    @SqlUpdate(value="UPDATE abra.transportation_pack_items SET id = :e.id, uid = :e.uid, transportation_pack_id = :e.transportationPackId, order_id = :e.orderId, status = :e.status, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") TransportationPackItemsDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE abra.transportation_pack_items SET id = :e.id, uid = :e.uid, transportation_pack_id = :e.transportationPackId, order_id = :e.orderId, status = :e.status, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") TransportationPackItemsDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE abra.transportation_pack_items SET id = :e.id, uid = :e.uid, transportation_pack_id = :e.transportationPackId, order_id = :e.orderId, status = :e.status, date_created = :e.dateCreated WHERE transportation_pack_id = :byTransportationPackId")
    public int updateByTransportationPackId(@BindBean(value="e") TransportationPackItemsDomain var1, @Bind(value="byTransportationPackId") Long var2);

    @SqlUpdate(value="UPDATE abra.transportation_pack_items SET id = :e.id, uid = :e.uid, transportation_pack_id = :e.transportationPackId, order_id = :e.orderId, status = :e.status, date_created = :e.dateCreated WHERE order_id = :byOrderId")
    public int updateByOrderId(@BindBean(value="e") TransportationPackItemsDomain var1, @Bind(value="byOrderId") Long var2);

    @SqlUpdate(value="UPDATE abra.transportation_pack_items SET id = :e.id, uid = :e.uid, transportation_pack_id = :e.transportationPackId, order_id = :e.orderId, status = :e.status, date_created = :e.dateCreated WHERE status = :byStatus")
    public int updateByStatus(@BindBean(value="e") TransportationPackItemsDomain var1, @Bind(value="byStatus") String var2);

    @SqlUpdate(value="UPDATE abra.transportation_pack_items SET id = :e.id, uid = :e.uid, transportation_pack_id = :e.transportationPackId, order_id = :e.orderId, status = :e.status, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") TransportationPackItemsDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM abra.transportation_pack_items WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM abra.transportation_pack_items WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM abra.transportation_pack_items WHERE transportation_pack_id = :transportationPackId")
    public int deleteByTransportationPackId(@Bind(value="transportationPackId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.transportation_pack_items WHERE order_id = :orderId")
    public int deleteByOrderId(@Bind(value="orderId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.transportation_pack_items WHERE status = :status")
    public int deleteByStatus(@Bind(value="status") String var1);

    @SqlUpdate(value="DELETE FROM abra.transportation_pack_items WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

