/*
 * Decompiled with CFR 0.152.
 */
package vectron.domains.enums;

public enum VectronPaymentType {
    CASH("CASH"),
    CARD("CARD"),
    INVOICE_CARD("INVOICE_CARD"),
    INVOICE_CASH("INVOICE_CASH"),
    ORDER_CARD("ORDER_CARD"),
    ORDER_CASH("ORDER_CASH"),
    ESHOP_CARD("ESHOP_CARD"),
    ESHOP_CASH("ESHOP_CASH"),
    CONSUMPTION("CONSUMPTION");

    public final String label;

    private VectronPaymentType(String label) {
        this.label = label;
    }

    public static VectronPaymentType valueOfLabel(String label) {
        for (VectronPaymentType e : VectronPaymentType.values()) {
            if (!e.label.equals(label)) continue;
            return e;
        }
        return CASH;
    }

    public static VectronPaymentType parse(String type) {
        if (type != null) {
            switch (type) {
                case "KARTOU": {
                    return CARD;
                }
                case "FAKTURA HOTOVE": {
                    return INVOICE_CASH;
                }
                case "FAKTURA KARTOU": {
                    return INVOICE_CARD;
                }
                case "OBJEDNAVKA HOTOVE": {
                    return ORDER_CASH;
                }
                case "OBJEDNAVKA KARTOU": {
                    return ORDER_CARD;
                }
                case "ESHOP HOTOVE": {
                    return ESHOP_CASH;
                }
                case "ESHOP KARTOU": {
                    return ESHOP_CARD;
                }
                case "KONZUMACE": {
                    return CONSUMPTION;
                }
            }
            return CASH;
        }
        return CASH;
    }
}

