/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.utils.domains;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class KeycloakAuthResult
implements Serializable {
    private boolean authorized = false;
    private String username = null;
    private String email = null;
    private String givenName = null;
    private String familyName = null;
    private String aud = null;
    private String azp = null;
    private List<String> roles = new ArrayList<String>();

    public KeycloakAuthResult() {
        this.authorized = false;
    }

    public KeycloakAuthResult(JsonObject token) {
        if (token != null) {
            JsonArray clientResourceAccessRoles;
            JsonObject clientResourceAccess;
            this.username = token.getString("preferred_username", null);
            this.email = token.getString("email", null);
            this.givenName = token.getString("given_name", null);
            if (this.givenName == null) {
                this.givenName = token.getString("givenname", null);
            }
            this.familyName = token.getString("family_name", null);
            if (this.familyName == null) {
                this.familyName = token.getString("familyname", null);
            }
            this.aud = token.getString("aud", null);
            this.azp = token.getString("azp", null);
            this.aud = token.getString("aud", null);
            this.azp = token.getString("azp", null);
            JsonObject resourceAccess = token.getJsonObject("resource_access", null);
            if (resourceAccess != null && this.azp != null && (clientResourceAccess = resourceAccess.getJsonObject(this.azp)) != null && (clientResourceAccessRoles = clientResourceAccess.getJsonArray("roles")) != null) {
                for (Object role : clientResourceAccessRoles) {
                    this.roles.add((String)role);
                }
            }
            if (this.username != null) {
                this.authorized = true;
            }
        }
    }

    public String getRolesStr() {
        if (this.roles != null) {
            return String.join((CharSequence)",", this.roles);
        }
        return null;
    }

    public boolean hasRole(String r) {
        if (this.roles != null && r != null) {
            for (String role : this.roles) {
                if (role == null || !role.equalsIgnoreCase(r)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAuthorized() {
        return this.authorized;
    }

    public String getUsername() {
        return this.username;
    }

    public String getEmail() {
        return this.email;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getAud() {
        return this.aud;
    }

    public String getAzp() {
        return this.azp;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setAuthorized(boolean authorized) {
        this.authorized = authorized;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public void setAud(String aud) {
        this.aud = aud;
    }

    public void setAzp(String azp) {
        this.azp = azp;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeycloakAuthResult)) {
            return false;
        }
        KeycloakAuthResult other = (KeycloakAuthResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAuthorized() != other.isAuthorized()) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$givenName = this.getGivenName();
        String other$givenName = other.getGivenName();
        if (this$givenName == null ? other$givenName != null : !this$givenName.equals(other$givenName)) {
            return false;
        }
        String this$familyName = this.getFamilyName();
        String other$familyName = other.getFamilyName();
        if (this$familyName == null ? other$familyName != null : !this$familyName.equals(other$familyName)) {
            return false;
        }
        String this$aud = this.getAud();
        String other$aud = other.getAud();
        if (this$aud == null ? other$aud != null : !this$aud.equals(other$aud)) {
            return false;
        }
        String this$azp = this.getAzp();
        String other$azp = other.getAzp();
        if (this$azp == null ? other$azp != null : !this$azp.equals(other$azp)) {
            return false;
        }
        List<String> this$roles = this.getRoles();
        List<String> other$roles = other.getRoles();
        return !(this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KeycloakAuthResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAuthorized() ? 79 : 97);
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $givenName = this.getGivenName();
        result = result * 59 + ($givenName == null ? 43 : $givenName.hashCode());
        String $familyName = this.getFamilyName();
        result = result * 59 + ($familyName == null ? 43 : $familyName.hashCode());
        String $aud = this.getAud();
        result = result * 59 + ($aud == null ? 43 : $aud.hashCode());
        String $azp = this.getAzp();
        result = result * 59 + ($azp == null ? 43 : $azp.hashCode());
        List<String> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        return result;
    }

    public String toString() {
        return "KeycloakAuthResult(authorized=" + this.isAuthorized() + ", username=" + this.getUsername() + ", email=" + this.getEmail() + ", givenName=" + this.getGivenName() + ", familyName=" + this.getFamilyName() + ", aud=" + this.getAud() + ", azp=" + this.getAzp() + ", roles=" + this.getRoles() + ")";
    }
}

