/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.data;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.data.ManufacturerMapper;
import cz.airtoy.airshop.dao.mappers.data.full.ManufacturerFullMapper;
import cz.airtoy.airshop.domains.data.ManufacturerDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface ManufacturerDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.external_record_id,\n\t\tp.name,\n\t\tp.brand_id,\n\t\tp.variant,\n\t\tp.alternative_name,\n\t\tp.annotation,\n\t\tp.tag_exists,\n\t\tp.disabled,\n\t\tp.ord,\n\t\tp.description,\n\t\tp.meta_title,\n\t\tp.meta_description,\n\t\tp.meta_key_words,\n\t\tp.path,\n\t\tp.date_updated,\n\t\tp.note,\n\t\tp.date_created,\n\t\tfoo.cnt,\n\t\tfoo1.cnt_disabled0\n FROM \n\t\tdata.manufacturer p\n     LEFT OUTER JOIN (       SELECT         manufacturer_id,         count(*) as cnt       FROM         data.target_commodity       GROUP BY         manufacturer_id   ) foo ON (foo.manufacturer_id = p.id)      LEFT OUTER JOIN (       SELECT         tc.manufacturer_id,         count(*) as cnt_disabled0       FROM         data.target_commodity tc\t\t      JOIN data.target_commodity_target tct ON (tct.target_commodity_id = tc.id AND tct.disabled = 0) \n       GROUP BY         tc.manufacturer_id   ) foo1 ON (foo1.manufacturer_id = p.id) \t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.external_record_id::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.brand_id::text ~* :mask \n\tOR \n\t\tp.variant::text ~* :mask \n\tOR \n\t\tp.alternative_name::text ~* :mask \n\tOR \n\t\tp.annotation::text ~* :mask \n\tOR \n\t\tp.tag_exists::text ~* :mask \n\tOR \n\t\tp.disabled::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.meta_title::text ~* :mask \n\tOR \n\t\tp.meta_description::text ~* :mask \n\tOR \n\t\tp.meta_key_words::text ~* :mask \n\tOR \n\t\tp.path::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=ManufacturerFullMapper.class)
    public List<ManufacturerDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.external_record_id,\n\t\tp.name,\n\t\tp.brand_id,\n\t\tp.variant,\n\t\tp.alternative_name,\n\t\tp.annotation,\n\t\tp.tag_exists,\n\t\tp.disabled,\n\t\tp.ord,\n\t\tp.description,\n\t\tp.meta_title,\n\t\tp.meta_description,\n\t\tp.meta_key_words,\n\t\tp.path,\n\t\tp.date_updated,\n\t\tp.note,\n\t\tp.date_created,\n\t\tfoo.cnt,\n\t\tfoo1.cnt_disabled0\n FROM \n\t\tdata.manufacturer p\n     LEFT OUTER JOIN (       SELECT         ftc.manufacturer_id,         count(*) as cnt       FROM         data.target_commodity ftc\t\t      JOIN data.target_commodity_target ftct ON (ftct.target_commodity_id = ftc.id) \n       WHERE\t        (CASE WHEN :disabled = 'ALL' THEN TRUE ELSE ( ftct.disabled = (CASE WHEN :disabled = '1' THEN 1 ELSE 0 END) ) END) \n       AND \t        (CASE WHEN :onOrder = 'ALL' THEN TRUE ELSE ( ftc.on_order = (CASE WHEN :onOrder = '1' THEN 1 ELSE 0 END) ) END) \n       GROUP BY         ftc.manufacturer_id   ) foo ON (foo.manufacturer_id = p.id)      LEFT OUTER JOIN (       SELECT         tc.manufacturer_id,         count(*) as cnt_disabled0       FROM         data.target_commodity tc\t\t      JOIN data.target_commodity_target tct ON (tct.target_commodity_id = tc.id AND tct.disabled = 0) \n       GROUP BY         tc.manufacturer_id   ) foo1 ON (foo1.manufacturer_id = p.id) \t\n\tWHERE \n\t  (CASE WHEN :targetId = '-1' THEN TRUE ELSE ( p.id IN ( SELECT tc.manufacturer_id FROM data.target_commodity tc WHERE tc.id IN (SELECT tct.target_commodity_id FROM data.target_commodity_target tct where tct.target_id = :targetId) ) ) END) \n AND  \t  (CASE WHEN :categoryId = '-1' THEN TRUE ELSE ( p.id IN ( SELECT tc.manufacturer_id FROM data.target_commodity tc WHERE tc.id IN (SELECT tcc.target_commodity_id FROM data.target_commodity_category tcc where tcc.target_category_id = :categoryId) ) ) END) \n AND \t  p.id IN (       SELECT         tc.manufacturer_id       FROM         data.target_commodity tc\t\t      JOIN data.target_commodity_target tct ON (tct.target_commodity_id = tc.id) \n       WHERE\t        (CASE WHEN :disabled = 'ALL' THEN TRUE ELSE ( tct.disabled = (CASE WHEN :disabled = '1' THEN 1 ELSE 0 END) ) END) \n       AND \t        (CASE WHEN :onOrder = 'ALL' THEN TRUE ELSE ( tc.on_order = (CASE WHEN :onOrder = '1' THEN 1 ELSE 0 END) ) END) \n       GROUP BY         tc.manufacturer_id     ) \n AND ( \t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.external_record_id::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.brand_id::text ~* :mask \n\tOR \n\t\tp.variant::text ~* :mask \n\tOR \n\t\tp.alternative_name::text ~* :mask \n\tOR \n\t\tp.annotation::text ~* :mask \n\tOR \n\t\tp.tag_exists::text ~* :mask \n\tOR \n\t\tp.disabled::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.meta_title::text ~* :mask \n\tOR \n\t\tp.meta_description::text ~* :mask \n\tOR \n\t\tp.meta_key_words::text ~* :mask \n\tOR \n\t\tp.path::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\t) \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=ManufacturerFullMapper.class)
    public List<ManufacturerDomain> findByMaskFilter(@Bind(value="targetId") Long var1, @Bind(value="categoryId") Long var2, @Bind(value="mask") String var3, @Bind(value="disabled") String var4, @Bind(value="onOrder") String var5, @Bind(value="offset") int var6, @Bind(value="limit") int var7, @Define(value="order") String var8, @Define(value="sort") String var9);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tdata.manufacturer p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.external_record_id::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.brand_id::text ~* :mask \n\tOR \n\t\tp.variant::text ~* :mask \n\tOR \n\t\tp.alternative_name::text ~* :mask \n\tOR \n\t\tp.annotation::text ~* :mask \n\tOR \n\t\tp.tag_exists::text ~* :mask \n\tOR \n\t\tp.disabled::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.meta_title::text ~* :mask \n\tOR \n\t\tp.meta_description::text ~* :mask \n\tOR \n\t\tp.meta_key_words::text ~* :mask \n\tOR \n\t\tp.path::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tdata.manufacturer p\n\t\n\tWHERE \n\t  (CASE WHEN :targetId = '-1' THEN TRUE ELSE ( p.id IN ( SELECT tc.manufacturer_id FROM data.target_commodity tc WHERE tc.id IN (SELECT tct.target_commodity_id FROM data.target_commodity_target tct where tct.target_id = :targetId) ) ) END) \n AND  \t  (CASE WHEN :categoryId = '-1' THEN TRUE ELSE ( p.id IN ( SELECT tc.manufacturer_id FROM data.target_commodity tc WHERE tc.id IN (SELECT tcc.target_commodity_id FROM data.target_commodity_category tcc where tcc.target_category_id = :categoryId) ) ) END) \n AND \t  p.id IN (       SELECT         tc.manufacturer_id       FROM         data.target_commodity tc\t\t      JOIN data.target_commodity_target tct ON (tct.target_commodity_id = tc.id) \n       WHERE\t        (CASE WHEN :disabled = 'ALL' THEN TRUE ELSE ( tct.disabled = (CASE WHEN :disabled = '1' THEN 1 ELSE 0 END) ) END) \n       AND \t        (CASE WHEN :onOrder = 'ALL' THEN TRUE ELSE ( tc.on_order = (CASE WHEN :onOrder = '1' THEN 1 ELSE 0 END) ) END) \n       GROUP BY         tc.manufacturer_id     ) \n AND ( \t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.external_record_id::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.brand_id::text ~* :mask \n\tOR \n\t\tp.variant::text ~* :mask \n\tOR \n\t\tp.alternative_name::text ~* :mask \n\tOR \n\t\tp.annotation::text ~* :mask \n\tOR \n\t\tp.tag_exists::text ~* :mask \n\tOR \n\t\tp.disabled::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.meta_title::text ~* :mask \n\tOR \n\t\tp.meta_description::text ~* :mask \n\tOR \n\t\tp.meta_key_words::text ~* :mask \n\tOR \n\t\tp.path::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n ) \n")
    public long findByMaskFilterCount(@Bind(value="targetId") Long var1, @Bind(value="categoryId") Long var2, @Bind(value="mask") String var3, @Bind(value="disabled") String var4, @Bind(value="onOrder") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  ")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.id = :id")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public ManufacturerDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.id = :id")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.manufacturer p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public ManufacturerDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.manufacturer p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.external_record_id = :externalRecordId")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public ManufacturerDomain findByExternalRecordId(@Bind(value="externalRecordId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.external_record_id = :externalRecordId")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByExternalRecordId(@Bind(value="externalRecordId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.manufacturer p  WHERE p.external_record_id = :externalRecordId")
    public long findListByExternalRecordIdCount(@Bind(value="externalRecordId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.external_record_id = :externalRecordId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByExternalRecordId(@Bind(value="externalRecordId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.name = :name")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public ManufacturerDomain findByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.name = :name")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.manufacturer p  WHERE p.name = :name")
    public long findListByNameCount(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.name = :name ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByName(@Bind(value="name") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.brand_id = :brandId")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public ManufacturerDomain findByBrandId(@Bind(value="brandId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.brand_id = :brandId")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByBrandId(@Bind(value="brandId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.manufacturer p  WHERE p.brand_id = :brandId")
    public long findListByBrandIdCount(@Bind(value="brandId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.brand_id = :brandId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByBrandId(@Bind(value="brandId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.variant = :variant")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public ManufacturerDomain findByVariant(@Bind(value="variant") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.variant = :variant")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByVariant(@Bind(value="variant") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.manufacturer p  WHERE p.variant = :variant")
    public long findListByVariantCount(@Bind(value="variant") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.variant = :variant ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByVariant(@Bind(value="variant") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.alternative_name = :alternativeName")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public ManufacturerDomain findByAlternativeName(@Bind(value="alternativeName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.alternative_name = :alternativeName")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByAlternativeName(@Bind(value="alternativeName") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.manufacturer p  WHERE p.alternative_name = :alternativeName")
    public long findListByAlternativeNameCount(@Bind(value="alternativeName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.alternative_name = :alternativeName ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByAlternativeName(@Bind(value="alternativeName") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.annotation = :annotation")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public ManufacturerDomain findByAnnotation(@Bind(value="annotation") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.annotation = :annotation")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByAnnotation(@Bind(value="annotation") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.manufacturer p  WHERE p.annotation = :annotation")
    public long findListByAnnotationCount(@Bind(value="annotation") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.annotation = :annotation ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByAnnotation(@Bind(value="annotation") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.tag_exists = :tagExists")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public ManufacturerDomain findByTagExists(@Bind(value="tagExists") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.tag_exists = :tagExists")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByTagExists(@Bind(value="tagExists") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.manufacturer p  WHERE p.tag_exists = :tagExists")
    public long findListByTagExistsCount(@Bind(value="tagExists") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.tag_exists = :tagExists ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByTagExists(@Bind(value="tagExists") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.disabled = :disabled")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public ManufacturerDomain findByDisabled(@Bind(value="disabled") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.disabled = :disabled")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByDisabled(@Bind(value="disabled") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.manufacturer p  WHERE p.disabled = :disabled")
    public long findListByDisabledCount(@Bind(value="disabled") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.disabled = :disabled ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByDisabled(@Bind(value="disabled") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.ord = :ord")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public ManufacturerDomain findByOrd(@Bind(value="ord") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.ord = :ord")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByOrd(@Bind(value="ord") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.manufacturer p  WHERE p.ord = :ord")
    public long findListByOrdCount(@Bind(value="ord") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.ord = :ord ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByOrd(@Bind(value="ord") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.description = :description")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public ManufacturerDomain findByDescription(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.description = :description")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByDescription(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.manufacturer p  WHERE p.description = :description")
    public long findListByDescriptionCount(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.description = :description ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByDescription(@Bind(value="description") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.meta_title = :metaTitle")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public ManufacturerDomain findByMetaTitle(@Bind(value="metaTitle") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.meta_title = :metaTitle")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByMetaTitle(@Bind(value="metaTitle") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.manufacturer p  WHERE p.meta_title = :metaTitle")
    public long findListByMetaTitleCount(@Bind(value="metaTitle") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.meta_title = :metaTitle ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByMetaTitle(@Bind(value="metaTitle") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.meta_description = :metaDescription")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public ManufacturerDomain findByMetaDescription(@Bind(value="metaDescription") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.meta_description = :metaDescription")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByMetaDescription(@Bind(value="metaDescription") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.manufacturer p  WHERE p.meta_description = :metaDescription")
    public long findListByMetaDescriptionCount(@Bind(value="metaDescription") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.meta_description = :metaDescription ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByMetaDescription(@Bind(value="metaDescription") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.meta_key_words = :metaKeyWords")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public ManufacturerDomain findByMetaKeyWords(@Bind(value="metaKeyWords") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.meta_key_words = :metaKeyWords")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByMetaKeyWords(@Bind(value="metaKeyWords") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.manufacturer p  WHERE p.meta_key_words = :metaKeyWords")
    public long findListByMetaKeyWordsCount(@Bind(value="metaKeyWords") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.meta_key_words = :metaKeyWords ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByMetaKeyWords(@Bind(value="metaKeyWords") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.path = :path")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public ManufacturerDomain findByPath(@Bind(value="path") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.path = :path")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByPath(@Bind(value="path") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.manufacturer p  WHERE p.path = :path")
    public long findListByPathCount(@Bind(value="path") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.path = :path ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByPath(@Bind(value="path") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public ManufacturerDomain findByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.manufacturer p  WHERE p.date_updated = :dateUpdated")
    public long findListByDateUpdatedCount(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.date_updated = :dateUpdated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.note = :note")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public ManufacturerDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.note = :note")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.manufacturer p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public ManufacturerDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.manufacturer p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.external_record_id, p.name, p.brand_id, p.variant, p.alternative_name, p.annotation, p.tag_exists, p.disabled, p.ord, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.date_updated, p.note, p.date_created FROM data.manufacturer p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ManufacturerMapper.class)
    public List<ManufacturerDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO data.manufacturer (id, uid, external_record_id, name, brand_id, variant, alternative_name, annotation, tag_exists, disabled, ord, description, meta_title, meta_description, meta_key_words, path, date_updated, note, date_created) VALUES (:id, :uid, :externalRecordId, :name, :brandId, :variant, :alternativeName, :annotation, :tagExists, :disabled, :ord, :description, :metaTitle, :metaDescription, :metaKeyWords, :path, :dateUpdated, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="externalRecordId") String var3, @Bind(value="name") String var4, @Bind(value="brandId") String var5, @Bind(value="variant") String var6, @Bind(value="alternativeName") String var7, @Bind(value="annotation") String var8, @Bind(value="tagExists") String var9, @Bind(value="disabled") Integer var10, @Bind(value="ord") Integer var11, @Bind(value="description") String var12, @Bind(value="metaTitle") String var13, @Bind(value="metaDescription") String var14, @Bind(value="metaKeyWords") String var15, @Bind(value="path") String var16, @Bind(value="dateUpdated") Date var17, @Bind(value="note") String var18, @Bind(value="dateCreated") Date var19);

    @SqlUpdate(value="INSERT INTO data.manufacturer (external_record_id, name, brand_id, variant, alternative_name, annotation, tag_exists, disabled, ord, description, meta_title, meta_description, meta_key_words, path, date_updated, note, date_created) VALUES (:e.externalRecordId, :e.name, :e.brandId, :e.variant, :e.alternativeName, :e.annotation, :e.tagExists, :e.disabled, :e.ord, :e.description, :e.metaTitle, :e.metaDescription, :e.metaKeyWords, :e.path, :e.dateUpdated, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") ManufacturerDomain var1);

    @SqlUpdate(value="UPDATE data.manufacturer SET id = :e.id, uid = :e.uid, external_record_id = :e.externalRecordId, name = :e.name, brand_id = :e.brandId, variant = :e.variant, alternative_name = :e.alternativeName, annotation = :e.annotation, tag_exists = :e.tagExists, disabled = :e.disabled, ord = :e.ord, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") ManufacturerDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE data.manufacturer SET id = :e.id, uid = :e.uid, external_record_id = :e.externalRecordId, name = :e.name, brand_id = :e.brandId, variant = :e.variant, alternative_name = :e.alternativeName, annotation = :e.annotation, tag_exists = :e.tagExists, disabled = :e.disabled, ord = :e.ord, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") ManufacturerDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE data.manufacturer SET id = :e.id, uid = :e.uid, external_record_id = :e.externalRecordId, name = :e.name, brand_id = :e.brandId, variant = :e.variant, alternative_name = :e.alternativeName, annotation = :e.annotation, tag_exists = :e.tagExists, disabled = :e.disabled, ord = :e.ord, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE external_record_id = :byExternalRecordId")
    public int updateByExternalRecordId(@BindBean(value="e") ManufacturerDomain var1, @Bind(value="byExternalRecordId") String var2);

    @SqlUpdate(value="UPDATE data.manufacturer SET id = :e.id, uid = :e.uid, external_record_id = :e.externalRecordId, name = :e.name, brand_id = :e.brandId, variant = :e.variant, alternative_name = :e.alternativeName, annotation = :e.annotation, tag_exists = :e.tagExists, disabled = :e.disabled, ord = :e.ord, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE name = :byName")
    public int updateByName(@BindBean(value="e") ManufacturerDomain var1, @Bind(value="byName") String var2);

    @SqlUpdate(value="UPDATE data.manufacturer SET id = :e.id, uid = :e.uid, external_record_id = :e.externalRecordId, name = :e.name, brand_id = :e.brandId, variant = :e.variant, alternative_name = :e.alternativeName, annotation = :e.annotation, tag_exists = :e.tagExists, disabled = :e.disabled, ord = :e.ord, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE brand_id = :byBrandId")
    public int updateByBrandId(@BindBean(value="e") ManufacturerDomain var1, @Bind(value="byBrandId") String var2);

    @SqlUpdate(value="UPDATE data.manufacturer SET id = :e.id, uid = :e.uid, external_record_id = :e.externalRecordId, name = :e.name, brand_id = :e.brandId, variant = :e.variant, alternative_name = :e.alternativeName, annotation = :e.annotation, tag_exists = :e.tagExists, disabled = :e.disabled, ord = :e.ord, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE variant = :byVariant")
    public int updateByVariant(@BindBean(value="e") ManufacturerDomain var1, @Bind(value="byVariant") String var2);

    @SqlUpdate(value="UPDATE data.manufacturer SET id = :e.id, uid = :e.uid, external_record_id = :e.externalRecordId, name = :e.name, brand_id = :e.brandId, variant = :e.variant, alternative_name = :e.alternativeName, annotation = :e.annotation, tag_exists = :e.tagExists, disabled = :e.disabled, ord = :e.ord, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE alternative_name = :byAlternativeName")
    public int updateByAlternativeName(@BindBean(value="e") ManufacturerDomain var1, @Bind(value="byAlternativeName") String var2);

    @SqlUpdate(value="UPDATE data.manufacturer SET id = :e.id, uid = :e.uid, external_record_id = :e.externalRecordId, name = :e.name, brand_id = :e.brandId, variant = :e.variant, alternative_name = :e.alternativeName, annotation = :e.annotation, tag_exists = :e.tagExists, disabled = :e.disabled, ord = :e.ord, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE annotation = :byAnnotation")
    public int updateByAnnotation(@BindBean(value="e") ManufacturerDomain var1, @Bind(value="byAnnotation") String var2);

    @SqlUpdate(value="UPDATE data.manufacturer SET id = :e.id, uid = :e.uid, external_record_id = :e.externalRecordId, name = :e.name, brand_id = :e.brandId, variant = :e.variant, alternative_name = :e.alternativeName, annotation = :e.annotation, tag_exists = :e.tagExists, disabled = :e.disabled, ord = :e.ord, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE tag_exists = :byTagExists")
    public int updateByTagExists(@BindBean(value="e") ManufacturerDomain var1, @Bind(value="byTagExists") String var2);

    @SqlUpdate(value="UPDATE data.manufacturer SET id = :e.id, uid = :e.uid, external_record_id = :e.externalRecordId, name = :e.name, brand_id = :e.brandId, variant = :e.variant, alternative_name = :e.alternativeName, annotation = :e.annotation, tag_exists = :e.tagExists, disabled = :e.disabled, ord = :e.ord, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE disabled = :byDisabled")
    public int updateByDisabled(@BindBean(value="e") ManufacturerDomain var1, @Bind(value="byDisabled") Integer var2);

    @SqlUpdate(value="UPDATE data.manufacturer SET id = :e.id, uid = :e.uid, external_record_id = :e.externalRecordId, name = :e.name, brand_id = :e.brandId, variant = :e.variant, alternative_name = :e.alternativeName, annotation = :e.annotation, tag_exists = :e.tagExists, disabled = :e.disabled, ord = :e.ord, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE ord = :byOrd")
    public int updateByOrd(@BindBean(value="e") ManufacturerDomain var1, @Bind(value="byOrd") Integer var2);

    @SqlUpdate(value="UPDATE data.manufacturer SET id = :e.id, uid = :e.uid, external_record_id = :e.externalRecordId, name = :e.name, brand_id = :e.brandId, variant = :e.variant, alternative_name = :e.alternativeName, annotation = :e.annotation, tag_exists = :e.tagExists, disabled = :e.disabled, ord = :e.ord, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE description = :byDescription")
    public int updateByDescription(@BindBean(value="e") ManufacturerDomain var1, @Bind(value="byDescription") String var2);

    @SqlUpdate(value="UPDATE data.manufacturer SET id = :e.id, uid = :e.uid, external_record_id = :e.externalRecordId, name = :e.name, brand_id = :e.brandId, variant = :e.variant, alternative_name = :e.alternativeName, annotation = :e.annotation, tag_exists = :e.tagExists, disabled = :e.disabled, ord = :e.ord, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE meta_title = :byMetaTitle")
    public int updateByMetaTitle(@BindBean(value="e") ManufacturerDomain var1, @Bind(value="byMetaTitle") String var2);

    @SqlUpdate(value="UPDATE data.manufacturer SET id = :e.id, uid = :e.uid, external_record_id = :e.externalRecordId, name = :e.name, brand_id = :e.brandId, variant = :e.variant, alternative_name = :e.alternativeName, annotation = :e.annotation, tag_exists = :e.tagExists, disabled = :e.disabled, ord = :e.ord, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE meta_description = :byMetaDescription")
    public int updateByMetaDescription(@BindBean(value="e") ManufacturerDomain var1, @Bind(value="byMetaDescription") String var2);

    @SqlUpdate(value="UPDATE data.manufacturer SET id = :e.id, uid = :e.uid, external_record_id = :e.externalRecordId, name = :e.name, brand_id = :e.brandId, variant = :e.variant, alternative_name = :e.alternativeName, annotation = :e.annotation, tag_exists = :e.tagExists, disabled = :e.disabled, ord = :e.ord, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE meta_key_words = :byMetaKeyWords")
    public int updateByMetaKeyWords(@BindBean(value="e") ManufacturerDomain var1, @Bind(value="byMetaKeyWords") String var2);

    @SqlUpdate(value="UPDATE data.manufacturer SET id = :e.id, uid = :e.uid, external_record_id = :e.externalRecordId, name = :e.name, brand_id = :e.brandId, variant = :e.variant, alternative_name = :e.alternativeName, annotation = :e.annotation, tag_exists = :e.tagExists, disabled = :e.disabled, ord = :e.ord, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE path = :byPath")
    public int updateByPath(@BindBean(value="e") ManufacturerDomain var1, @Bind(value="byPath") String var2);

    @SqlUpdate(value="UPDATE data.manufacturer SET id = :e.id, uid = :e.uid, external_record_id = :e.externalRecordId, name = :e.name, brand_id = :e.brandId, variant = :e.variant, alternative_name = :e.alternativeName, annotation = :e.annotation, tag_exists = :e.tagExists, disabled = :e.disabled, ord = :e.ord, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_updated = :byDateUpdated")
    public int updateByDateUpdated(@BindBean(value="e") ManufacturerDomain var1, @Bind(value="byDateUpdated") Date var2);

    @SqlUpdate(value="UPDATE data.manufacturer SET id = :e.id, uid = :e.uid, external_record_id = :e.externalRecordId, name = :e.name, brand_id = :e.brandId, variant = :e.variant, alternative_name = :e.alternativeName, annotation = :e.annotation, tag_exists = :e.tagExists, disabled = :e.disabled, ord = :e.ord, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") ManufacturerDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE data.manufacturer SET id = :e.id, uid = :e.uid, external_record_id = :e.externalRecordId, name = :e.name, brand_id = :e.brandId, variant = :e.variant, alternative_name = :e.alternativeName, annotation = :e.annotation, tag_exists = :e.tagExists, disabled = :e.disabled, ord = :e.ord, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") ManufacturerDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM data.manufacturer WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM data.manufacturer WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM data.manufacturer WHERE external_record_id = :externalRecordId")
    public int deleteByExternalRecordId(@Bind(value="externalRecordId") String var1);

    @SqlUpdate(value="DELETE FROM data.manufacturer WHERE name = :name")
    public int deleteByName(@Bind(value="name") String var1);

    @SqlUpdate(value="DELETE FROM data.manufacturer WHERE brand_id = :brandId")
    public int deleteByBrandId(@Bind(value="brandId") String var1);

    @SqlUpdate(value="DELETE FROM data.manufacturer WHERE variant = :variant")
    public int deleteByVariant(@Bind(value="variant") String var1);

    @SqlUpdate(value="DELETE FROM data.manufacturer WHERE alternative_name = :alternativeName")
    public int deleteByAlternativeName(@Bind(value="alternativeName") String var1);

    @SqlUpdate(value="DELETE FROM data.manufacturer WHERE annotation = :annotation")
    public int deleteByAnnotation(@Bind(value="annotation") String var1);

    @SqlUpdate(value="DELETE FROM data.manufacturer WHERE tag_exists = :tagExists")
    public int deleteByTagExists(@Bind(value="tagExists") String var1);

    @SqlUpdate(value="DELETE FROM data.manufacturer WHERE disabled = :disabled")
    public int deleteByDisabled(@Bind(value="disabled") Integer var1);

    @SqlUpdate(value="DELETE FROM data.manufacturer WHERE ord = :ord")
    public int deleteByOrd(@Bind(value="ord") Integer var1);

    @SqlUpdate(value="DELETE FROM data.manufacturer WHERE description = :description")
    public int deleteByDescription(@Bind(value="description") String var1);

    @SqlUpdate(value="DELETE FROM data.manufacturer WHERE meta_title = :metaTitle")
    public int deleteByMetaTitle(@Bind(value="metaTitle") String var1);

    @SqlUpdate(value="DELETE FROM data.manufacturer WHERE meta_description = :metaDescription")
    public int deleteByMetaDescription(@Bind(value="metaDescription") String var1);

    @SqlUpdate(value="DELETE FROM data.manufacturer WHERE meta_key_words = :metaKeyWords")
    public int deleteByMetaKeyWords(@Bind(value="metaKeyWords") String var1);

    @SqlUpdate(value="DELETE FROM data.manufacturer WHERE path = :path")
    public int deleteByPath(@Bind(value="path") String var1);

    @SqlUpdate(value="DELETE FROM data.manufacturer WHERE date_updated = :dateUpdated")
    public int deleteByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlUpdate(value="DELETE FROM data.manufacturer WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM data.manufacturer WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

