/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.data;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.data.CategoryVariantMapper;
import cz.airtoy.airshop.domains.data.CategoryVariantDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface CategoryVariantDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.category_id,\n\t\tp.language_name,\n\t\tp.name,\n\t\tp.alternative_name,\n\t\tp.description,\n\t\tp.alternative_description,\n\t\tp.rank,\n\t\tp.meta_title,\n\t\tp.meta_description,\n\t\tp.meta_key_words,\n\t\tp.date_updated,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tdata.category_variant p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.category_id::text ~* :mask \n\tOR \n\t\tp.language_name::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.alternative_name::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.alternative_description::text ~* :mask \n\tOR \n\t\tp.rank::text ~* :mask \n\tOR \n\t\tp.meta_title::text ~* :mask \n\tOR \n\t\tp.meta_description::text ~* :mask \n\tOR \n\t\tp.meta_key_words::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tdata.category_variant p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.category_id::text ~* :mask \n\tOR \n\t\tp.language_name::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.alternative_name::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.alternative_description::text ~* :mask \n\tOR \n\t\tp.rank::text ~* :mask \n\tOR \n\t\tp.meta_title::text ~* :mask \n\tOR \n\t\tp.meta_description::text ~* :mask \n\tOR \n\t\tp.meta_key_words::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.category_id = :categoryId AND p.language_name = :languageName")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public CategoryVariantDomain findByCategoryIdLanguageName(@Bind(value="categoryId") Long var1, @Bind(value="languageName") String var2);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  ")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.id = :id")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public CategoryVariantDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.id = :id")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.category_variant p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public CategoryVariantDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.category_variant p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.category_id = :categoryId")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public CategoryVariantDomain findByCategoryId(@Bind(value="categoryId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.category_id = :categoryId")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findListByCategoryId(@Bind(value="categoryId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.category_variant p  WHERE p.category_id = :categoryId")
    public long findListByCategoryIdCount(@Bind(value="categoryId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.category_id = :categoryId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findListByCategoryId(@Bind(value="categoryId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.language_name = :languageName")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public CategoryVariantDomain findByLanguageName(@Bind(value="languageName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.language_name = :languageName")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findListByLanguageName(@Bind(value="languageName") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.category_variant p  WHERE p.language_name = :languageName")
    public long findListByLanguageNameCount(@Bind(value="languageName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.language_name = :languageName ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findListByLanguageName(@Bind(value="languageName") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.name = :name")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public CategoryVariantDomain findByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.name = :name")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findListByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.category_variant p  WHERE p.name = :name")
    public long findListByNameCount(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.name = :name ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findListByName(@Bind(value="name") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.alternative_name = :alternativeName")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public CategoryVariantDomain findByAlternativeName(@Bind(value="alternativeName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.alternative_name = :alternativeName")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findListByAlternativeName(@Bind(value="alternativeName") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.category_variant p  WHERE p.alternative_name = :alternativeName")
    public long findListByAlternativeNameCount(@Bind(value="alternativeName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.alternative_name = :alternativeName ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findListByAlternativeName(@Bind(value="alternativeName") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.description = :description")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public CategoryVariantDomain findByDescription(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.description = :description")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findListByDescription(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.category_variant p  WHERE p.description = :description")
    public long findListByDescriptionCount(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.description = :description ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findListByDescription(@Bind(value="description") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.alternative_description = :alternativeDescription")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public CategoryVariantDomain findByAlternativeDescription(@Bind(value="alternativeDescription") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.alternative_description = :alternativeDescription")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findListByAlternativeDescription(@Bind(value="alternativeDescription") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.category_variant p  WHERE p.alternative_description = :alternativeDescription")
    public long findListByAlternativeDescriptionCount(@Bind(value="alternativeDescription") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.alternative_description = :alternativeDescription ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findListByAlternativeDescription(@Bind(value="alternativeDescription") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.rank = :rank")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public CategoryVariantDomain findByRank(@Bind(value="rank") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.rank = :rank")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findListByRank(@Bind(value="rank") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.category_variant p  WHERE p.rank = :rank")
    public long findListByRankCount(@Bind(value="rank") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.rank = :rank ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findListByRank(@Bind(value="rank") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.meta_title = :metaTitle")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public CategoryVariantDomain findByMetaTitle(@Bind(value="metaTitle") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.meta_title = :metaTitle")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findListByMetaTitle(@Bind(value="metaTitle") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.category_variant p  WHERE p.meta_title = :metaTitle")
    public long findListByMetaTitleCount(@Bind(value="metaTitle") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.meta_title = :metaTitle ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findListByMetaTitle(@Bind(value="metaTitle") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.meta_description = :metaDescription")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public CategoryVariantDomain findByMetaDescription(@Bind(value="metaDescription") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.meta_description = :metaDescription")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findListByMetaDescription(@Bind(value="metaDescription") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.category_variant p  WHERE p.meta_description = :metaDescription")
    public long findListByMetaDescriptionCount(@Bind(value="metaDescription") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.meta_description = :metaDescription ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findListByMetaDescription(@Bind(value="metaDescription") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.meta_key_words = :metaKeyWords")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public CategoryVariantDomain findByMetaKeyWords(@Bind(value="metaKeyWords") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.meta_key_words = :metaKeyWords")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findListByMetaKeyWords(@Bind(value="metaKeyWords") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.category_variant p  WHERE p.meta_key_words = :metaKeyWords")
    public long findListByMetaKeyWordsCount(@Bind(value="metaKeyWords") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.meta_key_words = :metaKeyWords ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findListByMetaKeyWords(@Bind(value="metaKeyWords") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public CategoryVariantDomain findByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.category_variant p  WHERE p.date_updated = :dateUpdated")
    public long findListByDateUpdatedCount(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.date_updated = :dateUpdated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.note = :note")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public CategoryVariantDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.note = :note")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.category_variant p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public CategoryVariantDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.category_variant p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.category_id, p.language_name, p.name, p.alternative_name, p.description, p.alternative_description, p.rank, p.meta_title, p.meta_description, p.meta_key_words, p.date_updated, p.note, p.date_created FROM data.category_variant p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CategoryVariantMapper.class)
    public List<CategoryVariantDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO data.category_variant (id, uid, category_id, language_name, name, alternative_name, description, alternative_description, rank, meta_title, meta_description, meta_key_words, date_updated, note, date_created) VALUES (:id, :uid, :categoryId, :languageName, :name, :alternativeName, :description, :alternativeDescription, :rank, :metaTitle, :metaDescription, :metaKeyWords, :dateUpdated, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="categoryId") Long var3, @Bind(value="languageName") String var4, @Bind(value="name") String var5, @Bind(value="alternativeName") String var6, @Bind(value="description") String var7, @Bind(value="alternativeDescription") String var8, @Bind(value="rank") Integer var9, @Bind(value="metaTitle") String var10, @Bind(value="metaDescription") String var11, @Bind(value="metaKeyWords") String var12, @Bind(value="dateUpdated") Date var13, @Bind(value="note") String var14, @Bind(value="dateCreated") Date var15);

    @SqlUpdate(value="INSERT INTO data.category_variant (category_id, language_name, name, alternative_name, description, alternative_description, rank, meta_title, meta_description, meta_key_words, date_updated, note, date_created) VALUES (:e.categoryId, :e.languageName, :e.name, :e.alternativeName, :e.description, :e.alternativeDescription, :e.rank, :e.metaTitle, :e.metaDescription, :e.metaKeyWords, :e.dateUpdated, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") CategoryVariantDomain var1);

    @SqlUpdate(value="UPDATE data.category_variant SET id = :e.id, uid = :e.uid, category_id = :e.categoryId, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, description = :e.description, alternative_description = :e.alternativeDescription, rank = :e.rank, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") CategoryVariantDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE data.category_variant SET id = :e.id, uid = :e.uid, category_id = :e.categoryId, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, description = :e.description, alternative_description = :e.alternativeDescription, rank = :e.rank, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") CategoryVariantDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE data.category_variant SET id = :e.id, uid = :e.uid, category_id = :e.categoryId, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, description = :e.description, alternative_description = :e.alternativeDescription, rank = :e.rank, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE category_id = :byCategoryId")
    public int updateByCategoryId(@BindBean(value="e") CategoryVariantDomain var1, @Bind(value="byCategoryId") Long var2);

    @SqlUpdate(value="UPDATE data.category_variant SET id = :e.id, uid = :e.uid, category_id = :e.categoryId, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, description = :e.description, alternative_description = :e.alternativeDescription, rank = :e.rank, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE language_name = :byLanguageName")
    public int updateByLanguageName(@BindBean(value="e") CategoryVariantDomain var1, @Bind(value="byLanguageName") String var2);

    @SqlUpdate(value="UPDATE data.category_variant SET id = :e.id, uid = :e.uid, category_id = :e.categoryId, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, description = :e.description, alternative_description = :e.alternativeDescription, rank = :e.rank, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE name = :byName")
    public int updateByName(@BindBean(value="e") CategoryVariantDomain var1, @Bind(value="byName") String var2);

    @SqlUpdate(value="UPDATE data.category_variant SET id = :e.id, uid = :e.uid, category_id = :e.categoryId, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, description = :e.description, alternative_description = :e.alternativeDescription, rank = :e.rank, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE alternative_name = :byAlternativeName")
    public int updateByAlternativeName(@BindBean(value="e") CategoryVariantDomain var1, @Bind(value="byAlternativeName") String var2);

    @SqlUpdate(value="UPDATE data.category_variant SET id = :e.id, uid = :e.uid, category_id = :e.categoryId, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, description = :e.description, alternative_description = :e.alternativeDescription, rank = :e.rank, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE description = :byDescription")
    public int updateByDescription(@BindBean(value="e") CategoryVariantDomain var1, @Bind(value="byDescription") String var2);

    @SqlUpdate(value="UPDATE data.category_variant SET id = :e.id, uid = :e.uid, category_id = :e.categoryId, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, description = :e.description, alternative_description = :e.alternativeDescription, rank = :e.rank, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE alternative_description = :byAlternativeDescription")
    public int updateByAlternativeDescription(@BindBean(value="e") CategoryVariantDomain var1, @Bind(value="byAlternativeDescription") String var2);

    @SqlUpdate(value="UPDATE data.category_variant SET id = :e.id, uid = :e.uid, category_id = :e.categoryId, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, description = :e.description, alternative_description = :e.alternativeDescription, rank = :e.rank, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE rank = :byRank")
    public int updateByRank(@BindBean(value="e") CategoryVariantDomain var1, @Bind(value="byRank") Integer var2);

    @SqlUpdate(value="UPDATE data.category_variant SET id = :e.id, uid = :e.uid, category_id = :e.categoryId, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, description = :e.description, alternative_description = :e.alternativeDescription, rank = :e.rank, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE meta_title = :byMetaTitle")
    public int updateByMetaTitle(@BindBean(value="e") CategoryVariantDomain var1, @Bind(value="byMetaTitle") String var2);

    @SqlUpdate(value="UPDATE data.category_variant SET id = :e.id, uid = :e.uid, category_id = :e.categoryId, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, description = :e.description, alternative_description = :e.alternativeDescription, rank = :e.rank, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE meta_description = :byMetaDescription")
    public int updateByMetaDescription(@BindBean(value="e") CategoryVariantDomain var1, @Bind(value="byMetaDescription") String var2);

    @SqlUpdate(value="UPDATE data.category_variant SET id = :e.id, uid = :e.uid, category_id = :e.categoryId, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, description = :e.description, alternative_description = :e.alternativeDescription, rank = :e.rank, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE meta_key_words = :byMetaKeyWords")
    public int updateByMetaKeyWords(@BindBean(value="e") CategoryVariantDomain var1, @Bind(value="byMetaKeyWords") String var2);

    @SqlUpdate(value="UPDATE data.category_variant SET id = :e.id, uid = :e.uid, category_id = :e.categoryId, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, description = :e.description, alternative_description = :e.alternativeDescription, rank = :e.rank, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_updated = :byDateUpdated")
    public int updateByDateUpdated(@BindBean(value="e") CategoryVariantDomain var1, @Bind(value="byDateUpdated") Date var2);

    @SqlUpdate(value="UPDATE data.category_variant SET id = :e.id, uid = :e.uid, category_id = :e.categoryId, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, description = :e.description, alternative_description = :e.alternativeDescription, rank = :e.rank, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") CategoryVariantDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE data.category_variant SET id = :e.id, uid = :e.uid, category_id = :e.categoryId, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, description = :e.description, alternative_description = :e.alternativeDescription, rank = :e.rank, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") CategoryVariantDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM data.category_variant WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM data.category_variant WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM data.category_variant WHERE category_id = :categoryId")
    public int deleteByCategoryId(@Bind(value="categoryId") Long var1);

    @SqlUpdate(value="DELETE FROM data.category_variant WHERE language_name = :languageName")
    public int deleteByLanguageName(@Bind(value="languageName") String var1);

    @SqlUpdate(value="DELETE FROM data.category_variant WHERE name = :name")
    public int deleteByName(@Bind(value="name") String var1);

    @SqlUpdate(value="DELETE FROM data.category_variant WHERE alternative_name = :alternativeName")
    public int deleteByAlternativeName(@Bind(value="alternativeName") String var1);

    @SqlUpdate(value="DELETE FROM data.category_variant WHERE description = :description")
    public int deleteByDescription(@Bind(value="description") String var1);

    @SqlUpdate(value="DELETE FROM data.category_variant WHERE alternative_description = :alternativeDescription")
    public int deleteByAlternativeDescription(@Bind(value="alternativeDescription") String var1);

    @SqlUpdate(value="DELETE FROM data.category_variant WHERE rank = :rank")
    public int deleteByRank(@Bind(value="rank") Integer var1);

    @SqlUpdate(value="DELETE FROM data.category_variant WHERE meta_title = :metaTitle")
    public int deleteByMetaTitle(@Bind(value="metaTitle") String var1);

    @SqlUpdate(value="DELETE FROM data.category_variant WHERE meta_description = :metaDescription")
    public int deleteByMetaDescription(@Bind(value="metaDescription") String var1);

    @SqlUpdate(value="DELETE FROM data.category_variant WHERE meta_key_words = :metaKeyWords")
    public int deleteByMetaKeyWords(@Bind(value="metaKeyWords") String var1);

    @SqlUpdate(value="DELETE FROM data.category_variant WHERE date_updated = :dateUpdated")
    public int deleteByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlUpdate(value="DELETE FROM data.category_variant WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM data.category_variant WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

