/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.app;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.app.StocktakingItemsExportMapper;
import cz.airtoy.airshop.dao.mappers.app.StocktakingItemsMapper;
import cz.airtoy.airshop.dao.mappers.full.StocktakingItemsFullMapper;
import cz.airtoy.airshop.domains.app.StocktakingItemsDomain;
import cz.airtoy.airshop.domains.app.StocktakingItemsExportDomain;
import cz.airtoy.airshop.domains.full.StocktakingItemsFullDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface StocktakingItemsDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT\n\tsc.plu,\n\tsc.ean,\n\tsc.name,\n\tSUM(si.quantity) as quantity\nFROM\n\tapp.stocktaking_items si\n\tLEFT OUTER JOIN abra.store_cards sc ON (sc.id = si.store_cards_id)\nWHERE\n\tsi.stocktaking_id = :stocktakingId\nGROUP BY\n\tsc.plu,\n\tsc.ean,\n\tsc.name\nORDER BY \n\tsc.name ASC \n")
    @RegisterRowMapper(value=StocktakingItemsExportMapper.class)
    public List<StocktakingItemsExportDomain> exportByStocktakingId(@Bind(value="stocktakingId") Long var1);

    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.stocktaking_id,\n\t\tp.partner_id,\n\t\tp.plu,\n\t\tp.ean,\n\t\tp.store_cards_id,\n\t\tp.date_started,\n\t\tp.date_finished,\n\t\tp.quantity,\n\t\tp.new_quantity,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tapp.stocktaking_items p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.stocktaking_id::text ~* :mask \n\tOR \n\t\tp.partner_id::text ~* :mask \n\tOR \n\t\tp.plu::text ~* :mask \n\tOR \n\t\tp.ean::text ~* :mask \n\tOR \n\t\tp.store_cards_id::text ~* :mask \n\tOR \n\t\tp.date_started::text ~* :mask \n\tOR \n\t\tp.date_finished::text ~* :mask \n\tOR \n\t\tp.quantity::text ~* :mask \n\tOR \n\t\tp.new_quantity::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public List<StocktakingItemsDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tapp.stocktaking_items p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.stocktaking_id::text ~* :mask \n\tOR \n\t\tp.partner_id::text ~* :mask \n\tOR \n\t\tp.plu::text ~* :mask \n\tOR \n\t\tp.ean::text ~* :mask \n\tOR \n\t\tp.store_cards_id::text ~* :mask \n\tOR \n\t\tp.date_started::text ~* :mask \n\tOR \n\t\tp.date_finished::text ~* :mask \n\tOR \n\t\tp.quantity::text ~* :mask \n\tOR \n\t\tp.new_quantity::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.stocktaking_id = :stocktakingId AND p.store_cards_id = :storeCardsId AND p.partner_id <> :partnerId AND date_started IS NOT NULL AND date_finished IS NULL")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public StocktakingItemsDomain findByStocktakingIdStoreCardsIdPartnerIdUnfinished(@Bind(value="stocktakingId") Long var1, @Bind(value="storeCardsId") Long var2, @Bind(value="partnerId") Long var3);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.stocktaking_id = :stocktakingId AND p.store_cards_id = :storeCardsId AND date_started IS NOT NULL AND date_finished IS NOT NULL ORDER BY p.id DESC LIMIT 1")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public StocktakingItemsDomain findByStocktakingIdStoreCardsIdLastFinished(@Bind(value="stocktakingId") Long var1, @Bind(value="storeCardsId") Long var2);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.id = :id")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public StocktakingItemsDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created,\t  abra_store_cards.id AS sc_id,\n\t\tabra_store_cards.uid AS sc_uid,\n\t\tabra_store_cards.abra_id AS sc_abra_id,\n\t\tabra_store_cards.manufacturer AS sc_manufacturer,\n\t\tabra_store_cards.date_authorized_at AS sc_date_authorized_at,\n\t\tabra_store_cards.authorizedby_id AS sc_authorizedby_id,\n\t\tabra_store_cards.bodycode AS sc_bodycode,\n\t\tabra_store_cards.category AS sc_category,\n\t\tabra_store_cards.classid AS sc_classid,\n\t\tabra_store_cards.code AS sc_code,\n\t\tabra_store_cards.comment AS sc_comment,\n\t\tabra_store_cards.date_correctedat AS sc_date_correctedat,\n\t\tabra_store_cards.correctedby_id AS sc_correctedby_id,\n\t\tabra_store_cards.country_id AS sc_country_id,\n\t\tabra_store_cards.date_createdat AS sc_date_createdat,\n\t\tabra_store_cards.createdby_id AS sc_createdby_id,\n\t\tabra_store_cards.customstariff AS sc_customstariff,\n\t\tabra_store_cards.customstariffnumber AS sc_customstariffnumber,\n\t\tabra_store_cards.date_dateofchange AS sc_date_dateofchange,\n\t\tabra_store_cards.dealerdiscount_id AS sc_dealerdiscount_id,\n\t\tabra_store_cards.discountsexcluded AS sc_discountsexcluded,\n\t\tabra_store_cards.displayname AS sc_displayname,\n\t\tabra_store_cards.ean AS sc_ean,\n\t\tabra_store_cards.expirationdue AS sc_expirationdue,\n\t\tabra_store_cards.foreignname AS sc_foreignname,\n\t\tabra_store_cards.guaranteelength AS sc_guaranteelength,\n\t\tabra_store_cards.guaranteelengthcorporate AS sc_guaranteelengthcorporate,\n\t\tabra_store_cards.guaranteeunitname AS sc_guaranteeunitname,\n\t\tabra_store_cards.guaranteeunitnamecorporate AS sc_guaranteeunitnamecorporate,\n\t\tabra_store_cards.hidden AS sc_hidden,\n\t\tabra_store_cards.incometype_id AS sc_incometype_id,\n\t\tabra_store_cards.intrastatcommodity_id AS sc_intrastatcommodity_id,\n\t\tabra_store_cards.intrastatcurrentprice AS sc_intrastatcurrentprice,\n\t\tabra_store_cards.intrastatcurrentpricelimit AS sc_intrastatcurrentpricelimit,\n\t\tabra_store_cards.intrastatextratype_id AS sc_intrastatextratype_id,\n\t\tabra_store_cards.intrastatinputstatistic_id AS sc_intrastatinputstatistic_id,\n\t\tabra_store_cards.intrastatoutputstatistic_id AS sc_intrastatoutputstatistic_id,\n\t\tabra_store_cards.intrastatregion_id AS sc_intrastatregion_id,\n\t\tabra_store_cards.intrastatunitcode AS sc_intrastatunitcode,\n\t\tabra_store_cards.intrastatunitrate AS sc_intrastatunitrate,\n\t\tabra_store_cards.intrastatunitrateref AS sc_intrastatunitrateref,\n\t\tabra_store_cards.intrastatweight AS sc_intrastatweight,\n\t\tabra_store_cards.intrastatweightunit AS sc_intrastatweightunit,\n\t\tabra_store_cards.isproduct AS sc_isproduct,\n\t\tabra_store_cards.isscalable AS sc_isscalable,\n\t\tabra_store_cards.mainsupplier_id AS sc_mainsupplier_id,\n\t\tabra_store_cards.mainunitcode AS sc_mainunitcode,\n\t\tabra_store_cards.mainunitrate AS sc_mainunitrate,\n\t\tabra_store_cards.mossservice_id AS sc_mossservice_id,\n\t\tabra_store_cards.name AS sc_name,\n\t\tabra_store_cards.nonstocktype AS sc_nonstocktype,\n\t\tabra_store_cards.note AS sc_note,\n\t\tabra_store_cards.objversion AS sc_objversion,\n\t\tabra_store_cards.outofstockbatchdelivery AS sc_outofstockbatchdelivery,\n\t\tabra_store_cards.outofstockdelivery AS sc_outofstockdelivery,\n\t\tabra_store_cards.picture_id AS sc_picture_id,\n\t\tabra_store_cards.plu AS sc_plu,\n\t\tabra_store_cards.prefixcode AS sc_prefixcode,\n\t\tabra_store_cards.producer_id AS sc_producer_id,\n\t\tabra_store_cards.quantitydiscount_id AS sc_quantitydiscount_id,\n\t\tabra_store_cards.serialnumberstructure AS sc_serialnumberstructure,\n\t\tabra_store_cards.shortname AS sc_shortname,\n\t\tabra_store_cards.specification AS sc_specification,\n\t\tabra_store_cards.specification2 AS sc_specification2,\n\t\tabra_store_cards.spendingtaxtariff AS sc_spendingtaxtariff,\n\t\tabra_store_cards.storeassortmentgroup_id AS sc_storeassortmentgroup_id,\n\t\tabra_store_cards.storebatchstructure_id AS sc_storebatchstructure_id,\n\t\tabra_store_cards.storecardcategory_id AS sc_storecardcategory_id,\n\t\tabra_store_cards.storemenuitem_id AS sc_storemenuitem_id,\n\t\tabra_store_cards.suffixcode AS sc_suffixcode,\n\t\tabra_store_cards.toleranceminus AS sc_toleranceminus,\n\t\tabra_store_cards.toleranceplus AS sc_toleranceplus,\n\t\tabra_store_cards.tolerancetype AS sc_tolerancetype,\n\t\tabra_store_cards.useoutofstockbatchdelivery AS sc_useoutofstockbatchdelivery,\n\t\tabra_store_cards.useoutofstockdelivery AS sc_useoutofstockdelivery,\n\t\tabra_store_cards.usualgrossprofit AS sc_usualgrossprofit,\n\t\tabra_store_cards.vatrate AS sc_vatrate,\n\t\tabra_store_cards.vatrate_id AS sc_vatrate_id,\n\t\tabra_store_cards.withcontainers AS sc_withcontainers,\n\t\tabra_store_cards.abra_autobeershop AS sc_abra_autobeershop,\n\t\tabra_store_cards.abra_autodelikatesy AS sc_abra_autodelikatesy,\n\t\tabra_store_cards.abra_barva AS sc_abra_barva,\n\t\tabra_store_cards.abra_carovy_kod AS sc_abra_carovy_kod,\n\t\tabra_store_cards.abra_cas_exportu AS sc_abra_cas_exportu,\n\t\tabra_store_cards.abra_clo AS sc_abra_clo,\n\t\tabra_store_cards.abra_datum_trvamlivosti AS sc_abra_datum_trvamlivosti,\n\t\tabra_store_cards.abra_dostupnost AS sc_abra_dostupnost,\n\t\tabra_store_cards.abra_dovozce AS sc_abra_dovozce,\n\t\tabra_store_cards.abra_nazev_eshop AS sc_abra_nazev_eshop,\n\t\tabra_store_cards.abra_nazev_vyrobku AS sc_abra_nazev_vyrobku,\n\t\tabra_store_cards.abra_params AS sc_abra_params,\n\t\tabra_store_cards.abra_placeofshop AS sc_abra_placeofshop,\n\t\tabra_store_cards.abra_popis_produktu AS sc_abra_popis_produktu,\n\t\tabra_store_cards.abra_skladovani AS sc_abra_skladovani,\n\t\tabra_store_cards.abra_slozeni AS sc_abra_slozeni,\n\t\tabra_store_cards.abra_slozeni_stitek AS sc_abra_slozeni_stitek,\n\t\tabra_store_cards.abra_stateonshop AS sc_abra_stateonshop,\n\t\tabra_store_cards.abra_stitek_text AS sc_abra_stitek_text,\n\t\tabra_store_cards.abra_umistneni_sklad AS sc_abra_umistneni_sklad,\n\t\tabra_store_cards.abra_vaha AS sc_abra_vaha,\n\t\tabra_store_cards.abra_vecny_popis AS sc_abra_vecny_popis,\n\t\tabra_store_cards.abra_vyrobce AS sc_abra_vyrobce,\n\t\tabra_store_cards.abra_zeme_puvodu_id AS sc_abra_zeme_puvodu_id,\n\t\tabra_store_cards.abra_znacka AS sc_abra_znacka,\n\t\tabra_store_cards.abra_zobrazeno AS sc_abra_zobrazeno,\n\t\tabra_store_cards.abra_exportnullquantity AS sc_abra_exportnullquantity,\n\t\tabra_store_cards.abra_alkohol AS sc_abra_alkohol,\n\t\tabra_store_cards.abra_plato AS sc_abra_plato,\n\t\tabra_store_cards.abra_objemlitry AS sc_abra_objemlitry,\n\t\tabra_store_cards.abra_sazbaspotrdane AS sc_abra_sazbaspotrdane,\n\t\tabra_store_cards.abra_typlahve AS sc_abra_typlahve,\n\t\tabra_store_cards.quantity AS sc_quantity,\n\t\tabra_store_cards.price_qunit AS sc_price_qunit,\n\t\tabra_store_cards.price_unitrate AS sc_price_unitrate,\n\t\tabra_store_cards.price_amount AS sc_price_amount,\n\t\tabra_store_cards.date_created AS sc_date_created,\n\t\tabra_store_cards.abra_showin_eshop AS sc_abra_showin_eshop,\n\t\tabra_store_cards.abra_showin_bshop AS sc_abra_showin_bshop,\n\t\tabra_store_cards.abra_nazev_bshop AS sc_abra_nazev_bshop,\n\t\tabra_store_cards.abra_nazev_uctenka AS sc_abra_nazev_uctenka,\n\t\tabra_store_cards.abra_export_vectron AS sc_abra_export_vectron,\n\t\tabra_store_cards.abra_change_gastro_on_pda AS sc_abra_change_gastro_on_pda,\n\t\tabra_store_cards.abra_export_prices_eshop AS sc_abra_export_prices_eshop,\n\t\tabra_store_cards.abra_export_prices_bshop AS sc_abra_export_prices_bshop,\n\t\tabra_store_cards.abra_fc_hash_deli AS sc_abra_fc_hash_deli,\n\t\tabra_store_cards.abra_fc_hash_beer AS sc_abra_fc_hash_beer,\n\t\tabra_store_cards.abra_vratna_zaloha_id AS sc_abra_vratna_zaloha_id,\n\t\tabra_store_cards.abra_fc_stockid_deli AS sc_abra_fc_stockid_deli,\n\t\tabra_store_cards.abra_fc_stockid_beer AS sc_abra_fc_stockid_beer,\n   abra_store_cards.abra_autobeershop_eu AS sc_abra_autobeershop_eu,\n   abra_store_cards.abra_fc_hash_beer_eu AS sc_abra_fc_hash_beer_eu,\n   abra_store_cards.abra_showin_bshop_eu AS sc_abra_showin_bshop_eu,\n   abra_store_cards.abra_nazev_bshop_eu AS sc_abra_nazev_bshop_eu,\n   abra_store_cards.abra_bshop_exists AS sc_abra_bshop_exists,\n   abra_store_cards.abra_deli_exists AS sc_abra_deli_exists,\n   abra_store_cards.abra_fc_stockid_beer_eu AS sc_abra_fc_stockid_beer_eu,\n   abra_store_cards.abra_doporucovat AS sc_abra_doporucovat,\n\t  adm_partners.id AS prtn_id,\n\t\tadm_partners.uid AS prtn_uid,\n\t\tadm_partners.role_name AS prtn_role_name,\n\t\tadm_partners.partner_state AS prtn_partner_state,\n\t\tadm_partners.username AS prtn_username,\n\t\tadm_partners.password AS prtn_password,\n\t\tadm_partners.nickname AS prtn_nickname,\n\t\tadm_partners.credit AS prtn_credit,\n\t\tadm_partners.vip_valid_to AS prtn_vip_valid_to,\n\t\tadm_partners.firstname AS prtn_firstname,\n\t\tadm_partners.middlename AS prtn_middlename,\n\t\tadm_partners.lastname AS prtn_lastname,\n\t\tadm_partners.gender AS prtn_gender,\n\t\tadm_partners.seeking AS prtn_seeking,\n\t\tadm_partners.age AS prtn_age,\n\t\tadm_partners.rating AS prtn_rating,\n\t\tadm_partners.rating_sum AS prtn_rating_sum,\n\t\tadm_partners.rating_count AS prtn_rating_count,\n\t\tadm_partners.date_birthday AS prtn_date_birthday,\n\t\tadm_partners.last_seen AS prtn_last_seen,\n\t\tadm_partners.phone AS prtn_phone,\n\t\tadm_partners.email AS prtn_email,\n\t\tadm_partners.city AS prtn_city,\n\t\tadm_partners.city_uid AS prtn_city_uid,\n\t\tadm_partners.country AS prtn_country,\n\t\tadm_partners.hair AS prtn_hair,\n\t\tadm_partners.fcm_token AS prtn_fcm_token,\n\t\tadm_partners.store_id AS prtn_store_id,\n\t\tadm_partners.printer_id AS prtn_printer_id,\n\t\tadm_partners.a4_printer_id AS prtn_a4_printer_id,\n\t\tadm_partners.t80_printer_id AS prtn_t80_printer_id,\n\t\tadm_partners.from_store_id AS prtn_from_store_id,\n\t\tadm_partners.to_store_id AS prtn_to_store_id,\n\t\tadm_partners.workpos AS prtn_workpos,\n\t\tadm_partners.profile_text AS prtn_profile_text,\n\t\tadm_partners.photo AS prtn_photo,\n\t\tadm_partners.visits_count AS prtn_visits_count,\n\t\tadm_partners.sms_count AS prtn_sms_count,\n\t\tadm_partners.web_messages_count AS prtn_web_messages_count,\n\t\tadm_partners.date_survey AS prtn_date_survey,\n\t\tadm_partners.activationkey AS prtn_activationkey,\n\t\tadm_partners.actived AS prtn_actived,\n\t\tadm_partners.confirmed AS prtn_confirmed,\n\t\tadm_partners.date_changed AS prtn_date_changed,\n\t\tadm_partners.user_changed AS prtn_user_changed,\n\t\tadm_partners.note AS prtn_note,\n\t\tadm_partners.date_created AS prtn_date_created\n FROM app.stocktaking_items p  \t\t\tLEFT OUTER JOIN abra.store_cards abra_store_cards ON (p.store_cards_id = abra_store_cards.id)  \t\t\tLEFT OUTER JOIN adm.partners adm_partners ON (p.partner_id = adm_partners.id)  WHERE p.id = :id")
    @RegisterRowMapper(value=StocktakingItemsFullMapper.class)
    public StocktakingItemsFullDomain findByIdFull(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.id = :id")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public List<StocktakingItemsDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.stocktaking_items p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public List<StocktakingItemsDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public StocktakingItemsDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public List<StocktakingItemsDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.stocktaking_items p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public List<StocktakingItemsDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.stocktaking_id = :stocktakingId")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public StocktakingItemsDomain findByStocktakingId(@Bind(value="stocktakingId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.stocktaking_id = :stocktakingId")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public List<StocktakingItemsDomain> findListByStocktakingId(@Bind(value="stocktakingId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created,\t  abra_store_cards.id AS sc_id,\n\t\tabra_store_cards.uid AS sc_uid,\n\t\tabra_store_cards.abra_id AS sc_abra_id,\n\t\tabra_store_cards.manufacturer AS sc_manufacturer,\n\t\tabra_store_cards.date_authorized_at AS sc_date_authorized_at,\n\t\tabra_store_cards.authorizedby_id AS sc_authorizedby_id,\n\t\tabra_store_cards.bodycode AS sc_bodycode,\n\t\tabra_store_cards.category AS sc_category,\n\t\tabra_store_cards.classid AS sc_classid,\n\t\tabra_store_cards.code AS sc_code,\n\t\tabra_store_cards.comment AS sc_comment,\n\t\tabra_store_cards.date_correctedat AS sc_date_correctedat,\n\t\tabra_store_cards.correctedby_id AS sc_correctedby_id,\n\t\tabra_store_cards.country_id AS sc_country_id,\n\t\tabra_store_cards.date_createdat AS sc_date_createdat,\n\t\tabra_store_cards.createdby_id AS sc_createdby_id,\n\t\tabra_store_cards.customstariff AS sc_customstariff,\n\t\tabra_store_cards.customstariffnumber AS sc_customstariffnumber,\n\t\tabra_store_cards.date_dateofchange AS sc_date_dateofchange,\n\t\tabra_store_cards.dealerdiscount_id AS sc_dealerdiscount_id,\n\t\tabra_store_cards.discountsexcluded AS sc_discountsexcluded,\n\t\tabra_store_cards.displayname AS sc_displayname,\n\t\tabra_store_cards.ean AS sc_ean,\n\t\tabra_store_cards.expirationdue AS sc_expirationdue,\n\t\tabra_store_cards.foreignname AS sc_foreignname,\n\t\tabra_store_cards.guaranteelength AS sc_guaranteelength,\n\t\tabra_store_cards.guaranteelengthcorporate AS sc_guaranteelengthcorporate,\n\t\tabra_store_cards.guaranteeunitname AS sc_guaranteeunitname,\n\t\tabra_store_cards.guaranteeunitnamecorporate AS sc_guaranteeunitnamecorporate,\n\t\tabra_store_cards.hidden AS sc_hidden,\n\t\tabra_store_cards.incometype_id AS sc_incometype_id,\n\t\tabra_store_cards.intrastatcommodity_id AS sc_intrastatcommodity_id,\n\t\tabra_store_cards.intrastatcurrentprice AS sc_intrastatcurrentprice,\n\t\tabra_store_cards.intrastatcurrentpricelimit AS sc_intrastatcurrentpricelimit,\n\t\tabra_store_cards.intrastatextratype_id AS sc_intrastatextratype_id,\n\t\tabra_store_cards.intrastatinputstatistic_id AS sc_intrastatinputstatistic_id,\n\t\tabra_store_cards.intrastatoutputstatistic_id AS sc_intrastatoutputstatistic_id,\n\t\tabra_store_cards.intrastatregion_id AS sc_intrastatregion_id,\n\t\tabra_store_cards.intrastatunitcode AS sc_intrastatunitcode,\n\t\tabra_store_cards.intrastatunitrate AS sc_intrastatunitrate,\n\t\tabra_store_cards.intrastatunitrateref AS sc_intrastatunitrateref,\n\t\tabra_store_cards.intrastatweight AS sc_intrastatweight,\n\t\tabra_store_cards.intrastatweightunit AS sc_intrastatweightunit,\n\t\tabra_store_cards.isproduct AS sc_isproduct,\n\t\tabra_store_cards.isscalable AS sc_isscalable,\n\t\tabra_store_cards.mainsupplier_id AS sc_mainsupplier_id,\n\t\tabra_store_cards.mainunitcode AS sc_mainunitcode,\n\t\tabra_store_cards.mainunitrate AS sc_mainunitrate,\n\t\tabra_store_cards.mossservice_id AS sc_mossservice_id,\n\t\tabra_store_cards.name AS sc_name,\n\t\tabra_store_cards.nonstocktype AS sc_nonstocktype,\n\t\tabra_store_cards.note AS sc_note,\n\t\tabra_store_cards.objversion AS sc_objversion,\n\t\tabra_store_cards.outofstockbatchdelivery AS sc_outofstockbatchdelivery,\n\t\tabra_store_cards.outofstockdelivery AS sc_outofstockdelivery,\n\t\tabra_store_cards.picture_id AS sc_picture_id,\n\t\tabra_store_cards.plu AS sc_plu,\n\t\tabra_store_cards.prefixcode AS sc_prefixcode,\n\t\tabra_store_cards.producer_id AS sc_producer_id,\n\t\tabra_store_cards.quantitydiscount_id AS sc_quantitydiscount_id,\n\t\tabra_store_cards.serialnumberstructure AS sc_serialnumberstructure,\n\t\tabra_store_cards.shortname AS sc_shortname,\n\t\tabra_store_cards.specification AS sc_specification,\n\t\tabra_store_cards.specification2 AS sc_specification2,\n\t\tabra_store_cards.spendingtaxtariff AS sc_spendingtaxtariff,\n\t\tabra_store_cards.storeassortmentgroup_id AS sc_storeassortmentgroup_id,\n\t\tabra_store_cards.storebatchstructure_id AS sc_storebatchstructure_id,\n\t\tabra_store_cards.storecardcategory_id AS sc_storecardcategory_id,\n\t\tabra_store_cards.storemenuitem_id AS sc_storemenuitem_id,\n\t\tabra_store_cards.suffixcode AS sc_suffixcode,\n\t\tabra_store_cards.toleranceminus AS sc_toleranceminus,\n\t\tabra_store_cards.toleranceplus AS sc_toleranceplus,\n\t\tabra_store_cards.tolerancetype AS sc_tolerancetype,\n\t\tabra_store_cards.useoutofstockbatchdelivery AS sc_useoutofstockbatchdelivery,\n\t\tabra_store_cards.useoutofstockdelivery AS sc_useoutofstockdelivery,\n\t\tabra_store_cards.usualgrossprofit AS sc_usualgrossprofit,\n\t\tabra_store_cards.vatrate AS sc_vatrate,\n\t\tabra_store_cards.vatrate_id AS sc_vatrate_id,\n\t\tabra_store_cards.withcontainers AS sc_withcontainers,\n\t\tabra_store_cards.abra_autobeershop AS sc_abra_autobeershop,\n\t\tabra_store_cards.abra_autodelikatesy AS sc_abra_autodelikatesy,\n\t\tabra_store_cards.abra_barva AS sc_abra_barva,\n\t\tabra_store_cards.abra_carovy_kod AS sc_abra_carovy_kod,\n\t\tabra_store_cards.abra_cas_exportu AS sc_abra_cas_exportu,\n\t\tabra_store_cards.abra_clo AS sc_abra_clo,\n\t\tabra_store_cards.abra_datum_trvamlivosti AS sc_abra_datum_trvamlivosti,\n\t\tabra_store_cards.abra_dostupnost AS sc_abra_dostupnost,\n\t\tabra_store_cards.abra_dovozce AS sc_abra_dovozce,\n\t\tabra_store_cards.abra_nazev_eshop AS sc_abra_nazev_eshop,\n\t\tabra_store_cards.abra_nazev_vyrobku AS sc_abra_nazev_vyrobku,\n\t\tabra_store_cards.abra_params AS sc_abra_params,\n\t\tabra_store_cards.abra_placeofshop AS sc_abra_placeofshop,\n\t\tabra_store_cards.abra_popis_produktu AS sc_abra_popis_produktu,\n\t\tabra_store_cards.abra_skladovani AS sc_abra_skladovani,\n\t\tabra_store_cards.abra_slozeni AS sc_abra_slozeni,\n\t\tabra_store_cards.abra_slozeni_stitek AS sc_abra_slozeni_stitek,\n\t\tabra_store_cards.abra_stateonshop AS sc_abra_stateonshop,\n\t\tabra_store_cards.abra_stitek_text AS sc_abra_stitek_text,\n\t\tabra_store_cards.abra_umistneni_sklad AS sc_abra_umistneni_sklad,\n\t\tabra_store_cards.abra_vaha AS sc_abra_vaha,\n\t\tabra_store_cards.abra_vecny_popis AS sc_abra_vecny_popis,\n\t\tabra_store_cards.abra_vyrobce AS sc_abra_vyrobce,\n\t\tabra_store_cards.abra_zeme_puvodu_id AS sc_abra_zeme_puvodu_id,\n\t\tabra_store_cards.abra_znacka AS sc_abra_znacka,\n\t\tabra_store_cards.abra_zobrazeno AS sc_abra_zobrazeno,\n\t\tabra_store_cards.abra_exportnullquantity AS sc_abra_exportnullquantity,\n\t\tabra_store_cards.abra_alkohol AS sc_abra_alkohol,\n\t\tabra_store_cards.abra_plato AS sc_abra_plato,\n\t\tabra_store_cards.abra_objemlitry AS sc_abra_objemlitry,\n\t\tabra_store_cards.abra_sazbaspotrdane AS sc_abra_sazbaspotrdane,\n\t\tabra_store_cards.abra_typlahve AS sc_abra_typlahve,\n\t\tabra_store_cards.quantity AS sc_quantity,\n\t\tabra_store_cards.price_qunit AS sc_price_qunit,\n\t\tabra_store_cards.price_unitrate AS sc_price_unitrate,\n\t\tabra_store_cards.price_amount AS sc_price_amount,\n\t\tabra_store_cards.date_created AS sc_date_created,\n\t\tabra_store_cards.abra_showin_eshop AS sc_abra_showin_eshop,\n\t\tabra_store_cards.abra_showin_bshop AS sc_abra_showin_bshop,\n\t\tabra_store_cards.abra_nazev_bshop AS sc_abra_nazev_bshop,\n\t\tabra_store_cards.abra_nazev_uctenka AS sc_abra_nazev_uctenka,\n\t\tabra_store_cards.abra_export_vectron AS sc_abra_export_vectron,\n\t\tabra_store_cards.abra_change_gastro_on_pda AS sc_abra_change_gastro_on_pda,\n\t\tabra_store_cards.abra_export_prices_eshop AS sc_abra_export_prices_eshop,\n\t\tabra_store_cards.abra_export_prices_bshop AS sc_abra_export_prices_bshop,\n\t\tabra_store_cards.abra_fc_hash_deli AS sc_abra_fc_hash_deli,\n\t\tabra_store_cards.abra_fc_hash_beer AS sc_abra_fc_hash_beer,\n\t\tabra_store_cards.abra_vratna_zaloha_id AS sc_abra_vratna_zaloha_id,\n\t\tabra_store_cards.abra_fc_stockid_deli AS sc_abra_fc_stockid_deli,\n\t\tabra_store_cards.abra_fc_stockid_beer AS sc_abra_fc_stockid_beer,\n   abra_store_cards.abra_autobeershop_eu AS sc_abra_autobeershop_eu,\n   abra_store_cards.abra_fc_hash_beer_eu AS sc_abra_fc_hash_beer_eu,\n   abra_store_cards.abra_showin_bshop_eu AS sc_abra_showin_bshop_eu,\n   abra_store_cards.abra_nazev_bshop_eu AS sc_abra_nazev_bshop_eu,\n   abra_store_cards.abra_bshop_exists AS sc_abra_bshop_exists,\n   abra_store_cards.abra_deli_exists AS sc_abra_deli_exists,\n   abra_store_cards.abra_fc_stockid_beer_eu AS sc_abra_fc_stockid_beer_eu,\n   abra_store_cards.abra_doporucovat AS sc_abra_doporucovat,\n\t  adm_partners.id AS prtn_id,\n\t\tadm_partners.uid AS prtn_uid,\n\t\tadm_partners.role_name AS prtn_role_name,\n\t\tadm_partners.partner_state AS prtn_partner_state,\n\t\tadm_partners.username AS prtn_username,\n\t\tadm_partners.password AS prtn_password,\n\t\tadm_partners.nickname AS prtn_nickname,\n\t\tadm_partners.credit AS prtn_credit,\n\t\tadm_partners.vip_valid_to AS prtn_vip_valid_to,\n\t\tadm_partners.firstname AS prtn_firstname,\n\t\tadm_partners.middlename AS prtn_middlename,\n\t\tadm_partners.lastname AS prtn_lastname,\n\t\tadm_partners.gender AS prtn_gender,\n\t\tadm_partners.seeking AS prtn_seeking,\n\t\tadm_partners.age AS prtn_age,\n\t\tadm_partners.rating AS prtn_rating,\n\t\tadm_partners.rating_sum AS prtn_rating_sum,\n\t\tadm_partners.rating_count AS prtn_rating_count,\n\t\tadm_partners.date_birthday AS prtn_date_birthday,\n\t\tadm_partners.last_seen AS prtn_last_seen,\n\t\tadm_partners.phone AS prtn_phone,\n\t\tadm_partners.email AS prtn_email,\n\t\tadm_partners.city AS prtn_city,\n\t\tadm_partners.city_uid AS prtn_city_uid,\n\t\tadm_partners.country AS prtn_country,\n\t\tadm_partners.hair AS prtn_hair,\n\t\tadm_partners.fcm_token AS prtn_fcm_token,\n\t\tadm_partners.store_id AS prtn_store_id,\n\t\tadm_partners.printer_id AS prtn_printer_id,\n\t\tadm_partners.a4_printer_id AS prtn_a4_printer_id,\n\t\tadm_partners.t80_printer_id AS prtn_t80_printer_id,\n\t\tadm_partners.from_store_id AS prtn_from_store_id,\n\t\tadm_partners.to_store_id AS prtn_to_store_id,\n\t\tadm_partners.workpos AS prtn_workpos,\n\t\tadm_partners.profile_text AS prtn_profile_text,\n\t\tadm_partners.photo AS prtn_photo,\n\t\tadm_partners.visits_count AS prtn_visits_count,\n\t\tadm_partners.sms_count AS prtn_sms_count,\n\t\tadm_partners.web_messages_count AS prtn_web_messages_count,\n\t\tadm_partners.date_survey AS prtn_date_survey,\n\t\tadm_partners.activationkey AS prtn_activationkey,\n\t\tadm_partners.actived AS prtn_actived,\n\t\tadm_partners.confirmed AS prtn_confirmed,\n\t\tadm_partners.date_changed AS prtn_date_changed,\n\t\tadm_partners.user_changed AS prtn_user_changed,\n\t\tadm_partners.note AS prtn_note,\n\t\tadm_partners.date_created AS prtn_date_created\n FROM app.stocktaking_items p  \t\t\tLEFT OUTER JOIN abra.store_cards abra_store_cards ON (p.store_cards_id = abra_store_cards.id)  \t\t\tLEFT OUTER JOIN adm.partners adm_partners ON (p.partner_id = adm_partners.id)  WHERE \n p.stocktaking_id = :stocktakingId  AND ( CASE WHEN :partnerId > 0 THEN p.partner_id = :partnerId ELSE TRUE END ) \tAND ( \n\t\tabra_store_cards.plu::text ~* :pluEan \n)")
    @RegisterRowMapper(value=StocktakingItemsFullMapper.class)
    public List<StocktakingItemsFullDomain> findListByStocktakingIdFull(@Bind(value="stocktakingId") Long var1, @Bind(value="partnerId") Long var2, @Bind(value="pluEan") String var3);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.stocktaking_items p LEFT OUTER JOIN abra.store_cards abra_store_cards ON (p.store_cards_id = abra_store_cards.id) WHERE p.stocktaking_id = :stocktakingId AND ( CASE WHEN :partnerId > 0 THEN p.partner_id = :partnerId ELSE TRUE END ) \tAND ( \n\t\tabra_store_cards.plu::text ~* :pluEan \n)")
    public long findListByStocktakingIdFullCount(@Bind(value="stocktakingId") Long var1, @Bind(value="partnerId") Long var2, @Bind(value="pluEan") String var3);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.stocktaking_items p  WHERE p.stocktaking_id = :stocktakingId")
    public long findListByStocktakingIdCount(@Bind(value="stocktakingId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.stocktaking_id = :stocktakingId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public List<StocktakingItemsDomain> findListByStocktakingId(@Bind(value="stocktakingId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created,\t  abra_store_cards.id AS sc_id,\n\t\tabra_store_cards.uid AS sc_uid,\n\t\tabra_store_cards.abra_id AS sc_abra_id,\n\t\tabra_store_cards.manufacturer AS sc_manufacturer,\n\t\tabra_store_cards.date_authorized_at AS sc_date_authorized_at,\n\t\tabra_store_cards.authorizedby_id AS sc_authorizedby_id,\n\t\tabra_store_cards.bodycode AS sc_bodycode,\n\t\tabra_store_cards.category AS sc_category,\n\t\tabra_store_cards.classid AS sc_classid,\n\t\tabra_store_cards.code AS sc_code,\n\t\tabra_store_cards.comment AS sc_comment,\n\t\tabra_store_cards.date_correctedat AS sc_date_correctedat,\n\t\tabra_store_cards.correctedby_id AS sc_correctedby_id,\n\t\tabra_store_cards.country_id AS sc_country_id,\n\t\tabra_store_cards.date_createdat AS sc_date_createdat,\n\t\tabra_store_cards.createdby_id AS sc_createdby_id,\n\t\tabra_store_cards.customstariff AS sc_customstariff,\n\t\tabra_store_cards.customstariffnumber AS sc_customstariffnumber,\n\t\tabra_store_cards.date_dateofchange AS sc_date_dateofchange,\n\t\tabra_store_cards.dealerdiscount_id AS sc_dealerdiscount_id,\n\t\tabra_store_cards.discountsexcluded AS sc_discountsexcluded,\n\t\tabra_store_cards.displayname AS sc_displayname,\n\t\tabra_store_cards.ean AS sc_ean,\n\t\tabra_store_cards.expirationdue AS sc_expirationdue,\n\t\tabra_store_cards.foreignname AS sc_foreignname,\n\t\tabra_store_cards.guaranteelength AS sc_guaranteelength,\n\t\tabra_store_cards.guaranteelengthcorporate AS sc_guaranteelengthcorporate,\n\t\tabra_store_cards.guaranteeunitname AS sc_guaranteeunitname,\n\t\tabra_store_cards.guaranteeunitnamecorporate AS sc_guaranteeunitnamecorporate,\n\t\tabra_store_cards.hidden AS sc_hidden,\n\t\tabra_store_cards.incometype_id AS sc_incometype_id,\n\t\tabra_store_cards.intrastatcommodity_id AS sc_intrastatcommodity_id,\n\t\tabra_store_cards.intrastatcurrentprice AS sc_intrastatcurrentprice,\n\t\tabra_store_cards.intrastatcurrentpricelimit AS sc_intrastatcurrentpricelimit,\n\t\tabra_store_cards.intrastatextratype_id AS sc_intrastatextratype_id,\n\t\tabra_store_cards.intrastatinputstatistic_id AS sc_intrastatinputstatistic_id,\n\t\tabra_store_cards.intrastatoutputstatistic_id AS sc_intrastatoutputstatistic_id,\n\t\tabra_store_cards.intrastatregion_id AS sc_intrastatregion_id,\n\t\tabra_store_cards.intrastatunitcode AS sc_intrastatunitcode,\n\t\tabra_store_cards.intrastatunitrate AS sc_intrastatunitrate,\n\t\tabra_store_cards.intrastatunitrateref AS sc_intrastatunitrateref,\n\t\tabra_store_cards.intrastatweight AS sc_intrastatweight,\n\t\tabra_store_cards.intrastatweightunit AS sc_intrastatweightunit,\n\t\tabra_store_cards.isproduct AS sc_isproduct,\n\t\tabra_store_cards.isscalable AS sc_isscalable,\n\t\tabra_store_cards.mainsupplier_id AS sc_mainsupplier_id,\n\t\tabra_store_cards.mainunitcode AS sc_mainunitcode,\n\t\tabra_store_cards.mainunitrate AS sc_mainunitrate,\n\t\tabra_store_cards.mossservice_id AS sc_mossservice_id,\n\t\tabra_store_cards.name AS sc_name,\n\t\tabra_store_cards.nonstocktype AS sc_nonstocktype,\n\t\tabra_store_cards.note AS sc_note,\n\t\tabra_store_cards.objversion AS sc_objversion,\n\t\tabra_store_cards.outofstockbatchdelivery AS sc_outofstockbatchdelivery,\n\t\tabra_store_cards.outofstockdelivery AS sc_outofstockdelivery,\n\t\tabra_store_cards.picture_id AS sc_picture_id,\n\t\tabra_store_cards.plu AS sc_plu,\n\t\tabra_store_cards.prefixcode AS sc_prefixcode,\n\t\tabra_store_cards.producer_id AS sc_producer_id,\n\t\tabra_store_cards.quantitydiscount_id AS sc_quantitydiscount_id,\n\t\tabra_store_cards.serialnumberstructure AS sc_serialnumberstructure,\n\t\tabra_store_cards.shortname AS sc_shortname,\n\t\tabra_store_cards.specification AS sc_specification,\n\t\tabra_store_cards.specification2 AS sc_specification2,\n\t\tabra_store_cards.spendingtaxtariff AS sc_spendingtaxtariff,\n\t\tabra_store_cards.storeassortmentgroup_id AS sc_storeassortmentgroup_id,\n\t\tabra_store_cards.storebatchstructure_id AS sc_storebatchstructure_id,\n\t\tabra_store_cards.storecardcategory_id AS sc_storecardcategory_id,\n\t\tabra_store_cards.storemenuitem_id AS sc_storemenuitem_id,\n\t\tabra_store_cards.suffixcode AS sc_suffixcode,\n\t\tabra_store_cards.toleranceminus AS sc_toleranceminus,\n\t\tabra_store_cards.toleranceplus AS sc_toleranceplus,\n\t\tabra_store_cards.tolerancetype AS sc_tolerancetype,\n\t\tabra_store_cards.useoutofstockbatchdelivery AS sc_useoutofstockbatchdelivery,\n\t\tabra_store_cards.useoutofstockdelivery AS sc_useoutofstockdelivery,\n\t\tabra_store_cards.usualgrossprofit AS sc_usualgrossprofit,\n\t\tabra_store_cards.vatrate AS sc_vatrate,\n\t\tabra_store_cards.vatrate_id AS sc_vatrate_id,\n\t\tabra_store_cards.withcontainers AS sc_withcontainers,\n\t\tabra_store_cards.abra_autobeershop AS sc_abra_autobeershop,\n\t\tabra_store_cards.abra_autodelikatesy AS sc_abra_autodelikatesy,\n\t\tabra_store_cards.abra_barva AS sc_abra_barva,\n\t\tabra_store_cards.abra_carovy_kod AS sc_abra_carovy_kod,\n\t\tabra_store_cards.abra_cas_exportu AS sc_abra_cas_exportu,\n\t\tabra_store_cards.abra_clo AS sc_abra_clo,\n\t\tabra_store_cards.abra_datum_trvamlivosti AS sc_abra_datum_trvamlivosti,\n\t\tabra_store_cards.abra_dostupnost AS sc_abra_dostupnost,\n\t\tabra_store_cards.abra_dovozce AS sc_abra_dovozce,\n\t\tabra_store_cards.abra_nazev_eshop AS sc_abra_nazev_eshop,\n\t\tabra_store_cards.abra_nazev_vyrobku AS sc_abra_nazev_vyrobku,\n\t\tabra_store_cards.abra_params AS sc_abra_params,\n\t\tabra_store_cards.abra_placeofshop AS sc_abra_placeofshop,\n\t\tabra_store_cards.abra_popis_produktu AS sc_abra_popis_produktu,\n\t\tabra_store_cards.abra_skladovani AS sc_abra_skladovani,\n\t\tabra_store_cards.abra_slozeni AS sc_abra_slozeni,\n\t\tabra_store_cards.abra_slozeni_stitek AS sc_abra_slozeni_stitek,\n\t\tabra_store_cards.abra_stateonshop AS sc_abra_stateonshop,\n\t\tabra_store_cards.abra_stitek_text AS sc_abra_stitek_text,\n\t\tabra_store_cards.abra_umistneni_sklad AS sc_abra_umistneni_sklad,\n\t\tabra_store_cards.abra_vaha AS sc_abra_vaha,\n\t\tabra_store_cards.abra_vecny_popis AS sc_abra_vecny_popis,\n\t\tabra_store_cards.abra_vyrobce AS sc_abra_vyrobce,\n\t\tabra_store_cards.abra_zeme_puvodu_id AS sc_abra_zeme_puvodu_id,\n\t\tabra_store_cards.abra_znacka AS sc_abra_znacka,\n\t\tabra_store_cards.abra_zobrazeno AS sc_abra_zobrazeno,\n\t\tabra_store_cards.abra_exportnullquantity AS sc_abra_exportnullquantity,\n\t\tabra_store_cards.abra_alkohol AS sc_abra_alkohol,\n\t\tabra_store_cards.abra_plato AS sc_abra_plato,\n\t\tabra_store_cards.abra_objemlitry AS sc_abra_objemlitry,\n\t\tabra_store_cards.abra_sazbaspotrdane AS sc_abra_sazbaspotrdane,\n\t\tabra_store_cards.abra_typlahve AS sc_abra_typlahve,\n\t\tabra_store_cards.quantity AS sc_quantity,\n\t\tabra_store_cards.price_qunit AS sc_price_qunit,\n\t\tabra_store_cards.price_unitrate AS sc_price_unitrate,\n\t\tabra_store_cards.price_amount AS sc_price_amount,\n\t\tabra_store_cards.date_created AS sc_date_created,\n\t\tabra_store_cards.abra_showin_eshop AS sc_abra_showin_eshop,\n\t\tabra_store_cards.abra_showin_bshop AS sc_abra_showin_bshop,\n\t\tabra_store_cards.abra_nazev_bshop AS sc_abra_nazev_bshop,\n\t\tabra_store_cards.abra_nazev_uctenka AS sc_abra_nazev_uctenka,\n\t\tabra_store_cards.abra_export_vectron AS sc_abra_export_vectron,\n\t\tabra_store_cards.abra_change_gastro_on_pda AS sc_abra_change_gastro_on_pda,\n\t\tabra_store_cards.abra_export_prices_eshop AS sc_abra_export_prices_eshop,\n\t\tabra_store_cards.abra_export_prices_bshop AS sc_abra_export_prices_bshop,\n\t\tabra_store_cards.abra_fc_hash_deli AS sc_abra_fc_hash_deli,\n\t\tabra_store_cards.abra_fc_hash_beer AS sc_abra_fc_hash_beer,\n\t\tabra_store_cards.abra_vratna_zaloha_id AS sc_abra_vratna_zaloha_id,\n\t\tabra_store_cards.abra_fc_stockid_deli AS sc_abra_fc_stockid_deli,\n\t\tabra_store_cards.abra_fc_stockid_beer AS sc_abra_fc_stockid_beer,\n   abra_store_cards.abra_autobeershop_eu AS sc_abra_autobeershop_eu,\n   abra_store_cards.abra_fc_hash_beer_eu AS sc_abra_fc_hash_beer_eu,\n   abra_store_cards.abra_showin_bshop_eu AS sc_abra_showin_bshop_eu,\n   abra_store_cards.abra_nazev_bshop_eu AS sc_abra_nazev_bshop_eu,\n   abra_store_cards.abra_bshop_exists AS sc_abra_bshop_exists,\n   abra_store_cards.abra_deli_exists AS sc_abra_deli_exists,\n   abra_store_cards.abra_deli_exists AS sc_abra_deli_exists,\n   abra_store_cards.abra_fc_stockid_beer_eu AS sc_abra_fc_stockid_beer_eu,\n   abra_store_cards.abra_doporucovat AS sc_abra_doporucovat,\n\t  adm_partners.id AS prtn_id,\n\t\tadm_partners.uid AS prtn_uid,\n\t\tadm_partners.role_name AS prtn_role_name,\n\t\tadm_partners.partner_state AS prtn_partner_state,\n\t\tadm_partners.username AS prtn_username,\n\t\tadm_partners.password AS prtn_password,\n\t\tadm_partners.nickname AS prtn_nickname,\n\t\tadm_partners.credit AS prtn_credit,\n\t\tadm_partners.vip_valid_to AS prtn_vip_valid_to,\n\t\tadm_partners.firstname AS prtn_firstname,\n\t\tadm_partners.middlename AS prtn_middlename,\n\t\tadm_partners.lastname AS prtn_lastname,\n\t\tadm_partners.gender AS prtn_gender,\n\t\tadm_partners.seeking AS prtn_seeking,\n\t\tadm_partners.age AS prtn_age,\n\t\tadm_partners.rating AS prtn_rating,\n\t\tadm_partners.rating_sum AS prtn_rating_sum,\n\t\tadm_partners.rating_count AS prtn_rating_count,\n\t\tadm_partners.date_birthday AS prtn_date_birthday,\n\t\tadm_partners.last_seen AS prtn_last_seen,\n\t\tadm_partners.phone AS prtn_phone,\n\t\tadm_partners.email AS prtn_email,\n\t\tadm_partners.city AS prtn_city,\n\t\tadm_partners.city_uid AS prtn_city_uid,\n\t\tadm_partners.country AS prtn_country,\n\t\tadm_partners.hair AS prtn_hair,\n\t\tadm_partners.fcm_token AS prtn_fcm_token,\n\t\tadm_partners.store_id AS prtn_store_id,\n\t\tadm_partners.printer_id AS prtn_printer_id,\n\t\tadm_partners.a4_printer_id AS prtn_a4_printer_id,\n\t\tadm_partners.t80_printer_id AS prtn_t80_printer_id,\n\t\tadm_partners.from_store_id AS prtn_from_store_id,\n\t\tadm_partners.to_store_id AS prtn_to_store_id,\n\t\tadm_partners.workpos AS prtn_workpos,\n\t\tadm_partners.profile_text AS prtn_profile_text,\n\t\tadm_partners.photo AS prtn_photo,\n\t\tadm_partners.visits_count AS prtn_visits_count,\n\t\tadm_partners.sms_count AS prtn_sms_count,\n\t\tadm_partners.web_messages_count AS prtn_web_messages_count,\n\t\tadm_partners.date_survey AS prtn_date_survey,\n\t\tadm_partners.activationkey AS prtn_activationkey,\n\t\tadm_partners.actived AS prtn_actived,\n\t\tadm_partners.confirmed AS prtn_confirmed,\n\t\tadm_partners.date_changed AS prtn_date_changed,\n\t\tadm_partners.user_changed AS prtn_user_changed,\n\t\tadm_partners.note AS prtn_note,\n\t\tadm_partners.date_created AS prtn_date_created\n FROM app.stocktaking_items p  \t\t\tLEFT OUTER JOIN abra.store_cards abra_store_cards ON (p.store_cards_id = abra_store_cards.id)  \t\t\tLEFT OUTER JOIN adm.partners adm_partners ON (p.partner_id = adm_partners.id)  WHERE p.stocktaking_id = :stocktakingId  AND ( CASE WHEN :partnerId > 0 THEN p.partner_id = :partnerId ELSE TRUE END ) \tAND ( \n\t\tabra_store_cards.plu::text ~* :pluEan \n)  ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StocktakingItemsFullMapper.class)
    public List<StocktakingItemsFullDomain> findListByStocktakingIdFull(@Bind(value="stocktakingId") Long var1, @Bind(value="partnerId") Long var2, @Bind(value="pluEan") String var3, @Bind(value="offset") int var4, @Bind(value="limit") int var5, @Define(value="order") String var6, @Define(value="sort") String var7);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.partner_id = :partnerId")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public StocktakingItemsDomain findByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.partner_id = :partnerId")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public List<StocktakingItemsDomain> findListByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.stocktaking_items p  WHERE p.partner_id = :partnerId")
    public long findListByPartnerIdCount(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.partner_id = :partnerId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public List<StocktakingItemsDomain> findListByPartnerId(@Bind(value="partnerId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.plu = :plu")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public StocktakingItemsDomain findByPlu(@Bind(value="plu") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.plu = :plu")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public List<StocktakingItemsDomain> findListByPlu(@Bind(value="plu") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.stocktaking_items p  WHERE p.plu = :plu")
    public long findListByPluCount(@Bind(value="plu") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.plu = :plu ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public List<StocktakingItemsDomain> findListByPlu(@Bind(value="plu") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.ean = :ean")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public StocktakingItemsDomain findByEan(@Bind(value="ean") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.ean = :ean")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public List<StocktakingItemsDomain> findListByEan(@Bind(value="ean") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.stocktaking_items p  WHERE p.ean = :ean")
    public long findListByEanCount(@Bind(value="ean") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.ean = :ean ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public List<StocktakingItemsDomain> findListByEan(@Bind(value="ean") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.store_cards_id = :storeCardsId")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public StocktakingItemsDomain findByStoreCardsId(@Bind(value="storeCardsId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.store_cards_id = :storeCardsId")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public List<StocktakingItemsDomain> findListByStoreCardsId(@Bind(value="storeCardsId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.stocktaking_items p  WHERE p.store_cards_id = :storeCardsId")
    public long findListByStoreCardsIdCount(@Bind(value="storeCardsId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.store_cards_id = :storeCardsId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public List<StocktakingItemsDomain> findListByStoreCardsId(@Bind(value="storeCardsId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.date_started = :dateStarted")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public StocktakingItemsDomain findByDateStarted(@Bind(value="dateStarted") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.date_started = :dateStarted")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public List<StocktakingItemsDomain> findListByDateStarted(@Bind(value="dateStarted") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.stocktaking_items p  WHERE p.date_started = :dateStarted")
    public long findListByDateStartedCount(@Bind(value="dateStarted") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.date_started = :dateStarted ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public List<StocktakingItemsDomain> findListByDateStarted(@Bind(value="dateStarted") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.date_finished = :dateFinished")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public StocktakingItemsDomain findByDateFinished(@Bind(value="dateFinished") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.date_finished = :dateFinished")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public List<StocktakingItemsDomain> findListByDateFinished(@Bind(value="dateFinished") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.stocktaking_items p  WHERE p.date_finished = :dateFinished")
    public long findListByDateFinishedCount(@Bind(value="dateFinished") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.date_finished = :dateFinished ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public List<StocktakingItemsDomain> findListByDateFinished(@Bind(value="dateFinished") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.quantity = :quantity")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public StocktakingItemsDomain findByQuantity(@Bind(value="quantity") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.quantity = :quantity")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public List<StocktakingItemsDomain> findListByQuantity(@Bind(value="quantity") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.stocktaking_items p  WHERE p.quantity = :quantity")
    public long findListByQuantityCount(@Bind(value="quantity") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.quantity = :quantity ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public List<StocktakingItemsDomain> findListByQuantity(@Bind(value="quantity") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.new_quantity = :newQuantity")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public StocktakingItemsDomain findByNewQuantity(@Bind(value="newQuantity") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.new_quantity = :newQuantity")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public List<StocktakingItemsDomain> findListByNewQuantity(@Bind(value="newQuantity") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.stocktaking_items p  WHERE p.new_quantity = :newQuantity")
    public long findListByNewQuantityCount(@Bind(value="newQuantity") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.new_quantity = :newQuantity ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public List<StocktakingItemsDomain> findListByNewQuantity(@Bind(value="newQuantity") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.note = :note")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public StocktakingItemsDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.note = :note")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public List<StocktakingItemsDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.stocktaking_items p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public List<StocktakingItemsDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public StocktakingItemsDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public List<StocktakingItemsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.stocktaking_items p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.stocktaking_id, p.partner_id, p.plu, p.ean, p.store_cards_id, p.date_started, p.date_finished, p.quantity, p.new_quantity, p.note, p.date_created FROM app.stocktaking_items p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StocktakingItemsMapper.class)
    public List<StocktakingItemsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO app.stocktaking_items (id, uid, stocktaking_id, partner_id, plu, ean, store_cards_id, date_started, date_finished, quantity, new_quantity, note, date_created) VALUES (:id, :uid, :stocktakingId, :partnerId, :plu, :ean, :storeCardsId, :dateStarted, :dateFinished, :quantity, :newQuantity, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="stocktakingId") Long var3, @Bind(value="partnerId") Long var4, @Bind(value="plu") String var5, @Bind(value="ean") String var6, @Bind(value="storeCardsId") Long var7, @Bind(value="dateStarted") Date var8, @Bind(value="dateFinished") Date var9, @Bind(value="quantity") Double var10, @Bind(value="newQuantity") Double var11, @Bind(value="note") String var12, @Bind(value="dateCreated") Date var13);

    @SqlUpdate(value="INSERT INTO app.stocktaking_items (stocktaking_id, partner_id, plu, ean, store_cards_id, date_started, date_finished, quantity, new_quantity, note, date_created) VALUES (:e.stocktakingId, :e.partnerId, :e.plu, :e.ean, :e.storeCardsId, :e.dateStarted, :e.dateFinished, :e.quantity, :e.newQuantity, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") StocktakingItemsDomain var1);

    @SqlUpdate(value="UPDATE app.stocktaking_items SET id = :e.id, uid = :e.uid, stocktaking_id = :e.stocktakingId, partner_id = :e.partnerId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, date_started = :e.dateStarted, date_finished = :e.dateFinished, quantity = :e.quantity, new_quantity = :e.newQuantity, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") StocktakingItemsDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE app.stocktaking_items SET id = :e.id, uid = :e.uid, stocktaking_id = :e.stocktakingId, partner_id = :e.partnerId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, date_started = :e.dateStarted, date_finished = :e.dateFinished, quantity = :e.quantity, new_quantity = :e.newQuantity, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") StocktakingItemsDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE app.stocktaking_items SET id = :e.id, uid = :e.uid, stocktaking_id = :e.stocktakingId, partner_id = :e.partnerId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, date_started = :e.dateStarted, date_finished = :e.dateFinished, quantity = :e.quantity, new_quantity = :e.newQuantity, note = :e.note, date_created = :e.dateCreated WHERE stocktaking_id = :byStocktakingId")
    public int updateByStocktakingId(@BindBean(value="e") StocktakingItemsDomain var1, @Bind(value="byStocktakingId") Long var2);

    @SqlUpdate(value="UPDATE app.stocktaking_items SET id = :e.id, uid = :e.uid, stocktaking_id = :e.stocktakingId, partner_id = :e.partnerId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, date_started = :e.dateStarted, date_finished = :e.dateFinished, quantity = :e.quantity, new_quantity = :e.newQuantity, note = :e.note, date_created = :e.dateCreated WHERE partner_id = :byPartnerId")
    public int updateByPartnerId(@BindBean(value="e") StocktakingItemsDomain var1, @Bind(value="byPartnerId") Long var2);

    @SqlUpdate(value="UPDATE app.stocktaking_items SET id = :e.id, uid = :e.uid, stocktaking_id = :e.stocktakingId, partner_id = :e.partnerId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, date_started = :e.dateStarted, date_finished = :e.dateFinished, quantity = :e.quantity, new_quantity = :e.newQuantity, note = :e.note, date_created = :e.dateCreated WHERE plu = :byPlu")
    public int updateByPlu(@BindBean(value="e") StocktakingItemsDomain var1, @Bind(value="byPlu") String var2);

    @SqlUpdate(value="UPDATE app.stocktaking_items SET id = :e.id, uid = :e.uid, stocktaking_id = :e.stocktakingId, partner_id = :e.partnerId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, date_started = :e.dateStarted, date_finished = :e.dateFinished, quantity = :e.quantity, new_quantity = :e.newQuantity, note = :e.note, date_created = :e.dateCreated WHERE ean = :byEan")
    public int updateByEan(@BindBean(value="e") StocktakingItemsDomain var1, @Bind(value="byEan") String var2);

    @SqlUpdate(value="UPDATE app.stocktaking_items SET id = :e.id, uid = :e.uid, stocktaking_id = :e.stocktakingId, partner_id = :e.partnerId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, date_started = :e.dateStarted, date_finished = :e.dateFinished, quantity = :e.quantity, new_quantity = :e.newQuantity, note = :e.note, date_created = :e.dateCreated WHERE store_cards_id = :byStoreCardsId")
    public int updateByStoreCardsId(@BindBean(value="e") StocktakingItemsDomain var1, @Bind(value="byStoreCardsId") Long var2);

    @SqlUpdate(value="UPDATE app.stocktaking_items SET id = :e.id, uid = :e.uid, stocktaking_id = :e.stocktakingId, partner_id = :e.partnerId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, date_started = :e.dateStarted, date_finished = :e.dateFinished, quantity = :e.quantity, new_quantity = :e.newQuantity, note = :e.note, date_created = :e.dateCreated WHERE date_started = :byDateStarted")
    public int updateByDateStarted(@BindBean(value="e") StocktakingItemsDomain var1, @Bind(value="byDateStarted") Date var2);

    @SqlUpdate(value="UPDATE app.stocktaking_items SET id = :e.id, uid = :e.uid, stocktaking_id = :e.stocktakingId, partner_id = :e.partnerId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, date_started = :e.dateStarted, date_finished = :e.dateFinished, quantity = :e.quantity, new_quantity = :e.newQuantity, note = :e.note, date_created = :e.dateCreated WHERE date_finished = :byDateFinished")
    public int updateByDateFinished(@BindBean(value="e") StocktakingItemsDomain var1, @Bind(value="byDateFinished") Date var2);

    @SqlUpdate(value="UPDATE app.stocktaking_items SET id = :e.id, uid = :e.uid, stocktaking_id = :e.stocktakingId, partner_id = :e.partnerId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, date_started = :e.dateStarted, date_finished = :e.dateFinished, quantity = :e.quantity, new_quantity = :e.newQuantity, note = :e.note, date_created = :e.dateCreated WHERE quantity = :byQuantity")
    public int updateByQuantity(@BindBean(value="e") StocktakingItemsDomain var1, @Bind(value="byQuantity") Double var2);

    @SqlUpdate(value="UPDATE app.stocktaking_items SET id = :e.id, uid = :e.uid, stocktaking_id = :e.stocktakingId, partner_id = :e.partnerId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, date_started = :e.dateStarted, date_finished = :e.dateFinished, quantity = :e.quantity, new_quantity = :e.newQuantity, note = :e.note, date_created = :e.dateCreated WHERE new_quantity = :byNewQuantity")
    public int updateByNewQuantity(@BindBean(value="e") StocktakingItemsDomain var1, @Bind(value="byNewQuantity") Double var2);

    @SqlUpdate(value="UPDATE app.stocktaking_items SET id = :e.id, uid = :e.uid, stocktaking_id = :e.stocktakingId, partner_id = :e.partnerId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, date_started = :e.dateStarted, date_finished = :e.dateFinished, quantity = :e.quantity, new_quantity = :e.newQuantity, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") StocktakingItemsDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE app.stocktaking_items SET id = :e.id, uid = :e.uid, stocktaking_id = :e.stocktakingId, partner_id = :e.partnerId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, date_started = :e.dateStarted, date_finished = :e.dateFinished, quantity = :e.quantity, new_quantity = :e.newQuantity, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") StocktakingItemsDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM app.stocktaking_items WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM app.stocktaking_items WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM app.stocktaking_items WHERE stocktaking_id = :stocktakingId")
    public int deleteByStocktakingId(@Bind(value="stocktakingId") Long var1);

    @SqlUpdate(value="DELETE FROM app.stocktaking_items WHERE partner_id = :partnerId")
    public int deleteByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlUpdate(value="DELETE FROM app.stocktaking_items WHERE plu = :plu")
    public int deleteByPlu(@Bind(value="plu") String var1);

    @SqlUpdate(value="DELETE FROM app.stocktaking_items WHERE ean = :ean")
    public int deleteByEan(@Bind(value="ean") String var1);

    @SqlUpdate(value="DELETE FROM app.stocktaking_items WHERE store_cards_id = :storeCardsId")
    public int deleteByStoreCardsId(@Bind(value="storeCardsId") Long var1);

    @SqlUpdate(value="DELETE FROM app.stocktaking_items WHERE date_started = :dateStarted")
    public int deleteByDateStarted(@Bind(value="dateStarted") Date var1);

    @SqlUpdate(value="DELETE FROM app.stocktaking_items WHERE date_finished = :dateFinished")
    public int deleteByDateFinished(@Bind(value="dateFinished") Date var1);

    @SqlUpdate(value="DELETE FROM app.stocktaking_items WHERE quantity = :quantity")
    public int deleteByQuantity(@Bind(value="quantity") Double var1);

    @SqlUpdate(value="DELETE FROM app.stocktaking_items WHERE new_quantity = :newQuantity")
    public int deleteByNewQuantity(@Bind(value="newQuantity") Double var1);

    @SqlUpdate(value="DELETE FROM app.stocktaking_items WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM app.stocktaking_items WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

