/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.PartnerRecordProcessedMapper;
import cz.airtoy.airshop.domains.PartnerRecordProcessedDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface PartnerRecordProcessedDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.partner_id,\n\t\tp.object,\n\t\tp.object_id,\n\t\tp.read,\n\t\tp.processed,\n\t\tp.date_created\n FROM \n\t\tadm.partner_record_processed p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.partner_id::text ~* :mask \n\tOR \n\t\tp.object::text ~* :mask \n\tOR \n\t\tp.object_id::text ~* :mask \n\tOR \n\t\tp.read::text ~* :mask \n\tOR \n\t\tp.processed::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=PartnerRecordProcessedMapper.class)
    public List<PartnerRecordProcessedDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tadm.partner_record_processed p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.partner_id::text ~* :mask \n\tOR \n\t\tp.object::text ~* :mask \n\tOR \n\t\tp.object_id::text ~* :mask \n\tOR \n\t\tp.read::text ~* :mask \n\tOR \n\t\tp.processed::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.object, p.object_id, p.read, p.processed, p.date_created FROM adm.partner_record_processed p  ")
    @RegisterRowMapper(value=PartnerRecordProcessedMapper.class)
    public List<PartnerRecordProcessedDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.object, p.object_id, p.read, p.processed, p.date_created FROM adm.partner_record_processed p  WHERE p.id = :id")
    @RegisterRowMapper(value=PartnerRecordProcessedMapper.class)
    public PartnerRecordProcessedDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.object, p.object_id, p.read, p.processed, p.date_created FROM adm.partner_record_processed p  WHERE p.id = :id")
    @RegisterRowMapper(value=PartnerRecordProcessedMapper.class)
    public List<PartnerRecordProcessedDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM adm.partner_record_processed p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.object, p.object_id, p.read, p.processed, p.date_created FROM adm.partner_record_processed p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=PartnerRecordProcessedMapper.class)
    public List<PartnerRecordProcessedDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.object, p.object_id, p.read, p.processed, p.date_created FROM adm.partner_record_processed p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=PartnerRecordProcessedMapper.class)
    public PartnerRecordProcessedDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.object, p.object_id, p.read, p.processed, p.date_created FROM adm.partner_record_processed p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=PartnerRecordProcessedMapper.class)
    public List<PartnerRecordProcessedDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM adm.partner_record_processed p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.object, p.object_id, p.read, p.processed, p.date_created FROM adm.partner_record_processed p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=PartnerRecordProcessedMapper.class)
    public List<PartnerRecordProcessedDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.object, p.object_id, p.read, p.processed, p.date_created FROM adm.partner_record_processed p  WHERE p.partner_id = :partnerId")
    @RegisterRowMapper(value=PartnerRecordProcessedMapper.class)
    public PartnerRecordProcessedDomain findByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.object, p.object_id, p.read, p.processed, p.date_created FROM adm.partner_record_processed p  WHERE p.partner_id = :partnerId")
    @RegisterRowMapper(value=PartnerRecordProcessedMapper.class)
    public List<PartnerRecordProcessedDomain> findListByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM adm.partner_record_processed p  WHERE p.partner_id = :partnerId")
    public long findListByPartnerIdCount(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.object, p.object_id, p.read, p.processed, p.date_created FROM adm.partner_record_processed p  WHERE p.partner_id = :partnerId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=PartnerRecordProcessedMapper.class)
    public List<PartnerRecordProcessedDomain> findListByPartnerId(@Bind(value="partnerId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.object, p.object_id, p.read, p.processed, p.date_created FROM adm.partner_record_processed p  WHERE p.object = :object")
    @RegisterRowMapper(value=PartnerRecordProcessedMapper.class)
    public PartnerRecordProcessedDomain findByObject(@Bind(value="object") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.object, p.object_id, p.read, p.processed, p.date_created FROM adm.partner_record_processed p  WHERE p.object = :object")
    @RegisterRowMapper(value=PartnerRecordProcessedMapper.class)
    public List<PartnerRecordProcessedDomain> findListByObject(@Bind(value="object") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM adm.partner_record_processed p  WHERE p.object = :object")
    public long findListByObjectCount(@Bind(value="object") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.object, p.object_id, p.read, p.processed, p.date_created FROM adm.partner_record_processed p  WHERE p.object = :object ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=PartnerRecordProcessedMapper.class)
    public List<PartnerRecordProcessedDomain> findListByObject(@Bind(value="object") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.object, p.object_id, p.read, p.processed, p.date_created FROM adm.partner_record_processed p  WHERE p.object_id = :objectId")
    @RegisterRowMapper(value=PartnerRecordProcessedMapper.class)
    public PartnerRecordProcessedDomain findByObjectId(@Bind(value="objectId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.object, p.object_id, p.read, p.processed, p.date_created FROM adm.partner_record_processed p  WHERE p.object_id = :objectId")
    @RegisterRowMapper(value=PartnerRecordProcessedMapper.class)
    public List<PartnerRecordProcessedDomain> findListByObjectId(@Bind(value="objectId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM adm.partner_record_processed p  WHERE p.object_id = :objectId")
    public long findListByObjectIdCount(@Bind(value="objectId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.object, p.object_id, p.read, p.processed, p.date_created FROM adm.partner_record_processed p  WHERE p.object_id = :objectId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=PartnerRecordProcessedMapper.class)
    public List<PartnerRecordProcessedDomain> findListByObjectId(@Bind(value="objectId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.object, p.object_id, p.read, p.processed, p.date_created FROM adm.partner_record_processed p  WHERE p.read = :read")
    @RegisterRowMapper(value=PartnerRecordProcessedMapper.class)
    public PartnerRecordProcessedDomain findByRead(@Bind(value="read") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.object, p.object_id, p.read, p.processed, p.date_created FROM adm.partner_record_processed p  WHERE p.read = :read")
    @RegisterRowMapper(value=PartnerRecordProcessedMapper.class)
    public List<PartnerRecordProcessedDomain> findListByRead(@Bind(value="read") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM adm.partner_record_processed p  WHERE p.read = :read")
    public long findListByReadCount(@Bind(value="read") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.object, p.object_id, p.read, p.processed, p.date_created FROM adm.partner_record_processed p  WHERE p.read = :read ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=PartnerRecordProcessedMapper.class)
    public List<PartnerRecordProcessedDomain> findListByRead(@Bind(value="read") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.object, p.object_id, p.read, p.processed, p.date_created FROM adm.partner_record_processed p  WHERE p.processed = :processed")
    @RegisterRowMapper(value=PartnerRecordProcessedMapper.class)
    public PartnerRecordProcessedDomain findByProcessed(@Bind(value="processed") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.object, p.object_id, p.read, p.processed, p.date_created FROM adm.partner_record_processed p  WHERE p.processed = :processed")
    @RegisterRowMapper(value=PartnerRecordProcessedMapper.class)
    public List<PartnerRecordProcessedDomain> findListByProcessed(@Bind(value="processed") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM adm.partner_record_processed p  WHERE p.processed = :processed")
    public long findListByProcessedCount(@Bind(value="processed") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.object, p.object_id, p.read, p.processed, p.date_created FROM adm.partner_record_processed p  WHERE p.processed = :processed ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=PartnerRecordProcessedMapper.class)
    public List<PartnerRecordProcessedDomain> findListByProcessed(@Bind(value="processed") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.object, p.object_id, p.read, p.processed, p.date_created FROM adm.partner_record_processed p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=PartnerRecordProcessedMapper.class)
    public PartnerRecordProcessedDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.object, p.object_id, p.read, p.processed, p.date_created FROM adm.partner_record_processed p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=PartnerRecordProcessedMapper.class)
    public List<PartnerRecordProcessedDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM adm.partner_record_processed p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.partner_id, p.object, p.object_id, p.read, p.processed, p.date_created FROM adm.partner_record_processed p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=PartnerRecordProcessedMapper.class)
    public List<PartnerRecordProcessedDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO adm.partner_record_processed (id, uid, partner_id, object, object_id, read, processed, date_created) VALUES (:id, :uid, :partnerId, :object, :objectId, :read, :processed, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="partnerId") Long var3, @Bind(value="object") String var4, @Bind(value="objectId") Long var5, @Bind(value="read") Date var6, @Bind(value="processed") Date var7, @Bind(value="dateCreated") Date var8);

    @SqlUpdate(value="INSERT INTO adm.partner_record_processed (partner_id, object, object_id, read, processed, date_created) VALUES (:e.partnerId, :e.object, :e.objectId, :e.read, :e.processed, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") PartnerRecordProcessedDomain var1);

    @SqlUpdate(value="UPDATE adm.partner_record_processed SET id = :e.id, uid = :e.uid, partner_id = :e.partnerId, object = :e.object, object_id = :e.objectId, read = :e.read, processed = :e.processed, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") PartnerRecordProcessedDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE adm.partner_record_processed SET id = :e.id, uid = :e.uid, partner_id = :e.partnerId, object = :e.object, object_id = :e.objectId, read = :e.read, processed = :e.processed, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") PartnerRecordProcessedDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE adm.partner_record_processed SET id = :e.id, uid = :e.uid, partner_id = :e.partnerId, object = :e.object, object_id = :e.objectId, read = :e.read, processed = :e.processed, date_created = :e.dateCreated WHERE partner_id = :byPartnerId")
    public int updateByPartnerId(@BindBean(value="e") PartnerRecordProcessedDomain var1, @Bind(value="byPartnerId") Long var2);

    @SqlUpdate(value="UPDATE adm.partner_record_processed SET id = :e.id, uid = :e.uid, partner_id = :e.partnerId, object = :e.object, object_id = :e.objectId, read = :e.read, processed = :e.processed, date_created = :e.dateCreated WHERE object = :byObject")
    public int updateByObject(@BindBean(value="e") PartnerRecordProcessedDomain var1, @Bind(value="byObject") String var2);

    @SqlUpdate(value="UPDATE adm.partner_record_processed SET id = :e.id, uid = :e.uid, partner_id = :e.partnerId, object = :e.object, object_id = :e.objectId, read = :e.read, processed = :e.processed, date_created = :e.dateCreated WHERE object_id = :byObjectId")
    public int updateByObjectId(@BindBean(value="e") PartnerRecordProcessedDomain var1, @Bind(value="byObjectId") Long var2);

    @SqlUpdate(value="UPDATE adm.partner_record_processed SET id = :e.id, uid = :e.uid, partner_id = :e.partnerId, object = :e.object, object_id = :e.objectId, read = :e.read, processed = :e.processed, date_created = :e.dateCreated WHERE read = :byRead")
    public int updateByRead(@BindBean(value="e") PartnerRecordProcessedDomain var1, @Bind(value="byRead") Date var2);

    @SqlUpdate(value="UPDATE adm.partner_record_processed SET id = :e.id, uid = :e.uid, partner_id = :e.partnerId, object = :e.object, object_id = :e.objectId, read = :e.read, processed = :e.processed, date_created = :e.dateCreated WHERE processed = :byProcessed")
    public int updateByProcessed(@BindBean(value="e") PartnerRecordProcessedDomain var1, @Bind(value="byProcessed") Date var2);

    @SqlUpdate(value="UPDATE adm.partner_record_processed SET id = :e.id, uid = :e.uid, partner_id = :e.partnerId, object = :e.object, object_id = :e.objectId, read = :e.read, processed = :e.processed, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") PartnerRecordProcessedDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM adm.partner_record_processed WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM adm.partner_record_processed WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM adm.partner_record_processed WHERE partner_id = :partnerId")
    public int deleteByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlUpdate(value="DELETE FROM adm.partner_record_processed WHERE object = :object")
    public int deleteByObject(@Bind(value="object") String var1);

    @SqlUpdate(value="DELETE FROM adm.partner_record_processed WHERE object_id = :objectId")
    public int deleteByObjectId(@Bind(value="objectId") Long var1);

    @SqlUpdate(value="DELETE FROM adm.partner_record_processed WHERE read = :read")
    public int deleteByRead(@Bind(value="read") Date var1);

    @SqlUpdate(value="DELETE FROM adm.partner_record_processed WHERE processed = :processed")
    public int deleteByProcessed(@Bind(value="processed") Date var1);

    @SqlUpdate(value="DELETE FROM adm.partner_record_processed WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

