/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.BottleTypeMapper;
import cz.airtoy.airshop.domains.BottleTypeDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface BottleTypeDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.name,\n\t\tp.description,\n\t\tp.volume,\n\t\tp.material,\n\t\tp.recycle,\n\t\tp.store_card_id,\n\t\tp.recycle_definitions_id,\n\t\tp.x_dimension,\n\t\tp.y_dimension,\n\t\tp.z_dimension,\n\t\tp.image,\n\t\tp.url,\n\t\tp.ean,\n\t\tp.store_id,\n\t\tp.note,\n\t\tp.updated,\n\t\tp.date_created\n FROM \n\t\tabra.bottle_type p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.volume::text ~* :mask \n\tOR \n\t\tp.material::text ~* :mask \n\tOR \n\t\tp.recycle::text ~* :mask \n\tOR \n\t\tp.store_card_id::text ~* :mask \n\tOR \n\t\tp.recycle_definitions_id::text ~* :mask \n\tOR \n\t\tp.x_dimension::text ~* :mask \n\tOR \n\t\tp.y_dimension::text ~* :mask \n\tOR \n\t\tp.z_dimension::text ~* :mask \n\tOR \n\t\tp.image::text ~* :mask \n\tOR \n\t\tp.url::text ~* :mask \n\tOR \n\t\tp.ean::text ~* :mask \n\tOR \n\t\tp.store_id::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.updated::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tabra.bottle_type p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.volume::text ~* :mask \n\tOR \n\t\tp.material::text ~* :mask \n\tOR \n\t\tp.recycle::text ~* :mask \n\tOR \n\t\tp.store_card_id::text ~* :mask \n\tOR \n\t\tp.recycle_definitions_id::text ~* :mask \n\tOR \n\t\tp.x_dimension::text ~* :mask \n\tOR \n\t\tp.y_dimension::text ~* :mask \n\tOR \n\t\tp.z_dimension::text ~* :mask \n\tOR \n\t\tp.image::text ~* :mask \n\tOR \n\t\tp.url::text ~* :mask \n\tOR \n\t\tp.ean::text ~* :mask \n\tOR \n\t\tp.store_id::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.updated::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  ")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.id = :id")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public BottleTypeDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.id = :id")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.bottle_type p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public BottleTypeDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.bottle_type p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.name = :name")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public BottleTypeDomain findByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.name = :name")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.bottle_type p  WHERE p.name = :name")
    public long findListByNameCount(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.name = :name ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByName(@Bind(value="name") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.description = :description")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public BottleTypeDomain findByDescription(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.description = :description")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByDescription(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.bottle_type p  WHERE p.description = :description")
    public long findListByDescriptionCount(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.description = :description ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByDescription(@Bind(value="description") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.volume = :volume")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public BottleTypeDomain findByVolume(@Bind(value="volume") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.volume = :volume")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByVolume(@Bind(value="volume") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.bottle_type p  WHERE p.volume = :volume")
    public long findListByVolumeCount(@Bind(value="volume") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.volume = :volume ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByVolume(@Bind(value="volume") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.material = :material")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public BottleTypeDomain findByMaterial(@Bind(value="material") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.material = :material")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByMaterial(@Bind(value="material") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.bottle_type p  WHERE p.material = :material")
    public long findListByMaterialCount(@Bind(value="material") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.material = :material ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByMaterial(@Bind(value="material") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.recycle = :recycle")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public BottleTypeDomain findByRecycle(@Bind(value="recycle") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.recycle = :recycle")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByRecycle(@Bind(value="recycle") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.bottle_type p  WHERE p.recycle = :recycle")
    public long findListByRecycleCount(@Bind(value="recycle") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.recycle = :recycle ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByRecycle(@Bind(value="recycle") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.store_card_id = :storeCardId")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public BottleTypeDomain findByStoreCardId(@Bind(value="storeCardId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.store_card_id = :storeCardId")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByStoreCardId(@Bind(value="storeCardId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.bottle_type p  WHERE p.store_card_id = :storeCardId")
    public long findListByStoreCardIdCount(@Bind(value="storeCardId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.store_card_id = :storeCardId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByStoreCardId(@Bind(value="storeCardId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.recycle_definitions_id = :recycleDefinitionsId")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public BottleTypeDomain findByRecycleDefinitionsId(@Bind(value="recycleDefinitionsId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.recycle_definitions_id = :recycleDefinitionsId")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByRecycleDefinitionsId(@Bind(value="recycleDefinitionsId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.bottle_type p  WHERE p.recycle_definitions_id = :recycleDefinitionsId")
    public long findListByRecycleDefinitionsIdCount(@Bind(value="recycleDefinitionsId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.recycle_definitions_id = :recycleDefinitionsId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByRecycleDefinitionsId(@Bind(value="recycleDefinitionsId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.x_dimension = :xDimension")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public BottleTypeDomain findByXDimension(@Bind(value="xDimension") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.x_dimension = :xDimension")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByXDimension(@Bind(value="xDimension") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.bottle_type p  WHERE p.x_dimension = :xDimension")
    public long findListByXDimensionCount(@Bind(value="xDimension") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.x_dimension = :xDimension ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByXDimension(@Bind(value="xDimension") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.y_dimension = :yDimension")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public BottleTypeDomain findByYDimension(@Bind(value="yDimension") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.y_dimension = :yDimension")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByYDimension(@Bind(value="yDimension") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.bottle_type p  WHERE p.y_dimension = :yDimension")
    public long findListByYDimensionCount(@Bind(value="yDimension") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.y_dimension = :yDimension ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByYDimension(@Bind(value="yDimension") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.z_dimension = :zDimension")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public BottleTypeDomain findByZDimension(@Bind(value="zDimension") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.z_dimension = :zDimension")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByZDimension(@Bind(value="zDimension") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.bottle_type p  WHERE p.z_dimension = :zDimension")
    public long findListByZDimensionCount(@Bind(value="zDimension") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.z_dimension = :zDimension ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByZDimension(@Bind(value="zDimension") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.image = :image")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public BottleTypeDomain findByImage(@Bind(value="image") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.image = :image")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByImage(@Bind(value="image") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.bottle_type p  WHERE p.image = :image")
    public long findListByImageCount(@Bind(value="image") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.image = :image ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByImage(@Bind(value="image") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.url = :url")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public BottleTypeDomain findByUrl(@Bind(value="url") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.url = :url")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByUrl(@Bind(value="url") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.bottle_type p  WHERE p.url = :url")
    public long findListByUrlCount(@Bind(value="url") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.url = :url ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByUrl(@Bind(value="url") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.ean = :ean")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public BottleTypeDomain findByEan(@Bind(value="ean") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.ean = :ean")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByEan(@Bind(value="ean") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.bottle_type p  WHERE p.ean = :ean")
    public long findListByEanCount(@Bind(value="ean") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.ean = :ean ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByEan(@Bind(value="ean") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.store_id = :storeId")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public BottleTypeDomain findByStoreId(@Bind(value="storeId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.store_id = :storeId")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByStoreId(@Bind(value="storeId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.bottle_type p  WHERE p.store_id = :storeId")
    public long findListByStoreIdCount(@Bind(value="storeId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.store_id = :storeId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByStoreId(@Bind(value="storeId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.note = :note")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public BottleTypeDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.note = :note")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.bottle_type p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.updated = :updated")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public BottleTypeDomain findByUpdated(@Bind(value="updated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.updated = :updated")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByUpdated(@Bind(value="updated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.bottle_type p  WHERE p.updated = :updated")
    public long findListByUpdatedCount(@Bind(value="updated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.updated = :updated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByUpdated(@Bind(value="updated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public BottleTypeDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.bottle_type p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.description, p.volume, p.material, p.recycle, p.store_card_id, p.recycle_definitions_id, p.x_dimension, p.y_dimension, p.z_dimension, p.image, p.url, p.ean, p.store_id, p.note, p.updated, p.date_created FROM abra.bottle_type p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BottleTypeMapper.class)
    public List<BottleTypeDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO abra.bottle_type (id, uid, name, description, volume, material, recycle, store_card_id, recycle_definitions_id, x_dimension, y_dimension, z_dimension, image, url, ean, store_id, note, updated, date_created) VALUES (:id, :uid, :name, :description, :volume, :material, :recycle, :storeCardId, :recycleDefinitionsId, :xDimension, :yDimension, :zDimension, :image, :url, :ean, :storeId, :note, :updated, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="name") String var3, @Bind(value="description") String var4, @Bind(value="volume") Double var5, @Bind(value="material") String var6, @Bind(value="recycle") Integer var7, @Bind(value="storeCardId") Long var8, @Bind(value="recycleDefinitionsId") Long var9, @Bind(value="xDimension") Double var10, @Bind(value="yDimension") Double var11, @Bind(value="zDimension") Double var12, @Bind(value="image") String var13, @Bind(value="url") String var14, @Bind(value="ean") String var15, @Bind(value="storeId") Long var16, @Bind(value="note") String var17, @Bind(value="updated") Date var18, @Bind(value="dateCreated") Date var19);

    @SqlUpdate(value="INSERT INTO abra.bottle_type (name, description, volume, material, recycle, store_card_id, recycle_definitions_id, x_dimension, y_dimension, z_dimension, image, url, ean, store_id, note, updated, date_created) VALUES (:e.name, :e.description, :e.volume, :e.material, :e.recycle, :e.storeCardId, :e.recycleDefinitionsId, :e.xDimension, :e.yDimension, :e.zDimension, :e.image, :e.url, :e.ean, :e.storeId, :e.note, :e.updated, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") BottleTypeDomain var1);

    @SqlUpdate(value="UPDATE abra.bottle_type SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, volume = :e.volume, material = :e.material, recycle = :e.recycle, store_card_id = :e.storeCardId, recycle_definitions_id = :e.recycleDefinitionsId, x_dimension = :e.xDimension, y_dimension = :e.yDimension, z_dimension = :e.zDimension, image = :e.image, url = :e.url, ean = :e.ean, store_id = :e.storeId, note = :e.note, updated = :e.updated, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") BottleTypeDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE abra.bottle_type SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, volume = :e.volume, material = :e.material, recycle = :e.recycle, store_card_id = :e.storeCardId, recycle_definitions_id = :e.recycleDefinitionsId, x_dimension = :e.xDimension, y_dimension = :e.yDimension, z_dimension = :e.zDimension, image = :e.image, url = :e.url, ean = :e.ean, store_id = :e.storeId, note = :e.note, updated = :e.updated, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") BottleTypeDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE abra.bottle_type SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, volume = :e.volume, material = :e.material, recycle = :e.recycle, store_card_id = :e.storeCardId, recycle_definitions_id = :e.recycleDefinitionsId, x_dimension = :e.xDimension, y_dimension = :e.yDimension, z_dimension = :e.zDimension, image = :e.image, url = :e.url, ean = :e.ean, store_id = :e.storeId, note = :e.note, updated = :e.updated, date_created = :e.dateCreated WHERE name = :byName")
    public int updateByName(@BindBean(value="e") BottleTypeDomain var1, @Bind(value="byName") String var2);

    @SqlUpdate(value="UPDATE abra.bottle_type SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, volume = :e.volume, material = :e.material, recycle = :e.recycle, store_card_id = :e.storeCardId, recycle_definitions_id = :e.recycleDefinitionsId, x_dimension = :e.xDimension, y_dimension = :e.yDimension, z_dimension = :e.zDimension, image = :e.image, url = :e.url, ean = :e.ean, store_id = :e.storeId, note = :e.note, updated = :e.updated, date_created = :e.dateCreated WHERE description = :byDescription")
    public int updateByDescription(@BindBean(value="e") BottleTypeDomain var1, @Bind(value="byDescription") String var2);

    @SqlUpdate(value="UPDATE abra.bottle_type SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, volume = :e.volume, material = :e.material, recycle = :e.recycle, store_card_id = :e.storeCardId, recycle_definitions_id = :e.recycleDefinitionsId, x_dimension = :e.xDimension, y_dimension = :e.yDimension, z_dimension = :e.zDimension, image = :e.image, url = :e.url, ean = :e.ean, store_id = :e.storeId, note = :e.note, updated = :e.updated, date_created = :e.dateCreated WHERE volume = :byVolume")
    public int updateByVolume(@BindBean(value="e") BottleTypeDomain var1, @Bind(value="byVolume") Double var2);

    @SqlUpdate(value="UPDATE abra.bottle_type SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, volume = :e.volume, material = :e.material, recycle = :e.recycle, store_card_id = :e.storeCardId, recycle_definitions_id = :e.recycleDefinitionsId, x_dimension = :e.xDimension, y_dimension = :e.yDimension, z_dimension = :e.zDimension, image = :e.image, url = :e.url, ean = :e.ean, store_id = :e.storeId, note = :e.note, updated = :e.updated, date_created = :e.dateCreated WHERE material = :byMaterial")
    public int updateByMaterial(@BindBean(value="e") BottleTypeDomain var1, @Bind(value="byMaterial") String var2);

    @SqlUpdate(value="UPDATE abra.bottle_type SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, volume = :e.volume, material = :e.material, recycle = :e.recycle, store_card_id = :e.storeCardId, recycle_definitions_id = :e.recycleDefinitionsId, x_dimension = :e.xDimension, y_dimension = :e.yDimension, z_dimension = :e.zDimension, image = :e.image, url = :e.url, ean = :e.ean, store_id = :e.storeId, note = :e.note, updated = :e.updated, date_created = :e.dateCreated WHERE recycle = :byRecycle")
    public int updateByRecycle(@BindBean(value="e") BottleTypeDomain var1, @Bind(value="byRecycle") Integer var2);

    @SqlUpdate(value="UPDATE abra.bottle_type SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, volume = :e.volume, material = :e.material, recycle = :e.recycle, store_card_id = :e.storeCardId, recycle_definitions_id = :e.recycleDefinitionsId, x_dimension = :e.xDimension, y_dimension = :e.yDimension, z_dimension = :e.zDimension, image = :e.image, url = :e.url, ean = :e.ean, store_id = :e.storeId, note = :e.note, updated = :e.updated, date_created = :e.dateCreated WHERE store_card_id = :byStoreCardId")
    public int updateByStoreCardId(@BindBean(value="e") BottleTypeDomain var1, @Bind(value="byStoreCardId") Long var2);

    @SqlUpdate(value="UPDATE abra.bottle_type SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, volume = :e.volume, material = :e.material, recycle = :e.recycle, store_card_id = :e.storeCardId, recycle_definitions_id = :e.recycleDefinitionsId, x_dimension = :e.xDimension, y_dimension = :e.yDimension, z_dimension = :e.zDimension, image = :e.image, url = :e.url, ean = :e.ean, store_id = :e.storeId, note = :e.note, updated = :e.updated, date_created = :e.dateCreated WHERE recycle_definitions_id = :byRecycleDefinitionsId")
    public int updateByRecycleDefinitionsId(@BindBean(value="e") BottleTypeDomain var1, @Bind(value="byRecycleDefinitionsId") Long var2);

    @SqlUpdate(value="UPDATE abra.bottle_type SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, volume = :e.volume, material = :e.material, recycle = :e.recycle, store_card_id = :e.storeCardId, recycle_definitions_id = :e.recycleDefinitionsId, x_dimension = :e.xDimension, y_dimension = :e.yDimension, z_dimension = :e.zDimension, image = :e.image, url = :e.url, ean = :e.ean, store_id = :e.storeId, note = :e.note, updated = :e.updated, date_created = :e.dateCreated WHERE x_dimension = :byXDimension")
    public int updateByXDimension(@BindBean(value="e") BottleTypeDomain var1, @Bind(value="byXDimension") Double var2);

    @SqlUpdate(value="UPDATE abra.bottle_type SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, volume = :e.volume, material = :e.material, recycle = :e.recycle, store_card_id = :e.storeCardId, recycle_definitions_id = :e.recycleDefinitionsId, x_dimension = :e.xDimension, y_dimension = :e.yDimension, z_dimension = :e.zDimension, image = :e.image, url = :e.url, ean = :e.ean, store_id = :e.storeId, note = :e.note, updated = :e.updated, date_created = :e.dateCreated WHERE y_dimension = :byYDimension")
    public int updateByYDimension(@BindBean(value="e") BottleTypeDomain var1, @Bind(value="byYDimension") Double var2);

    @SqlUpdate(value="UPDATE abra.bottle_type SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, volume = :e.volume, material = :e.material, recycle = :e.recycle, store_card_id = :e.storeCardId, recycle_definitions_id = :e.recycleDefinitionsId, x_dimension = :e.xDimension, y_dimension = :e.yDimension, z_dimension = :e.zDimension, image = :e.image, url = :e.url, ean = :e.ean, store_id = :e.storeId, note = :e.note, updated = :e.updated, date_created = :e.dateCreated WHERE z_dimension = :byZDimension")
    public int updateByZDimension(@BindBean(value="e") BottleTypeDomain var1, @Bind(value="byZDimension") Double var2);

    @SqlUpdate(value="UPDATE abra.bottle_type SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, volume = :e.volume, material = :e.material, recycle = :e.recycle, store_card_id = :e.storeCardId, recycle_definitions_id = :e.recycleDefinitionsId, x_dimension = :e.xDimension, y_dimension = :e.yDimension, z_dimension = :e.zDimension, image = :e.image, url = :e.url, ean = :e.ean, store_id = :e.storeId, note = :e.note, updated = :e.updated, date_created = :e.dateCreated WHERE image = :byImage")
    public int updateByImage(@BindBean(value="e") BottleTypeDomain var1, @Bind(value="byImage") String var2);

    @SqlUpdate(value="UPDATE abra.bottle_type SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, volume = :e.volume, material = :e.material, recycle = :e.recycle, store_card_id = :e.storeCardId, recycle_definitions_id = :e.recycleDefinitionsId, x_dimension = :e.xDimension, y_dimension = :e.yDimension, z_dimension = :e.zDimension, image = :e.image, url = :e.url, ean = :e.ean, store_id = :e.storeId, note = :e.note, updated = :e.updated, date_created = :e.dateCreated WHERE url = :byUrl")
    public int updateByUrl(@BindBean(value="e") BottleTypeDomain var1, @Bind(value="byUrl") String var2);

    @SqlUpdate(value="UPDATE abra.bottle_type SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, volume = :e.volume, material = :e.material, recycle = :e.recycle, store_card_id = :e.storeCardId, recycle_definitions_id = :e.recycleDefinitionsId, x_dimension = :e.xDimension, y_dimension = :e.yDimension, z_dimension = :e.zDimension, image = :e.image, url = :e.url, ean = :e.ean, store_id = :e.storeId, note = :e.note, updated = :e.updated, date_created = :e.dateCreated WHERE ean = :byEan")
    public int updateByEan(@BindBean(value="e") BottleTypeDomain var1, @Bind(value="byEan") String var2);

    @SqlUpdate(value="UPDATE abra.bottle_type SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, volume = :e.volume, material = :e.material, recycle = :e.recycle, store_card_id = :e.storeCardId, recycle_definitions_id = :e.recycleDefinitionsId, x_dimension = :e.xDimension, y_dimension = :e.yDimension, z_dimension = :e.zDimension, image = :e.image, url = :e.url, ean = :e.ean, store_id = :e.storeId, note = :e.note, updated = :e.updated, date_created = :e.dateCreated WHERE store_id = :byStoreId")
    public int updateByStoreId(@BindBean(value="e") BottleTypeDomain var1, @Bind(value="byStoreId") Long var2);

    @SqlUpdate(value="UPDATE abra.bottle_type SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, volume = :e.volume, material = :e.material, recycle = :e.recycle, store_card_id = :e.storeCardId, recycle_definitions_id = :e.recycleDefinitionsId, x_dimension = :e.xDimension, y_dimension = :e.yDimension, z_dimension = :e.zDimension, image = :e.image, url = :e.url, ean = :e.ean, store_id = :e.storeId, note = :e.note, updated = :e.updated, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") BottleTypeDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE abra.bottle_type SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, volume = :e.volume, material = :e.material, recycle = :e.recycle, store_card_id = :e.storeCardId, recycle_definitions_id = :e.recycleDefinitionsId, x_dimension = :e.xDimension, y_dimension = :e.yDimension, z_dimension = :e.zDimension, image = :e.image, url = :e.url, ean = :e.ean, store_id = :e.storeId, note = :e.note, updated = :e.updated, date_created = :e.dateCreated WHERE updated = :byUpdated")
    public int updateByUpdated(@BindBean(value="e") BottleTypeDomain var1, @Bind(value="byUpdated") Date var2);

    @SqlUpdate(value="UPDATE abra.bottle_type SET id = :e.id, uid = :e.uid, name = :e.name, description = :e.description, volume = :e.volume, material = :e.material, recycle = :e.recycle, store_card_id = :e.storeCardId, recycle_definitions_id = :e.recycleDefinitionsId, x_dimension = :e.xDimension, y_dimension = :e.yDimension, z_dimension = :e.zDimension, image = :e.image, url = :e.url, ean = :e.ean, store_id = :e.storeId, note = :e.note, updated = :e.updated, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") BottleTypeDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM abra.bottle_type WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM abra.bottle_type WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM abra.bottle_type WHERE name = :name")
    public int deleteByName(@Bind(value="name") String var1);

    @SqlUpdate(value="DELETE FROM abra.bottle_type WHERE description = :description")
    public int deleteByDescription(@Bind(value="description") String var1);

    @SqlUpdate(value="DELETE FROM abra.bottle_type WHERE volume = :volume")
    public int deleteByVolume(@Bind(value="volume") Double var1);

    @SqlUpdate(value="DELETE FROM abra.bottle_type WHERE material = :material")
    public int deleteByMaterial(@Bind(value="material") String var1);

    @SqlUpdate(value="DELETE FROM abra.bottle_type WHERE recycle = :recycle")
    public int deleteByRecycle(@Bind(value="recycle") Integer var1);

    @SqlUpdate(value="DELETE FROM abra.bottle_type WHERE store_card_id = :storeCardId")
    public int deleteByStoreCardId(@Bind(value="storeCardId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.bottle_type WHERE recycle_definitions_id = :recycleDefinitionsId")
    public int deleteByRecycleDefinitionsId(@Bind(value="recycleDefinitionsId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.bottle_type WHERE x_dimension = :xDimension")
    public int deleteByXDimension(@Bind(value="xDimension") Double var1);

    @SqlUpdate(value="DELETE FROM abra.bottle_type WHERE y_dimension = :yDimension")
    public int deleteByYDimension(@Bind(value="yDimension") Double var1);

    @SqlUpdate(value="DELETE FROM abra.bottle_type WHERE z_dimension = :zDimension")
    public int deleteByZDimension(@Bind(value="zDimension") Double var1);

    @SqlUpdate(value="DELETE FROM abra.bottle_type WHERE image = :image")
    public int deleteByImage(@Bind(value="image") String var1);

    @SqlUpdate(value="DELETE FROM abra.bottle_type WHERE url = :url")
    public int deleteByUrl(@Bind(value="url") String var1);

    @SqlUpdate(value="DELETE FROM abra.bottle_type WHERE ean = :ean")
    public int deleteByEan(@Bind(value="ean") String var1);

    @SqlUpdate(value="DELETE FROM abra.bottle_type WHERE store_id = :storeId")
    public int deleteByStoreId(@Bind(value="storeId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.bottle_type WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM abra.bottle_type WHERE updated = :updated")
    public int deleteByUpdated(@Bind(value="updated") Date var1);

    @SqlUpdate(value="DELETE FROM abra.bottle_type WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

