/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.AirshopNotificationsMapper;
import cz.airtoy.airshop.domains.AirshopNotificationsDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface AirshopNotificationsDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.ident,\n\t\tp.status,\n\t\tp.type,\n\t\tp.body,\n\t\tp.abra_id,\n\t\tp.attempts,\n\t\tp.read,\n\t\tp.date_created\n FROM \n\t\tsystem.airshop_notifications p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.ident::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.type::text ~* :mask \n\tOR \n\t\tp.body::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.attempts::text ~* :mask \n\tOR \n\t\tp.read::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public List<AirshopNotificationsDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tsystem.airshop_notifications p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.ident::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.type::text ~* :mask \n\tOR \n\t\tp.body::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.attempts::text ~* :mask \n\tOR \n\t\tp.read::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p ORDER BY p.id DESC LIMIT 1")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public AirshopNotificationsDomain findNewest();

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.id = :id")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public AirshopNotificationsDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.id = :id")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public List<AirshopNotificationsDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.airshop_notifications p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public List<AirshopNotificationsDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public AirshopNotificationsDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public List<AirshopNotificationsDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.airshop_notifications p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public List<AirshopNotificationsDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.ident = :ident")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public AirshopNotificationsDomain findByIdent(@Bind(value="ident") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.ident = :ident")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public List<AirshopNotificationsDomain> findListByIdent(@Bind(value="ident") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.airshop_notifications p  WHERE p.ident = :ident")
    public long findListByIdentCount(@Bind(value="ident") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.airshop_notifications p  WHERE p.ident = :ident AND p.read IS NULL")
    public long findListByIdentUnreadCount(@Bind(value="ident") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.ident = :ident ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public List<AirshopNotificationsDomain> findListByIdent(@Bind(value="ident") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.ident = :ident AND p.read IS NULL ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public List<AirshopNotificationsDomain> findListByIdentUnread(@Bind(value="ident") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.status = :status")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public AirshopNotificationsDomain findByStatus(@Bind(value="status") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.status = :status")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public List<AirshopNotificationsDomain> findListByStatus(@Bind(value="status") Boolean var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.airshop_notifications p  WHERE p.status = :status")
    public long findListByStatusCount(@Bind(value="status") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.status = :status ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public List<AirshopNotificationsDomain> findListByStatus(@Bind(value="status") Boolean var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.type = :type")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public AirshopNotificationsDomain findByType(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.type = :type")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public List<AirshopNotificationsDomain> findListByType(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.airshop_notifications p  WHERE p.type = :type")
    public long findListByTypeCount(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.type = :type ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public List<AirshopNotificationsDomain> findListByType(@Bind(value="type") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.type = :type AND p.read IS NULL")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public List<AirshopNotificationsDomain> findListByTypeUnread(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.airshop_notifications p  WHERE p.type = :type AND p.read IS NULL")
    public long findListByTypeUnreadCount(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.type = :type AND p.read IS NULL ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public List<AirshopNotificationsDomain> findListByTypeUnread(@Bind(value="type") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.body = :body")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public AirshopNotificationsDomain findByBody(@Bind(value="body") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.body = :body")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public List<AirshopNotificationsDomain> findListByBody(@Bind(value="body") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.airshop_notifications p  WHERE p.body = :body")
    public long findListByBodyCount(@Bind(value="body") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.body = :body ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public List<AirshopNotificationsDomain> findListByBody(@Bind(value="body") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.abra_id = :abraId")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public AirshopNotificationsDomain findByAbraId(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.abra_id = :abraId")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public List<AirshopNotificationsDomain> findListByAbraId(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.airshop_notifications p  WHERE p.abra_id = :abraId")
    public long findListByAbraIdCount(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.abra_id = :abraId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public List<AirshopNotificationsDomain> findListByAbraId(@Bind(value="abraId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.attempts = :attempts")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public AirshopNotificationsDomain findByAttempts(@Bind(value="attempts") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.attempts = :attempts")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public List<AirshopNotificationsDomain> findListByAttempts(@Bind(value="attempts") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.airshop_notifications p  WHERE p.attempts = :attempts")
    public long findListByAttemptsCount(@Bind(value="attempts") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.attempts = :attempts ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public List<AirshopNotificationsDomain> findListByAttempts(@Bind(value="attempts") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.read = :read")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public AirshopNotificationsDomain findByRead(@Bind(value="read") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.read = :read")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public List<AirshopNotificationsDomain> findListByRead(@Bind(value="read") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.airshop_notifications p  WHERE p.read = :read")
    public long findListByReadCount(@Bind(value="read") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.read = :read ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public List<AirshopNotificationsDomain> findListByRead(@Bind(value="read") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public AirshopNotificationsDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public List<AirshopNotificationsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.airshop_notifications p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.status, p.type, p.body, p.abra_id, p.attempts, p.read, p.date_created FROM system.airshop_notifications p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AirshopNotificationsMapper.class)
    public List<AirshopNotificationsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO system.airshop_notifications (id, uid, ident, status, type, body, abra_id, attempts, read, date_created) VALUES (:id, :uid, :ident, :status, :type, :body, :abraId, :attempts, :read, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="ident") String var3, @Bind(value="status") Boolean var4, @Bind(value="type") String var5, @Bind(value="body") String var6, @Bind(value="abraId") String var7, @Bind(value="attempts") Integer var8, @Bind(value="read") Date var9, @Bind(value="dateCreated") Date var10);

    @SqlUpdate(value="INSERT INTO system.airshop_notifications (ident, status, type, body, abra_id, attempts, read, date_created) VALUES (:e.ident, :e.status, :e.type, :e.body, :e.abraId, :e.attempts, :e.read, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") AirshopNotificationsDomain var1);

    @SqlUpdate(value="UPDATE system.airshop_notifications SET id = :e.id, uid = :e.uid, ident = :e.ident, status = :e.status, type = :e.type, body = :e.body, abra_id = :e.abraId, attempts = :e.attempts, read = :e.read, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") AirshopNotificationsDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE system.airshop_notifications SET read = NOW() WHERE id = :byId")
    public int updateReadById(@Bind(value="byId") Long var1);

    @SqlUpdate(value="UPDATE system.airshop_notifications SET id = :e.id, uid = :e.uid, ident = :e.ident, status = :e.status, type = :e.type, body = :e.body, abra_id = :e.abraId, attempts = :e.attempts, read = :e.read, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") AirshopNotificationsDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE system.airshop_notifications SET id = :e.id, uid = :e.uid, ident = :e.ident, status = :e.status, type = :e.type, body = :e.body, abra_id = :e.abraId, attempts = :e.attempts, read = :e.read, date_created = :e.dateCreated WHERE ident = :byIdent")
    public int updateByIdent(@BindBean(value="e") AirshopNotificationsDomain var1, @Bind(value="byIdent") String var2);

    @SqlUpdate(value="UPDATE system.airshop_notifications SET id = :e.id, uid = :e.uid, ident = :e.ident, status = :e.status, type = :e.type, body = :e.body, abra_id = :e.abraId, attempts = :e.attempts, read = :e.read, date_created = :e.dateCreated WHERE status = :byStatus")
    public int updateByStatus(@BindBean(value="e") AirshopNotificationsDomain var1, @Bind(value="byStatus") Boolean var2);

    @SqlUpdate(value="UPDATE system.airshop_notifications SET id = :e.id, uid = :e.uid, ident = :e.ident, status = :e.status, type = :e.type, body = :e.body, abra_id = :e.abraId, attempts = :e.attempts, read = :e.read, date_created = :e.dateCreated WHERE type = :byType")
    public int updateByType(@BindBean(value="e") AirshopNotificationsDomain var1, @Bind(value="byType") String var2);

    @SqlUpdate(value="UPDATE system.airshop_notifications SET id = :e.id, uid = :e.uid, ident = :e.ident, status = :e.status, type = :e.type, body = :e.body, abra_id = :e.abraId, attempts = :e.attempts, read = :e.read, date_created = :e.dateCreated WHERE body = :byBody")
    public int updateByBody(@BindBean(value="e") AirshopNotificationsDomain var1, @Bind(value="byBody") String var2);

    @SqlUpdate(value="UPDATE system.airshop_notifications SET id = :e.id, uid = :e.uid, ident = :e.ident, status = :e.status, type = :e.type, body = :e.body, abra_id = :e.abraId, attempts = :e.attempts, read = :e.read, date_created = :e.dateCreated WHERE abra_id = :byAbraId")
    public int updateByAbraId(@BindBean(value="e") AirshopNotificationsDomain var1, @Bind(value="byAbraId") String var2);

    @SqlUpdate(value="UPDATE system.airshop_notifications SET id = :e.id, uid = :e.uid, ident = :e.ident, status = :e.status, type = :e.type, body = :e.body, abra_id = :e.abraId, attempts = :e.attempts, read = :e.read, date_created = :e.dateCreated WHERE attempts = :byAttempts")
    public int updateByAttempts(@BindBean(value="e") AirshopNotificationsDomain var1, @Bind(value="byAttempts") Integer var2);

    @SqlUpdate(value="UPDATE system.airshop_notifications SET id = :e.id, uid = :e.uid, ident = :e.ident, status = :e.status, type = :e.type, body = :e.body, abra_id = :e.abraId, attempts = :e.attempts, read = :e.read, date_created = :e.dateCreated WHERE read = :byRead")
    public int updateByRead(@BindBean(value="e") AirshopNotificationsDomain var1, @Bind(value="byRead") Date var2);

    @SqlUpdate(value="UPDATE system.airshop_notifications SET id = :e.id, uid = :e.uid, ident = :e.ident, status = :e.status, type = :e.type, body = :e.body, abra_id = :e.abraId, attempts = :e.attempts, read = :e.read, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") AirshopNotificationsDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM system.airshop_notifications WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM system.airshop_notifications WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM system.airshop_notifications WHERE ident = :ident")
    public int deleteByIdent(@Bind(value="ident") String var1);

    @SqlUpdate(value="DELETE FROM system.airshop_notifications WHERE status = :status")
    public int deleteByStatus(@Bind(value="status") Boolean var1);

    @SqlUpdate(value="DELETE FROM system.airshop_notifications WHERE type = :type")
    public int deleteByType(@Bind(value="type") String var1);

    @SqlUpdate(value="DELETE FROM system.airshop_notifications WHERE body = :body")
    public int deleteByBody(@Bind(value="body") String var1);

    @SqlUpdate(value="DELETE FROM system.airshop_notifications WHERE abra_id = :abraId")
    public int deleteByAbraId(@Bind(value="abraId") String var1);

    @SqlUpdate(value="DELETE FROM system.airshop_notifications WHERE attempts = :attempts")
    public int deleteByAttempts(@Bind(value="attempts") Integer var1);

    @SqlUpdate(value="DELETE FROM system.airshop_notifications WHERE read = :read")
    public int deleteByRead(@Bind(value="read") Date var1);

    @SqlUpdate(value="DELETE FROM system.airshop_notifications WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

