/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.utils;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.dropwizard.db.DataSourceFactory;
import java.security.Security;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirebirdSqlDS {
    private static final Logger log = LoggerFactory.getLogger(FirebirdSqlDS.class);
    private static final int MAX_POOL_SIZE = 10;
    private static final DataSourceFactory sqlConfig = new DataSourceFactory();

    public static HikariDataSource getDataSource(String jdbc, String username, String password) {
        try {
            HikariConfig config = new HikariConfig();
            config.setMaximumPoolSize(10);
            config.setDriverClassName("org.firebirdsql.jdbc.FBDriver");
            config.setJdbcUrl(jdbc);
            config.setUsername(username);
            config.setPassword(password);
            config.addDataSourceProperty("encoding", (Object)"utf8");
            Security.setProperty("crypto.policy", "unlimited");
            return new HikariDataSource(config);
        }
        catch (Exception e) {
            log.error("Cannot connect to Firebird DB " + e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

