/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.domains.codecs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import cz.airtoy.airshop.domains.PrintersDomain;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintersDomainCodec
implements MessageCodec<PrintersDomain, PrintersDomain> {
    private static final Logger log = LoggerFactory.getLogger(PrintersDomainCodec.class);

    public void encodeToWire(Buffer buffer, PrintersDomain printersDomain) {
        GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
        Gson gson = gsonBuilder.create();
        String jsonToStr = gson.toJson((Object)printersDomain);
        int length = jsonToStr.getBytes().length;
        buffer.appendInt(length);
        buffer.appendString(jsonToStr);
    }

    public PrintersDomain decodeFromWire(int position, Buffer buffer) {
        int _pos = position;
        int length = buffer.getInt(_pos);
        String jsonStr = buffer.getString(_pos += 4, _pos += length);
        GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
        Gson gson = gsonBuilder.create();
        return (PrintersDomain)gson.fromJson(jsonStr, PrintersDomain.class);
    }

    public PrintersDomain transform(PrintersDomain printersDomain) {
        return printersDomain;
    }

    public String name() {
        return this.getClass().getSimpleName();
    }

    public byte systemCodecID() {
        return -1;
    }
}

