/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.app;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.app.StocktakingMapper;
import cz.airtoy.airshop.dao.mappers.full.StocktakingFullMapper;
import cz.airtoy.airshop.domains.app.StocktakingDomain;
import cz.airtoy.airshop.domains.full.StocktakingFullDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.BindList;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface StocktakingDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.name,\n\t\tp.store_id,\n\t\tp.partner_id,\n\t\tp.status,\n\t\tp.date_started,\n\t\tp.date_finished,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tapp.stocktaking p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.store_id::text ~* :mask \n\tOR \n\t\tp.partner_id::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.date_started::text ~* :mask \n\tOR \n\t\tp.date_finished::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public List<StocktakingDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tapp.stocktaking p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.store_id::text ~* :mask \n\tOR \n\t\tp.partner_id::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.date_started::text ~* :mask \n\tOR \n\t\tp.date_finished::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n \n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tapp.stocktaking p\n\t\n\t\tWHERE \n p.status IN (<status>) \tAND ( \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.store_id::text ~* :mask \n\tOR \n\t\tp.partner_id::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.date_started::text ~* :mask \n\tOR \n\t\tp.date_finished::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n ) \n")
    public long findByMaskFullCount(@BindList(value="status") List<String> var1, @Bind(value="mask") String var2);

    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.name,\n\t\tp.store_id,\n\t\tp.partner_id,\n\t\tp.status,\n\t\tp.date_started,\n\t\tp.date_finished,\n\t\tp.note,\n\t\tp.date_created,\n\t  abra_stores.id AS str_id,\n\t\tabra_stores.uid AS str_uid,\n\t\tabra_stores.abra_id AS str_abra_id,\n\t\tabra_stores.account_id AS str_account_id,\n\t\tabra_stores.address_id AS str_address_id,\n\t\tabra_stores.classid AS str_classid,\n\t\tabra_stores.code AS str_code,\n\t\tabra_stores.displayname AS str_displayname,\n\t\tabra_stores.fifo AS str_fifo,\n\t\tabra_stores.firstopenperiod_id AS str_firstopenperiod_id,\n\t\tabra_stores.hidden AS str_hidden,\n\t\tabra_stores.ignorescoutofstockdelivery AS str_ignorescoutofstockdelivery,\n\t\tabra_stores.intrastatinputstatistic_id AS str_intrastatinputstatistic_id,\n\t\tabra_stores.intrastatoutputstatistic_id AS str_intrastatoutputstatistic_id,\n\t\tabra_stores.intrastatregion_id AS str_intrastatregion_id,\n\t\tabra_stores.inventorystate AS str_inventorystate,\n\t\tabra_stores.invstartedby_id AS str_invstartedby_id,\n\t\tabra_stores.islogistic AS str_islogistic,\n\t\tabra_stores.date_islogisticfromdate AS str_date_islogisticfromdate,\n\t\tabra_stores.lastopenperiod_id AS str_lastopenperiod_id,\n\t\tabra_stores.machinename AS str_machinename,\n\t\tabra_stores.name AS str_name,\n\t\tabra_stores.objversion AS str_objversion,\n\t\tabra_stores.outofstockbatchdelivery AS str_outofstockbatchdelivery,\n\t\tabra_stores.outofstockdelivery AS str_outofstockdelivery,\n\t\tabra_stores.pricelist_id AS str_pricelist_id,\n\t\tabra_stores.refundstore_id AS str_refundstore_id,\n\t\tabra_stores.registerbusorders AS str_registerbusorders,\n\t\tabra_stores.toaccount AS str_toaccount,\n\t\tabra_stores.abra_pd_an_id AS str_abra_pd_an_id,\n\t\tabra_stores.abra_pd_clientid AS str_abra_pd_clientid,\n\t\tabra_stores.abra_pd_clientpass AS str_abra_pd_clientpass,\n\t\tabra_stores.abra_pd_send_depot AS str_abra_pd_send_depot,\n\t\tabra_stores.abra_pd_send_depot_addressid AS str_abra_pd_send_depot_addressid,\n\t\tabra_stores.abra_pd_send_depot_city AS str_abra_pd_send_depot_city,\n\t\tabra_stores.abra_pd_send_depot_fax AS str_abra_pd_send_depot_fax,\n\t\tabra_stores.abra_pd_send_depot_phone AS str_abra_pd_send_depot_phone,\n\t\tabra_stores.abra_pd_send_depot_postalcode AS str_abra_pd_send_depot_postalcode,\n\t\tabra_stores.abra_pd_send_depot_street AS str_abra_pd_send_depot_street,\n\t\tabra_stores.updated AS str_updated,\n\t\tabra_stores.date_created AS str_date_created,\n\t  adm_partners.id AS prtn_id,\n\t\tadm_partners.uid AS prtn_uid,\n\t\tadm_partners.role_name AS prtn_role_name,\n\t\tadm_partners.partner_state AS prtn_partner_state,\n\t\tadm_partners.username AS prtn_username,\n\t\tadm_partners.password AS prtn_password,\n\t\tadm_partners.nickname AS prtn_nickname,\n\t\tadm_partners.credit AS prtn_credit,\n\t\tadm_partners.vip_valid_to AS prtn_vip_valid_to,\n\t\tadm_partners.firstname AS prtn_firstname,\n\t\tadm_partners.middlename AS prtn_middlename,\n\t\tadm_partners.lastname AS prtn_lastname,\n\t\tadm_partners.gender AS prtn_gender,\n\t\tadm_partners.seeking AS prtn_seeking,\n\t\tadm_partners.age AS prtn_age,\n\t\tadm_partners.rating AS prtn_rating,\n\t\tadm_partners.rating_sum AS prtn_rating_sum,\n\t\tadm_partners.rating_count AS prtn_rating_count,\n\t\tadm_partners.date_birthday AS prtn_date_birthday,\n\t\tadm_partners.last_seen AS prtn_last_seen,\n\t\tadm_partners.phone AS prtn_phone,\n\t\tadm_partners.email AS prtn_email,\n\t\tadm_partners.city AS prtn_city,\n\t\tadm_partners.city_uid AS prtn_city_uid,\n\t\tadm_partners.country AS prtn_country,\n\t\tadm_partners.hair AS prtn_hair,\n\t\tadm_partners.fcm_token AS prtn_fcm_token,\n\t\tadm_partners.store_id AS prtn_store_id,\n\t\tadm_partners.printer_id AS prtn_printer_id,\n\t\tadm_partners.a4_printer_id AS prtn_a4_printer_id,\n\t\tadm_partners.t80_printer_id AS prtn_t80_printer_id,\n\t\tadm_partners.from_store_id AS prtn_from_store_id,\n\t\tadm_partners.to_store_id AS prtn_to_store_id,\n\t\tadm_partners.workpos AS prtn_workpos,\n\t\tadm_partners.profile_text AS prtn_profile_text,\n\t\tadm_partners.photo AS prtn_photo,\n\t\tadm_partners.visits_count AS prtn_visits_count,\n\t\tadm_partners.sms_count AS prtn_sms_count,\n\t\tadm_partners.web_messages_count AS prtn_web_messages_count,\n\t\tadm_partners.date_survey AS prtn_date_survey,\n\t\tadm_partners.activationkey AS prtn_activationkey,\n\t\tadm_partners.actived AS prtn_actived,\n\t\tadm_partners.confirmed AS prtn_confirmed,\n\t\tadm_partners.date_changed AS prtn_date_changed,\n\t\tadm_partners.user_changed AS prtn_user_changed,\n\t\tadm_partners.note AS prtn_note,\n\t\tadm_partners.date_created AS prtn_date_created\n FROM \n\t\tapp.stocktaking p\n \t\t\tLEFT OUTER JOIN abra.stores abra_stores ON (p.store_id = abra_stores.id)  \t\t\tLEFT OUTER JOIN adm.partners adm_partners ON (p.partner_id = adm_partners.id) \t\n\t\tWHERE \n p.status IN (<status>) \tAND ( \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.store_id::text ~* :mask \n\tOR \n\t\tp.partner_id::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.date_started::text ~* :mask \n\tOR \n\t\tp.date_finished::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\t) \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=StocktakingFullMapper.class)
    public List<StocktakingFullDomain> findByMaskFull(@BindList(value="status") List<String> var1, @Bind(value="mask") String var2, @Bind(value="offset") int var3, @Bind(value="limit") int var4, @Define(value="order") String var5, @Define(value="sort") String var6);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created, \t  abra_stores.id AS str_id,\n\t\tabra_stores.uid AS str_uid,\n\t\tabra_stores.abra_id AS str_abra_id,\n\t\tabra_stores.account_id AS str_account_id,\n\t\tabra_stores.address_id AS str_address_id,\n\t\tabra_stores.classid AS str_classid,\n\t\tabra_stores.code AS str_code,\n\t\tabra_stores.displayname AS str_displayname,\n\t\tabra_stores.fifo AS str_fifo,\n\t\tabra_stores.firstopenperiod_id AS str_firstopenperiod_id,\n\t\tabra_stores.hidden AS str_hidden,\n\t\tabra_stores.ignorescoutofstockdelivery AS str_ignorescoutofstockdelivery,\n\t\tabra_stores.intrastatinputstatistic_id AS str_intrastatinputstatistic_id,\n\t\tabra_stores.intrastatoutputstatistic_id AS str_intrastatoutputstatistic_id,\n\t\tabra_stores.intrastatregion_id AS str_intrastatregion_id,\n\t\tabra_stores.inventorystate AS str_inventorystate,\n\t\tabra_stores.invstartedby_id AS str_invstartedby_id,\n\t\tabra_stores.islogistic AS str_islogistic,\n\t\tabra_stores.date_islogisticfromdate AS str_date_islogisticfromdate,\n\t\tabra_stores.lastopenperiod_id AS str_lastopenperiod_id,\n\t\tabra_stores.machinename AS str_machinename,\n\t\tabra_stores.name AS str_name,\n\t\tabra_stores.objversion AS str_objversion,\n\t\tabra_stores.outofstockbatchdelivery AS str_outofstockbatchdelivery,\n\t\tabra_stores.outofstockdelivery AS str_outofstockdelivery,\n\t\tabra_stores.pricelist_id AS str_pricelist_id,\n\t\tabra_stores.refundstore_id AS str_refundstore_id,\n\t\tabra_stores.registerbusorders AS str_registerbusorders,\n\t\tabra_stores.toaccount AS str_toaccount,\n\t\tabra_stores.abra_pd_an_id AS str_abra_pd_an_id,\n\t\tabra_stores.abra_pd_clientid AS str_abra_pd_clientid,\n\t\tabra_stores.abra_pd_clientpass AS str_abra_pd_clientpass,\n\t\tabra_stores.abra_pd_send_depot AS str_abra_pd_send_depot,\n\t\tabra_stores.abra_pd_send_depot_addressid AS str_abra_pd_send_depot_addressid,\n\t\tabra_stores.abra_pd_send_depot_city AS str_abra_pd_send_depot_city,\n\t\tabra_stores.abra_pd_send_depot_fax AS str_abra_pd_send_depot_fax,\n\t\tabra_stores.abra_pd_send_depot_phone AS str_abra_pd_send_depot_phone,\n\t\tabra_stores.abra_pd_send_depot_postalcode AS str_abra_pd_send_depot_postalcode,\n\t\tabra_stores.abra_pd_send_depot_street AS str_abra_pd_send_depot_street,\n\t\tabra_stores.updated AS str_updated,\n\t\tabra_stores.date_created AS str_date_created,\n\t  adm_partners.id AS prtn_id,\n\t\tadm_partners.uid AS prtn_uid,\n\t\tadm_partners.role_name AS prtn_role_name,\n\t\tadm_partners.partner_state AS prtn_partner_state,\n\t\tadm_partners.username AS prtn_username,\n\t\tadm_partners.password AS prtn_password,\n\t\tadm_partners.nickname AS prtn_nickname,\n\t\tadm_partners.credit AS prtn_credit,\n\t\tadm_partners.vip_valid_to AS prtn_vip_valid_to,\n\t\tadm_partners.firstname AS prtn_firstname,\n\t\tadm_partners.middlename AS prtn_middlename,\n\t\tadm_partners.lastname AS prtn_lastname,\n\t\tadm_partners.gender AS prtn_gender,\n\t\tadm_partners.seeking AS prtn_seeking,\n\t\tadm_partners.age AS prtn_age,\n\t\tadm_partners.rating AS prtn_rating,\n\t\tadm_partners.rating_sum AS prtn_rating_sum,\n\t\tadm_partners.rating_count AS prtn_rating_count,\n\t\tadm_partners.date_birthday AS prtn_date_birthday,\n\t\tadm_partners.last_seen AS prtn_last_seen,\n\t\tadm_partners.phone AS prtn_phone,\n\t\tadm_partners.email AS prtn_email,\n\t\tadm_partners.city AS prtn_city,\n\t\tadm_partners.city_uid AS prtn_city_uid,\n\t\tadm_partners.country AS prtn_country,\n\t\tadm_partners.hair AS prtn_hair,\n\t\tadm_partners.fcm_token AS prtn_fcm_token,\n\t\tadm_partners.store_id AS prtn_store_id,\n\t\tadm_partners.printer_id AS prtn_printer_id,\n\t\tadm_partners.a4_printer_id AS prtn_a4_printer_id,\n\t\tadm_partners.t80_printer_id AS prtn_t80_printer_id,\n\t\tadm_partners.from_store_id AS prtn_from_store_id,\n\t\tadm_partners.to_store_id AS prtn_to_store_id,\n\t\tadm_partners.workpos AS prtn_workpos,\n\t\tadm_partners.profile_text AS prtn_profile_text,\n\t\tadm_partners.photo AS prtn_photo,\n\t\tadm_partners.visits_count AS prtn_visits_count,\n\t\tadm_partners.sms_count AS prtn_sms_count,\n\t\tadm_partners.web_messages_count AS prtn_web_messages_count,\n\t\tadm_partners.date_survey AS prtn_date_survey,\n\t\tadm_partners.activationkey AS prtn_activationkey,\n\t\tadm_partners.actived AS prtn_actived,\n\t\tadm_partners.confirmed AS prtn_confirmed,\n\t\tadm_partners.date_changed AS prtn_date_changed,\n\t\tadm_partners.user_changed AS prtn_user_changed,\n\t\tadm_partners.note AS prtn_note,\n\t\tadm_partners.date_created AS prtn_date_created\nFROM app.stocktaking p  \t\t\tLEFT OUTER JOIN abra.stores abra_stores ON (p.store_id = abra_stores.id)  \t\t\tLEFT OUTER JOIN adm.partners adm_partners ON (p.partner_id = adm_partners.id)  WHERE p.id = :id")
    @RegisterRowMapper(value=StocktakingFullMapper.class)
    public StocktakingFullDomain findByIdFull(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created FROM app.stocktaking p  WHERE p.store_id = :storeId AND p.date_finished IS NULL ")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public StocktakingDomain findByStoreIdNotFinished(@Bind(value="storeId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created FROM app.stocktaking p  WHERE p.id = :id")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public StocktakingDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created FROM app.stocktaking p  WHERE p.id = :id")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public List<StocktakingDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.stocktaking p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created FROM app.stocktaking p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public List<StocktakingDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created FROM app.stocktaking p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public StocktakingDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created FROM app.stocktaking p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public List<StocktakingDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.stocktaking p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created FROM app.stocktaking p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public List<StocktakingDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created FROM app.stocktaking p  WHERE p.name = :name")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public StocktakingDomain findByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created FROM app.stocktaking p  WHERE p.name = :name")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public List<StocktakingDomain> findListByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.stocktaking p  WHERE p.name = :name")
    public long findListByNameCount(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created FROM app.stocktaking p  WHERE p.name = :name ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public List<StocktakingDomain> findListByName(@Bind(value="name") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created FROM app.stocktaking p  WHERE p.store_id = :storeId")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public StocktakingDomain findByStoreId(@Bind(value="storeId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created FROM app.stocktaking p  WHERE p.store_id = :storeId")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public List<StocktakingDomain> findListByStoreId(@Bind(value="storeId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.stocktaking p  WHERE p.store_id = :storeId")
    public long findListByStoreIdCount(@Bind(value="storeId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created FROM app.stocktaking p  WHERE p.store_id = :storeId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public List<StocktakingDomain> findListByStoreId(@Bind(value="storeId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created FROM app.stocktaking p  WHERE p.partner_id = :partnerId")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public StocktakingDomain findByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created FROM app.stocktaking p  WHERE p.partner_id = :partnerId")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public List<StocktakingDomain> findListByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.stocktaking p  WHERE p.partner_id = :partnerId")
    public long findListByPartnerIdCount(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created FROM app.stocktaking p  WHERE p.partner_id = :partnerId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public List<StocktakingDomain> findListByPartnerId(@Bind(value="partnerId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created FROM app.stocktaking p  WHERE p.status = :status")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public StocktakingDomain findByStatus(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created FROM app.stocktaking p  WHERE p.status = :status")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public List<StocktakingDomain> findListByStatus(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.stocktaking p  WHERE p.status = :status")
    public long findListByStatusCount(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created FROM app.stocktaking p  WHERE p.status = :status ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public List<StocktakingDomain> findListByStatus(@Bind(value="status") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created FROM app.stocktaking p  WHERE p.date_started = :dateStarted")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public StocktakingDomain findByDateStarted(@Bind(value="dateStarted") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created FROM app.stocktaking p  WHERE p.date_started = :dateStarted")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public List<StocktakingDomain> findListByDateStarted(@Bind(value="dateStarted") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.stocktaking p  WHERE p.date_started = :dateStarted")
    public long findListByDateStartedCount(@Bind(value="dateStarted") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created FROM app.stocktaking p  WHERE p.date_started = :dateStarted ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public List<StocktakingDomain> findListByDateStarted(@Bind(value="dateStarted") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created FROM app.stocktaking p  WHERE p.date_finished = :dateFinished")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public StocktakingDomain findByDateFinished(@Bind(value="dateFinished") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created FROM app.stocktaking p  WHERE p.date_finished = :dateFinished")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public List<StocktakingDomain> findListByDateFinished(@Bind(value="dateFinished") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.stocktaking p  WHERE p.date_finished = :dateFinished")
    public long findListByDateFinishedCount(@Bind(value="dateFinished") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created FROM app.stocktaking p  WHERE p.date_finished = :dateFinished ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public List<StocktakingDomain> findListByDateFinished(@Bind(value="dateFinished") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created FROM app.stocktaking p  WHERE p.note = :note")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public StocktakingDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created FROM app.stocktaking p  WHERE p.note = :note")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public List<StocktakingDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.stocktaking p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created FROM app.stocktaking p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public List<StocktakingDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created FROM app.stocktaking p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public StocktakingDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created FROM app.stocktaking p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public List<StocktakingDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.stocktaking p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.store_id, p.partner_id, p.status, p.date_started, p.date_finished, p.note, p.date_created FROM app.stocktaking p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StocktakingMapper.class)
    public List<StocktakingDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO app.stocktaking (id, uid, name, store_id, partner_id, status, date_started, date_finished, note, date_created) VALUES (:id, :uid, :name, :storeId, :partnerId, :status, :dateStarted, :dateFinished, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="name") String var3, @Bind(value="storeId") Long var4, @Bind(value="partnerId") Long var5, @Bind(value="status") String var6, @Bind(value="dateStarted") Date var7, @Bind(value="dateFinished") Date var8, @Bind(value="note") String var9, @Bind(value="dateCreated") Date var10);

    @SqlUpdate(value="INSERT INTO app.stocktaking (name, store_id, partner_id, status, date_started, date_finished, note, date_created) VALUES (:e.name, :e.storeId, :e.partnerId, :e.status, :e.dateStarted, :e.dateFinished, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") StocktakingDomain var1);

    @SqlUpdate(value="UPDATE app.stocktaking SET id = :e.id, uid = :e.uid, name = :e.name, store_id = :e.storeId, partner_id = :e.partnerId, status = :e.status, date_started = :e.dateStarted, date_finished = :e.dateFinished, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") StocktakingDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE app.stocktaking SET id = :e.id, uid = :e.uid, name = :e.name, store_id = :e.storeId, partner_id = :e.partnerId, status = :e.status, date_started = :e.dateStarted, date_finished = :e.dateFinished, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") StocktakingDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE app.stocktaking SET id = :e.id, uid = :e.uid, name = :e.name, store_id = :e.storeId, partner_id = :e.partnerId, status = :e.status, date_started = :e.dateStarted, date_finished = :e.dateFinished, note = :e.note, date_created = :e.dateCreated WHERE name = :byName")
    public int updateByName(@BindBean(value="e") StocktakingDomain var1, @Bind(value="byName") String var2);

    @SqlUpdate(value="UPDATE app.stocktaking SET id = :e.id, uid = :e.uid, name = :e.name, store_id = :e.storeId, partner_id = :e.partnerId, status = :e.status, date_started = :e.dateStarted, date_finished = :e.dateFinished, note = :e.note, date_created = :e.dateCreated WHERE store_id = :byStoreId")
    public int updateByStoreId(@BindBean(value="e") StocktakingDomain var1, @Bind(value="byStoreId") Long var2);

    @SqlUpdate(value="UPDATE app.stocktaking SET id = :e.id, uid = :e.uid, name = :e.name, store_id = :e.storeId, partner_id = :e.partnerId, status = :e.status, date_started = :e.dateStarted, date_finished = :e.dateFinished, note = :e.note, date_created = :e.dateCreated WHERE partner_id = :byPartnerId")
    public int updateByPartnerId(@BindBean(value="e") StocktakingDomain var1, @Bind(value="byPartnerId") Long var2);

    @SqlUpdate(value="UPDATE app.stocktaking SET id = :e.id, uid = :e.uid, name = :e.name, store_id = :e.storeId, partner_id = :e.partnerId, status = :e.status, date_started = :e.dateStarted, date_finished = :e.dateFinished, note = :e.note, date_created = :e.dateCreated WHERE status = :byStatus")
    public int updateByStatus(@BindBean(value="e") StocktakingDomain var1, @Bind(value="byStatus") String var2);

    @SqlUpdate(value="UPDATE app.stocktaking SET id = :e.id, uid = :e.uid, name = :e.name, store_id = :e.storeId, partner_id = :e.partnerId, status = :e.status, date_started = :e.dateStarted, date_finished = :e.dateFinished, note = :e.note, date_created = :e.dateCreated WHERE date_started = :byDateStarted")
    public int updateByDateStarted(@BindBean(value="e") StocktakingDomain var1, @Bind(value="byDateStarted") Date var2);

    @SqlUpdate(value="UPDATE app.stocktaking SET id = :e.id, uid = :e.uid, name = :e.name, store_id = :e.storeId, partner_id = :e.partnerId, status = :e.status, date_started = :e.dateStarted, date_finished = :e.dateFinished, note = :e.note, date_created = :e.dateCreated WHERE date_finished = :byDateFinished")
    public int updateByDateFinished(@BindBean(value="e") StocktakingDomain var1, @Bind(value="byDateFinished") Date var2);

    @SqlUpdate(value="UPDATE app.stocktaking SET id = :e.id, uid = :e.uid, name = :e.name, store_id = :e.storeId, partner_id = :e.partnerId, status = :e.status, date_started = :e.dateStarted, date_finished = :e.dateFinished, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") StocktakingDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE app.stocktaking SET id = :e.id, uid = :e.uid, name = :e.name, store_id = :e.storeId, partner_id = :e.partnerId, status = :e.status, date_started = :e.dateStarted, date_finished = :e.dateFinished, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") StocktakingDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM app.stocktaking WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM app.stocktaking WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM app.stocktaking WHERE name = :name")
    public int deleteByName(@Bind(value="name") String var1);

    @SqlUpdate(value="DELETE FROM app.stocktaking WHERE store_id = :storeId")
    public int deleteByStoreId(@Bind(value="storeId") Long var1);

    @SqlUpdate(value="DELETE FROM app.stocktaking WHERE partner_id = :partnerId")
    public int deleteByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlUpdate(value="DELETE FROM app.stocktaking WHERE status = :status")
    public int deleteByStatus(@Bind(value="status") String var1);

    @SqlUpdate(value="DELETE FROM app.stocktaking WHERE date_started = :dateStarted")
    public int deleteByDateStarted(@Bind(value="dateStarted") Date var1);

    @SqlUpdate(value="DELETE FROM app.stocktaking WHERE date_finished = :dateFinished")
    public int deleteByDateFinished(@Bind(value="dateFinished") Date var1);

    @SqlUpdate(value="DELETE FROM app.stocktaking WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM app.stocktaking WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

