/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.utils;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.RectangleReadOnly;
import com.itextpdf.text.pdf.Barcode39;
import com.itextpdf.text.pdf.BarcodeQRCode;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.draw.DottedLineSeparator;
import com.itextpdf.text.pdf.draw.DrawInterface;
import cz.airtoy.airshop.domains.AddressesDomain;
import cz.airtoy.airshop.domains.DeliveryListDomain;
import cz.airtoy.airshop.domains.DeliveryListItemsDomain;
import cz.airtoy.airshop.domains.FirmOfficesDomain;
import cz.airtoy.airshop.domains.IncomingTransfersDomain;
import cz.airtoy.airshop.domains.OrderItemsDomain;
import cz.airtoy.airshop.domains.OrdersDomain;
import cz.airtoy.airshop.domains.OutgoingTransfersDomain;
import cz.airtoy.airshop.domains.StoreCardsDomain;
import cz.airtoy.airshop.domains.StoreCardsQuantityDomain;
import cz.airtoy.airshop.domains.StoresDomain;
import cz.airtoy.airshop.domains.TransferQueueDomain;
import cz.airtoy.airshop.domains.TransferQueueItemsDomain;
import cz.airtoy.airshop.domains.TransportationTypesDomain;
import cz.airtoy.airshop.domains.abra.AbraPaymenttypesDomain;
import cz.airtoy.airshop.domains.balikobot.BalikobotOrderDomain;
import cz.airtoy.airshop.domains.balikobot.CollectionListDomain;
import cz.airtoy.airshop.domains.balikobot.CollectionListItemDomain;
import cz.airtoy.airshop.domains.help.OrderSource;
import cz.airtoy.airshop.domains.help.pdf.PdfInputDeliveryListDomain;
import cz.airtoy.airshop.domains.help.pdf.PdfInputOrderDomain;
import cz.airtoy.airshop.domains.help.pdf.PdfInputTransferQueueDomain;
import cz.airtoy.airshop.misc.DaoSupportApp;
import java.io.IOException;
import java.io.OutputStream;
import java.math.RoundingMode;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfUtils {
    private static final Logger log = LoggerFactory.getLogger(PdfUtils.class);
    private static BaseFont baseFont;
    private static DecimalFormatSymbols otherSymbols;
    private static DecimalFormat df2;
    private static Font font;
    private static Font fontH;
    private static Font fontH1;
    private static Font fontH120;
    private static Font fontH130;
    private static Font fontH2;
    private static Font fontH212;
    private static Font fontH2B11;
    private static Font fontH2B;
    private static Font fontH3;
    private static Font fontH3B;

    public static void makeDeliveryListContent(Document document, PdfWriter writer, OrdersDomain ordersDomain, DeliveryListDomain deliveryListDomain, AddressesDomain firmResidenceAddress, AddressesDomain firmOfficeAddress, ArrayList<ImmutablePair<DeliveryListItemsDomain, StoreCardsDomain>> itemList, TransportationTypesDomain transportationTypesDomain, AbraPaymenttypesDomain abraPaymenttypesDomain, FirmOfficesDomain firmOfficesDomain) {
        try {
            if (deliveryListDomain != null) {
                PdfPTable tableRTSummary = new PdfPTable(2);
                tableRTSummary.setWidthPercentage(10.0f);
                tableRTSummary.setWidths(new int[]{2, 1});
                Barcode39 barcode39 = new Barcode39();
                barcode39.setCode(ordersDomain.getExternalnumber());
                Image code39Image = barcode39.createImageWithBarcode(writer.getDirectContent(), null, null);
                code39Image.scalePercent(100.0f);
                tableRTSummary.addCell(PdfUtils.createCellParagraph("DODAC\u00cd LIST", fontH1, 0.0f, 2, 2));
                tableRTSummary.addCell(PdfUtils.createCellParagraph(deliveryListDomain.getDisplayname(), fontH2, 0.0f, 2, 2));
                tableRTSummary.addCell(PdfUtils.createCellImage(code39Image, 0.0f, 2, 2));
                tableRTSummary.addCell(PdfUtils.createCellParagraph("Datum vystaven\u00ed:", fontH3, 0.0f, 0, 2));
                tableRTSummary.addCell(PdfUtils.createCellParagraph(new SimpleDateFormat("dd.MM.yyyy").format(deliveryListDomain.getDateCreated()), fontH3B, 0.0f, 0, 2));
                PdfPTable tableHeader = new PdfPTable(2);
                tableHeader.setWidthPercentage(100.0f);
                tableHeader.setWidths(new int[]{2, 1});
                URL resource = null;
                Image imageLogo = null;
                switch (ordersDomain.getSourceFamily()) {
                    case BEERSHOP: {
                        resource = PdfUtils.getResourceBeershopLogoPureOutlinesJpg();
                        imageLogo = Image.getInstance((URL)resource);
                        imageLogo.scalePercent(35.0f);
                        break;
                    }
                    case DELIKATESY: {
                        resource = PdfUtils.getResourceDelikatesyLongBmp();
                        imageLogo = Image.getInstance((URL)resource);
                        imageLogo.scalePercent(27.0f);
                    }
                }
                tableHeader.addCell(PdfUtils.createCellImage(imageLogo, 0.0f, 0, 0));
                tableHeader.addCell(PdfUtils.createCellTable(tableRTSummary, 0.0f, 0, 2));
                document.add((Element)tableHeader);
                document.add((Element)new Paragraph(" "));
                PdfPTable tableHeaderAddresses = new PdfPTable(2);
                tableHeaderAddresses.setWidthPercentage(100.0f);
                tableHeaderAddresses.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0, 0));
                tableHeaderAddresses.addCell(PdfUtils.createCellParagraph("DODAC\u00cd ADRESA:", fontH3, 0.0f, 0, 0));
                tableHeaderAddresses.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0, 0));
                tableHeaderAddresses.addCell(PdfUtils.createCellParagraph(" ", fontH3, 1.5f, 1.5f, 1.5f, 0.0f, 0, 0));
                tableHeaderAddresses.addCell(PdfUtils.createCellParagraph(ordersDomain != null ? ordersDomain.getExternalnumber() : "", fontH2B, 0.0f, 0, 0));
                tableHeaderAddresses.addCell(PdfUtils.createCellParagraph(20.0f, firmOfficeAddress.getRecipient(), fontH2B, 0.0f, 0, 0));
                if (firmOfficesDomain != null && firmOfficesDomain.getDisplayname() != null && !firmOfficesDomain.getDisplayname().equalsIgnoreCase("Provozovna")) {
                    tableHeaderAddresses.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0, 0));
                    tableHeaderAddresses.addCell(PdfUtils.createCellParagraph(20.0f, firmOfficesDomain.getDisplayname(), fontH2, 0.0f, 0, 0));
                }
                tableHeaderAddresses.addCell(PdfUtils.createCellParagraph(transportationTypesDomain != null ? transportationTypesDomain.getName() : "", fontH2B, 0.0f, 0, 0));
                tableHeaderAddresses.addCell(PdfUtils.createCellParagraph(20.0f, firmOfficeAddress != null ? firmOfficeAddress.getStreet() : "", fontH2, 0.0f, 0, 0));
                tableHeaderAddresses.addCell(PdfUtils.createCellParagraph(abraPaymenttypesDomain != null ? abraPaymenttypesDomain.getName() : "", fontH2B, 0.0f, 0, 0));
                tableHeaderAddresses.addCell(PdfUtils.createCellParagraph(20.0f, String.format("%s %s", firmOfficeAddress != null ? firmOfficeAddress.getPostcode() : "", firmOfficeAddress != null ? firmOfficeAddress.getCity() : ""), fontH2, 0.0f, 0, 0));
                tableHeaderAddresses.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0, 0));
                tableHeaderAddresses.addCell(PdfUtils.createCellParagraph(20.0f, firmOfficeAddress != null ? firmOfficeAddress.getCountry() : "", fontH2, 0.0f, 0, 0));
                tableHeaderAddresses.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0, 0));
                tableHeaderAddresses.addCell(PdfUtils.createCellParagraph(20.0f, ordersDomain != null && ordersDomain.getOrderPhone() != null ? String.format("Tel.: %s", ordersDomain.getOrderPhone()) : "", fontH2, 0.0f, 0, 0));
                tableHeaderAddresses.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0, 0));
                tableHeaderAddresses.addCell(PdfUtils.createCellParagraph(" ", fontH3, 1.5f, 0.0f, 1.5f, 1.5f, 0, 0));
                document.add((Element)tableHeaderAddresses);
                document.add((Element)new Paragraph(" "));
                PdfPTable tableSC = new PdfPTable(3);
                tableSC.setWidthPercentage(100.0f);
                tableSC.setWidths(new int[]{2, 1, 1});
                tableSC.addCell(PdfUtils.createCellParagraph("DODAVATEL:", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph("Z\u00c1KAZN\u00cdK:", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph("Craft & Deli s.r.o.", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph(firmResidenceAddress != null ? firmResidenceAddress.getRecipient() : "", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph("I\u010cO:", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph("Sokolovsk\u00e1 1464/188", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph(firmResidenceAddress != null ? firmResidenceAddress.getStreet() : "", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph("DI\u010c:", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph("180 00 Praha 8", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph(String.format("%s %s", firmResidenceAddress != null ? firmResidenceAddress.getPostcode() : "", firmResidenceAddress != null ? firmResidenceAddress.getCity() : ""), fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph("I\u010cO: 25624075 DI\u010c: CZ25624075", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph(firmResidenceAddress != null ? firmResidenceAddress.getCountry() : "", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph("", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph(ordersDomain != null && ordersDomain.getOrderPhone() != null ? String.format("Tel.: %s", ordersDomain.getOrderPhone()) : "", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0, 0));
                document.add((Element)tableSC);
                document.add((Element)new Paragraph(" "));
                PdfPTable tableData = new PdfPTable(5);
                tableData.setWidthPercentage(100.0f);
                tableData.setWidths(new int[]{1, 2, 12, 2, 4});
                tableData.addCell(PdfUtils.createCellParagraph("", fontH3, 0.0f, 0.0f, 0.0f, 0.5f, 0, 0));
                tableData.addCell(PdfUtils.createCellParagraph("", fontH3, 0.0f, 0.0f, 0.0f, 0.5f, 0, 0));
                tableData.addCell(PdfUtils.createCellParagraph("Zbo\u017e\u00ed", fontH3, 0.0f, 0.0f, 0.0f, 0.5f, 0, 0));
                tableData.addCell(PdfUtils.createCellParagraph("K\u00f3d", fontH3, 0.0f, 0.0f, 0.0f, 0.5f, 0, 0));
                tableData.addCell(PdfUtils.createCellParagraph("EAN", fontH3, 0.0f, 0.0f, 0.0f, 0.5f, 0, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 5, 0));
                if (itemList != null) {
                    for (ImmutablePair<DeliveryListItemsDomain, StoreCardsDomain> item : itemList) {
                        DeliveryListItemsDomain deliveryListItemsDomain = (DeliveryListItemsDomain)item.getKey();
                        StoreCardsDomain storeCardsDomain = (StoreCardsDomain)item.getValue();
                        if (deliveryListItemsDomain.getStorecardId() != null) {
                            tableData.addCell(PdfUtils.createCellImage(PdfUtils.createRectangle(writer, 0.5f, 0.0f, 0.0f, 10.0f, 10.0f, BaseColor.BLACK), 0.0f, 0, 0));
                            tableData.addCell(PdfUtils.createCellParagraph((int)Math.round(deliveryListItemsDomain != null ? deliveryListItemsDomain.getQuantity() : 0.0) + " " + (deliveryListItemsDomain != null ? deliveryListItemsDomain.getQunit() : ""), fontH3B, 0.0f, 0, 0));
                            tableData.addCell(PdfUtils.createCellParagraph(storeCardsDomain.getName(), fontH3B, 0.0f, 0, 0));
                            tableData.addCell(PdfUtils.createCellParagraph(storeCardsDomain.getCode(), fontH3B, 0.0f, 0, 0));
                            tableData.addCell(PdfUtils.createCellParagraph(storeCardsDomain.getEan(), fontH3B, 0.0f, 0, 0));
                            continue;
                        }
                        tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0, 0));
                        tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3B, 0.0f, 0, 0));
                        tableData.addCell(PdfUtils.createCellParagraph(deliveryListItemsDomain != null ? deliveryListItemsDomain.getText() : "", fontH3B, 0.0f, 0, 0));
                        tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3B, 0.0f, 0, 0));
                        tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3B, 0.0f, 0, 0));
                    }
                }
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 5, 0));
                tableData.addCell(PdfUtils.createCellParagraph("", fontH3, 0.0f, 0.0f, 0.0f, 1.0f, 5, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 5, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 5, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 5, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 5, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 5, 0));
                tableData.addCell(PdfUtils.createCellParagraph("Objedn\u00e1vka:", fontH3, 0.0f, 2, 0));
                tableData.addCell(PdfUtils.createCellParagraph(String.format("%s %s", ordersDomain != null ? ordersDomain.getDisplayname() : "", ordersDomain != null ? ordersDomain.getExternalnumber() : ""), fontH3B, 0.0f, 2, 0));
                document.add((Element)tableData);
            } else {
                log.error("Delivery list is null");
            }
        }
        catch (Exception e) {
            log.error("Exception making delivery list: " + e.getMessage(), (Throwable)e);
        }
    }

    public static byte[] createDeliveryList(OrdersDomain ordersDomain, DeliveryListDomain deliveryListDomain, AddressesDomain firmResidenceAddress, AddressesDomain firmOfficeAddress, ArrayList<ImmutablePair<DeliveryListItemsDomain, StoreCardsDomain>> itemList, TransportationTypesDomain transportationTypesDomain, AbraPaymenttypesDomain abraPaymenttypesDomain, FirmOfficesDomain firmOfficesDomain) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Document document = new Document(new Rectangle(PageSize.A4));
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)baos);
            document.open();
            PdfUtils.makeDeliveryListContent(document, writer, ordersDomain, deliveryListDomain, firmResidenceAddress, firmOfficeAddress, itemList, transportationTypesDomain, abraPaymenttypesDomain, firmOfficesDomain);
            document.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            log.error("Exception create delivery list: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static byte[] createMassDeliveryList(ArrayList<PdfInputDeliveryListDomain> list) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Document document = new Document(new Rectangle(PageSize.A4));
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)baos);
            document.open();
            list.forEach(i -> {
                PdfUtils.makeDeliveryListContent(document, writer, i.getOrdersDomain(), i.getDeliveryListDomain(), i.getFirmResidenceAddress(), i.getFirmOfficeAddress(), i.getItemList(), i.getTransportationTypesDomain(), i.getAbraPaymenttypesDomain(), i.getFirmOfficesDomain());
                document.newPage();
            });
            document.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            log.error("Exception create mass delivery list: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String createDeliveryListBase64(OrdersDomain ordersDomain, DeliveryListDomain deliveryListDomain, AddressesDomain firmResidenceAddress, AddressesDomain firmOfficeAddress, ArrayList<ImmutablePair<DeliveryListItemsDomain, StoreCardsDomain>> itemList, TransportationTypesDomain transportationTypesDomain, AbraPaymenttypesDomain abraPaymenttypesDomain, FirmOfficesDomain firmOfficesDomain) {
        byte[] deliveryList = PdfUtils.createDeliveryList(ordersDomain, deliveryListDomain, firmResidenceAddress, firmOfficeAddress, itemList, transportationTypesDomain, abraPaymenttypesDomain, firmOfficesDomain);
        if (deliveryList != null) {
            return Base64.getEncoder().encodeToString(deliveryList);
        }
        return null;
    }

    public static String createMassDeliveryListBase64(ArrayList<PdfInputDeliveryListDomain> list) {
        byte[] deliveryLists = PdfUtils.createMassDeliveryList(list);
        if (deliveryLists != null) {
            return Base64.getEncoder().encodeToString(deliveryLists);
        }
        return null;
    }

    public static void makeTransferQueueContent(Document document, PdfWriter writer, TransferQueueDomain transferQueueDomain, ArrayList<ImmutablePair<TransferQueueItemsDomain, StoreCardsDomain>> itemList, IncomingTransfersDomain incomingTransfersDomain, OutgoingTransfersDomain outgoingTransfersDomain, DaoSupportApp ds) {
        try {
            if (transferQueueDomain != null) {
                PdfPTable tableRTSummary = new PdfPTable(2);
                tableRTSummary.setWidthPercentage(10.0f);
                tableRTSummary.setWidths(new int[]{2, 1});
                Barcode39 barcode39 = new Barcode39();
                barcode39.setCode(transferQueueDomain.getId().toString());
                Image code39Image = barcode39.createImageWithBarcode(writer.getDirectContent(), null, null);
                code39Image.scalePercent(100.0f);
                tableRTSummary.addCell(PdfUtils.createCellParagraph("INTERN\u00cd P\u0158EVODKA", fontH1, 0.0f, 2, 2));
                SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyyHH:mm");
                tableRTSummary.addCell(PdfUtils.createCellImage(code39Image, 0.0f, 2, 2));
                tableRTSummary.addCell(PdfUtils.createCellParagraph("Datum vystaven\u00ed:", fontH3, 0.0f, 0, 2));
                tableRTSummary.addCell(PdfUtils.createCellParagraph(new SimpleDateFormat("dd.MM.yyyy").format(transferQueueDomain.getDateCreated()), fontH3B, 0.0f, 0, 2));
                PdfPTable tableHeader = new PdfPTable(2);
                tableHeader.setWidthPercentage(100.0f);
                tableHeader.setWidths(new int[]{2, 1});
                tableHeader.addCell(PdfUtils.createCell("", font, 0.0f, 0, 0));
                tableHeader.addCell(PdfUtils.createCellTable(tableRTSummary, 0.0f, 0, 2));
                document.add((Element)tableHeader);
                document.add((Element)new Paragraph(" "));
                PdfPTable tableSC = new PdfPTable(3);
                tableSC.setWidthPercentage(100.0f);
                tableSC.setWidths(new int[]{2, 1, 1});
                tableSC.addCell(PdfUtils.createCellParagraph("DODAVATEL:", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph("Z\u00c1KAZN\u00cdK:", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph("Craft & Deli s.r.o.", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph("Craft & Deli s.r.o.", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph("Sokolovsk\u00e1 1464/188", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph("Sokolovsk\u00e1 1464/188", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph("180 00 Praha 8", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph("180 00 Praha 8", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph("I\u010cO: 25624075", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph("I\u010cO: 25624075", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph("DI\u010c: CZ25624075", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph("DI\u010c: CZ25624075", fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0, 0));
                StoresDomain fromStoreDomain = ds.getStoresDbiDao().findById(transferQueueDomain.getFromStoreId());
                StoresDomain toStoreDomain = ds.getStoresDbiDao().findById(transferQueueDomain.getToStoreId());
                tableSC.addCell(PdfUtils.createCellParagraph(String.format("Sklad: %s", fromStoreDomain != null ? fromStoreDomain.getDisplayname() : ""), fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph(String.format("Sklad: %s", toStoreDomain != null ? toStoreDomain.getDisplayname() : ""), fontH3, 0.0f, 0, 0));
                tableSC.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0, 0));
                document.add((Element)tableSC);
                document.add((Element)new Paragraph(" "));
                PdfPTable tableData = new PdfPTable(7);
                tableData.setWidthPercentage(100.0f);
                tableData.setWidths(new int[]{1, 1, 20, 2, 2, 2, 4});
                tableData.addCell(PdfUtils.createCellParagraph("", fontH3, 0.0f, 0.0f, 0.0f, 0.5f, 0, 0));
                tableData.addCell(PdfUtils.createCellParagraph("Ks", fontH3, 0.0f, 0.0f, 0.0f, 0.5f, 0, 1));
                tableData.addCell(PdfUtils.createCellParagraph("Zbo\u017e\u00ed", fontH3, 0.0f, 0.0f, 0.0f, 0.5f, 0, 0));
                tableData.addCell(PdfUtils.createCellParagraph("K\u00f3d", fontH3, 0.0f, 0.0f, 0.0f, 0.5f, 0, 0));
                tableData.addCell(PdfUtils.createCellParagraph("Sklad", fontH3, 0.0f, 0.0f, 0.0f, 0.5f, 0, 0));
                tableData.addCell(PdfUtils.createCellParagraph("Plato", fontH3, 0.0f, 0.0f, 0.0f, 0.5f, 0, 2));
                tableData.addCell(PdfUtils.createCellParagraph("Spot\u0159ebn\u00ed da\u0148", fontH3, 0.0f, 0.0f, 0.0f, 0.5f, 0, 2));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 7, 0));
                if (itemList != null) {
                    for (ImmutablePair<TransferQueueItemsDomain, StoreCardsDomain> item : itemList) {
                        TransferQueueItemsDomain transferQueueItemsDomain = (TransferQueueItemsDomain)item.getKey();
                        StoreCardsDomain storeCardsDomain = (StoreCardsDomain)item.getValue();
                        if (transferQueueItemsDomain == null || storeCardsDomain == null || transferQueueItemsDomain.getStoreCardsId() == null) continue;
                        Image rectangle = transferQueueItemsDomain.getProcessing() != null ? PdfUtils.createRectangle(writer, 0.5f, 0.0f, 0.0f, 10.0f, 10.0f, BaseColor.BLACK, BaseColor.BLACK) : PdfUtils.createRectangle(writer, 0.5f, 0.0f, 0.0f, 10.0f, 10.0f, BaseColor.BLACK);
                        tableData.addCell(PdfUtils.createCellImage(rectangle, 0.0f, 0, 0));
                        tableData.addCell(PdfUtils.createCellParagraph(Integer.toString((int)Math.round(transferQueueItemsDomain != null ? transferQueueItemsDomain.getQuantity() : 0.0)), fontH3B, 0.0f, 0.0f, 0.0f, 0.1f, 0, 1, null, null, null, BaseColor.LIGHT_GRAY));
                        tableData.addCell(PdfUtils.createCellParagraph(storeCardsDomain.getName(), fontH3B, 0.0f, 0.0f, 0.0f, 0.1f, 0, 0, null, null, null, BaseColor.LIGHT_GRAY));
                        tableData.addCell(PdfUtils.createCellParagraph(storeCardsDomain.getCode(), fontH3, 0.0f, 0.0f, 0.0f, 0.1f, 0, 0, null, null, null, BaseColor.LIGHT_GRAY));
                        StoreCardsQuantityDomain storeCardsQuantityDomain = ds.getStoreCardsQuantityDbiDao().findByStoreCodeStorecardId(fromStoreDomain.getCode(), storeCardsDomain.getAbraId());
                        if (storeCardsQuantityDomain != null) {
                            tableData.addCell(PdfUtils.createCellParagraph(Integer.toString((int)Math.round(storeCardsQuantityDomain.getQuantity())), fontH3, 0.0f, 0.0f, 0.0f, 0.1f, 0, 2, null, null, null, BaseColor.LIGHT_GRAY));
                        } else {
                            tableData.addCell(PdfUtils.createCellParagraph("0", fontH3, 0.0f, 0.0f, 0.0f, 0.1f, 0, 2, null, null, null, BaseColor.LIGHT_GRAY));
                        }
                        if (storeCardsDomain.getAbraPlato() != null && storeCardsDomain.getAbraPlato() > 0.0) {
                            tableData.addCell(PdfUtils.createCellParagraph(String.format("%s\u00b0", Integer.toString((int)Math.round(storeCardsDomain.getAbraPlato()))), fontH3, 0.0f, 0.0f, 0.0f, 0.1f, 0, 2, null, null, null, BaseColor.LIGHT_GRAY));
                        } else {
                            tableData.addCell(PdfUtils.createCellParagraph("", fontH3, 0.0f, 0.0f, 0.0f, 0.1f, 0, 2, null, null, null, BaseColor.LIGHT_GRAY));
                        }
                        if (transferQueueItemsDomain.getQuantity() != null && transferQueueItemsDomain.getQuantity() > 0.0 && storeCardsDomain.getAbraObjemlitry() != null && storeCardsDomain.getAbraObjemlitry() > 0.0 && storeCardsDomain.getAbraPlato() != null && storeCardsDomain.getAbraPlato() > 0.0 && storeCardsDomain.getAbraSazbaspotrdane() != null && storeCardsDomain.getAbraSazbaspotrdane() > 0.0) {
                            double dan = transferQueueItemsDomain.getQuantity() * storeCardsDomain.getAbraObjemlitry() * storeCardsDomain.getAbraPlato() * storeCardsDomain.getAbraSazbaspotrdane();
                            tableData.addCell(PdfUtils.createCellParagraph(String.format("%s K\u010d", df2.format(dan)), fontH3, 0.0f, 0.0f, 0.0f, 0.1f, 0, 2, null, null, null, BaseColor.LIGHT_GRAY));
                            continue;
                        }
                        tableData.addCell(PdfUtils.createCellParagraph("", fontH3, 0.0f, 0.0f, 0.0f, 0.1f, 0, 2, null, null, null, BaseColor.LIGHT_GRAY));
                    }
                }
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 7, 0));
                tableData.addCell(PdfUtils.createCellParagraph("", fontH3, 0.0f, 0.0f, 0.0f, 1.0f, 7, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 7, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 7, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 7, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 7, 0));
                tableData.addCell(PdfUtils.createCellParagraph("P\u0159evodka:", fontH3, 0.0f, 2, 0));
                tableData.addCell(PdfUtils.createCellParagraph(sdf.format(transferQueueDomain.getDateCreated()), fontH3B, 0.0f, 2, 0));
                document.add((Element)tableData);
            } else {
                log.error("TransferQueueDomain is null");
            }
        }
        catch (Exception e) {
            log.error("Exception making transfer queue: " + e.getMessage(), (Throwable)e);
        }
    }

    public static byte[] createTransferQueue(TransferQueueDomain transferQueueDomain, ArrayList<ImmutablePair<TransferQueueItemsDomain, StoreCardsDomain>> itemList, IncomingTransfersDomain incomingTransfersDomain, OutgoingTransfersDomain outgoingTransfersDomain, DaoSupportApp ds) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Document document = new Document(new Rectangle(PageSize.A4));
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)baos);
            document.open();
            PdfUtils.makeTransferQueueContent(document, writer, transferQueueDomain, itemList, incomingTransfersDomain, outgoingTransfersDomain, ds);
            document.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            log.error("Exception creating transfer queue: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static byte[] createMassTransferQueue(ArrayList<PdfInputTransferQueueDomain> list, DaoSupportApp ds) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Document document = new Document(new Rectangle(PageSize.A4));
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)baos);
            document.open();
            list.forEach(i -> {
                PdfUtils.makeTransferQueueContent(document, writer, i.getTransferQueueDomain(), i.getItemList(), i.getIncomingTransfersDomain(), i.getOutgoingTransfersDomain(), ds);
                document.newPage();
            });
            document.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            log.error("Exception creating mass transfer queue list: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String createTransferQueueBase64(TransferQueueDomain transferQueueDomain, ArrayList<ImmutablePair<TransferQueueItemsDomain, StoreCardsDomain>> itemList, IncomingTransfersDomain incomingTransfersDomain, OutgoingTransfersDomain outgoingTransfersDomain, DaoSupportApp ds) {
        byte[] transferQueue = PdfUtils.createTransferQueue(transferQueueDomain, itemList, incomingTransfersDomain, outgoingTransfersDomain, ds);
        if (transferQueue != null) {
            return Base64.getEncoder().encodeToString(transferQueue);
        }
        return null;
    }

    public static String createMassTransferQueueBase64(ArrayList<PdfInputTransferQueueDomain> list, DaoSupportApp ds) {
        byte[] transferQueues = PdfUtils.createMassTransferQueue(list, ds);
        if (transferQueues != null) {
            return Base64.getEncoder().encodeToString(transferQueues);
        }
        return null;
    }

    public static void makeOrderContent(Document document, PdfWriter writer, OrdersDomain ordersDomain, List<OrderItemsDomain> orderItemsDomainList, DaoSupportApp ds) {
        try {
            if (ordersDomain != null) {
                Barcode39 barcode39 = new Barcode39();
                barcode39.setCode(ordersDomain.getExternalnumber());
                Image code39Image = barcode39.createImageWithBarcode(writer.getDirectContent(), null, null);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm");
                String transportation = "-";
                TransportationTypesDomain transportationTypesDomain = ds.getTransportationTypesDbiDao().findByAbraId(ordersDomain.getTransportationtypeId());
                if (transportationTypesDomain != null) {
                    transportation = transportationTypesDomain.getCode();
                }
                PdfPTable tableData = new PdfPTable(5);
                tableData.setWidthPercentage(100.0f);
                float[] columnWidths1 = new float[]{1.0f, 5.0f, 0.5f, 1.5f, 1.0f};
                tableData.setWidths(columnWidths1);
                tableData.addCell(PdfUtils.createCellParagraph(ordersDomain.getOrderFirstname() + " " + ordersDomain.getOrderLastname(), fontH1, 0.0f, 2, 0));
                tableData.addCell(PdfUtils.createCellParagraph(transportation, font, 0.0f, 0, 0));
                tableData.addCell(PdfUtils.createCellParagraph(simpleDateFormat.format(ordersDomain.getDateCreated()), font, 0.0f, 2, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 5, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0.5f, 0.0f, 0.0f, 5, 0));
                HashMap<Integer, Double> vatSums = new HashMap<Integer, Double>();
                Double sum = 0.0;
                if (orderItemsDomainList != null) {
                    for (OrderItemsDomain orderItemsDomain : orderItemsDomainList) {
                        StoreCardsDomain storeCardsDomain = null;
                        Integer vatRate = null;
                        if (orderItemsDomain.getStorecardId() != null) {
                            storeCardsDomain = ds.getStoreCardsDbiDao().findByAbraId(orderItemsDomain.getStorecardId());
                            vatRate = storeCardsDomain.getVatrate();
                        } else {
                            vatRate = orderItemsDomain.getVatrate();
                        }
                        String name = "-";
                        name = storeCardsDomain != null ? storeCardsDomain.getDisplayname() : orderItemsDomain.getText();
                        String plu = "-";
                        if (storeCardsDomain != null && storeCardsDomain.getPlu() != null) {
                            plu = storeCardsDomain.getPlu().toString();
                        }
                        String ean = "-";
                        if (storeCardsDomain != null && storeCardsDomain.getEan() != null) {
                            ean = storeCardsDomain.getEan();
                        }
                        Object price = "-";
                        if (storeCardsDomain != null) {
                            if (orderItemsDomain.getTamount() != null) {
                                price = (int)Math.round(orderItemsDomain.getTamount()) + " K\u010d";
                                sum = sum + orderItemsDomain.getTamount();
                                if (vatRate != null) {
                                    if (vatSums.containsKey(vatRate)) {
                                        vatSums.put(vatRate, (Double)vatSums.get(vatRate) + orderItemsDomain.getTamount());
                                    } else {
                                        vatSums.put(vatRate, orderItemsDomain.getTamount());
                                    }
                                }
                            }
                        } else if (orderItemsDomain.getTamount() != null) {
                            price = (int)Math.round(orderItemsDomain.getTamount()) + " K\u010d";
                            sum = sum + orderItemsDomain.getTamount();
                            if (vatRate != null) {
                                if (vatSums.containsKey(vatRate)) {
                                    vatSums.put(vatRate, (Double)vatSums.get(vatRate) + orderItemsDomain.getTamount());
                                } else {
                                    vatSums.put(vatRate, orderItemsDomain.getTamount());
                                }
                            }
                        }
                        tableData.addCell(PdfUtils.createCellParagraph(Integer.toString((int)Math.round(orderItemsDomain.getQuantity())), font, 0.0f, 0, 0));
                        tableData.addCell(PdfUtils.createCellParagraph(name, font, 0.0f, 0, 0));
                        tableData.addCell(PdfUtils.createCellParagraph(plu, font, 0.0f, 0, 0));
                        tableData.addCell(PdfUtils.createCellParagraph(ean, font, 0.0f, 0, 0));
                        tableData.addCell(PdfUtils.createCellParagraph((String)price, font, 0.0f, 0, 2));
                    }
                }
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 5, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0.5f, 0.0f, 0.0f, 5, 0));
                NumberFormat nf = NumberFormat.getNumberInstance(new Locale("cs", "CZ"));
                DecimalFormat df = (DecimalFormat)nf;
                df.applyPattern("###,###.0");
                String vats = vatSums.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(t -> "DPH " + t.getKey() + " % - " + df.format(t.getValue()) + " K\u010d").collect(Collectors.joining(", "));
                tableData.addCell(PdfUtils.createCellParagraph(vats, font, 0.0f, 5, 2));
                tableData.addCell(PdfUtils.createCellParagraph(" ", font, 0.0f, 3, 0));
                tableData.addCell(PdfUtils.createCellParagraph("Celkem", fontH, 0.0f, 0, 0));
                tableData.addCell(PdfUtils.createCellParagraph((int)Math.round(sum) + " K\u010d", fontH, 0.0f, 0, 2));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 5, 0));
                PdfPTable tableDataSign = new PdfPTable(3);
                tableDataSign.setTotalWidth(50.0f);
                float[] columnWidths2 = new float[]{0.5f, 0.1f, 0.5f};
                tableDataSign.setWidths(columnWidths2);
                tableDataSign.addCell(PdfUtils.createCellParagraph("Datum:", font, 0.0f, 0.5f, 0.0f, 0.0f, 0, 0));
                tableDataSign.addCell(PdfUtils.createCellParagraph(" ", font, 0.0f, 0, 0));
                tableDataSign.addCell(PdfUtils.createCellParagraph("Prevzal/a:", font, 0.0f, 0.5f, 0.0f, 0.0f, 0, 0));
                tableData.addCell(PdfUtils.createCellTable(tableDataSign, 0.0f, 2, 0));
                tableData.addCell(PdfUtils.createCellImage(code39Image, 0.0f, 3, 2));
                document.add((Element)tableData);
            } else {
                log.error("OrdersDomain is null");
            }
        }
        catch (Exception e) {
            log.error("Exception making order: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void makeOrderWithDeliveryContent(Document document, PdfWriter writer, OrdersDomain ordersDomain, List<OrderItemsDomain> orderItemsDomainList, AddressesDomain firmResidenceAddress, AddressesDomain firmOfficeAddress, DaoSupportApp ds, FirmOfficesDomain firmOfficesDomain) {
        try {
            if (ordersDomain != null) {
                Barcode39 barcode39 = new Barcode39();
                barcode39.setCode(ordersDomain.getExternalnumber());
                Image code39Image = barcode39.createImageWithBarcode(writer.getDirectContent(), null, null);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm");
                String transportation = "-";
                TransportationTypesDomain transportationTypesDomain = ds.getTransportationTypesDbiDao().findByAbraId(ordersDomain.getTransportationtypeId());
                if (transportationTypesDomain != null) {
                    transportation = transportationTypesDomain.getCode();
                }
                PdfPTable tableData = new PdfPTable(5);
                tableData.setWidthPercentage(100.0f);
                float[] columnWidths1 = new float[]{1.0f, 5.0f, 0.5f, 1.5f, 1.0f};
                tableData.setWidths(columnWidths1);
                tableData.addCell(PdfUtils.createCellParagraph(ordersDomain.getOrderFirstname() + " " + ordersDomain.getOrderLastname(), fontH1, 0.0f, 2, 0));
                tableData.addCell(PdfUtils.createCellParagraph(transportation, font, 0.0f, 0, 0));
                tableData.addCell(PdfUtils.createCellParagraph(simpleDateFormat.format(ordersDomain.getDateCreated()), font, 0.0f, 2, 0));
                String addressLine = String.format("%s%s%s%s%s%s", firmOfficeAddress != null && firmOfficeAddress.getPhonenumber1() != null ? String.format("Tel.: %s, ", firmOfficeAddress.getPhonenumber1()) : (ordersDomain != null && ordersDomain.getOrderPhone() != null ? String.format("Tel.: %s, ", ordersDomain.getOrderPhone()) : ""), firmOfficesDomain != null && firmOfficesDomain.getDisplayname() != null && !firmOfficesDomain.getDisplayname().equalsIgnoreCase("Provozovna") ? firmOfficesDomain.getDisplayname() + ", " : "", firmOfficeAddress != null && firmOfficeAddress.getRecipient() != null ? firmOfficeAddress.getRecipient() + ", " : "", firmOfficeAddress != null && firmOfficeAddress.getStreet() != null ? firmOfficeAddress.getStreet() + ", " : "", firmOfficeAddress != null && firmOfficeAddress.getCity() != null ? firmOfficeAddress.getCity() + ", " : "", firmOfficeAddress != null && firmOfficeAddress.getPostcode() != null ? firmOfficeAddress.getPostcode() : "");
                tableData.addCell(PdfUtils.createCellParagraph(addressLine, fontH3, 0.0f, 5, 0));
                tableData.addCell(PdfUtils.createCellParagraph(ordersDomain.getDescription() != null ? ordersDomain.getDescription() : "", font, 0.0f, 5, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 5, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0.5f, 0.0f, 0.0f, 5, 0));
                HashMap<Integer, Double> vatSums = new HashMap<Integer, Double>();
                Double sum = 0.0;
                if (orderItemsDomainList != null) {
                    for (OrderItemsDomain orderItemsDomain : orderItemsDomainList) {
                        StoreCardsDomain storeCardsDomain = null;
                        Integer vatRate = null;
                        if (orderItemsDomain.getStorecardId() != null) {
                            storeCardsDomain = ds.getStoreCardsDbiDao().findByAbraId(orderItemsDomain.getStorecardId());
                            vatRate = storeCardsDomain.getVatrate();
                        } else {
                            vatRate = orderItemsDomain.getVatrate();
                        }
                        String name = "-";
                        name = storeCardsDomain != null ? storeCardsDomain.getDisplayname() : orderItemsDomain.getText();
                        String plu = "-";
                        if (storeCardsDomain != null && storeCardsDomain.getPlu() != null) {
                            plu = storeCardsDomain.getPlu().toString();
                        }
                        String ean = "-";
                        if (storeCardsDomain != null && storeCardsDomain.getEan() != null) {
                            ean = storeCardsDomain.getEan();
                        }
                        Object price = "-";
                        if (storeCardsDomain != null) {
                            if (orderItemsDomain.getTamount() != null) {
                                price = (int)Math.round(orderItemsDomain.getTamount()) + " K\u010d";
                                sum = sum + orderItemsDomain.getTamount();
                                if (vatRate != null) {
                                    if (vatSums.containsKey(vatRate)) {
                                        vatSums.put(vatRate, (Double)vatSums.get(vatRate) + orderItemsDomain.getTamount());
                                    } else {
                                        vatSums.put(vatRate, orderItemsDomain.getTamount());
                                    }
                                }
                            }
                        } else if (orderItemsDomain.getTamount() != null) {
                            price = (int)Math.round(orderItemsDomain.getTamount()) + " K\u010d";
                            sum = sum + orderItemsDomain.getTamount();
                            if (vatRate != null) {
                                if (vatSums.containsKey(vatRate)) {
                                    vatSums.put(vatRate, (Double)vatSums.get(vatRate) + orderItemsDomain.getTamount());
                                } else {
                                    vatSums.put(vatRate, orderItemsDomain.getTamount());
                                }
                            }
                        }
                        tableData.addCell(PdfUtils.createCellParagraph(Integer.toString((int)Math.round(orderItemsDomain.getQuantity())), font, 0.0f, 0, 0));
                        tableData.addCell(PdfUtils.createCellParagraph(name, font, 0.0f, 0, 0));
                        tableData.addCell(PdfUtils.createCellParagraph(plu, font, 0.0f, 0, 0));
                        tableData.addCell(PdfUtils.createCellParagraph(ean, font, 0.0f, 0, 0));
                        tableData.addCell(PdfUtils.createCellParagraph((String)price, font, 0.0f, 0, 2));
                    }
                }
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 5, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0.5f, 0.0f, 0.0f, 5, 0));
                NumberFormat nf = NumberFormat.getNumberInstance(new Locale("cs", "CZ"));
                DecimalFormat df = (DecimalFormat)nf;
                df.applyPattern("###,###.0");
                String vats = vatSums.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(t -> "DPH " + t.getKey() + " % - " + df.format(t.getValue()) + " K\u010d").collect(Collectors.joining(", "));
                tableData.addCell(PdfUtils.createCellParagraph(vats, font, 0.0f, 5, 2));
                tableData.addCell(PdfUtils.createCellParagraph(" ", font, 0.0f, 3, 0));
                tableData.addCell(PdfUtils.createCellParagraph("Celkem", fontH, 0.0f, 0, 0));
                tableData.addCell(PdfUtils.createCellParagraph((int)Math.round(sum) + " K\u010d", fontH, 0.0f, 0, 2));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 5, 0));
                PdfPTable tableDataSign = new PdfPTable(3);
                tableDataSign.setTotalWidth(50.0f);
                float[] columnWidths2 = new float[]{0.5f, 0.1f, 0.5f};
                tableDataSign.setWidths(columnWidths2);
                tableDataSign.addCell(PdfUtils.createCellParagraph("Datum:", font, 0.0f, 0.5f, 0.0f, 0.0f, 0, 0));
                tableDataSign.addCell(PdfUtils.createCellParagraph(" ", font, 0.0f, 0, 0));
                tableDataSign.addCell(PdfUtils.createCellParagraph("Prevzal/a:", font, 0.0f, 0.5f, 0.0f, 0.0f, 0, 0));
                tableData.addCell(PdfUtils.createCellTable(tableDataSign, 0.0f, 2, 0));
                tableData.addCell(PdfUtils.createCellImage(code39Image, 0.0f, 3, 2));
                document.add((Element)tableData);
            } else {
                log.error("OrdersDomain is null");
            }
        }
        catch (Exception e) {
            log.error("Exception making order: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void makeThermo80OrderWithDeliveryContent(Document document, PdfWriter writer, OrdersDomain ordersDomain, List<OrderItemsDomain> orderItemsDomainList, AddressesDomain firmResidenceAddress, AddressesDomain firmOfficeAddress, DaoSupportApp ds, FirmOfficesDomain firmOfficesDomain) {
        try {
            if (ordersDomain != null) {
                PdfPCell cellImage;
                Image imageLogo;
                URL resource;
                Barcode39 barcode39 = new Barcode39();
                barcode39.setCode(ordersDomain.getExternalnumber());
                barcode39.setX(1.2f);
                barcode39.setSize(10.0f);
                Image code39Image = barcode39.createImageWithBarcode(writer.getDirectContent(), null, null);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm");
                String transportation = "-";
                TransportationTypesDomain transportationTypesDomain = ds.getTransportationTypesDbiDao().findByAbraId(ordersDomain.getTransportationtypeId());
                if (transportationTypesDomain != null) {
                    transportation = transportationTypesDomain.getCode();
                }
                PdfPTable tableData = new PdfPTable(2);
                tableData.setWidthPercentage(100.0f);
                float[] columnWidths1 = new float[]{0.7f, 0.3f};
                tableData.setWidths(columnWidths1);
                if (ordersDomain.getSource().getFamily() == OrderSource.DELIKATESY) {
                    resource = PdfUtils.getResourceDelikatesyBwBmp();
                    imageLogo = Image.getInstance((URL)resource);
                    imageLogo.scalePercent(20.0f);
                    cellImage = PdfUtils.createCellImage(imageLogo, 0.0f, 2, 1);
                    cellImage.setFixedHeight(80.0f);
                    tableData.addCell(cellImage);
                } else {
                    resource = PdfUtils.getResourceBeershopLogoNewBmp();
                    imageLogo = Image.getInstance((URL)resource);
                    imageLogo.scalePercent(30.0f);
                    cellImage = PdfUtils.createCellImage(imageLogo, 0.0f, 2, 1);
                    cellImage.setFixedHeight(110.0f);
                    tableData.addCell(cellImage);
                }
                tableData.addCell(PdfUtils.createCellImage(code39Image, 0.0f, 2, 1));
                tableData.addCell(PdfUtils.createCellParagraph(ordersDomain.getExternalnumber(), fontH1, 0.0f, 2, 1));
                tableData.addCell(PdfUtils.createCellParagraph(transportation, fontH1, 0.0f, 2, 1));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH2, 0.0f, 2, 0));
                tableData.addCell(PdfUtils.createCellParagraph(ordersDomain.getOrderFirstname() + " " + ordersDomain.getOrderLastname(), fontH1, 0.0f, 2, 0));
                tableData.addCell(PdfUtils.createCellParagraph(ordersDomain.getOrderEmail(), fontH2, 0.0f, 2, 0));
                StringBuilder addr = new StringBuilder();
                if (firmOfficeAddress != null) {
                    tableData.addCell(PdfUtils.createCellParagraph(firmOfficeAddress.getPhonenumber1() != null ? String.format("Tel.: %s", firmOfficeAddress.getPhonenumber1()) : (ordersDomain != null && ordersDomain.getOrderPhone() != null ? String.format("Tel.: %s", ordersDomain.getOrderPhone()) : ""), fontH2, 0.0f, 2, 0));
                    addr.append((String)(firmOfficesDomain.getDisplayname() != null && !firmOfficesDomain.getDisplayname().equalsIgnoreCase("Provozovna") ? firmOfficesDomain.getDisplayname() + ", " : ""));
                    addr.append((String)(firmOfficeAddress.getRecipient() != null ? firmOfficeAddress.getRecipient() + ", " : ""));
                    addr.append((String)(firmOfficeAddress.getStreet() != null ? firmOfficeAddress.getStreet() + ", " : ""));
                    addr.append((String)(firmOfficeAddress.getCity() != null ? firmOfficeAddress.getCity() + ", " : ""));
                    addr.append(firmOfficeAddress.getPostcode() != null ? firmOfficeAddress.getPostcode() : "");
                    tableData.addCell(PdfUtils.createCellParagraph(addr.toString(), fontH2, 0.0f, 2, 0));
                }
                StringBuilder addrRes = new StringBuilder();
                if (firmResidenceAddress != null) {
                    addrRes.append((String)(firmOfficesDomain.getDisplayname() != null && !firmOfficesDomain.getDisplayname().equalsIgnoreCase("Provozovna") ? firmOfficesDomain.getDisplayname() + ", " : ""));
                    addrRes.append((String)(firmResidenceAddress.getRecipient() != null ? firmResidenceAddress.getRecipient() + ", " : ""));
                    addrRes.append((String)(firmResidenceAddress.getStreet() != null ? firmResidenceAddress.getStreet() + ", " : ""));
                    addrRes.append((String)(firmResidenceAddress.getCity() != null ? firmResidenceAddress.getCity() + ", " : ""));
                    addrRes.append(firmResidenceAddress.getPostcode() != null ? firmResidenceAddress.getPostcode() : "");
                    if (!addr.toString().equalsIgnoreCase(addrRes.toString())) {
                        tableData.addCell(PdfUtils.createCellParagraph("Doru\u010dovac\u00ed adresa:", fontH3, 0.0f, 2, 0));
                        tableData.addCell(PdfUtils.createCellParagraph(firmResidenceAddress.getPhonenumber1() != null ? String.format("Tel.: %s", firmResidenceAddress.getPhonenumber1()) : (ordersDomain != null && ordersDomain.getOrderPhone() != null ? String.format("Tel.: %s", ordersDomain.getOrderPhone()) : ""), fontH2, 0.0f, 2, 0));
                        tableData.addCell(PdfUtils.createCellParagraph(addrRes.toString(), fontH2, 0.0f, 2, 0));
                    }
                }
                tableData.addCell(PdfUtils.createCellParagraph(simpleDateFormat.format(ordersDomain.getDateCreated()), fontH2, 0.0f, 2, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH2, 0.0f, 2, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH2, 0.0f, 0.5f, 0.0f, 0.0f, 2, 0));
                HashMap<Integer, Double> vatSums = new HashMap<Integer, Double>();
                Double sum = 0.0;
                if (orderItemsDomainList != null) {
                    for (OrderItemsDomain orderItemsDomain : orderItemsDomainList) {
                        StoreCardsDomain storeCardsDomain = null;
                        Integer vatRate = null;
                        if (orderItemsDomain.getStorecardId() != null) {
                            storeCardsDomain = ds.getStoreCardsDbiDao().findByAbraId(orderItemsDomain.getStorecardId());
                            vatRate = storeCardsDomain.getVatrate();
                        } else {
                            vatRate = orderItemsDomain.getVatrate();
                        }
                        String plu = "";
                        if (storeCardsDomain != null && storeCardsDomain.getPlu() != null) {
                            plu = storeCardsDomain.getPlu().toString();
                        }
                        String name = "-";
                        name = storeCardsDomain != null ? storeCardsDomain.getDisplayname() : orderItemsDomain.getText();
                        if (plu != null && !plu.isEmpty() && name != null) {
                            name = name.replace(plu, "").trim();
                        }
                        String ean = "";
                        if (storeCardsDomain != null && storeCardsDomain.getEan() != null) {
                            ean = storeCardsDomain.getEan();
                        }
                        Object price = "-";
                        if (storeCardsDomain != null) {
                            if (orderItemsDomain.getTamount() != null) {
                                price = (int)Math.round(orderItemsDomain.getTamount()) + " K\u010d";
                                sum = sum + orderItemsDomain.getTamount();
                                if (vatRate != null) {
                                    if (vatSums.containsKey(vatRate)) {
                                        vatSums.put(vatRate, (Double)vatSums.get(vatRate) + orderItemsDomain.getTamount());
                                    } else {
                                        vatSums.put(vatRate, orderItemsDomain.getTamount());
                                    }
                                }
                            }
                        } else if (orderItemsDomain.getTamount() != null) {
                            price = (int)Math.round(orderItemsDomain.getTamount()) + " K\u010d";
                            sum = sum + orderItemsDomain.getTamount();
                            if (vatRate != null) {
                                if (vatSums.containsKey(vatRate)) {
                                    vatSums.put(vatRate, (Double)vatSums.get(vatRate) + orderItemsDomain.getTamount());
                                } else {
                                    vatSums.put(vatRate, orderItemsDomain.getTamount());
                                }
                            }
                        }
                        Object itemInfo = "";
                        if (plu != null && !plu.isEmpty()) {
                            itemInfo = (String)itemInfo + String.format("%s ks", Integer.toString((int)Math.round(orderItemsDomain.getQuantity())));
                        } else if (orderItemsDomain.getQuantity() > 1.0) {
                            itemInfo = (String)itemInfo + String.format("%s ks", Integer.toString((int)Math.round(orderItemsDomain.getQuantity())));
                        }
                        if (plu != null && !plu.isEmpty()) {
                            itemInfo = (String)itemInfo + "    " + String.format("%s", plu);
                        }
                        if (ean != null && !ean.isEmpty()) {
                            itemInfo = (String)itemInfo + "    " + String.format("%s", ean);
                        }
                        tableData.addCell(PdfUtils.createCellParagraph(!((String)itemInfo).trim().equalsIgnoreCase("") ? ((String)itemInfo).trim() : name, ((String)itemInfo).trim().equalsIgnoreCase("") ? fontH3 : fontH3B, 0.0f, 0, 0));
                        tableData.addCell(PdfUtils.createCellParagraph((String)price, fontH3B, 0.0f, 0, 2));
                        if (!((String)itemInfo).trim().equalsIgnoreCase("")) {
                            tableData.addCell(PdfUtils.createCellParagraph(name, fontH3, 0.0f, 2, 0));
                        }
                        PdfPCell cellParagraph1 = PdfUtils.createCellParagraph(" ", fontH2, 0.0f, 2, 0);
                        cellParagraph1.setFixedHeight(5.0f);
                        tableData.addCell(cellParagraph1);
                        PdfPCell cellParagraph = PdfUtils.createCellParagraph(" ", fontH2, 0.0f, 0.5f, 0.0f, 0.0f, 2, 0);
                        cellParagraph.setFixedHeight(5.0f);
                        tableData.addCell(cellParagraph);
                    }
                }
                NumberFormat nf = NumberFormat.getNumberInstance(new Locale("cs", "CZ"));
                DecimalFormat df = (DecimalFormat)nf;
                df.applyPattern("###,###.0");
                Stream sorted = vatSums.entrySet().stream().sorted(Map.Entry.comparingByKey());
                sorted.forEach(t -> {
                    tableData.addCell(PdfUtils.createCellParagraph("DPH " + t.getKey() + " %", fontH3, 0.0f, 0, 0));
                    tableData.addCell(PdfUtils.createCellParagraph(df.format(t.getValue()) + " K\u010d", fontH3, 0.0f, 0, 2));
                });
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 2, 0));
                tableData.addCell(PdfUtils.createCellParagraph("Celkem", fontH2B, 0.0f, 0, 0));
                tableData.addCell(PdfUtils.createCellParagraph((int)Math.round(sum) + " K\u010d", fontH2B, 0.0f, 0, 2));
                tableData.addCell(PdfUtils.createCellParagraph("Datum:", fontH3, 0.0f, 0.5f, 0.0f, 0.0f, 2, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 2, 0));
                tableData.addCell(PdfUtils.createCellParagraph("Prevzal/a:", fontH3, 0.0f, 0.5f, 0.0f, 0.0f, 2, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", font, 0.0f, 2, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH2, 0.0f, 2, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH2, 0.0f, 2, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH2, 0.0f, 0.5f, 0.0f, 0.0f, 2, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH2, 0.0f, 2, 0));
                tableData.addCell(PdfUtils.createCellParagraph(ordersDomain.getOrderFirstname() + " " + ordersDomain.getOrderLastname(), fontH1, 0.0f, 2, 1));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH2, 0.0f, 2, 0));
                tableData.addCell(PdfUtils.createCellImage(code39Image, 0.0f, 2, 1));
                tableData.addCell(PdfUtils.createCellParagraph(ordersDomain.getExternalnumber(), fontH1, 0.0f, 0, 1));
                tableData.addCell(PdfUtils.createCellParagraph(transportation, fontH1, 0.0f, 2, 0));
                tableData.addCell(PdfUtils.createCellParagraph(simpleDateFormat.format(Calendar.getInstance().getTime()), fontH2, 0.0f, 2, 1));
                document.add((Element)tableData);
            } else {
                log.error("OrdersDomain is null");
            }
        }
        catch (Exception e) {
            log.error("Exception making order: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void makeThermo80DeliveryListContent(Document document, PdfWriter writer, OrdersDomain ordersDomain, DeliveryListDomain deliveryListDomain, AddressesDomain firmResidenceAddress, AddressesDomain firmOfficeAddress, ArrayList<ImmutablePair<DeliveryListItemsDomain, StoreCardsDomain>> itemList, TransportationTypesDomain transportationTypesDomain, AbraPaymenttypesDomain abraPaymenttypesDomain, FirmOfficesDomain firmOfficesDomain) {
        try {
            if (ordersDomain != null) {
                Image imageLogo;
                Barcode39 barcode39 = new Barcode39();
                barcode39.setCode(ordersDomain.getExternalnumber());
                barcode39.setX(1.2f);
                barcode39.setSize(10.0f);
                Image code39Image = barcode39.createImageWithBarcode(writer.getDirectContent(), null, null);
                String transportation = "-";
                if (transportationTypesDomain != null) {
                    transportation = transportationTypesDomain.getCode();
                }
                PdfPTable tableData = new PdfPTable(4);
                tableData.setWidthPercentage(100.0f);
                float[] columnWidths1 = new float[]{0.1f, 0.2f, 0.3f, 0.4f};
                tableData.setWidths(columnWidths1);
                switch (ordersDomain.getSourceFamily()) {
                    case BEERSHOP: {
                        URL resource = PdfUtils.getResourceBeershopLogoNewBmp();
                        imageLogo = Image.getInstance((URL)resource);
                        imageLogo.scalePercent(30.0f);
                        break;
                    }
                    default: {
                        URL resource = PdfUtils.getResourceDelikatesyBwBmp();
                        imageLogo = Image.getInstance((URL)resource);
                        imageLogo.scalePercent(20.0f);
                    }
                }
                PdfPCell cellImage = PdfUtils.createCellImage(imageLogo, 0.0f, 4, 1);
                cellImage.setFixedHeight(80.0f);
                tableData.addCell(cellImage);
                tableData.addCell(PdfUtils.createCellImage(code39Image, 0.0f, 4, 1));
                tableData.addCell(PdfUtils.createCellParagraph("DODAC\u00cd LIST ", fontH130, 0.0f, 4, 1));
                tableData.addCell(PdfUtils.createCellParagraph(deliveryListDomain.getDisplayname(), fontH1, 0.0f, 4, 1));
                tableData.addCell(PdfUtils.createCellParagraph(ordersDomain.getExternalnumber(), fontH1, 0.0f, 3, 1));
                tableData.addCell(PdfUtils.createCellParagraph(transportation, fontH1, 0.0f, 0, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH2, 0.0f, 4, 0));
                tableData.addCell(PdfUtils.createCellParagraph(String.format("Datum vystaven\u00ed: %s", new SimpleDateFormat("dd.MM.yyyy").format(deliveryListDomain.getDateCreated())), fontH2, 0.0f, 4, 1));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH2, 0.0f, 4, 0));
                tableData.addCell(PdfUtils.createCellParagraph(ordersDomain.getOrderFirstname() + " " + ordersDomain.getOrderLastname(), fontH1, 0.0f, 4, 0));
                tableData.addCell(PdfUtils.createCellParagraph(ordersDomain.getOrderEmail(), fontH2, 0.0f, 4, 0));
                StringBuilder addr = new StringBuilder();
                if (firmOfficeAddress != null) {
                    tableData.addCell(PdfUtils.createCellParagraph(firmOfficeAddress.getPhonenumber1() != null ? String.format("Tel.: %s", firmOfficeAddress.getPhonenumber1()) : (ordersDomain != null && ordersDomain.getOrderPhone() != null ? String.format("Tel.: %s", ordersDomain.getOrderPhone()) : ""), fontH2, 0.0f, 4, 0));
                    addr.append((String)(firmOfficesDomain.getDisplayname() != null && !firmOfficesDomain.getDisplayname().equalsIgnoreCase("Provozovna") ? firmOfficesDomain.getDisplayname() + ", " : ""));
                    addr.append((String)(firmOfficeAddress.getRecipient() != null ? firmOfficeAddress.getRecipient() + ", " : ""));
                    addr.append((String)(firmOfficeAddress.getStreet() != null ? firmOfficeAddress.getStreet() + ", " : ""));
                    addr.append((String)(firmOfficeAddress.getCity() != null ? firmOfficeAddress.getCity() + ", " : ""));
                    addr.append(firmOfficeAddress.getPostcode() != null ? firmOfficeAddress.getPostcode() : "");
                    tableData.addCell(PdfUtils.createCellParagraph(addr.toString(), fontH2, 0.0f, 4, 0));
                }
                StringBuilder addrRes = new StringBuilder();
                if (firmResidenceAddress != null) {
                    addrRes.append((String)(firmOfficesDomain.getDisplayname() != null && !firmOfficesDomain.getDisplayname().equalsIgnoreCase("Provozovna") ? firmOfficesDomain.getDisplayname() + ", " : ""));
                    addrRes.append((String)(firmResidenceAddress.getRecipient() != null ? firmResidenceAddress.getRecipient() + ", " : ""));
                    addrRes.append((String)(firmResidenceAddress.getStreet() != null ? firmResidenceAddress.getStreet() + ", " : ""));
                    addrRes.append((String)(firmResidenceAddress.getCity() != null ? firmResidenceAddress.getCity() + ", " : ""));
                    addrRes.append(firmResidenceAddress.getPostcode() != null ? firmResidenceAddress.getPostcode() : "");
                    if (!addr.toString().equalsIgnoreCase(addrRes.toString())) {
                        tableData.addCell(PdfUtils.createCellParagraph("Doru\u010dovac\u00ed adresa:", fontH3, 0.0f, 4, 0));
                        tableData.addCell(PdfUtils.createCellParagraph(firmResidenceAddress.getPhonenumber1() != null ? String.format("Tel.: %s", firmResidenceAddress.getPhonenumber1()) : (ordersDomain != null && ordersDomain.getOrderPhone() != null ? String.format("Tel.: %s", ordersDomain.getOrderPhone()) : ""), fontH2, 0.0f, 4, 0));
                        tableData.addCell(PdfUtils.createCellParagraph(addrRes.toString(), fontH2, 0.0f, 4, 0));
                    }
                }
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH2, 0.0f, 4, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH2, 0.0f, 0.5f, 0.0f, 0.0f, 4, 0));
                if (itemList != null) {
                    for (ImmutablePair<DeliveryListItemsDomain, StoreCardsDomain> item : itemList) {
                        DeliveryListItemsDomain deliveryListItemsDomain = (DeliveryListItemsDomain)item.getKey();
                        StoreCardsDomain storeCardsDomain = (StoreCardsDomain)item.getValue();
                        String plu = "";
                        if (storeCardsDomain != null && storeCardsDomain.getPlu() != null) {
                            plu = storeCardsDomain.getPlu().toString();
                        }
                        String name = "-";
                        if (storeCardsDomain != null) {
                            name = storeCardsDomain.getDisplayname();
                        }
                        if (plu != null && !plu.isEmpty() && name != null) {
                            name = name.replace(plu, "").trim();
                        }
                        String ean = "";
                        if (storeCardsDomain != null && storeCardsDomain.getEan() != null) {
                            ean = storeCardsDomain.getEan();
                        }
                        String itemInfo = (int)Math.round(deliveryListItemsDomain != null ? deliveryListItemsDomain.getQuantity() : 0.0) + " " + (deliveryListItemsDomain != null ? deliveryListItemsDomain.getQunit() : "");
                        if (deliveryListItemsDomain.getStorecardId() == null) continue;
                        tableData.addCell(PdfUtils.createCellImage(PdfUtils.createRectangle(writer, 0.5f, 0.0f, 0.0f, 10.0f, 10.0f, BaseColor.BLACK), 0.0f, 0, 1));
                        tableData.addCell(PdfUtils.createCellParagraph(!itemInfo.trim().equalsIgnoreCase("") ? itemInfo.trim() : name, itemInfo.trim().equalsIgnoreCase("") ? fontH3 : fontH3B, 0.0f, 0, 0));
                        tableData.addCell(PdfUtils.createCellParagraph(plu, fontH3B, 0.0f, 0, 2));
                        tableData.addCell(PdfUtils.createCellParagraph(ean, fontH3B, 0.0f, 0, 2));
                        tableData.addCell(PdfUtils.createCellParagraph(name, fontH3, 0.0f, 0.0f, 0.0f, 0.5f, 4, 0));
                    }
                }
                tableData.addCell(PdfUtils.createCellParagraph("Datum:", fontH3, 0.0f, 0.0f, 0.0f, 0.0f, 4, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 4, 0));
                tableData.addCell(PdfUtils.createCellParagraph("Prevzal/a:", fontH3, 0.0f, 0.5f, 0.0f, 0.0f, 4, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", font, 0.0f, 4, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH2, 0.0f, 4, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH2, 0.0f, 4, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH2, 0.0f, 0.5f, 0.0f, 0.0f, 4, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH2, 0.0f, 4, 0));
                document.add((Element)tableData);
            } else {
                log.error("OrdersDomain is null");
            }
        }
        catch (Exception e) {
            log.error("Exception making order: " + e.getMessage(), (Throwable)e);
        }
    }

    public static byte[] createThermo80DeliveryList(OrdersDomain ordersDomain, DeliveryListDomain deliveryListDomain, AddressesDomain firmResidenceAddress, AddressesDomain firmOfficeAddress, ArrayList<ImmutablePair<DeliveryListItemsDomain, StoreCardsDomain>> itemList, TransportationTypesDomain transportationTypesDomain, AbraPaymenttypesDomain abraPaymenttypesDomain, FirmOfficesDomain firmOfficesDomain) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Document document = new Document((Rectangle)new RectangleReadOnly(204.0f, 148.0f), 0.0f, 0.0f, 0.0f, 0.0f);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)baos);
            document.open();
            PdfUtils.makeThermo80DeliveryListContent(document, writer, ordersDomain, deliveryListDomain, firmResidenceAddress, firmOfficeAddress, itemList, transportationTypesDomain, abraPaymenttypesDomain, firmOfficesDomain);
            document.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            log.error("Exception create delivery list: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static byte[] createMassThermo80DeliveryList(ArrayList<PdfInputDeliveryListDomain> list) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Document document = new Document(new Rectangle(PageSize.A4));
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)baos);
            document.open();
            list.forEach(i -> {
                PdfUtils.makeThermo80DeliveryListContent(document, writer, i.getOrdersDomain(), i.getDeliveryListDomain(), i.getFirmResidenceAddress(), i.getFirmOfficeAddress(), i.getItemList(), i.getTransportationTypesDomain(), i.getAbraPaymenttypesDomain(), i.getFirmOfficesDomain());
                document.newPage();
            });
            document.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            log.error("Exception create mass delivery list: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String createThermo80DeliveryListBase64(OrdersDomain ordersDomain, DeliveryListDomain deliveryListDomain, AddressesDomain firmResidenceAddress, AddressesDomain firmOfficeAddress, ArrayList<ImmutablePair<DeliveryListItemsDomain, StoreCardsDomain>> itemList, TransportationTypesDomain transportationTypesDomain, AbraPaymenttypesDomain abraPaymenttypesDomain, FirmOfficesDomain firmOfficesDomain) {
        byte[] deliveryList = PdfUtils.createThermo80DeliveryList(ordersDomain, deliveryListDomain, firmResidenceAddress, firmOfficeAddress, itemList, transportationTypesDomain, abraPaymenttypesDomain, firmOfficesDomain);
        if (deliveryList != null) {
            return Base64.getEncoder().encodeToString(deliveryList);
        }
        return null;
    }

    public static String createMassThermo80DeliveryListBase64(ArrayList<PdfInputDeliveryListDomain> list) {
        byte[] deliveryLists = PdfUtils.createMassThermo80DeliveryList(list);
        if (deliveryLists != null) {
            return Base64.getEncoder().encodeToString(deliveryLists);
        }
        return null;
    }

    public static void makeCollectionListDpdContent(Document document, PdfWriter writer, CollectionListDomain collectionListDomain, List<CollectionListItemDomain> collectionListItemDomainList, DaoSupportApp ds) {
        try {
            if (collectionListDomain != null) {
                PdfPTable tableData = new PdfPTable(5);
                tableData.setWidthPercentage(100.0f);
                float[] columnWidths1 = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
                tableData.setWidths(columnWidths1);
                tableData.addCell(PdfUtils.createCellParagraph("DPD svozov\u00fd list", fontH1, 0.0f, 5, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0.5f, 0.0f, 0.0f, 5, 0));
                Integer sumPcs = 0;
                Double sumWeight = 0.0;
                if (collectionListItemDomainList != null) {
                    for (CollectionListItemDomain collectionListItemDomain : collectionListItemDomainList) {
                        if (collectionListItemDomain != null) {
                            BalikobotOrderDomain balikobotOrderDomain = ds.getBalikobotOrderDbiDao().findById(collectionListItemDomain.getBalikobotOrderId());
                            if (balikobotOrderDomain != null) {
                                tableData.addCell(PdfUtils.createCellParagraph("\u010c\u00edslo z\u00e1silky", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("P\u0159\u00edjemce z\u00e1silky", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("Po\u010det jednotek", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("Slu\u017eby", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("", font, 0.0f, 0, 0));
                                sumPcs = sumPcs + balikobotOrderDomain.getPackageCnt();
                                tableData.addCell(PdfUtils.createCellParagraph(balikobotOrderDomain.getCarrierId(), fontH, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph(balikobotOrderDomain.getFirm() != null ? balikobotOrderDomain.getFirm() : balikobotOrderDomain.getDisplayName(), fontH, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph(balikobotOrderDomain.getPackageCnt().toString(), fontH, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("Produkt:", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph(balikobotOrderDomain.getServiceType(), font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("Referen\u010dn\u00ed \u010d\u00edslo", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("Adresa", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("Hmotnost v Kg", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("Dob\u00edrka:", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph(balikobotOrderDomain.getCod() == 1 ? String.format("%s / %s", balikobotOrderDomain.getCodPrice(), balikobotOrderDomain.getCodPriceCurrencyCode()) : "", fontH, 0.0f, 0, 0));
                                sumWeight = sumWeight + balikobotOrderDomain.getWeight() / 1000.0;
                                tableData.addCell(PdfUtils.createCellParagraph(balikobotOrderDomain.getPackageId(), fontH, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph(String.format("%s, %s, %s", balikobotOrderDomain.getStreet(), balikobotOrderDomain.getCity(), balikobotOrderDomain.getPostcode()), fontH, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph(Double.toString(balikobotOrderDomain.getWeight() / 1000.0), fontH, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("Kontaktn\u00ed osoba", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("Hodnota z\u00e1silky", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph(balikobotOrderDomain.getDisplayName(), fontH, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph(String.format("%s / %s", balikobotOrderDomain.getPrice(), balikobotOrderDomain.getPriceCurrencyCode()), fontH, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0.5f, 0.0f, 0.0f, 5, 0));
                                continue;
                            }
                            log.error(String.format("Cannot find BalikobotOrderDomain by id[%d]", collectionListItemDomain.getBalikobotOrderId()));
                            continue;
                        }
                        log.error(String.format("Collection item is NULL for: %s", collectionListDomain));
                    }
                    tableData.addCell(PdfUtils.createCellParagraph("Po\u010det z\u00e1silek", fontH, 0.0f, 0, 0));
                    tableData.addCell(PdfUtils.createCellParagraph(Integer.valueOf(collectionListItemDomainList.size()).toString(), fontH1, 0.0f, 4, 0));
                    tableData.addCell(PdfUtils.createCellParagraph("Po\u010det jednotek", fontH, 0.0f, 0, 0));
                    tableData.addCell(PdfUtils.createCellParagraph(sumPcs.toString(), fontH1, 0.0f, 4, 0));
                    tableData.addCell(PdfUtils.createCellParagraph("Celkov\u00e1 v\u00e1ha", fontH, 0.0f, 0, 0));
                    tableData.addCell(PdfUtils.createCellParagraph(String.format("%s Kg", sumWeight.toString()), fontH1, 0.0f, 4, 0));
                } else {
                    log.error("No collection list items");
                }
                document.add((Element)tableData);
            } else {
                log.error("CollectionListDomain is null");
            }
        }
        catch (Exception e) {
            log.error("Exception making CollectionList: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void makeCollectionListWedoContent(Document document, PdfWriter writer, CollectionListDomain collectionListDomain, List<CollectionListItemDomain> collectionListItemDomainList, DaoSupportApp ds) {
        try {
            if (collectionListDomain != null) {
                PdfPTable tableData = new PdfPTable(5);
                tableData.setWidthPercentage(100.0f);
                float[] columnWidths1 = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
                tableData.setWidths(columnWidths1);
                tableData.addCell(PdfUtils.createCellParagraph("WEDO svozov\u00fd list", fontH1, 0.0f, 5, 0));
                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0.5f, 0.0f, 0.0f, 5, 0));
                Integer sumPcs = 0;
                Double sumWeight = 0.0;
                if (collectionListItemDomainList != null) {
                    for (CollectionListItemDomain collectionListItemDomain : collectionListItemDomainList) {
                        if (collectionListItemDomain != null) {
                            BalikobotOrderDomain balikobotOrderDomain = ds.getBalikobotOrderDbiDao().findById(collectionListItemDomain.getBalikobotOrderId());
                            if (balikobotOrderDomain != null) {
                                tableData.addCell(PdfUtils.createCellParagraph("\u010c\u00edslo z\u00e1silky", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("P\u0159\u00edjemce z\u00e1silky", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("Po\u010det jednotek", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("Slu\u017eby", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("", font, 0.0f, 0, 0));
                                sumPcs = sumPcs + balikobotOrderDomain.getPackageCnt();
                                tableData.addCell(PdfUtils.createCellParagraph(balikobotOrderDomain.getCarrierId(), fontH, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph(balikobotOrderDomain.getFirm() != null ? balikobotOrderDomain.getFirm() : balikobotOrderDomain.getDisplayName(), fontH, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph(balikobotOrderDomain.getPackageCnt().toString(), fontH, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("Produkt:", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph(balikobotOrderDomain.getServiceType(), font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("Referen\u010dn\u00ed \u010d\u00edslo", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("Adresa", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("Hmotnost v Kg", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("Dob\u00edrka:", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph(balikobotOrderDomain.getCod() == 1 ? String.format("%s / %s", balikobotOrderDomain.getCodPrice(), balikobotOrderDomain.getCodPriceCurrencyCode()) : "", fontH, 0.0f, 0, 0));
                                sumWeight = sumWeight + balikobotOrderDomain.getWeight() / 1000.0;
                                tableData.addCell(PdfUtils.createCellParagraph(balikobotOrderDomain.getPackageId(), fontH, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph(String.format("%s, %s, %s", balikobotOrderDomain.getStreet(), balikobotOrderDomain.getCity(), balikobotOrderDomain.getPostcode()), fontH, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph(Double.toString(balikobotOrderDomain.getWeight() / 1000.0), fontH, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("Kontaktn\u00ed osoba", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("Hodnota z\u00e1silky", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph(balikobotOrderDomain.getDisplayName(), fontH, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph(String.format("%s / %s", balikobotOrderDomain.getPrice(), balikobotOrderDomain.getPriceCurrencyCode()), fontH, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph("", font, 0.0f, 0, 0));
                                tableData.addCell(PdfUtils.createCellParagraph(" ", fontH3, 0.0f, 0.5f, 0.0f, 0.0f, 5, 0));
                                continue;
                            }
                            log.error(String.format("Cannot find BalikobotOrderDomain by id[%d]", collectionListItemDomain.getBalikobotOrderId()));
                            continue;
                        }
                        log.error(String.format("Collection item is NULL for: %s", collectionListDomain));
                    }
                    tableData.addCell(PdfUtils.createCellParagraph("Po\u010det z\u00e1silek", fontH, 0.0f, 0, 0));
                    tableData.addCell(PdfUtils.createCellParagraph(Integer.valueOf(collectionListItemDomainList.size()).toString(), fontH1, 0.0f, 4, 0));
                    tableData.addCell(PdfUtils.createCellParagraph("Po\u010det jednotek", fontH, 0.0f, 0, 0));
                    tableData.addCell(PdfUtils.createCellParagraph(sumPcs.toString(), fontH1, 0.0f, 4, 0));
                    tableData.addCell(PdfUtils.createCellParagraph("Celkov\u00e1 v\u00e1ha", fontH, 0.0f, 0, 0));
                    tableData.addCell(PdfUtils.createCellParagraph(String.format("%s Kg", sumWeight.toString()), fontH1, 0.0f, 4, 0));
                } else {
                    log.error("No collection list items");
                }
                document.add((Element)tableData);
            } else {
                log.error("CollectionListDomain is null");
            }
        }
        catch (Exception e) {
            log.error("Exception making CollectionList: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void makeSubscriptionLetterContent(Document document, PdfWriter writer, OrdersDomain ordersDomain, DaoSupportApp ds, FirmOfficesDomain firmOfficesDomain, AddressesDomain firmOfficeAddress) {
        try {
            if (ordersDomain != null) {
                BarcodeQRCode codeQr = new BarcodeQRCode("https://sub.beershop.cz/" + ordersDomain.getAbraId(), 110, 110, null);
                Image codeQrImage = codeQr.getImage();
                codeQrImage.scaleAbsolute(110.0f, 110.0f);
                PdfPTable tableHeader = new PdfPTable(2);
                tableHeader.setWidthPercentage(100.0f);
                tableHeader.setWidths(new int[]{1, 4});
                URL resource = PdfUtils.getResourceBeershopLogoUctenkaBW();
                Image imageLogo = Image.getInstance((URL)resource);
                imageLogo.scalePercent(100.0f);
                tableHeader.addCell(PdfUtils.createCellImage(imageLogo, 0.0f, 2, 1));
                tableHeader.addCell(PdfUtils.createCellParagraph("INFORMACE K PIVN\u00cdMU P\u0158EDPLATN\u00c9MU", fontH120, 0.0f, 2, 1));
                Object[] objectArray = new Object[4];
                Object object = objectArray[0] = firmOfficesDomain != null && firmOfficesDomain.getDisplayname() != null && !firmOfficesDomain.getDisplayname().equalsIgnoreCase("Provozovna") ? firmOfficesDomain.getDisplayname() + ", " : "";
                objectArray[1] = firmOfficeAddress != null && firmOfficeAddress.getRecipient() != null && !firmOfficeAddress.getRecipient().equalsIgnoreCase(firmOfficesDomain.getDisplayname() != null && !firmOfficesDomain.getDisplayname().equalsIgnoreCase("Provozovna") ? firmOfficesDomain.getDisplayname() : "") ? firmOfficeAddress.getRecipient() + ", " : "";
                objectArray[2] = firmOfficeAddress != null && firmOfficeAddress.getStreet() != null ? firmOfficeAddress.getStreet() + ", " : "";
                objectArray[3] = firmOfficeAddress != null && firmOfficeAddress.getCity() != null ? firmOfficeAddress.getCity() + " " : "";
                String addressLine = String.format("%s%s%s%s", objectArray);
                tableHeader.addCell(PdfUtils.createCellParagraph(String.format("Objedn\u00e1vka %s, %s", ordersDomain.getExternalnumber(), addressLine), fontH2, 0.0f, 2, 1));
                tableHeader.addCell(PdfUtils.createCellParagraph(" ", fontH212, 0.0f, 2, 0));
                tableHeader.addCell(PdfUtils.createCellImage(codeQrImage, 0.0f, 0, 0));
                tableHeader.addCell(PdfUtils.createCellParagraph("Mil\u00fd p\u0159edplatiteli,\n\ndost\u00e1v\u00e1te prvn\u00ed sadu piv, kter\u00e1 je sou\u010d\u00e1st\u00ed va\u0161eho pivn\u00edho p\u0159edplatn\u00e9ho. Postupn\u011b ka\u017ed\u00e9 2 t\u00fddny v\u00e1m p\u0159ijde dal\u0161\u00ed z\u00e1silka, tedy dal\u0161\u00edch 5 bal\u00ed\u010dk\u016f, kter\u00e9 budou obsahovat piva vybran\u00e1 z nab\u00eddky Beershop.cz, nebo z novinek z pivovar\u016f, se kter\u00fdmi spolupracujeme. Budete tak m\u00edt mo\u017enost poznat celkem 36 piv z \u010ceska a ze sv\u011bta.\n", fontH212, 0.0f, 0, 0));
                tableHeader.addCell(PdfUtils.createCellParagraph("Proto\u017ee v\u00e1m bal\u00ed\u010dky pos\u00edl\u00e1me postupn\u011b a spol\u00e9h\u00e1me p\u0159itom na dopravce, pova\u017eujeme za d\u016fle\u017eit\u00e9 v\u00e1s informovat o odesl\u00e1n\u00ed a o pr\u016fb\u011bhu doru\u010dov\u00e1n\u00ed jednotliv\u00fdch z\u00e1silek. Detaily sv\u00e9ho p\u0159edplatn\u00e9ho si proto zobraz\u00edte na mobiln\u00edm telefonu po na\u010dten\u00ed tohoto QR k\u00f3du. Zobraz\u00ed se v\u00e1m str\u00e1nka s informacemi o jednotliv\u00fdch bal\u00ed\u010dc\u00edch, pl\u00e1novan\u00fdch term\u00ednech odesl\u00e1n\u00ed a odkazy na sledov\u00e1n\u00ed z\u00e1silky u dopravce. Dopravce v\u00e1s samoz\u0159ejm\u011b bude informovat standardn\u00ed cestou (email/SMS) o p\u0159evzet\u00ed a term\u00ednu doru\u010den\u00ed z\u00e1silky. \n \nChcete-li zm\u011bnit adresu dod\u00e1n\u00ed nebo term\u00edn odesl\u00e1n\u00ed n\u011bkter\u00e9 z\u00e1silky, m\u016f\u017eete tak u\u010dinit tak\u00e9 na str\u00e1nce, kter\u00e1 se v\u00e1m zobraz\u00ed po na\u010dten\u00ed QR k\u00f3du. P\u0159ejeme hodn\u011b radosti p\u0159i ochutn\u00e1v\u00e1n\u00ed.\n \nNa zdrav\u00ed!\nT\u00fdm Beershop.cz\n", fontH212, 0.0f, 2, 0));
                document.add((Element)tableHeader);
            } else {
                log.error("OrdersDomain is null");
            }
        }
        catch (Exception e) {
            log.error("Exception making order: " + e.getMessage(), (Throwable)e);
        }
    }

    public static byte[] createOrder(OrdersDomain ordersDomain, List<OrderItemsDomain> orderItemsDomainList, DaoSupportApp ds) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Document document = new Document(new Rectangle(PageSize.A4));
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)baos);
            document.open();
            PdfUtils.makeOrderContent(document, writer, ordersDomain, orderItemsDomainList, ds);
            document.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            log.error("Exception creating order: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static byte[] createOrderWithDelivery(OrdersDomain ordersDomain, List<OrderItemsDomain> orderItemsDomainList, AddressesDomain firmResidenceAddress, AddressesDomain firmOfficeAddress, DaoSupportApp ds, FirmOfficesDomain firmOfficesDomain) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Document document = new Document(new Rectangle(PageSize.A4));
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)baos);
            document.open();
            PdfUtils.makeOrderWithDeliveryContent(document, writer, ordersDomain, orderItemsDomainList, firmResidenceAddress, firmOfficeAddress, ds, firmOfficesDomain);
            document.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            log.error("Exception creating order: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static byte[] createThermo80OrderWithDelivery(OrdersDomain ordersDomain, List<OrderItemsDomain> orderItemsDomainList, AddressesDomain firmResidenceAddress, AddressesDomain firmOfficeAddress, DaoSupportApp ds, FirmOfficesDomain firmOfficesDomain) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Document document = new Document((Rectangle)new RectangleReadOnly(204.0f, 148.0f), 0.0f, 0.0f, 0.0f, 0.0f);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)baos);
            document.open();
            PdfUtils.makeThermo80OrderWithDeliveryContent(document, writer, ordersDomain, orderItemsDomainList, firmResidenceAddress, firmOfficeAddress, ds, firmOfficesDomain);
            document.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            log.error("Exception creating order: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static byte[] createCollectionListDpd(CollectionListDomain collectionListDomain, List<CollectionListItemDomain> collectionListItemDomainList, DaoSupportApp ds) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Document document = new Document(new Rectangle(PageSize.A4));
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)baos);
            document.open();
            PdfUtils.makeCollectionListDpdContent(document, writer, collectionListDomain, collectionListItemDomainList, ds);
            document.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            log.error("Exception creating order: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static byte[] createCollectionListWedo(CollectionListDomain collectionListDomain, List<CollectionListItemDomain> collectionListItemDomainList, DaoSupportApp ds) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Document document = new Document(new Rectangle(PageSize.A4));
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)baos);
            document.open();
            PdfUtils.makeCollectionListWedoContent(document, writer, collectionListDomain, collectionListItemDomainList, ds);
            document.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            log.error("Exception creating order: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static byte[] createSubscriptionLetter(OrdersDomain ordersDomain, DaoSupportApp ds, FirmOfficesDomain firmOfficesDomain, AddressesDomain firmOfficeAddress) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Document document = new Document(new Rectangle(PageSize.A4));
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)baos);
            document.open();
            PdfUtils.makeSubscriptionLetterContent(document, writer, ordersDomain, ds, firmOfficesDomain, firmOfficeAddress);
            document.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            log.error("Exception creating subscription letter: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static byte[] createMassOrder(ArrayList<PdfInputOrderDomain> list, DaoSupportApp ds) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Document document = new Document(new Rectangle(PageSize.A4));
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)baos);
            document.open();
            DottedLineSeparator separator = new DottedLineSeparator();
            separator.setPercentage(113.76673f);
            Chunk linebreak = new Chunk((DrawInterface)separator);
            list.forEach(i -> {
                PdfUtils.makeOrderContent(document, writer, i.getOrdersDomain(), i.getOrderItemsDomainList(), ds);
                try {
                    document.add((Element)new Phrase("\n"));
                    document.add((Element)new Phrase("\n"));
                    document.add((Element)linebreak);
                    document.add((Element)new Phrase("\n"));
                    document.add((Element)new Phrase("\n"));
                }
                catch (DocumentException e) {
                    log.error("Cannot put dotted separator: " + e.getMessage(), (Throwable)e);
                }
            });
            document.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            log.error("Exception creating mass order: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static byte[] createMassOrderWithDelivery(ArrayList<PdfInputOrderDomain> list, DaoSupportApp ds) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Document document = new Document(new Rectangle(PageSize.A4));
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)baos);
            document.open();
            DottedLineSeparator separator = new DottedLineSeparator();
            separator.setPercentage(113.76673f);
            Chunk linebreak = new Chunk((DrawInterface)separator);
            list.forEach(i -> {
                PdfUtils.makeOrderWithDeliveryContent(document, writer, i.getOrdersDomain(), i.getOrderItemsDomainList(), i.getFirmResidenceAddress(), i.getFirmOfficeAddress(), ds, i.getFirmOfficesDomain());
                try {
                    document.add((Element)new Phrase("\n"));
                    document.add((Element)new Phrase("\n"));
                    document.add((Element)linebreak);
                    document.add((Element)new Phrase("\n"));
                    document.add((Element)new Phrase("\n"));
                }
                catch (DocumentException e) {
                    log.error("Cannot put dotted separator: " + e.getMessage(), (Throwable)e);
                }
            });
            document.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            log.error("Exception creating mass order: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static byte[] createMassThermo80OrderWithDelivery(ArrayList<PdfInputOrderDomain> list, DaoSupportApp ds) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Document document = new Document((Rectangle)new RectangleReadOnly(204.0f, 148.0f), 0.0f, 0.0f, 0.0f, 0.0f);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)baos);
            document.open();
            DottedLineSeparator separator = new DottedLineSeparator();
            separator.setPercentage(113.76673f);
            Chunk linebreak = new Chunk((DrawInterface)separator);
            list.forEach(i -> {
                PdfUtils.makeThermo80OrderWithDeliveryContent(document, writer, i.getOrdersDomain(), i.getOrderItemsDomainList(), i.getFirmResidenceAddress(), i.getFirmOfficeAddress(), ds, i.getFirmOfficesDomain());
                try {
                    document.add((Element)new Phrase("\n"));
                    document.add((Element)new Phrase("\n"));
                    document.add((Element)linebreak);
                    document.add((Element)new Phrase("\n"));
                    document.add((Element)new Phrase("\n"));
                }
                catch (DocumentException e) {
                    log.error("Cannot put dotted separator: " + e.getMessage(), (Throwable)e);
                }
            });
            document.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            log.error("Exception creating mass order: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static byte[] createMassSubscriptionLetter(ArrayList<PdfInputOrderDomain> list, DaoSupportApp ds) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Document document = new Document(new Rectangle(PageSize.A4));
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)baos);
            document.open();
            DottedLineSeparator separator = new DottedLineSeparator();
            separator.setPercentage(113.76673f);
            Chunk linebreak = new Chunk((DrawInterface)separator);
            list.forEach(i -> {
                PdfUtils.makeSubscriptionLetterContent(document, writer, i.getOrdersDomain(), ds, i.getFirmOfficesDomain(), i.getFirmOfficeAddress());
                try {
                    document.add((Element)new Phrase("\n"));
                    document.add((Element)new Phrase("\n"));
                    document.add((Element)linebreak);
                    document.add((Element)new Phrase("\n"));
                    document.add((Element)new Phrase("\n"));
                }
                catch (DocumentException e) {
                    log.error("Cannot put dotted separator: " + e.getMessage(), (Throwable)e);
                }
            });
            document.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            log.error("Exception creating mass subscription letter: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String createOrderBase64(OrdersDomain ordersDomain, List<OrderItemsDomain> orderItemsDomainList, DaoSupportApp ds) {
        byte[] order = PdfUtils.createOrder(ordersDomain, orderItemsDomainList, ds);
        if (order != null) {
            return Base64.getEncoder().encodeToString(order);
        }
        return null;
    }

    public static String createOrderWithDeliveryBase64(OrdersDomain ordersDomain, List<OrderItemsDomain> orderItemsDomainList, AddressesDomain firmResidenceAddress, AddressesDomain firmOfficeAddress, DaoSupportApp ds, FirmOfficesDomain firmOfficesDomain) {
        byte[] order = PdfUtils.createOrderWithDelivery(ordersDomain, orderItemsDomainList, firmResidenceAddress, firmOfficeAddress, ds, firmOfficesDomain);
        if (order != null) {
            return Base64.getEncoder().encodeToString(order);
        }
        return null;
    }

    public static String createThermo80OrderWithDeliveryBase64(OrdersDomain ordersDomain, List<OrderItemsDomain> orderItemsDomainList, AddressesDomain firmResidenceAddress, AddressesDomain firmOfficeAddress, DaoSupportApp ds, FirmOfficesDomain firmOfficesDomain) {
        byte[] order = PdfUtils.createThermo80OrderWithDelivery(ordersDomain, orderItemsDomainList, firmResidenceAddress, firmOfficeAddress, ds, firmOfficesDomain);
        if (order != null) {
            return Base64.getEncoder().encodeToString(order);
        }
        return null;
    }

    public static String createCollectionListDpdBase64(CollectionListDomain collectionListDomain, List<CollectionListItemDomain> collectionListItemDomainList, DaoSupportApp ds) {
        byte[] order = PdfUtils.createCollectionListDpd(collectionListDomain, collectionListItemDomainList, ds);
        if (order != null) {
            return Base64.getEncoder().encodeToString(order);
        }
        return null;
    }

    public static String createCollectionListWedoBase64(CollectionListDomain collectionListDomain, List<CollectionListItemDomain> collectionListItemDomainList, DaoSupportApp ds) {
        byte[] order = PdfUtils.createCollectionListWedo(collectionListDomain, collectionListItemDomainList, ds);
        if (order != null) {
            return Base64.getEncoder().encodeToString(order);
        }
        return null;
    }

    public static String createSubscriptionLetterBase64(OrdersDomain ordersDomain, DaoSupportApp ds, FirmOfficesDomain firmOfficesDomain, AddressesDomain firmOfficeAddress) {
        byte[] subscriptionLetter = PdfUtils.createSubscriptionLetter(ordersDomain, ds, firmOfficesDomain, firmOfficeAddress);
        if (subscriptionLetter != null) {
            return Base64.getEncoder().encodeToString(subscriptionLetter);
        }
        return null;
    }

    public static String createMassOrderBase64(ArrayList<PdfInputOrderDomain> list, DaoSupportApp ds) {
        byte[] orders = PdfUtils.createMassOrder(list, ds);
        if (orders != null) {
            return Base64.getEncoder().encodeToString(orders);
        }
        return null;
    }

    public static String createMassOrderWithDeliveryBase64(ArrayList<PdfInputOrderDomain> list, DaoSupportApp ds) {
        byte[] orders = PdfUtils.createMassOrderWithDelivery(list, ds);
        if (orders != null) {
            return Base64.getEncoder().encodeToString(orders);
        }
        return null;
    }

    public static String createMassThermo80OrderWithDeliveryBase64(ArrayList<PdfInputOrderDomain> list, DaoSupportApp ds) {
        byte[] orders = PdfUtils.createMassThermo80OrderWithDelivery(list, ds);
        if (orders != null) {
            return Base64.getEncoder().encodeToString(orders);
        }
        return null;
    }

    public static String createMassSubscriptionLetterBase64(ArrayList<PdfInputOrderDomain> list, DaoSupportApp ds) {
        byte[] subscriptionLetters = PdfUtils.createMassSubscriptionLetter(list, ds);
        if (subscriptionLetters != null) {
            return Base64.getEncoder().encodeToString(subscriptionLetters);
        }
        return null;
    }

    public static Image createRectangle(PdfWriter writer, float borderWidth, float llx, float lly, float urx, float ury, BaseColor borderColor) throws IOException, BadElementException {
        return PdfUtils.createRectangle(writer, borderWidth, llx, lly, urx, ury, borderColor, null);
    }

    public static Image createRectangle(PdfWriter writer, float borderWidth, float llx, float lly, float urx, float ury, BaseColor borderColor, BaseColor backgroundColor) throws IOException, BadElementException {
        Rectangle rect = new Rectangle(llx, lly, urx, ury);
        rect.setBorder(15);
        rect.setBorderWidth(borderWidth);
        rect.setBorderColor(borderColor);
        if (backgroundColor != null) {
            rect.setBackgroundColor(backgroundColor);
        }
        PdfTemplate template = writer.getDirectContent().createTemplate(urx - llx, ury - lly);
        template.setLineWidth(borderWidth);
        template.setColorStroke(borderColor);
        if (backgroundColor != null) {
            template.setColorFill(backgroundColor);
            template.rectangle(0.0f, 0.0f, urx - llx, ury - lly);
            template.fill();
        } else {
            template.rectangle(0.0f, 0.0f, urx - llx, ury - lly);
            template.stroke();
        }
        Image image = Image.getInstance((PdfTemplate)template);
        return image;
    }

    public static PdfPCell createCell(String content, Font font, float borderWidth, int colspan, int alignment) {
        PdfPCell cell = new PdfPCell(new Phrase(content, font));
        if (borderWidth > 0.0f) {
            cell.setBorderWidth(borderWidth);
            cell.setBorder(30);
        } else {
            cell.setBorder(0);
        }
        if (colspan > 0) {
            cell.setColspan(colspan);
        }
        cell.setHorizontalAlignment(alignment);
        cell.setVerticalAlignment(5);
        return cell;
    }

    public static PdfPCell createCellParagraph(String content, Font font, float borderWidth, int colspan, int alignment) {
        PdfPCell cell = new PdfPCell((Phrase)new Paragraph(content, font));
        if (borderWidth > 0.0f) {
            cell.setBorderWidth(borderWidth);
            cell.setBorder(30);
        } else {
            cell.setBorder(0);
        }
        if (colspan > 0) {
            cell.setColspan(colspan);
        }
        cell.setHorizontalAlignment(alignment);
        cell.setVerticalAlignment(5);
        return cell;
    }

    public static PdfPCell createCellParagraph(float indent, String content, Font font, float borderWidth, int colspan, int alignment) {
        PdfPCell cell = new PdfPCell((Phrase)new Paragraph(content, font));
        if (borderWidth > 0.0f) {
            cell.setBorderWidth(borderWidth);
            cell.setBorder(30);
        } else {
            cell.setBorder(0);
        }
        if (colspan > 0) {
            cell.setColspan(colspan);
        }
        cell.setHorizontalAlignment(alignment);
        cell.setIndent(indent);
        cell.setVerticalAlignment(5);
        return cell;
    }

    public static PdfPCell createCellParagraph(String content, Font font, float borderWidthLeft, float borderWidthTop, float borderWidthRight, float borderWidthBottom, int colspan, int alignment) {
        PdfPCell cell = new PdfPCell((Phrase)new Paragraph(content, font));
        if (borderWidthLeft > 0.0f || borderWidthTop > 0.0f || borderWidthRight > 0.0f || borderWidthBottom > 0.0f) {
            cell.setBorder(30);
        } else {
            cell.setBorder(0);
        }
        if (borderWidthLeft > 0.0f) {
            cell.setBorderWidthLeft(borderWidthLeft);
        } else {
            cell.setBorderWidthLeft(0.0f);
        }
        if (borderWidthTop > 0.0f) {
            cell.setBorderWidthTop(borderWidthTop);
        } else {
            cell.setBorderWidthTop(0.0f);
        }
        if (borderWidthRight > 0.0f) {
            cell.setBorderWidthRight(borderWidthRight);
        } else {
            cell.setBorderWidthRight(0.0f);
        }
        if (borderWidthBottom > 0.0f) {
            cell.setBorderWidthBottom(borderWidthBottom);
        } else {
            cell.setBorderWidthBottom(0.0f);
        }
        if (colspan > 0) {
            cell.setColspan(colspan);
        }
        cell.setHorizontalAlignment(alignment);
        cell.setVerticalAlignment(5);
        return cell;
    }

    public static PdfPCell createCellParagraph(String content, Font font, float borderWidthLeft, float borderWidthTop, float borderWidthRight, float borderWidthBottom, int colspan, int alignment, BaseColor borderColorLeft, BaseColor borderColorTop, BaseColor borderColorRight, BaseColor borderColorBottom) {
        PdfPCell cell = new PdfPCell((Phrase)new Paragraph(content, font));
        if (borderWidthLeft > 0.0f || borderWidthTop > 0.0f || borderWidthRight > 0.0f || borderWidthBottom > 0.0f) {
            cell.setBorder(30);
        } else {
            cell.setBorder(0);
        }
        if (borderWidthLeft > 0.0f) {
            cell.setBorderWidthLeft(borderWidthLeft);
        } else {
            cell.setBorderWidthLeft(0.0f);
        }
        if (borderWidthTop > 0.0f) {
            cell.setBorderWidthTop(borderWidthTop);
        } else {
            cell.setBorderWidthTop(0.0f);
        }
        if (borderWidthRight > 0.0f) {
            cell.setBorderWidthRight(borderWidthRight);
        } else {
            cell.setBorderWidthRight(0.0f);
        }
        if (borderWidthBottom > 0.0f) {
            cell.setBorderWidthBottom(borderWidthBottom);
        } else {
            cell.setBorderWidthBottom(0.0f);
        }
        if (colspan > 0) {
            cell.setColspan(colspan);
        }
        if (borderColorLeft != null) {
            cell.setBorderColorLeft(borderColorLeft);
        } else {
            cell.setBorderColorLeft(BaseColor.WHITE);
        }
        if (borderColorTop != null) {
            cell.setBorderColorTop(borderColorTop);
        } else {
            cell.setBorderColorTop(BaseColor.WHITE);
        }
        if (borderColorRight != null) {
            cell.setBorderColorRight(borderColorRight);
        } else {
            cell.setBorderColorRight(BaseColor.WHITE);
        }
        if (borderColorBottom != null) {
            cell.setBorderColorBottom(borderColorBottom);
        } else {
            cell.setBorderColorBottom(BaseColor.WHITE);
        }
        if (colspan > 0) {
            cell.setColspan(colspan);
        }
        cell.setHorizontalAlignment(alignment);
        cell.setVerticalAlignment(5);
        return cell;
    }

    public static PdfPCell createCellImage(Image image, float borderWidth, int colspan, int alignment) {
        PdfPCell cell = new PdfPCell(image);
        if (borderWidth > 0.0f) {
            cell.setBorderWidth(borderWidth);
            cell.setBorder(30);
        } else {
            cell.setBorder(0);
        }
        if (colspan > 0) {
            cell.setColspan(colspan);
        }
        cell.setHorizontalAlignment(alignment);
        cell.setVerticalAlignment(5);
        return cell;
    }

    public static PdfPCell createCellTable(PdfPTable table, float borderWidth, int colspan, int alignment) {
        PdfPCell cell = new PdfPCell(table);
        if (borderWidth > 0.0f) {
            cell.setBorderWidth(borderWidth);
            cell.setBorder(30);
        } else {
            cell.setBorder(0);
        }
        if (colspan > 0) {
            cell.setColspan(colspan);
        }
        cell.setHorizontalAlignment(alignment);
        cell.setVerticalAlignment(5);
        return cell;
    }

    private static URL getResourceDelikatesyLogo() {
        return PdfUtils.class.getResource("/img/logo-delikatesy.png");
    }

    private static URL getResourceBeershopLogo() {
        return PdfUtils.class.getResource("/img/logo-beershop-dlouhe-oranzove.png");
    }

    private static URL getResourceBeershopLogoKohout() {
        return PdfUtils.class.getResource("/img/logo-beershop-square_1200.png");
    }

    private static URL getResourceBeershopLogoHipsterVanoce() {
        return PdfUtils.class.getResource("/img/logo-beershopcz-hipster-eshop.png");
    }

    private static URL getResourceBeershopLogoUctenkaBW() {
        return PdfUtils.class.getResource("/img/logo-beershop-uctenka-bw.png");
    }

    private static URL getResourceBeershopLogoGreyEmail() {
        return PdfUtils.class.getResource("/img/logo-beershop-grey-email.png");
    }

    private static URL getResourceBeershopLogoGreyEmailBmp() {
        return PdfUtils.class.getResource("/img/logo-beershop-grey-email.bmp");
    }

    private static URL getResourceBeershopLogoNewBmp() {
        return PdfUtils.class.getResource("/img/logo-beershop-new.bmp");
    }

    private static URL getResourceBeershopLogoPureBlackSvg() {
        return PdfUtils.class.getResource("/img/logo-beershop-pure-black.svg");
    }

    private static URL getResourceBeershopLogoPureBlackJpg() {
        return PdfUtils.class.getResource("/img/logo-beershop-pure-black.jpg");
    }

    private static URL getResourceBeershopLogoPureOutlinesJpg() {
        return PdfUtils.class.getResource("/img/logo-beershop-pure-outlines.jpg");
    }

    private static URL getResourceBeershopLogoUctenkaBWBmp() {
        return PdfUtils.class.getResource("/img/logo-beershop-uctenka-bw.bmp");
    }

    private static URL getResourceDelikatesyVanoce() {
        return PdfUtils.class.getResource("/img/logo-delikatesy-online-vanocni-2022.png");
    }

    private static URL getResourceDelikatesyUctenka() {
        return PdfUtils.class.getResource("/img/logo-delikatesy-uctenka.png");
    }

    private static URL getResourceDelikatesyUctenkaBmp() {
        return PdfUtils.class.getResource("/img/logo-delikatesy-uctenka.bmp");
    }

    private static URL getResourceDelikatesyBwBmp() {
        return PdfUtils.class.getResource("/img/logo-delikatesy-bw.bmp");
    }

    private static URL getResourceDelikatesyLongBmp() {
        return PdfUtils.class.getResource("/img/logo-delikatesy-long.png");
    }

    static {
        otherSymbols = new DecimalFormatSymbols(Locale.GERMAN);
        df2 = new DecimalFormat("#.##", otherSymbols);
        otherSymbols.setDecimalSeparator(',');
        otherSymbols.setGroupingSeparator(' ');
        df2.setMaximumFractionDigits(2);
        df2.setMinimumFractionDigits(2);
        df2.setRoundingMode(RoundingMode.HALF_UP);
        try {
            baseFont = BaseFont.createFont((String)"arialuni.ttf", (String)"Identity-H", (boolean)true);
        }
        catch (Exception e) {
            log.error("Exception loading arialuni.ttf font: " + e.getMessage(), (Throwable)e);
        }
        font = new Font(baseFont, 8.0f, 0);
        fontH = new Font(baseFont, 8.0f, 1);
        fontH1 = new Font(baseFont, 16.0f, 1);
        fontH120 = new Font(baseFont, 20.0f, 1);
        fontH130 = new Font(baseFont, 30.0f, 1);
        fontH2 = new Font(baseFont, 11.0f, 0);
        fontH212 = new Font(baseFont, 13.0f, 0);
        fontH2B11 = new Font(baseFont, 11.0f, 1);
        fontH2B = new Font(baseFont, 11.0f, 1);
        fontH3 = new Font(baseFont, 9.0f, 0);
        fontH3B = new Font(baseFont, 9.0f, 1);
    }
}

