/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.mappers.full;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import cz.airtoy.airshop.dao.mappers.OrdersMapper;
import cz.airtoy.airshop.dao.mappers.common.BaseMapper;
import cz.airtoy.airshop.domains.OrderItemsDomain;
import cz.airtoy.airshop.domains.OrderStatusLogDomain;
import cz.airtoy.airshop.domains.OrdersDomain;
import cz.airtoy.airshop.domains.PartnerMessageDomain;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrdersFullMapper
extends BaseMapper
implements RowMapper<OrdersDomain> {
    private static final Logger log = LoggerFactory.getLogger(OrdersFullMapper.class);

    public OrdersDomain map(ResultSet resultSet, StatementContext ctx) throws SQLException {
        OrdersDomain d = new OrdersDomain();
        OrdersMapper.process(resultSet, d);
        OrdersFullMapper.addMessages(resultSet, d);
        OrdersFullMapper.addStatusLogs(resultSet, d);
        OrdersFullMapper.addStatusLogs(resultSet, d);
        OrdersFullMapper.addRows(resultSet, d);
        return d;
    }

    public static void addMessages(ResultSet resultSet, OrdersDomain d) throws SQLException {
        GsonBuilder gsonBuilder;
        Gson gson;
        List list;
        String messages = OrdersFullMapper.getString(resultSet, "messages");
        if (messages != null && !messages.isEmpty() && (list = (List)(gson = (gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss")).create()).fromJson(messages, new TypeToken<List<PartnerMessageDomain>>(){}.getType())) != null) {
            d.setMessages(list);
        }
    }

    public static void addStatusLogs(ResultSet resultSet, OrdersDomain d) throws SQLException {
        GsonBuilder gsonBuilder;
        Gson gson;
        List list;
        String statusLogs = OrdersFullMapper.getString(resultSet, "statusLogs");
        if (statusLogs != null && !statusLogs.isEmpty() && (list = (List)(gson = (gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss")).create()).fromJson(statusLogs, new TypeToken<List<OrderStatusLogDomain>>(){}.getType())) != null) {
            d.setStatusLogs(list);
        }
    }

    public static void addRows(ResultSet resultSet, OrdersDomain d) throws SQLException {
        GsonBuilder gsonBuilder;
        Gson gson;
        List list;
        String rows = OrdersFullMapper.getString(resultSet, "rows");
        if (rows != null && !rows.isEmpty() && (list = (List)(gson = (gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss")).create()).fromJson(rows, new TypeToken<List<OrderItemsDomain>>(){}.getType())) != null) {
            d.setRows(list);
        }
    }
}

