/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.email;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.email.TemplateRulesMapper;
import cz.airtoy.airshop.domains.email.TemplateRulesDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface TemplateRulesDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.template_id,\n\t\tp.rule_name,\n\t\tp.rule_exp,\n\t\tp.date_created\n FROM \n\t\temail.template_rules p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.template_id::text ~* :mask \n\tOR \n\t\tp.rule_name::text ~* :mask \n\tOR \n\t\tp.rule_exp::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=TemplateRulesMapper.class)
    public List<TemplateRulesDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\temail.template_rules p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.template_id::text ~* :mask \n\tOR \n\t\tp.rule_name::text ~* :mask \n\tOR \n\t\tp.rule_exp::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.rule_name, p.rule_exp, p.date_created FROM email.template_rules p  ")
    @RegisterRowMapper(value=TemplateRulesMapper.class)
    public List<TemplateRulesDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.rule_name, p.rule_exp, p.date_created FROM email.template_rules p  WHERE p.id = :id")
    @RegisterRowMapper(value=TemplateRulesMapper.class)
    public TemplateRulesDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.rule_name, p.rule_exp, p.date_created FROM email.template_rules p  WHERE p.id = :id")
    @RegisterRowMapper(value=TemplateRulesMapper.class)
    public List<TemplateRulesDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.template_rules p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.rule_name, p.rule_exp, p.date_created FROM email.template_rules p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TemplateRulesMapper.class)
    public List<TemplateRulesDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.rule_name, p.rule_exp, p.date_created FROM email.template_rules p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=TemplateRulesMapper.class)
    public TemplateRulesDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.rule_name, p.rule_exp, p.date_created FROM email.template_rules p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=TemplateRulesMapper.class)
    public List<TemplateRulesDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.template_rules p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.rule_name, p.rule_exp, p.date_created FROM email.template_rules p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TemplateRulesMapper.class)
    public List<TemplateRulesDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.rule_name, p.rule_exp, p.date_created FROM email.template_rules p  WHERE p.template_id = :templateId")
    @RegisterRowMapper(value=TemplateRulesMapper.class)
    public TemplateRulesDomain findByTemplateId(@Bind(value="templateId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.rule_name, p.rule_exp, p.date_created FROM email.template_rules p  WHERE p.template_id = :templateId")
    @RegisterRowMapper(value=TemplateRulesMapper.class)
    public List<TemplateRulesDomain> findListByTemplateId(@Bind(value="templateId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.template_rules p  WHERE p.template_id = :templateId")
    public long findListByTemplateIdCount(@Bind(value="templateId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.rule_name, p.rule_exp, p.date_created FROM email.template_rules p  WHERE p.template_id = :templateId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TemplateRulesMapper.class)
    public List<TemplateRulesDomain> findListByTemplateId(@Bind(value="templateId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.rule_name, p.rule_exp, p.date_created FROM email.template_rules p  WHERE p.rule_name = :ruleName")
    @RegisterRowMapper(value=TemplateRulesMapper.class)
    public TemplateRulesDomain findByRuleName(@Bind(value="ruleName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.rule_name, p.rule_exp, p.date_created FROM email.template_rules p  WHERE p.rule_name = :ruleName")
    @RegisterRowMapper(value=TemplateRulesMapper.class)
    public List<TemplateRulesDomain> findListByRuleName(@Bind(value="ruleName") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.template_rules p  WHERE p.rule_name = :ruleName")
    public long findListByRuleNameCount(@Bind(value="ruleName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.rule_name, p.rule_exp, p.date_created FROM email.template_rules p  WHERE p.rule_name = :ruleName ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TemplateRulesMapper.class)
    public List<TemplateRulesDomain> findListByRuleName(@Bind(value="ruleName") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.rule_name, p.rule_exp, p.date_created FROM email.template_rules p  WHERE p.rule_exp = :ruleExp")
    @RegisterRowMapper(value=TemplateRulesMapper.class)
    public TemplateRulesDomain findByRuleExp(@Bind(value="ruleExp") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.rule_name, p.rule_exp, p.date_created FROM email.template_rules p  WHERE p.rule_exp = :ruleExp")
    @RegisterRowMapper(value=TemplateRulesMapper.class)
    public List<TemplateRulesDomain> findListByRuleExp(@Bind(value="ruleExp") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.template_rules p  WHERE p.rule_exp = :ruleExp")
    public long findListByRuleExpCount(@Bind(value="ruleExp") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.rule_name, p.rule_exp, p.date_created FROM email.template_rules p  WHERE p.rule_exp = :ruleExp ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TemplateRulesMapper.class)
    public List<TemplateRulesDomain> findListByRuleExp(@Bind(value="ruleExp") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.rule_name, p.rule_exp, p.date_created FROM email.template_rules p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=TemplateRulesMapper.class)
    public TemplateRulesDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.rule_name, p.rule_exp, p.date_created FROM email.template_rules p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=TemplateRulesMapper.class)
    public List<TemplateRulesDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM email.template_rules p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.template_id, p.rule_name, p.rule_exp, p.date_created FROM email.template_rules p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TemplateRulesMapper.class)
    public List<TemplateRulesDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO email.template_rules (id, uid, template_id, rule_name, rule_exp, date_created) VALUES (:id, :uid, :templateId, :ruleName, :ruleExp, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="templateId") Long var3, @Bind(value="ruleName") String var4, @Bind(value="ruleExp") String var5, @Bind(value="dateCreated") Date var6);

    @SqlUpdate(value="INSERT INTO email.template_rules (template_id, rule_name, rule_exp, date_created) VALUES (:e.templateId, :e.ruleName, :e.ruleExp, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") TemplateRulesDomain var1);

    @SqlUpdate(value="UPDATE email.template_rules SET id = :e.id, uid = :e.uid, template_id = :e.templateId, rule_name = :e.ruleName, rule_exp = :e.ruleExp, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") TemplateRulesDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE email.template_rules SET id = :e.id, uid = :e.uid, template_id = :e.templateId, rule_name = :e.ruleName, rule_exp = :e.ruleExp, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") TemplateRulesDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE email.template_rules SET id = :e.id, uid = :e.uid, template_id = :e.templateId, rule_name = :e.ruleName, rule_exp = :e.ruleExp, date_created = :e.dateCreated WHERE template_id = :byTemplateId")
    public int updateByTemplateId(@BindBean(value="e") TemplateRulesDomain var1, @Bind(value="byTemplateId") Long var2);

    @SqlUpdate(value="UPDATE email.template_rules SET id = :e.id, uid = :e.uid, template_id = :e.templateId, rule_name = :e.ruleName, rule_exp = :e.ruleExp, date_created = :e.dateCreated WHERE rule_name = :byRuleName")
    public int updateByRuleName(@BindBean(value="e") TemplateRulesDomain var1, @Bind(value="byRuleName") String var2);

    @SqlUpdate(value="UPDATE email.template_rules SET id = :e.id, uid = :e.uid, template_id = :e.templateId, rule_name = :e.ruleName, rule_exp = :e.ruleExp, date_created = :e.dateCreated WHERE rule_exp = :byRuleExp")
    public int updateByRuleExp(@BindBean(value="e") TemplateRulesDomain var1, @Bind(value="byRuleExp") String var2);

    @SqlUpdate(value="UPDATE email.template_rules SET id = :e.id, uid = :e.uid, template_id = :e.templateId, rule_name = :e.ruleName, rule_exp = :e.ruleExp, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") TemplateRulesDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM email.template_rules WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM email.template_rules WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM email.template_rules WHERE template_id = :templateId")
    public int deleteByTemplateId(@Bind(value="templateId") Long var1);

    @SqlUpdate(value="DELETE FROM email.template_rules WHERE rule_name = :ruleName")
    public int deleteByRuleName(@Bind(value="ruleName") String var1);

    @SqlUpdate(value="DELETE FROM email.template_rules WHERE rule_exp = :ruleExp")
    public int deleteByRuleExp(@Bind(value="ruleExp") String var1);

    @SqlUpdate(value="DELETE FROM email.template_rules WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

