/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.domains.codecs.balikobot;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import cz.airtoy.airshop.domains.balikobot.ShipperDomain;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShipperDomainCodec
implements MessageCodec<ShipperDomain, ShipperDomain> {
    private static final Logger log = LoggerFactory.getLogger(ShipperDomainCodec.class);

    public void encodeToWire(Buffer buffer, ShipperDomain shipperDomain) {
        GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
        Gson gson = gsonBuilder.create();
        String jsonToStr = gson.toJson((Object)shipperDomain);
        int length = jsonToStr.getBytes().length;
        buffer.appendInt(length);
        buffer.appendString(jsonToStr);
    }

    public ShipperDomain decodeFromWire(int position, Buffer buffer) {
        int _pos = position;
        int length = buffer.getInt(_pos);
        String jsonStr = buffer.getString(_pos += 4, _pos += length);
        GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
        Gson gson = gsonBuilder.create();
        return (ShipperDomain)gson.fromJson(jsonStr, ShipperDomain.class);
    }

    public ShipperDomain transform(ShipperDomain shipperDomain) {
        return shipperDomain;
    }

    public String name() {
        return this.getClass().getSimpleName();
    }

    public byte systemCodecID() {
        return -1;
    }
}

