/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.PackageMapper;
import cz.airtoy.airshop.domains.PackageDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface PackageDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.name,\n\t\tp.package_width,\n\t\tp.package_height,\n\t\tp.package_depth,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tsystem.package p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.package_width::text ~* :mask \n\tOR \n\t\tp.package_height::text ~* :mask \n\tOR \n\t\tp.package_depth::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=PackageMapper.class)
    public List<PackageDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tsystem.package p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.package_width::text ~* :mask \n\tOR \n\t\tp.package_height::text ~* :mask \n\tOR \n\t\tp.package_depth::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.package_width, p.package_height, p.package_depth, p.note, p.date_created FROM system.package p ORDER BY (COALESCE(p.package_width, 1) * COALESCE(p.package_height, 1) * COALESCE(p.package_depth, 1)) ASC")
    @RegisterRowMapper(value=PackageMapper.class)
    public List<PackageDomain> findAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.package_width, p.package_height, p.package_depth, p.note, p.date_created FROM system.package p  WHERE p.id = :id")
    @RegisterRowMapper(value=PackageMapper.class)
    public PackageDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.package_width, p.package_height, p.package_depth, p.note, p.date_created FROM system.package p  WHERE p.id = :id")
    @RegisterRowMapper(value=PackageMapper.class)
    public List<PackageDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.package p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.package_width, p.package_height, p.package_depth, p.note, p.date_created FROM system.package p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=PackageMapper.class)
    public List<PackageDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.package_width, p.package_height, p.package_depth, p.note, p.date_created FROM system.package p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=PackageMapper.class)
    public PackageDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.package_width, p.package_height, p.package_depth, p.note, p.date_created FROM system.package p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=PackageMapper.class)
    public List<PackageDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.package p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.package_width, p.package_height, p.package_depth, p.note, p.date_created FROM system.package p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=PackageMapper.class)
    public List<PackageDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.package_width, p.package_height, p.package_depth, p.note, p.date_created FROM system.package p  WHERE p.name = :name")
    @RegisterRowMapper(value=PackageMapper.class)
    public PackageDomain findByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.package_width, p.package_height, p.package_depth, p.note, p.date_created FROM system.package p  WHERE p.name = :name")
    @RegisterRowMapper(value=PackageMapper.class)
    public List<PackageDomain> findListByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.package p  WHERE p.name = :name")
    public long findListByNameCount(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.package_width, p.package_height, p.package_depth, p.note, p.date_created FROM system.package p  WHERE p.name = :name ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=PackageMapper.class)
    public List<PackageDomain> findListByName(@Bind(value="name") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.package_width, p.package_height, p.package_depth, p.note, p.date_created FROM system.package p  WHERE p.package_width = :packageWidth")
    @RegisterRowMapper(value=PackageMapper.class)
    public PackageDomain findByPackageWidth(@Bind(value="packageWidth") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.package_width, p.package_height, p.package_depth, p.note, p.date_created FROM system.package p  WHERE p.package_width = :packageWidth")
    @RegisterRowMapper(value=PackageMapper.class)
    public List<PackageDomain> findListByPackageWidth(@Bind(value="packageWidth") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.package p  WHERE p.package_width = :packageWidth")
    public long findListByPackageWidthCount(@Bind(value="packageWidth") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.package_width, p.package_height, p.package_depth, p.note, p.date_created FROM system.package p  WHERE p.package_width = :packageWidth ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=PackageMapper.class)
    public List<PackageDomain> findListByPackageWidth(@Bind(value="packageWidth") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.package_width, p.package_height, p.package_depth, p.note, p.date_created FROM system.package p  WHERE p.package_height = :packageHeight")
    @RegisterRowMapper(value=PackageMapper.class)
    public PackageDomain findByPackageHeight(@Bind(value="packageHeight") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.package_width, p.package_height, p.package_depth, p.note, p.date_created FROM system.package p  WHERE p.package_height = :packageHeight")
    @RegisterRowMapper(value=PackageMapper.class)
    public List<PackageDomain> findListByPackageHeight(@Bind(value="packageHeight") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.package p  WHERE p.package_height = :packageHeight")
    public long findListByPackageHeightCount(@Bind(value="packageHeight") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.package_width, p.package_height, p.package_depth, p.note, p.date_created FROM system.package p  WHERE p.package_height = :packageHeight ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=PackageMapper.class)
    public List<PackageDomain> findListByPackageHeight(@Bind(value="packageHeight") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.package_width, p.package_height, p.package_depth, p.note, p.date_created FROM system.package p  WHERE p.package_depth = :packageDepth")
    @RegisterRowMapper(value=PackageMapper.class)
    public PackageDomain findByPackageDepth(@Bind(value="packageDepth") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.package_width, p.package_height, p.package_depth, p.note, p.date_created FROM system.package p  WHERE p.package_depth = :packageDepth")
    @RegisterRowMapper(value=PackageMapper.class)
    public List<PackageDomain> findListByPackageDepth(@Bind(value="packageDepth") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.package p  WHERE p.package_depth = :packageDepth")
    public long findListByPackageDepthCount(@Bind(value="packageDepth") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.package_width, p.package_height, p.package_depth, p.note, p.date_created FROM system.package p  WHERE p.package_depth = :packageDepth ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=PackageMapper.class)
    public List<PackageDomain> findListByPackageDepth(@Bind(value="packageDepth") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.package_width, p.package_height, p.package_depth, p.note, p.date_created FROM system.package p  WHERE p.note = :note")
    @RegisterRowMapper(value=PackageMapper.class)
    public PackageDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.package_width, p.package_height, p.package_depth, p.note, p.date_created FROM system.package p  WHERE p.note = :note")
    @RegisterRowMapper(value=PackageMapper.class)
    public List<PackageDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.package p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.package_width, p.package_height, p.package_depth, p.note, p.date_created FROM system.package p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=PackageMapper.class)
    public List<PackageDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.package_width, p.package_height, p.package_depth, p.note, p.date_created FROM system.package p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=PackageMapper.class)
    public PackageDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.package_width, p.package_height, p.package_depth, p.note, p.date_created FROM system.package p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=PackageMapper.class)
    public List<PackageDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.package p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.name, p.package_width, p.package_height, p.package_depth, p.note, p.date_created FROM system.package p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=PackageMapper.class)
    public List<PackageDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO system.package (id, uid, name, package_width, package_height, package_depth, note, date_created) VALUES (:id, :uid, :name, :packageWidth, :packageHeight, :packageDepth, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="name") String var3, @Bind(value="packageWidth") Integer var4, @Bind(value="packageHeight") Integer var5, @Bind(value="packageDepth") Integer var6, @Bind(value="note") String var7, @Bind(value="dateCreated") Date var8);

    @SqlUpdate(value="INSERT INTO system.package (name, package_width, package_height, package_depth, note, date_created) VALUES (:e.name, :e.packageWidth, :e.packageHeight, :e.packageDepth, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") PackageDomain var1);

    @SqlUpdate(value="UPDATE system.package SET id = :e.id, uid = :e.uid, name = :e.name, package_width = :e.packageWidth, package_height = :e.packageHeight, package_depth = :e.packageDepth, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") PackageDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE system.package SET id = :e.id, uid = :e.uid, name = :e.name, package_width = :e.packageWidth, package_height = :e.packageHeight, package_depth = :e.packageDepth, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") PackageDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE system.package SET id = :e.id, uid = :e.uid, name = :e.name, package_width = :e.packageWidth, package_height = :e.packageHeight, package_depth = :e.packageDepth, note = :e.note, date_created = :e.dateCreated WHERE name = :byName")
    public int updateByName(@BindBean(value="e") PackageDomain var1, @Bind(value="byName") String var2);

    @SqlUpdate(value="UPDATE system.package SET id = :e.id, uid = :e.uid, name = :e.name, package_width = :e.packageWidth, package_height = :e.packageHeight, package_depth = :e.packageDepth, note = :e.note, date_created = :e.dateCreated WHERE package_width = :byPackageWidth")
    public int updateByPackageWidth(@BindBean(value="e") PackageDomain var1, @Bind(value="byPackageWidth") Integer var2);

    @SqlUpdate(value="UPDATE system.package SET id = :e.id, uid = :e.uid, name = :e.name, package_width = :e.packageWidth, package_height = :e.packageHeight, package_depth = :e.packageDepth, note = :e.note, date_created = :e.dateCreated WHERE package_height = :byPackageHeight")
    public int updateByPackageHeight(@BindBean(value="e") PackageDomain var1, @Bind(value="byPackageHeight") Integer var2);

    @SqlUpdate(value="UPDATE system.package SET id = :e.id, uid = :e.uid, name = :e.name, package_width = :e.packageWidth, package_height = :e.packageHeight, package_depth = :e.packageDepth, note = :e.note, date_created = :e.dateCreated WHERE package_depth = :byPackageDepth")
    public int updateByPackageDepth(@BindBean(value="e") PackageDomain var1, @Bind(value="byPackageDepth") Integer var2);

    @SqlUpdate(value="UPDATE system.package SET id = :e.id, uid = :e.uid, name = :e.name, package_width = :e.packageWidth, package_height = :e.packageHeight, package_depth = :e.packageDepth, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") PackageDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE system.package SET id = :e.id, uid = :e.uid, name = :e.name, package_width = :e.packageWidth, package_height = :e.packageHeight, package_depth = :e.packageDepth, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") PackageDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM system.package WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM system.package WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM system.package WHERE name = :name")
    public int deleteByName(@Bind(value="name") String var1);

    @SqlUpdate(value="DELETE FROM system.package WHERE package_width = :packageWidth")
    public int deleteByPackageWidth(@Bind(value="packageWidth") Integer var1);

    @SqlUpdate(value="DELETE FROM system.package WHERE package_height = :packageHeight")
    public int deleteByPackageHeight(@Bind(value="packageHeight") Integer var1);

    @SqlUpdate(value="DELETE FROM system.package WHERE package_depth = :packageDepth")
    public int deleteByPackageDepth(@Bind(value="packageDepth") Integer var1);

    @SqlUpdate(value="DELETE FROM system.package WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM system.package WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

