/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.utils;

import java.util.stream.Collector;

public class StringUtils {
    static final String allowedCharacters = " abcdefghijklmnopqrstuvwxyz1234567890.,-_?!+-*/=@#$%^&*(){}[]\u011b\u0161\u010d\u0159\u017e\u00fd\u00e1\u00ed\u00e9\u016f\u00fa\u00f3\u0165\u0148\u00fc\u010f\u013e\u00f6\u00e6\u00e5\u00f8\u00e4\u00f6\u00e0\u00e2\u00e7\u00e8\u00ea\u00eb\u00ee\u00ef\u00f4\u00fb\u00f9\u00ff\u00f1\u0153\u00dfABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890.,-?!+-*/=\u011a\u0160\u010c\u0158\u017d\u00dd\u00c1\u00cd\u00c9\u016e\u00da\u00d3\u0164\u0147\u00dc\u010e\u013d\u00d6\u00c6\u00c5\u00d8\u00c4\u00d6\u00c0\u00c2\u00c7\u00c8\u00ca\u00cb\u00ce\u00cf\u00d4\u00db\u00d9\u0178\u00d1\u0152\n\t";
    static final String allowedCharactersNoDiacritics = " abcdefghijklmnopqrstuvwxyz1234567890.,-_?!+-*/=@#$%^&*(){}[]ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890.,-?!+-*/=\n\t\\";

    public static String filter(String str) {
        if (str != null && str.length() > 0) {
            return str.chars().mapToObj(c -> Character.valueOf((char)c)).map(StringUtils::procesChar).collect(Collector.of(StringBuilder::new, StringBuilder::append, StringBuilder::append, StringBuilder::toString, new Collector.Characteristics[0]));
        }
        return str;
    }

    public static String processStringFilterNoDiacritics(String str) {
        return StringUtils.processStringFilterNoDiacritics(str, '.');
    }

    public static String processStringFilterNoDiacritics(String str, char repl) {
        if (str != null && str.length() > 0) {
            return str.chars().mapToObj(c -> Character.valueOf((char)c)).map(c -> Character.valueOf(StringUtils.procesCharForNoDiacritics(c.charValue(), repl))).collect(Collector.of(StringBuilder::new, StringBuilder::append, StringBuilder::append, StringBuilder::toString, new Collector.Characteristics[0]));
        }
        return str;
    }

    private static char procesChar(char c) {
        return allowedCharacters.indexOf(c) >= 0 ? c : (char)' ';
    }

    private static char procesCharForNoDiacritics(char c, char r) {
        return allowedCharactersNoDiacritics.indexOf(c) >= 0 ? c : r;
    }

    public static String parsePhone(String phone) {
        if (phone == null) {
            return null;
        }
        if (((String)(phone = ((String)phone).replaceAll("\\s", ""))).matches("(\\+420|00420|\\+421|00421).*")) {
            phone = ((String)phone).replaceFirst("(\\+|00)", "");
        } else if (((String)phone).matches("\\+[1-9].*")) {
            phone = ((String)phone).substring(1);
        } else if (((String)phone).length() == 9) {
            phone = "420" + (String)phone;
        }
        return phone;
    }
}

