/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.system;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.system.BeersMapper;
import cz.airtoy.airshop.dao.mappers.system.help.BeersRatingMapper;
import cz.airtoy.airshop.dao.mappers.system.help.BeersWithWebsitesMapper;
import cz.airtoy.airshop.domains.system.BeersDomain;
import cz.airtoy.airshop.domains.system.help.BeerWithInfoDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.SingleValue;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface DelikatesyDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.title,\n\t\tp.beershop_www,\n\t\tp.beershop_id,\n\t\tp.img,\n\t\tp.ibu,\n\t\tp.abv,\n\t\tp.style,\n\t\tp.condition,\n\t\tp.price,\n\t\tp.active,\n\t\tp.total_rating,\n\t\tp.date_changed,\n\t\tp.user_changed,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tsystem.delikatesy p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.title::text ~* :mask \n\tOR \n\t\tp.beershop_www::text ~* :mask \n\tOR \n\t\tp.beershop_id::text ~* :mask \n\tOR \n\t\tp.img::text ~* :mask \n\tOR \n\t\tp.ibu::text ~* :mask \n\tOR \n\t\tp.abv::text ~* :mask \n\tOR \n\t\tp.style::text ~* :mask \n\tOR \n\t\tp.condition::text ~* :mask \n\tOR \n\t\tp.price::text ~* :mask \n\tOR \n\t\tp.active::text ~* :mask \n\tOR \n\t\tp.total_rating::text ~* :mask \n\tOR \n\t\tp.date_changed::text ~* :mask \n\tOR \n\t\tp.user_changed::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tsystem.delikatesy p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.title::text ~* :mask \n\tOR \n\t\tp.beershop_www::text ~* :mask \n\tOR \n\t\tp.beershop_id::text ~* :mask \n\tOR \n\t\tp.img::text ~* :mask \n\tOR \n\t\tp.ibu::text ~* :mask \n\tOR \n\t\tp.abv::text ~* :mask \n\tOR \n\t\tp.style::text ~* :mask \n\tOR \n\t\tp.condition::text ~* :mask \n\tOR \n\t\tp.price::text ~* :mask \n\tOR \n\t\tp.active::text ~* :mask \n\tOR \n\t\tp.total_rating::text ~* :mask \n\tOR \n\t\tp.date_changed::text ~* :mask \n\tOR \n\t\tp.user_changed::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT \n\t\tp.id,\n\t\tp.title,\n\t\tp.beershop_www,\n\t\tp.beershop_id,\n\t\tp.img,\n\t\tp.ibu,\n\t\tp.abv,\n\t\tp.style,\n\t\tp.condition,\n\t\tp.price,\n\t\tp.active,\n\t\tp.total_rating,\n\t\tp.date_changed,\n\t\tp.user_changed,\n\t\tp.note,\n\t\tp.date_created,\n\t   to_json(\n\t\t   array(\n\t\t\t\t   SELECT\n\t\t\t\t\t\t  to_json(wbfoo.*)\n\t\t\t\t   FROM\n\t\t\t\t\t\t(\n\t\t\t\t\t\t\tSELECT \n\t\t\t\t\t\t\t\t\twbf.id,\n\t\t\t\t\t\t\t\t\twbf.website_id AS \"websiteId\",\n\t\t\t\t\t\t\t\t\twbf.beer_id AS \"beerId\",\n\t\t\t\t\t\t\t\t\twbf.www,\n\t\t\t\t\t\t\t\t\twbf.rating,\n\t\t\t\t\t\t\t\t\twbf.rating_count AS \"ratingCount\",\n\t\t\t\t\t\t\t\t\twbf.rating_max AS \"ratingMax\",\n\t\t\t\t\t\t\t\t\twbf.last_scan AS \"lastScan\",\n\t\t\t\t\t\t\t\t\twbf.date_changed AS \"dateChanged\",\n\t\t\t\t\t\t\t\t\twbf.user_changed AS \"userChanged\",\n\t\t\t\t\t\t\t\t\twbf.note,\n\t\t\t\t\t\t\t\t\twbf.date_created AS \"dateCreated\"\n\t\t\t\t\t\t\tFROM \n\t\t\t\t\t\t\t\t\tsystem.website_beers wbf\n\t\t\t\t\t\t\tWHERE \n\t\t\t\t\t\t\t\t\twbf.beer_id = p.id\n        \t\t\t\t\t) wbfoo\n\t\t\t\t\t   )\n\t\t\t   )::TEXT AS websites\n \tFROM \n\t\t\t\tsystem.delikatesy p\n\t\tWHERE \n ( \t\tp.id::text ~* :mask \n\tOR \n\t\tp.title::text ~* :mask \n\tOR \n\t\tp.beershop_www::text ~* :mask \n\tOR \n\t\tp.beershop_id::text ~* :mask \n\tOR \n\t\tp.img::text ~* :mask \n\tOR \n\t\tp.ibu::text ~* :mask \n\tOR \n\t\tp.abv::text ~* :mask \n\tOR \n\t\tp.style::text ~* :mask \n\tOR \n\t\tp.condition::text ~* :mask \n\tOR \n\t\tp.price::text ~* :mask \n\tOR \n\t\tp.active::text ~* :mask \n\tOR \n\t\tp.total_rating::text ~* :mask \n\tOR \n\t\tp.date_changed::text ~* :mask \n\tOR \n\t\tp.user_changed::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\t) \n\tAND\n\t\tcoalesce(LOWER(p.style::text), ''::text)::text like LOWER(:style)\n\tAND\n\t\t(p.active = :active OR (CASE WHEN p.active = 0 OR p.active = 1 THEN 2 ELSE 1 END) = :active)\n\n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=BeersWithWebsitesMapper.class)
    public List<BeerWithInfoDomain> findByMaskWithWebsites(@Bind(value="mask") String var1, @Bind(value="style") String var2, @Bind(value="active") Integer var3, @Bind(value="offset") int var4, @Bind(value="limit") int var5, @Define(value="order") String var6, @Define(value="sort") String var7);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n \tFROM \n\t\t\t\tsystem.delikatesy p\n\t\tWHERE \n ( \t\tp.id::text ~* :mask \n\tOR \n\t\tp.title::text ~* :mask \n\tOR \n\t\tp.beershop_www::text ~* :mask \n\tOR \n\t\tp.beershop_id::text ~* :mask \n\tOR \n\t\tp.img::text ~* :mask \n\tOR \n\t\tp.ibu::text ~* :mask \n\tOR \n\t\tp.abv::text ~* :mask \n\tOR \n\t\tp.style::text ~* :mask \n\tOR \n\t\tp.condition::text ~* :mask \n\tOR \n\t\tp.price::text ~* :mask \n\tOR \n\t\tp.active::text ~* :mask \n\tOR \n\t\tp.total_rating::text ~* :mask \n\tOR \n\t\tp.date_changed::text ~* :mask \n\tOR \n\t\tp.user_changed::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\t) \n\tAND\n\t\tcoalesce(LOWER(p.style::text), ''::text)::text like LOWER(:style)\n\tAND\n\t\t(p.active = :active OR (CASE WHEN p.active = 0 OR p.active = 1 THEN 2 ELSE 1 END) = :active)\n\n\n")
    public long findByMaskWithWebsitesCount(@Bind(value="mask") String var1, @Bind(value="style") String var2, @Bind(value="active") Integer var3);

    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.title,\n\t\tp.beershop_www,\n\t\tp.beershop_id,\n\t\tp.img,\n\t\tp.ibu,\n\t\tp.abv,\n\t\tp.style,\n\t\tp.condition,\n\t\tp.price,\n\t\tp.active,\n\t\tp.total_rating,\n\t\tp.date_changed,\n\t\tp.user_changed,\n\t\tp.note,\n\t\tp.date_created,\n\t\tfoo.rating,\n\t   to_json(\n\t\t   array(\n\t\t\t\t   SELECT\n\t\t\t\t\t\t  to_json(wbfoo.*)\n\t\t\t\t   FROM\n\t\t\t\t\t\t(\n\t\t\t\t\t\t\tSELECT \n\t\t\t\t\t\t\t\t\twbf.id,\n\t\t\t\t\t\t\t\t\twbf.website_id AS \"websiteId\",\n\t\t\t\t\t\t\t\t\twbf.beer_id AS \"beerId\",\n\t\t\t\t\t\t\t\t\twbf.www,\n\t\t\t\t\t\t\t\t\twbf.rating,\n\t\t\t\t\t\t\t\t\twbf.rating_count AS \"ratingCount\",\n\t\t\t\t\t\t\t\t\twbf.rating_max AS \"ratingMax\",\n\t\t\t\t\t\t\t\t\twbf.last_scan AS \"lastScan\",\n\t\t\t\t\t\t\t\t\twbf.date_changed AS \"dateChanged\",\n\t\t\t\t\t\t\t\t\twbf.user_changed AS \"userChanged\",\n\t\t\t\t\t\t\t\t\twbf.note,\n\t\t\t\t\t\t\t\t\twbf.date_created AS \"dateCreated\"\n\t\t\t\t\t\t\tFROM \n\t\t\t\t\t\t\t\t\tsystem.website_beers wbf\n\t\t\t\t\t\t\tWHERE \n\t\t\t\t\t\t\t\t\twbf.beer_id = p.id\n        \t\t\t\t\t) wbfoo\n\t\t\t\t\t   )\n\t\t\t   )::TEXT AS websites\n FROM \n\t\tsystem.delikatesy p\n\t\tINNER JOIN (\n\t\t\tSELECT\n\t\t\t\t\twb.beer_id,\n\t\t\t\t\tSUM(wb.rating) as rating\n\t\t\tFROM\n\t\t\t\tsystem.website_beers wb\n\t\t\tWHERE\n\t\t\t\twb.website_id = :websiteId\n\t\t\tGROUP BY\n\t\t\t\twb.beer_id\n\t\t) foo ON (p.id = foo.beer_id)\n\n\t\tWHERE \n ( \t\tp.id::text ~* :mask \n\tOR \n\t\tp.title::text ~* :mask \n\tOR \n\t\tp.beershop_www::text ~* :mask \n\tOR \n\t\tp.beershop_id::text ~* :mask \n\tOR \n\t\tp.img::text ~* :mask \n\tOR \n\t\tp.ibu::text ~* :mask \n\tOR \n\t\tp.abv::text ~* :mask \n\tOR \n\t\tp.style::text ~* :mask \n\tOR \n\t\tp.condition::text ~* :mask \n\tOR \n\t\tp.price::text ~* :mask \n\tOR \n\t\tp.active::text ~* :mask \n\tOR \n\t\tp.total_rating::text ~* :mask \n\tOR \n\t\tp.date_changed::text ~* :mask \n\tOR \n\t\tp.user_changed::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\t) \n\tAND\n\t\tcoalesce(LOWER(p.style::text), ''::text)::text like LOWER(:style)\n\tAND\n\t\t(p.active = :active OR (CASE WHEN p.active = 0 OR p.active = 1 THEN 2 ELSE 1 END) = :active)\n\n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=BeersRatingMapper.class)
    public List<BeerWithInfoDomain> findByMaskRating(@Bind(value="websiteId") Long var1, @Bind(value="mask") String var2, @Bind(value="style") String var3, @Bind(value="active") Integer var4, @Bind(value="offset") int var5, @Bind(value="limit") int var6, @Define(value="order") String var7, @Define(value="sort") String var8);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tsystem.delikatesy p\n\t\tINNER JOIN (\n\t\t\tSELECT\n\t\t\t\t\twb.beer_id,\n\t\t\t\t\tSUM(wb.rating) as rating\n\t\t\tFROM\n\t\t\t\tsystem.website_beers wb\n\t\t\tWHERE\n\t\t\t\twb.website_id = :websiteId\n\t\t\tGROUP BY\n\t\t\t\twb.beer_id\n\t\t) foo ON (p.id = foo.beer_id)\n\n\t\tWHERE \n ( \t\tp.id::text ~* :mask \n\tOR \n\t\tp.title::text ~* :mask \n\tOR \n\t\tp.beershop_www::text ~* :mask \n\tOR \n\t\tp.beershop_id::text ~* :mask \n\tOR \n\t\tp.img::text ~* :mask \n\tOR \n\t\tp.ibu::text ~* :mask \n\tOR \n\t\tp.abv::text ~* :mask \n\tOR \n\t\tp.style::text ~* :mask \n\tOR \n\t\tp.condition::text ~* :mask \n\tOR \n\t\tp.price::text ~* :mask \n\tOR \n\t\tp.active::text ~* :mask \n\tOR \n\t\tp.total_rating::text ~* :mask \n\tOR \n\t\tp.date_changed::text ~* :mask \n\tOR \n\t\tp.user_changed::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\t) \n\tAND\n\t\tcoalesce(LOWER(p.style::text), ''::text)::text like LOWER(:style)\n\tAND\n\t\t(p.active = :active OR (CASE WHEN p.active = 0 OR p.active = 1 THEN 2 ELSE 1 END) = :active)\n\n\n")
    public long findByMaskRatingCount(@Bind(value="websiteId") Long var1, @Bind(value="mask") String var2, @Bind(value="style") String var3, @Bind(value="active") Integer var4);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p WHERE (p.active = :active OR (CASE WHEN p.active = 0 OR p.active = 1 THEN 2 ELSE 1 END) = :active) ORDER BY p.id ASC")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findByActiveSpecial(@Bind(value="active") Integer var1);

    @SqlQuery(value="SELECT\n\t(\n\t\t(\n\t\t\t2 * ( SELECT COALESCE(SUM(rrt.rt), 0) FROM ( SELECT COALESCE(rating, 0) as rt FROM system.website_beers WHERE beer_id = :beerId AND website_id = 1 UNION ALL SELECT 0 ) rrt )::float -- RT\n\t\t\t* ( SELECT COALESCE(SUM(vrrt.vhrt), 0) FROM ( SELECT COALESCE(rating_count::float / (SELECT ( CASE WHEN COALESCE(SUM(rating_count), 0) > 0 THEN COALESCE(SUM(rating_count), 0) ELSE 1 END ) FROM system.website_beers WHERE beer_id = :beerId)::float, 0) vhrt FROM system.website_beers WHERE beer_id = :beerId AND website_id = 1 UNION ALL SELECT 0 ) vrrt )::float -- VH (RT)\n\t\t) + (\n\t\t\t(SELECT COALESCE(SUM(rpi.rt), 0) FROM ( SELECT COALESCE(rating, 0) as rt FROM system.website_beers WHERE beer_id = :beerId AND website_id = 2 UNION ALL SELECT 0 ) rpi )::float -- PI\n\t\t\t* (SELECT COALESCE(SUM(vrpi.vhrt), 0) FROM ( SELECT COALESCE(rating_count::float / (SELECT ( CASE WHEN COALESCE(SUM(rating_count), 0) > 0 THEN COALESCE(SUM(rating_count), 0) ELSE 1 END ) FROM system.website_beers WHERE beer_id = :beerId)::float, 0) vhrt FROM system.website_beers WHERE beer_id = :beerId AND website_id = 2 UNION ALL SELECT 0 ) vrpi )::float -- VH (PI)\n\t\t)\n\t\t+ (\n\t\t\t2 * ( SELECT COALESCE(SUM(run.rt), 0) FROM ( SELECT COALESCE(rating, 0) as rt FROM system.website_beers WHERE beer_id = :beerId AND website_id = 3 UNION ALL SELECT 0 ) run )::float -- UN\n\t\t\t* (SELECT COALESCE(SUM(vrun.vhrt), 0) FROM ( SELECT COALESCE(rating_count::float / (SELECT ( CASE WHEN COALESCE(SUM(rating_count), 0) > 0 THEN COALESCE(SUM(rating_count), 0) ELSE 1 END ) FROM system.website_beers WHERE beer_id = :beerId)::float, 0) vhrt FROM system.website_beers WHERE beer_id = :beerId AND website_id = 3 UNION ALL SELECT 0 ) vrun )::float -- VH (UN)\n\t\t)\n\t\t+ (\n\t\t\t( SELECT COALESCE(SUM(rbe.rt), 0) FROM ( SELECT COALESCE(rating, 0) as rt FROM system.website_beers WHERE beer_id = :beerId AND website_id = 4 UNION ALL SELECT 0 ) rbe )::float -- BE\n\t\t\t/ 10\n\t\t\t* (SELECT COALESCE(SUM(vrbe.vhrt), 0) FROM ( SELECT COALESCE(rating_count::float / (SELECT ( CASE WHEN COALESCE(SUM(rating_count), 0) > 0 THEN COALESCE(SUM(rating_count), 0) ELSE 1 END ) FROM system.website_beers WHERE beer_id = :beerId)::float, 0) vhrt FROM system.website_beers WHERE beer_id = :beerId AND website_id = 4 UNION ALL SELECT 0 ) vrbe )::float -- VH (BE)\n\t\t)\n\t) * 10\n")
    @SingleValue
    public Double countTotalRatingForBeer(@Bind(value="beerId") Long var1);

    @SqlQuery(value="SELECT p.style FROM system.delikatesy p WHERE p.style IS NOT NULL AND p.style <> '' GROUP BY p.style ORDER BY p.style ")
    public List<String> findListAllStyles();

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  ")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.id = :id")
    @RegisterRowMapper(value=BeersMapper.class)
    public BeersDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.id = :id")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.delikatesy p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.title = :title")
    @RegisterRowMapper(value=BeersMapper.class)
    public BeersDomain findByTitle(@Bind(value="title") String var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.title = :title")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListByTitle(@Bind(value="title") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.delikatesy p  WHERE p.title = :title")
    public long findListByTitleCount(@Bind(value="title") String var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.title = :title ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListByTitle(@Bind(value="title") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.beershop_www = :beershopWww")
    @RegisterRowMapper(value=BeersMapper.class)
    public BeersDomain findByBeershopWww(@Bind(value="beershopWww") String var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.beershop_www = :beershopWww")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListByBeershopWww(@Bind(value="beershopWww") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.delikatesy p  WHERE p.beershop_www = :beershopWww")
    public long findListByBeershopWwwCount(@Bind(value="beershopWww") String var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.beershop_www = :beershopWww ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListByBeershopWww(@Bind(value="beershopWww") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.beershop_id = :beershopId")
    @RegisterRowMapper(value=BeersMapper.class)
    public BeersDomain findByBeershopId(@Bind(value="beershopId") String var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.beershop_id = :beershopId")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListByBeershopId(@Bind(value="beershopId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.delikatesy p  WHERE p.beershop_id = :beershopId")
    public long findListByBeershopIdCount(@Bind(value="beershopId") String var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.beershop_id = :beershopId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListByBeershopId(@Bind(value="beershopId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.img = :img")
    @RegisterRowMapper(value=BeersMapper.class)
    public BeersDomain findByImg(@Bind(value="img") String var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.img = :img")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListByImg(@Bind(value="img") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.delikatesy p  WHERE p.img = :img")
    public long findListByImgCount(@Bind(value="img") String var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.img = :img ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListByImg(@Bind(value="img") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.ibu = :ibu")
    @RegisterRowMapper(value=BeersMapper.class)
    public BeersDomain findByIbu(@Bind(value="ibu") Double var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.ibu = :ibu")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListByIbu(@Bind(value="ibu") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.delikatesy p  WHERE p.ibu = :ibu")
    public long findListByIbuCount(@Bind(value="ibu") Double var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.ibu = :ibu ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListByIbu(@Bind(value="ibu") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.abv = :abv")
    @RegisterRowMapper(value=BeersMapper.class)
    public BeersDomain findByAbv(@Bind(value="abv") Double var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.abv = :abv")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListByAbv(@Bind(value="abv") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.delikatesy p  WHERE p.abv = :abv")
    public long findListByAbvCount(@Bind(value="abv") Double var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.abv = :abv ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListByAbv(@Bind(value="abv") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.style = :style")
    @RegisterRowMapper(value=BeersMapper.class)
    public BeersDomain findByStyle(@Bind(value="style") String var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.style = :style")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListByStyle(@Bind(value="style") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.delikatesy p  WHERE p.style = :style")
    public long findListByStyleCount(@Bind(value="style") String var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.style = :style ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListByStyle(@Bind(value="style") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.condition = :condition")
    @RegisterRowMapper(value=BeersMapper.class)
    public BeersDomain findByCondition(@Bind(value="condition") String var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.condition = :condition")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListByCondition(@Bind(value="condition") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.delikatesy p  WHERE p.condition = :condition")
    public long findListByConditionCount(@Bind(value="condition") String var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.condition = :condition ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListByCondition(@Bind(value="condition") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.price = :price")
    @RegisterRowMapper(value=BeersMapper.class)
    public BeersDomain findByPrice(@Bind(value="price") Double var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.price = :price")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListByPrice(@Bind(value="price") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.delikatesy p  WHERE p.price = :price")
    public long findListByPriceCount(@Bind(value="price") Double var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.price = :price ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListByPrice(@Bind(value="price") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.active = :active")
    @RegisterRowMapper(value=BeersMapper.class)
    public BeersDomain findByActive(@Bind(value="active") Integer var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.active = :active")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListByActive(@Bind(value="active") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.delikatesy p  WHERE p.active = :active")
    public long findListByActiveCount(@Bind(value="active") Integer var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.active = :active ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListByActive(@Bind(value="active") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.total_rating = :totalRating")
    @RegisterRowMapper(value=BeersMapper.class)
    public BeersDomain findByTotalRating(@Bind(value="totalRating") Double var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.total_rating = :totalRating")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListByTotalRating(@Bind(value="totalRating") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.delikatesy p  WHERE p.total_rating = :totalRating")
    public long findListByTotalRatingCount(@Bind(value="totalRating") Double var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.total_rating = :totalRating ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListByTotalRating(@Bind(value="totalRating") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.date_changed = :dateChanged")
    @RegisterRowMapper(value=BeersMapper.class)
    public BeersDomain findByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.date_changed = :dateChanged")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.delikatesy p  WHERE p.date_changed = :dateChanged")
    public long findListByDateChangedCount(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.date_changed = :dateChanged ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListByDateChanged(@Bind(value="dateChanged") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.user_changed = :userChanged")
    @RegisterRowMapper(value=BeersMapper.class)
    public BeersDomain findByUserChanged(@Bind(value="userChanged") String var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.user_changed = :userChanged")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListByUserChanged(@Bind(value="userChanged") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.delikatesy p  WHERE p.user_changed = :userChanged")
    public long findListByUserChangedCount(@Bind(value="userChanged") String var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.user_changed = :userChanged ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListByUserChanged(@Bind(value="userChanged") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.note = :note")
    @RegisterRowMapper(value=BeersMapper.class)
    public BeersDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.note = :note")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.delikatesy p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=BeersMapper.class)
    public BeersDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.delikatesy p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.title, p.beershop_www, p.beershop_id, p.img, p.ibu, p.abv, p.style, p.condition, p.price, p.active, p.total_rating, p.date_changed, p.user_changed, p.note, p.date_created FROM system.delikatesy p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeersMapper.class)
    public List<BeersDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO system.delikatesy (id, title, beershop_www, beershop_id, img, ibu, abv, style, condition, price, active, total_rating, date_changed, user_changed, note, date_created) VALUES (:id, :title, :beershopWww, :beershopId, :img, :ibu, :abv, :style, :condition, :price, :active, :totalRating, :dateChanged, :userChanged, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="title") String var2, @Bind(value="beershopWww") String var3, @Bind(value="beershopId") String var4, @Bind(value="img") String var5, @Bind(value="ibu") Double var6, @Bind(value="abv") Double var7, @Bind(value="style") String var8, @Bind(value="condition") String var9, @Bind(value="price") Double var10, @Bind(value="active") Integer var11, @Bind(value="totalRating") Double var12, @Bind(value="dateChanged") Date var13, @Bind(value="userChanged") String var14, @Bind(value="note") String var15, @Bind(value="dateCreated") Date var16);

    @SqlUpdate(value="INSERT INTO system.delikatesy (title, beershop_www, beershop_id, img, ibu, abv, style, condition, price, active, total_rating, date_changed, user_changed, note, date_created) VALUES (:e.title, :e.beershopWww, :e.beershopId, :e.img, :e.ibu, :e.abv, :e.style, :e.condition, :e.price, :e.active, :e.totalRating, :e.dateChanged, :e.userChanged, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") BeersDomain var1);

    @SqlUpdate(value="UPDATE system.delikatesy SET id = :e.id, title = :e.title, beershop_www = :e.beershopWww, beershop_id = :e.beershopId, img = :e.img, ibu = :e.ibu, abv = :e.abv, style = :e.style, condition = :e.condition, price = :e.price, active = :e.active, total_rating = :e.totalRating, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") BeersDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE system.delikatesy SET id = :e.id, title = :e.title, beershop_www = :e.beershopWww, beershop_id = :e.beershopId, img = :e.img, ibu = :e.ibu, abv = :e.abv, style = :e.style, condition = :e.condition, price = :e.price, active = :e.active, total_rating = :e.totalRating, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE title = :byTitle")
    public int updateByTitle(@BindBean(value="e") BeersDomain var1, @Bind(value="byTitle") String var2);

    @SqlUpdate(value="UPDATE system.delikatesy SET id = :e.id, title = :e.title, beershop_www = :e.beershopWww, beershop_id = :e.beershopId, img = :e.img, ibu = :e.ibu, abv = :e.abv, style = :e.style, condition = :e.condition, price = :e.price, active = :e.active, total_rating = :e.totalRating, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE beershop_www = :byBeershopWww")
    public int updateByBeershopWww(@BindBean(value="e") BeersDomain var1, @Bind(value="byBeershopWww") String var2);

    @SqlUpdate(value="UPDATE system.delikatesy SET id = :e.id, title = :e.title, beershop_www = :e.beershopWww, beershop_id = :e.beershopId, img = :e.img, ibu = :e.ibu, abv = :e.abv, style = :e.style, condition = :e.condition, price = :e.price, active = :e.active, total_rating = :e.totalRating, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE beershop_id = :byBeershopId")
    public int updateByBeershopId(@BindBean(value="e") BeersDomain var1, @Bind(value="byBeershopId") String var2);

    @SqlUpdate(value="UPDATE system.delikatesy SET id = :e.id, title = :e.title, beershop_www = :e.beershopWww, beershop_id = :e.beershopId, img = :e.img, ibu = :e.ibu, abv = :e.abv, style = :e.style, condition = :e.condition, price = :e.price, active = :e.active, total_rating = :e.totalRating, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE img = :byImg")
    public int updateByImg(@BindBean(value="e") BeersDomain var1, @Bind(value="byImg") String var2);

    @SqlUpdate(value="UPDATE system.delikatesy SET id = :e.id, title = :e.title, beershop_www = :e.beershopWww, beershop_id = :e.beershopId, img = :e.img, ibu = :e.ibu, abv = :e.abv, style = :e.style, condition = :e.condition, price = :e.price, active = :e.active, total_rating = :e.totalRating, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE ibu = :byIbu")
    public int updateByIbu(@BindBean(value="e") BeersDomain var1, @Bind(value="byIbu") Double var2);

    @SqlUpdate(value="UPDATE system.delikatesy SET id = :e.id, title = :e.title, beershop_www = :e.beershopWww, beershop_id = :e.beershopId, img = :e.img, ibu = :e.ibu, abv = :e.abv, style = :e.style, condition = :e.condition, price = :e.price, active = :e.active, total_rating = :e.totalRating, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE abv = :byAbv")
    public int updateByAbv(@BindBean(value="e") BeersDomain var1, @Bind(value="byAbv") Double var2);

    @SqlUpdate(value="UPDATE system.delikatesy SET id = :e.id, title = :e.title, beershop_www = :e.beershopWww, beershop_id = :e.beershopId, img = :e.img, ibu = :e.ibu, abv = :e.abv, style = :e.style, condition = :e.condition, price = :e.price, active = :e.active, total_rating = :e.totalRating, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE style = :byStyle")
    public int updateByStyle(@BindBean(value="e") BeersDomain var1, @Bind(value="byStyle") String var2);

    @SqlUpdate(value="UPDATE system.delikatesy SET id = :e.id, title = :e.title, beershop_www = :e.beershopWww, beershop_id = :e.beershopId, img = :e.img, ibu = :e.ibu, abv = :e.abv, style = :e.style, condition = :e.condition, price = :e.price, active = :e.active, total_rating = :e.totalRating, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE condition = :byCondition")
    public int updateByCondition(@BindBean(value="e") BeersDomain var1, @Bind(value="byCondition") String var2);

    @SqlUpdate(value="UPDATE system.delikatesy SET id = :e.id, title = :e.title, beershop_www = :e.beershopWww, beershop_id = :e.beershopId, img = :e.img, ibu = :e.ibu, abv = :e.abv, style = :e.style, condition = :e.condition, price = :e.price, active = :e.active, total_rating = :e.totalRating, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE price = :byPrice")
    public int updateByPrice(@BindBean(value="e") BeersDomain var1, @Bind(value="byPrice") Double var2);

    @SqlUpdate(value="UPDATE system.delikatesy SET id = :e.id, title = :e.title, beershop_www = :e.beershopWww, beershop_id = :e.beershopId, img = :e.img, ibu = :e.ibu, abv = :e.abv, style = :e.style, condition = :e.condition, price = :e.price, active = :e.active, total_rating = :e.totalRating, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE active = :byActive")
    public int updateByActive(@BindBean(value="e") BeersDomain var1, @Bind(value="byActive") Integer var2);

    @SqlUpdate(value="UPDATE system.delikatesy SET id = :e.id, title = :e.title, beershop_www = :e.beershopWww, beershop_id = :e.beershopId, img = :e.img, ibu = :e.ibu, abv = :e.abv, style = :e.style, condition = :e.condition, price = :e.price, active = :e.active, total_rating = :e.totalRating, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE total_rating = :byTotalRating")
    public int updateByTotalRating(@BindBean(value="e") BeersDomain var1, @Bind(value="byTotalRating") Double var2);

    @SqlUpdate(value="UPDATE system.delikatesy SET id = :e.id, title = :e.title, beershop_www = :e.beershopWww, beershop_id = :e.beershopId, img = :e.img, ibu = :e.ibu, abv = :e.abv, style = :e.style, condition = :e.condition, price = :e.price, active = :e.active, total_rating = :e.totalRating, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE date_changed = :byDateChanged")
    public int updateByDateChanged(@BindBean(value="e") BeersDomain var1, @Bind(value="byDateChanged") Date var2);

    @SqlUpdate(value="UPDATE system.delikatesy SET id = :e.id, title = :e.title, beershop_www = :e.beershopWww, beershop_id = :e.beershopId, img = :e.img, ibu = :e.ibu, abv = :e.abv, style = :e.style, condition = :e.condition, price = :e.price, active = :e.active, total_rating = :e.totalRating, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE user_changed = :byUserChanged")
    public int updateByUserChanged(@BindBean(value="e") BeersDomain var1, @Bind(value="byUserChanged") String var2);

    @SqlUpdate(value="UPDATE system.delikatesy SET id = :e.id, title = :e.title, beershop_www = :e.beershopWww, beershop_id = :e.beershopId, img = :e.img, ibu = :e.ibu, abv = :e.abv, style = :e.style, condition = :e.condition, price = :e.price, active = :e.active, total_rating = :e.totalRating, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") BeersDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE system.delikatesy SET id = :e.id, title = :e.title, beershop_www = :e.beershopWww, beershop_id = :e.beershopId, img = :e.img, ibu = :e.ibu, abv = :e.abv, style = :e.style, condition = :e.condition, price = :e.price, active = :e.active, total_rating = :e.totalRating, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") BeersDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM system.delikatesy WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM system.delikatesy WHERE title = :title")
    public int deleteByTitle(@Bind(value="title") String var1);

    @SqlUpdate(value="DELETE FROM system.delikatesy WHERE beershop_www = :beershopWww")
    public int deleteByBeershopWww(@Bind(value="beershopWww") String var1);

    @SqlUpdate(value="DELETE FROM system.delikatesy WHERE beershop_id = :beershopId")
    public int deleteByBeershopId(@Bind(value="beershopId") String var1);

    @SqlUpdate(value="DELETE FROM system.delikatesy WHERE img = :img")
    public int deleteByImg(@Bind(value="img") String var1);

    @SqlUpdate(value="DELETE FROM system.delikatesy WHERE ibu = :ibu")
    public int deleteByIbu(@Bind(value="ibu") Double var1);

    @SqlUpdate(value="DELETE FROM system.delikatesy WHERE abv = :abv")
    public int deleteByAbv(@Bind(value="abv") Double var1);

    @SqlUpdate(value="DELETE FROM system.delikatesy WHERE style = :style")
    public int deleteByStyle(@Bind(value="style") String var1);

    @SqlUpdate(value="DELETE FROM system.delikatesy WHERE condition = :condition")
    public int deleteByCondition(@Bind(value="condition") String var1);

    @SqlUpdate(value="DELETE FROM system.delikatesy WHERE price = :price")
    public int deleteByPrice(@Bind(value="price") Double var1);

    @SqlUpdate(value="DELETE FROM system.delikatesy WHERE active = :active")
    public int deleteByActive(@Bind(value="active") Integer var1);

    @SqlUpdate(value="DELETE FROM system.delikatesy WHERE total_rating = :totalRating")
    public int deleteByTotalRating(@Bind(value="totalRating") Double var1);

    @SqlUpdate(value="DELETE FROM system.delikatesy WHERE date_changed = :dateChanged")
    public int deleteByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlUpdate(value="DELETE FROM system.delikatesy WHERE user_changed = :userChanged")
    public int deleteByUserChanged(@Bind(value="userChanged") String var1);

    @SqlUpdate(value="DELETE FROM system.delikatesy WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM system.delikatesy WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

