/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.StoreCardEansMapper;
import cz.airtoy.airshop.domains.StoreCardEansDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface StoreCardEansDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.abra_id,\n\t\tp.store_cards_id,\n\t\tp.store_units_id,\n\t\tp.objversion,\n\t\tp.ean,\n\t\tp.date_created\n FROM \n\t\tabra.store_card_eans p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.store_cards_id::text ~* :mask \n\tOR \n\t\tp.store_units_id::text ~* :mask \n\tOR \n\t\tp.objversion::text ~* :mask \n\tOR \n\t\tp.ean::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=StoreCardEansMapper.class)
    public List<StoreCardEansDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tabra.store_card_eans p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.store_cards_id::text ~* :mask \n\tOR \n\t\tp.store_units_id::text ~* :mask \n\tOR \n\t\tp.objversion::text ~* :mask \n\tOR \n\t\tp.ean::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_cards_id, p.store_units_id, p.objversion, p.ean, p.date_created FROM abra.store_card_eans p  WHERE p.id = :id")
    @RegisterRowMapper(value=StoreCardEansMapper.class)
    public StoreCardEansDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_cards_id, p.store_units_id, p.objversion, p.ean, p.date_created FROM abra.store_card_eans p  WHERE p.id = :id")
    @RegisterRowMapper(value=StoreCardEansMapper.class)
    public List<StoreCardEansDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.store_card_eans p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_cards_id, p.store_units_id, p.objversion, p.ean, p.date_created FROM abra.store_card_eans p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StoreCardEansMapper.class)
    public List<StoreCardEansDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_cards_id, p.store_units_id, p.objversion, p.ean, p.date_created FROM abra.store_card_eans p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=StoreCardEansMapper.class)
    public StoreCardEansDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_cards_id, p.store_units_id, p.objversion, p.ean, p.date_created FROM abra.store_card_eans p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=StoreCardEansMapper.class)
    public List<StoreCardEansDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.store_card_eans p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_cards_id, p.store_units_id, p.objversion, p.ean, p.date_created FROM abra.store_card_eans p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StoreCardEansMapper.class)
    public List<StoreCardEansDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_cards_id, p.store_units_id, p.objversion, p.ean, p.date_created FROM abra.store_card_eans p  WHERE p.abra_id = :abraId")
    @RegisterRowMapper(value=StoreCardEansMapper.class)
    public StoreCardEansDomain findByAbraId(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_cards_id, p.store_units_id, p.objversion, p.ean, p.date_created FROM abra.store_card_eans p  WHERE p.abra_id = :abraId")
    @RegisterRowMapper(value=StoreCardEansMapper.class)
    public List<StoreCardEansDomain> findListByAbraId(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.store_card_eans p  WHERE p.abra_id = :abraId")
    public long findListByAbraIdCount(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_cards_id, p.store_units_id, p.objversion, p.ean, p.date_created FROM abra.store_card_eans p  WHERE p.abra_id = :abraId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StoreCardEansMapper.class)
    public List<StoreCardEansDomain> findListByAbraId(@Bind(value="abraId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_cards_id, p.store_units_id, p.objversion, p.ean, p.date_created FROM abra.store_card_eans p  WHERE p.store_cards_id = :storeCardsId")
    @RegisterRowMapper(value=StoreCardEansMapper.class)
    public StoreCardEansDomain findByStoreCardsId(@Bind(value="storeCardsId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_cards_id, p.store_units_id, p.objversion, p.ean, p.date_created FROM abra.store_card_eans p  WHERE p.store_cards_id = :storeCardsId")
    @RegisterRowMapper(value=StoreCardEansMapper.class)
    public List<StoreCardEansDomain> findListByStoreCardsId(@Bind(value="storeCardsId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.store_card_eans p  WHERE p.store_cards_id = :storeCardsId")
    public long findListByStoreCardsIdCount(@Bind(value="storeCardsId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_cards_id, p.store_units_id, p.objversion, p.ean, p.date_created FROM abra.store_card_eans p  WHERE p.store_cards_id = :storeCardsId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StoreCardEansMapper.class)
    public List<StoreCardEansDomain> findListByStoreCardsId(@Bind(value="storeCardsId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_cards_id, p.store_units_id, p.objversion, p.ean, p.date_created FROM abra.store_card_eans p  WHERE p.store_units_id = :storeUnitsId")
    @RegisterRowMapper(value=StoreCardEansMapper.class)
    public StoreCardEansDomain findByStoreUnitsId(@Bind(value="storeUnitsId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_cards_id, p.store_units_id, p.objversion, p.ean, p.date_created FROM abra.store_card_eans p  WHERE p.store_units_id = :storeUnitsId")
    @RegisterRowMapper(value=StoreCardEansMapper.class)
    public List<StoreCardEansDomain> findListByStoreUnitsId(@Bind(value="storeUnitsId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.store_card_eans p  WHERE p.store_units_id = :storeUnitsId")
    public long findListByStoreUnitsIdCount(@Bind(value="storeUnitsId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_cards_id, p.store_units_id, p.objversion, p.ean, p.date_created FROM abra.store_card_eans p  WHERE p.store_units_id = :storeUnitsId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StoreCardEansMapper.class)
    public List<StoreCardEansDomain> findListByStoreUnitsId(@Bind(value="storeUnitsId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_cards_id, p.store_units_id, p.objversion, p.ean, p.date_created FROM abra.store_card_eans p  WHERE p.objversion = :objversion")
    @RegisterRowMapper(value=StoreCardEansMapper.class)
    public StoreCardEansDomain findByObjversion(@Bind(value="objversion") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_cards_id, p.store_units_id, p.objversion, p.ean, p.date_created FROM abra.store_card_eans p  WHERE p.objversion = :objversion")
    @RegisterRowMapper(value=StoreCardEansMapper.class)
    public List<StoreCardEansDomain> findListByObjversion(@Bind(value="objversion") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.store_card_eans p  WHERE p.objversion = :objversion")
    public long findListByObjversionCount(@Bind(value="objversion") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_cards_id, p.store_units_id, p.objversion, p.ean, p.date_created FROM abra.store_card_eans p  WHERE p.objversion = :objversion ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StoreCardEansMapper.class)
    public List<StoreCardEansDomain> findListByObjversion(@Bind(value="objversion") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_cards_id, p.store_units_id, p.objversion, p.ean, p.date_created FROM abra.store_card_eans p  WHERE p.ean = :ean")
    @RegisterRowMapper(value=StoreCardEansMapper.class)
    public StoreCardEansDomain findByEan(@Bind(value="ean") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_cards_id, p.store_units_id, p.objversion, p.ean, p.date_created FROM abra.store_card_eans p  WHERE p.ean = :ean")
    @RegisterRowMapper(value=StoreCardEansMapper.class)
    public List<StoreCardEansDomain> findListByEan(@Bind(value="ean") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.store_card_eans p  WHERE p.ean = :ean")
    public long findListByEanCount(@Bind(value="ean") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_cards_id, p.store_units_id, p.objversion, p.ean, p.date_created FROM abra.store_card_eans p  WHERE p.ean = :ean ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StoreCardEansMapper.class)
    public List<StoreCardEansDomain> findListByEan(@Bind(value="ean") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_cards_id, p.store_units_id, p.objversion, p.ean, p.date_created FROM abra.store_card_eans p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=StoreCardEansMapper.class)
    public StoreCardEansDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_cards_id, p.store_units_id, p.objversion, p.ean, p.date_created FROM abra.store_card_eans p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=StoreCardEansMapper.class)
    public List<StoreCardEansDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.store_card_eans p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_cards_id, p.store_units_id, p.objversion, p.ean, p.date_created FROM abra.store_card_eans p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=StoreCardEansMapper.class)
    public List<StoreCardEansDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO abra.store_card_eans (id, uid, abra_id, store_cards_id, store_units_id, objversion, ean, date_created) VALUES (:id, :uid, :abraId, :storeCardsId, :storeUnitsId, :objversion, :ean, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="abraId") String var3, @Bind(value="storeCardsId") Long var4, @Bind(value="storeUnitsId") Long var5, @Bind(value="objversion") Integer var6, @Bind(value="ean") String var7, @Bind(value="dateCreated") Date var8);

    @SqlUpdate(value="INSERT INTO abra.store_card_eans (abra_id, store_cards_id, store_units_id, objversion, ean, date_created) VALUES (:e.abraId, :e.storeCardsId, :e.storeUnitsId, :e.objversion, :e.ean, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") StoreCardEansDomain var1);

    @SqlUpdate(value="UPDATE abra.store_card_eans SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, store_cards_id = :e.storeCardsId, store_units_id = :e.storeUnitsId, objversion = :e.objversion, ean = :e.ean, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") StoreCardEansDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE abra.store_card_eans SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, store_cards_id = :e.storeCardsId, store_units_id = :e.storeUnitsId, objversion = :e.objversion, ean = :e.ean, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") StoreCardEansDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE abra.store_card_eans SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, store_cards_id = :e.storeCardsId, store_units_id = :e.storeUnitsId, objversion = :e.objversion, ean = :e.ean, date_created = :e.dateCreated WHERE abra_id = :byAbraId")
    public int updateByAbraId(@BindBean(value="e") StoreCardEansDomain var1, @Bind(value="byAbraId") String var2);

    @SqlUpdate(value="UPDATE abra.store_card_eans SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, store_cards_id = :e.storeCardsId, store_units_id = :e.storeUnitsId, objversion = :e.objversion, ean = :e.ean, date_created = :e.dateCreated WHERE store_cards_id = :byStoreCardsId")
    public int updateByStoreCardsId(@BindBean(value="e") StoreCardEansDomain var1, @Bind(value="byStoreCardsId") Long var2);

    @SqlUpdate(value="UPDATE abra.store_card_eans SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, store_cards_id = :e.storeCardsId, store_units_id = :e.storeUnitsId, objversion = :e.objversion, ean = :e.ean, date_created = :e.dateCreated WHERE store_units_id = :byStoreUnitsId")
    public int updateByStoreUnitsId(@BindBean(value="e") StoreCardEansDomain var1, @Bind(value="byStoreUnitsId") Long var2);

    @SqlUpdate(value="UPDATE abra.store_card_eans SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, store_cards_id = :e.storeCardsId, store_units_id = :e.storeUnitsId, objversion = :e.objversion, ean = :e.ean, date_created = :e.dateCreated WHERE objversion = :byObjversion")
    public int updateByObjversion(@BindBean(value="e") StoreCardEansDomain var1, @Bind(value="byObjversion") Integer var2);

    @SqlUpdate(value="UPDATE abra.store_card_eans SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, store_cards_id = :e.storeCardsId, store_units_id = :e.storeUnitsId, objversion = :e.objversion, ean = :e.ean, date_created = :e.dateCreated WHERE ean = :byEan")
    public int updateByEan(@BindBean(value="e") StoreCardEansDomain var1, @Bind(value="byEan") String var2);

    @SqlUpdate(value="UPDATE abra.store_card_eans SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, store_cards_id = :e.storeCardsId, store_units_id = :e.storeUnitsId, objversion = :e.objversion, ean = :e.ean, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") StoreCardEansDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM abra.store_card_eans WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM abra.store_card_eans WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM abra.store_card_eans WHERE abra_id = :abraId")
    public int deleteByAbraId(@Bind(value="abraId") String var1);

    @SqlUpdate(value="DELETE FROM abra.store_card_eans WHERE store_cards_id = :storeCardsId")
    public int deleteByStoreCardsId(@Bind(value="storeCardsId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.store_card_eans WHERE store_units_id = :storeUnitsId")
    public int deleteByStoreUnitsId(@Bind(value="storeUnitsId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.store_card_eans WHERE objversion = :objversion")
    public int deleteByObjversion(@Bind(value="objversion") Integer var1);

    @SqlUpdate(value="DELETE FROM abra.store_card_eans WHERE ean = :ean")
    public int deleteByEan(@Bind(value="ean") String var1);

    @SqlUpdate(value="DELETE FROM abra.store_card_eans WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

