/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.OrderProcessMapper;
import cz.airtoy.airshop.domains.OrderProcessDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface OrderProcessDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.order_id,\n\t\tp.partner_id,\n\t\tp.status,\n\t\tp.date_started,\n\t\tp.date_finished,\n\t\tp.date_updated,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tapp.order_process p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.order_id::text ~* :mask \n\tOR \n\t\tp.partner_id::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.date_started::text ~* :mask \n\tOR \n\t\tp.date_finished::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=OrderProcessMapper.class)
    public List<OrderProcessDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tapp.order_process p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.order_id::text ~* :mask \n\tOR \n\t\tp.partner_id::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.date_started::text ~* :mask \n\tOR \n\t\tp.date_finished::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.partner_id, p.status, p.date_started, p.date_finished, p.date_updated, p.note, p.date_created FROM app.order_process p  WHERE p.id = :id")
    @RegisterRowMapper(value=OrderProcessMapper.class)
    public OrderProcessDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.partner_id, p.status, p.date_started, p.date_finished, p.date_updated, p.note, p.date_created FROM app.order_process p  WHERE p.id = :id")
    @RegisterRowMapper(value=OrderProcessMapper.class)
    public List<OrderProcessDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.order_process p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.partner_id, p.status, p.date_started, p.date_finished, p.date_updated, p.note, p.date_created FROM app.order_process p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderProcessMapper.class)
    public List<OrderProcessDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.partner_id, p.status, p.date_started, p.date_finished, p.date_updated, p.note, p.date_created FROM app.order_process p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=OrderProcessMapper.class)
    public OrderProcessDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.partner_id, p.status, p.date_started, p.date_finished, p.date_updated, p.note, p.date_created FROM app.order_process p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=OrderProcessMapper.class)
    public List<OrderProcessDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.order_process p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.partner_id, p.status, p.date_started, p.date_finished, p.date_updated, p.note, p.date_created FROM app.order_process p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderProcessMapper.class)
    public List<OrderProcessDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.partner_id, p.status, p.date_started, p.date_finished, p.date_updated, p.note, p.date_created FROM app.order_process p  WHERE p.order_id = :orderId")
    @RegisterRowMapper(value=OrderProcessMapper.class)
    public OrderProcessDomain findByOrderId(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.partner_id, p.status, p.date_started, p.date_finished, p.date_updated, p.note, p.date_created FROM app.order_process p  WHERE p.order_id = :orderId")
    @RegisterRowMapper(value=OrderProcessMapper.class)
    public List<OrderProcessDomain> findListByOrderId(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.order_process p  WHERE p.order_id = :orderId")
    public long findListByOrderIdCount(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.partner_id, p.status, p.date_started, p.date_finished, p.date_updated, p.note, p.date_created FROM app.order_process p  WHERE p.order_id = :orderId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderProcessMapper.class)
    public List<OrderProcessDomain> findListByOrderId(@Bind(value="orderId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.partner_id, p.status, p.date_started, p.date_finished, p.date_updated, p.note, p.date_created FROM app.order_process p  WHERE p.partner_id = :partnerId")
    @RegisterRowMapper(value=OrderProcessMapper.class)
    public OrderProcessDomain findByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.partner_id, p.status, p.date_started, p.date_finished, p.date_updated, p.note, p.date_created FROM app.order_process p  WHERE p.partner_id = :partnerId")
    @RegisterRowMapper(value=OrderProcessMapper.class)
    public List<OrderProcessDomain> findListByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.order_process p  WHERE p.partner_id = :partnerId")
    public long findListByPartnerIdCount(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.partner_id, p.status, p.date_started, p.date_finished, p.date_updated, p.note, p.date_created FROM app.order_process p  WHERE p.partner_id = :partnerId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderProcessMapper.class)
    public List<OrderProcessDomain> findListByPartnerId(@Bind(value="partnerId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.partner_id, p.status, p.date_started, p.date_finished, p.date_updated, p.note, p.date_created FROM app.order_process p  WHERE p.status = :status")
    @RegisterRowMapper(value=OrderProcessMapper.class)
    public OrderProcessDomain findByStatus(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.partner_id, p.status, p.date_started, p.date_finished, p.date_updated, p.note, p.date_created FROM app.order_process p  WHERE p.status = :status")
    @RegisterRowMapper(value=OrderProcessMapper.class)
    public List<OrderProcessDomain> findListByStatus(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.order_process p  WHERE p.status = :status")
    public long findListByStatusCount(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.partner_id, p.status, p.date_started, p.date_finished, p.date_updated, p.note, p.date_created FROM app.order_process p  WHERE p.status = :status ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderProcessMapper.class)
    public List<OrderProcessDomain> findListByStatus(@Bind(value="status") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.partner_id, p.status, p.date_started, p.date_finished, p.date_updated, p.note, p.date_created FROM app.order_process p  WHERE p.date_started = :dateStarted")
    @RegisterRowMapper(value=OrderProcessMapper.class)
    public OrderProcessDomain findByDateStarted(@Bind(value="dateStarted") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.partner_id, p.status, p.date_started, p.date_finished, p.date_updated, p.note, p.date_created FROM app.order_process p  WHERE p.date_started = :dateStarted")
    @RegisterRowMapper(value=OrderProcessMapper.class)
    public List<OrderProcessDomain> findListByDateStarted(@Bind(value="dateStarted") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.order_process p  WHERE p.date_started = :dateStarted")
    public long findListByDateStartedCount(@Bind(value="dateStarted") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.partner_id, p.status, p.date_started, p.date_finished, p.date_updated, p.note, p.date_created FROM app.order_process p  WHERE p.date_started = :dateStarted ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderProcessMapper.class)
    public List<OrderProcessDomain> findListByDateStarted(@Bind(value="dateStarted") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.partner_id, p.status, p.date_started, p.date_finished, p.date_updated, p.note, p.date_created FROM app.order_process p  WHERE p.date_finished = :dateFinished")
    @RegisterRowMapper(value=OrderProcessMapper.class)
    public OrderProcessDomain findByDateFinished(@Bind(value="dateFinished") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.partner_id, p.status, p.date_started, p.date_finished, p.date_updated, p.note, p.date_created FROM app.order_process p  WHERE p.date_finished = :dateFinished")
    @RegisterRowMapper(value=OrderProcessMapper.class)
    public List<OrderProcessDomain> findListByDateFinished(@Bind(value="dateFinished") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.order_process p  WHERE p.date_finished = :dateFinished")
    public long findListByDateFinishedCount(@Bind(value="dateFinished") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.partner_id, p.status, p.date_started, p.date_finished, p.date_updated, p.note, p.date_created FROM app.order_process p  WHERE p.date_finished = :dateFinished ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderProcessMapper.class)
    public List<OrderProcessDomain> findListByDateFinished(@Bind(value="dateFinished") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.partner_id, p.status, p.date_started, p.date_finished, p.date_updated, p.note, p.date_created FROM app.order_process p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=OrderProcessMapper.class)
    public OrderProcessDomain findByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.partner_id, p.status, p.date_started, p.date_finished, p.date_updated, p.note, p.date_created FROM app.order_process p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=OrderProcessMapper.class)
    public List<OrderProcessDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.order_process p  WHERE p.date_updated = :dateUpdated")
    public long findListByDateUpdatedCount(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.partner_id, p.status, p.date_started, p.date_finished, p.date_updated, p.note, p.date_created FROM app.order_process p  WHERE p.date_updated = :dateUpdated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderProcessMapper.class)
    public List<OrderProcessDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.partner_id, p.status, p.date_started, p.date_finished, p.date_updated, p.note, p.date_created FROM app.order_process p  WHERE p.note = :note")
    @RegisterRowMapper(value=OrderProcessMapper.class)
    public OrderProcessDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.partner_id, p.status, p.date_started, p.date_finished, p.date_updated, p.note, p.date_created FROM app.order_process p  WHERE p.note = :note")
    @RegisterRowMapper(value=OrderProcessMapper.class)
    public List<OrderProcessDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.order_process p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.partner_id, p.status, p.date_started, p.date_finished, p.date_updated, p.note, p.date_created FROM app.order_process p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderProcessMapper.class)
    public List<OrderProcessDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.partner_id, p.status, p.date_started, p.date_finished, p.date_updated, p.note, p.date_created FROM app.order_process p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=OrderProcessMapper.class)
    public OrderProcessDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.partner_id, p.status, p.date_started, p.date_finished, p.date_updated, p.note, p.date_created FROM app.order_process p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=OrderProcessMapper.class)
    public List<OrderProcessDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.order_process p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.order_id, p.partner_id, p.status, p.date_started, p.date_finished, p.date_updated, p.note, p.date_created FROM app.order_process p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderProcessMapper.class)
    public List<OrderProcessDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO app.order_process (id, uid, order_id, partner_id, status, date_started, date_finished, date_updated, note, date_created) VALUES (:id, :uid, :orderId, :partnerId, :status, :dateStarted, :dateFinished, :dateUpdated, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="orderId") Long var3, @Bind(value="partnerId") Long var4, @Bind(value="status") String var5, @Bind(value="dateStarted") Date var6, @Bind(value="dateFinished") Date var7, @Bind(value="dateUpdated") Date var8, @Bind(value="note") String var9, @Bind(value="dateCreated") Date var10);

    @SqlUpdate(value="INSERT INTO app.order_process (order_id, partner_id, status, date_started, date_finished, date_updated, note, date_created) VALUES (:e.orderId, :e.partnerId, :e.status, :e.dateStarted, :e.dateFinished, :e.dateUpdated, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") OrderProcessDomain var1);

    @SqlUpdate(value="UPDATE app.order_process SET id = :e.id, uid = :e.uid, order_id = :e.orderId, partner_id = :e.partnerId, status = :e.status, date_started = :e.dateStarted, date_finished = :e.dateFinished, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") OrderProcessDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE app.order_process SET id = :e.id, uid = :e.uid, order_id = :e.orderId, partner_id = :e.partnerId, status = :e.status, date_started = :e.dateStarted, date_finished = :e.dateFinished, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") OrderProcessDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE app.order_process SET id = :e.id, uid = :e.uid, order_id = :e.orderId, partner_id = :e.partnerId, status = :e.status, date_started = :e.dateStarted, date_finished = :e.dateFinished, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE order_id = :byOrderId")
    public int updateByOrderId(@BindBean(value="e") OrderProcessDomain var1, @Bind(value="byOrderId") Long var2);

    @SqlUpdate(value="UPDATE app.order_process SET id = :e.id, uid = :e.uid, order_id = :e.orderId, partner_id = :e.partnerId, status = :e.status, date_started = :e.dateStarted, date_finished = :e.dateFinished, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE partner_id = :byPartnerId")
    public int updateByPartnerId(@BindBean(value="e") OrderProcessDomain var1, @Bind(value="byPartnerId") Long var2);

    @SqlUpdate(value="UPDATE app.order_process SET id = :e.id, uid = :e.uid, order_id = :e.orderId, partner_id = :e.partnerId, status = :e.status, date_started = :e.dateStarted, date_finished = :e.dateFinished, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE status = :byStatus")
    public int updateByStatus(@BindBean(value="e") OrderProcessDomain var1, @Bind(value="byStatus") String var2);

    @SqlUpdate(value="UPDATE app.order_process SET id = :e.id, uid = :e.uid, order_id = :e.orderId, partner_id = :e.partnerId, status = :e.status, date_started = :e.dateStarted, date_finished = :e.dateFinished, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_started = :byDateStarted")
    public int updateByDateStarted(@BindBean(value="e") OrderProcessDomain var1, @Bind(value="byDateStarted") Date var2);

    @SqlUpdate(value="UPDATE app.order_process SET id = :e.id, uid = :e.uid, order_id = :e.orderId, partner_id = :e.partnerId, status = :e.status, date_started = :e.dateStarted, date_finished = :e.dateFinished, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_finished = :byDateFinished")
    public int updateByDateFinished(@BindBean(value="e") OrderProcessDomain var1, @Bind(value="byDateFinished") Date var2);

    @SqlUpdate(value="UPDATE app.order_process SET id = :e.id, uid = :e.uid, order_id = :e.orderId, partner_id = :e.partnerId, status = :e.status, date_started = :e.dateStarted, date_finished = :e.dateFinished, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_updated = :byDateUpdated")
    public int updateByDateUpdated(@BindBean(value="e") OrderProcessDomain var1, @Bind(value="byDateUpdated") Date var2);

    @SqlUpdate(value="UPDATE app.order_process SET id = :e.id, uid = :e.uid, order_id = :e.orderId, partner_id = :e.partnerId, status = :e.status, date_started = :e.dateStarted, date_finished = :e.dateFinished, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") OrderProcessDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE app.order_process SET id = :e.id, uid = :e.uid, order_id = :e.orderId, partner_id = :e.partnerId, status = :e.status, date_started = :e.dateStarted, date_finished = :e.dateFinished, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") OrderProcessDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM app.order_process WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM app.order_process WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM app.order_process WHERE order_id = :orderId")
    public int deleteByOrderId(@Bind(value="orderId") Long var1);

    @SqlUpdate(value="DELETE FROM app.order_process WHERE partner_id = :partnerId")
    public int deleteByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlUpdate(value="DELETE FROM app.order_process WHERE status = :status")
    public int deleteByStatus(@Bind(value="status") String var1);

    @SqlUpdate(value="DELETE FROM app.order_process WHERE date_started = :dateStarted")
    public int deleteByDateStarted(@Bind(value="dateStarted") Date var1);

    @SqlUpdate(value="DELETE FROM app.order_process WHERE date_finished = :dateFinished")
    public int deleteByDateFinished(@Bind(value="dateFinished") Date var1);

    @SqlUpdate(value="DELETE FROM app.order_process WHERE date_updated = :dateUpdated")
    public int deleteByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlUpdate(value="DELETE FROM app.order_process WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM app.order_process WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

