/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.commons;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;

public interface BaseDao {
    public static final Jdbi dbi = null;

    default public void setDbi(Jdbi dbi) {
    }

    default public Jdbi getDbi() {
        return dbi;
    }

    default public Integer executeUpdate(String query, Optional<Map<String, Object>> params) {
        return (Integer)dbi.withHandle(h -> {
            Update q = h.createUpdate(query);
            params.ifPresent(m -> m.keySet().forEach(k -> q.bind(k, m.get(k))));
            return q.execute();
        });
    }

    default public Map<String, Object> loadFirst(String query, Optional<Map<String, Object>> params) {
        List<Map<String, Object>> data = this.loadRawData(query, params);
        if (data != null) {
            return data.get(0);
        }
        return null;
    }

    default public List<Map<String, Object>> loadRawData(String query, Optional<Map<String, Object>> params) {
        return (List)dbi.withHandle(h -> {
            Query q = h.select(query, new Object[0]);
            params.ifPresent(m -> m.keySet().forEach(k -> q.bind(k, m.get(k))));
            return q.mapToMap().list();
        });
    }

    default public Integer loadFirstValueInteger(String query, Optional<Map<String, Object>> params) {
        return (Integer)dbi.withHandle(h -> {
            Query q = h.select(query, new Object[0]);
            params.ifPresent(m -> m.keySet().forEach(k -> q.bind(k, m.get(k))));
            return (Integer)q.mapTo(Integer.class).first();
        });
    }

    default public Long loadFirstValueLong(String query, Optional<Map<String, Object>> params) {
        return (Long)dbi.withHandle(h -> {
            Query q = h.select(query, new Object[0]);
            params.ifPresent(m -> m.keySet().forEach(k -> q.bind(k, m.get(k))));
            return (Long)q.mapTo(Long.class).first();
        });
    }

    default public String loadFirstValueString(String query, Optional<Map<String, Object>> params) {
        return (String)dbi.withHandle(h -> {
            Query q = h.select(query, new Object[0]);
            params.ifPresent(m -> m.keySet().forEach(k -> q.bind(k, m.get(k))));
            return (String)q.mapTo(String.class).first();
        });
    }
}

